/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include "flegita-sink.h"
#include <gegl.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gnome-scan-node.h>
#include <gnome-scan-common.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gnome-scan-option.h>
#include "flegita-options.h"




static char* string_replace (const char* self, const char* old, const char* replacement);
struct _FlegitaSinkPrivate {
	GeglNode* _save;
	char* directory;
	char* basename;
	char* suffix;
	gint count;
};

#define FLEGITA_SINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_SINK, FlegitaSinkPrivate))
enum  {
	FLEGITA_SINK_DUMMY_PROPERTY
};
static gboolean flegita_sink_real_start_image (GnomeScanNode* base);
static void flegita_sink_on_output_filename_changed (FlegitaSink* self, FlegitaOptionOutputFilename* option, GParamSpec* pspec);
static void _flegita_sink_on_output_filename_changed_g_object_notify (FlegitaOptionOutputFilename* _sender, GParamSpec* pspec, gpointer self);
static GObject * flegita_sink_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer flegita_sink_parent_class = NULL;
static void flegita_sink_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static char* string_replace (const char* self, const char* old, const char* replacement) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	inner_error = NULL;
	{
		char* _tmp0;
		GRegex* _tmp1;
		GRegex* regex;
		char* _tmp2;
		char* _tmp3;
		_tmp0 = NULL;
		_tmp1 = NULL;
		regex = (_tmp1 = g_regex_new (_tmp0 = g_regex_escape_string (old, -1), 0, 0, &inner_error), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		_tmp2 = g_regex_replace_literal (regex, self, (glong) (-1), 0, replacement, 0, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
		}
		_tmp3 = NULL;
		return (_tmp3 = _tmp2, (regex == NULL) ? NULL : (regex = (g_regex_unref (regex), NULL)), _tmp3);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_assert_not_reached ();
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally0:
	;
}


static gboolean flegita_sink_real_start_image (GnomeScanNode* base) {
	FlegitaSink * self;
	char* filename;
	char* number;
	gboolean _tmp3;
	self = (FlegitaSink*) base;
	filename = NULL;
	number = NULL;
	do {
		char* _tmp2;
		if (self->priv->count == 0) {
			char* _tmp0;
			_tmp0 = NULL;
			number = (_tmp0 = g_strdup (""), number = (g_free (number), NULL), _tmp0);
		} else {
			char* _tmp1;
			_tmp1 = NULL;
			number = (_tmp1 = g_strdup_printf ("-%d", self->priv->count), number = (g_free (number), NULL), _tmp1);
		}
		_tmp2 = NULL;
		filename = (_tmp2 = g_strdup_printf ("%s%c%s%s%s", self->priv->directory, (gint) G_DIR_SEPARATOR, self->priv->basename, number, self->priv->suffix), filename = (g_free (filename), NULL), _tmp2);
		self->priv->count++;
	} while (g_file_test (filename, G_FILE_TEST_EXISTS));
	g_debug ("flegita-sink.vala:81: Saving to %s", filename);
	gegl_node_set (self->priv->_save, "path", filename, NULL);
	return (_tmp3 = TRUE, filename = (g_free (filename), NULL), number = (g_free (number), NULL), _tmp3);
}


static void flegita_sink_on_output_filename_changed (FlegitaSink* self, FlegitaOptionOutputFilename* option, GParamSpec* pspec) {
	char* _tmp0;
	char* _tmp1;
	char* _tmp3;
	const char* _tmp2;
	gboolean _tmp5;
	gboolean _tmp6;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (pspec != NULL);
	/* test directory existence?*/
	self->priv->count = 0;
	_tmp0 = NULL;
	self->priv->directory = (_tmp0 = g_path_get_dirname (flegita_option_output_filename_get_value (option)), self->priv->directory = (g_free (self->priv->directory), NULL), _tmp0);
	_tmp1 = NULL;
	self->priv->basename = (_tmp1 = g_path_get_basename (flegita_option_output_filename_get_value (option)), self->priv->basename = (g_free (self->priv->basename), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->suffix = (_tmp3 = (_tmp2 = g_utf8_strrchr (self->priv->basename, (glong) (-1), (gunichar) '.'), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->suffix = (g_free (self->priv->suffix), NULL), _tmp3);
	if (self->priv->suffix != NULL) {
		char* _tmp4;
		_tmp4 = NULL;
		self->priv->basename = (_tmp4 = string_replace (self->priv->basename, self->priv->suffix, ""), self->priv->basename = (g_free (self->priv->basename), NULL), _tmp4);
	}
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	if (g_file_test (self->priv->directory, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS)) {
		_tmp6 = g_utf8_strlen (self->priv->basename, -1) > 0;
	} else {
		_tmp6 = FALSE;
	}
	if (_tmp6) {
		_tmp5 = self->priv->suffix != NULL;
	} else {
		_tmp5 = FALSE;
	}
	if (_tmp5) {
		gnome_scan_node_update_status ((GnomeScanNode*) self, GNOME_SCAN_STATUS_READY, NULL);
	} else {
		gnome_scan_node_update_status ((GnomeScanNode*) self, GNOME_SCAN_STATUS_UNCONFIGURED, NULL);
	}
}


FlegitaSink* flegita_sink_construct (GType object_type) {
	FlegitaSink * self;
	self = (FlegitaSink*) gnome_scan_sink_construct (object_type);
	return self;
}


FlegitaSink* flegita_sink_new (void) {
	return flegita_sink_construct (FLEGITA_TYPE_SINK);
}


static void _flegita_sink_on_output_filename_changed_g_object_notify (FlegitaOptionOutputFilename* _sender, GParamSpec* pspec, gpointer self) {
	flegita_sink_on_output_filename_changed (self, _sender, pspec);
}


static GObject * flegita_sink_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	FlegitaSinkClass * klass;
	GObjectClass * parent_class;
	FlegitaSink * self;
	klass = FLEGITA_SINK_CLASS (g_type_class_peek (FLEGITA_TYPE_SINK));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = FLEGITA_SINK (obj);
	{
		GnomeScanFormat* format;
		FlegitaOptionOutputFilename* option;
		const char* gettext_package;
		FlegitaOptionOutputFilename* _tmp0;
		GnomeScanFormat* _tmp5;
		gint _tmp4_length1;
		char** _tmp4;
		char** _tmp3;
		gint _tmp2_length1;
		char** _tmp2;
		char** _tmp1;
		char* _tmp6;
		GeglNode* _tmp7;
		format = NULL;
		option = NULL;
		gettext_package = GETTEXT_PACKAGE;
		_tmp0 = NULL;
		option = (_tmp0 = flegita_option_output_filename_new ("output-filename", N_ ("Output Filename"), N_ ("Output filename"), GETTEXT_PACKAGE, GNOME_SCAN_OPTION_GROUP_SINK, GNOME_SCAN_OPTION_HINT_PRIMARY), (option == NULL) ? NULL : (option = (g_object_unref (option), NULL)), _tmp0);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		format = (_tmp5 = gnome_scan_format_new ("png", N_ ("PNG Picture"), GETTEXT_PACKAGE, "image", (_tmp2 = (_tmp1 = g_new0 (char*, 1 + 1), _tmp1[0] = g_strdup ("image/png"), _tmp1), _tmp2_length1 = 1, _tmp2), 1, (_tmp4 = (_tmp3 = g_new0 (char*, 1 + 1), _tmp3[0] = g_strdup ("png"), _tmp3), _tmp4_length1 = 1, _tmp4), 1), (format == NULL) ? NULL : (format = (g_object_unref (format), NULL)), _tmp5);
		_tmp4 = (_vala_array_free (_tmp4, _tmp4_length1, (GDestroyNotify) g_free), NULL);
		_tmp2 = (_vala_array_free (_tmp2, _tmp2_length1, (GDestroyNotify) g_free), NULL);
		flegita_option_output_filename_install_format (option, format);
		gnome_scan_node_install_option ((GnomeScanNode*) self, (GnomeScanOption*) option);
		_tmp6 = NULL;
		flegita_option_output_filename_set_value (option, _tmp6 = g_strdup_printf ("%s%c%s.%s", g_get_user_special_dir (G_USER_DIRECTORY_PICTURES), (gint) G_DIR_SEPARATOR, _ ("Scanned picture"), format->suffixes[0]));
		_tmp6 = (g_free (_tmp6), NULL);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _flegita_sink_on_output_filename_changed_g_object_notify, self, 0);
		/* gegl pipeline*/
		_tmp7 = NULL;
		self->priv->_save = (_tmp7 = gegl_node_new (), (self->priv->_save == NULL) ? NULL : (self->priv->_save = (g_object_unref (self->priv->_save), NULL)), _tmp7);
		gegl_node_set (self->priv->_save, "operation", "gegl:png-save", "compression", 9, "bitdepth", 8, NULL);
		gnome_scan_node_append_node ((GnomeScanNode*) self, self->priv->_save);
		gnome_scan_node_update_status ((GnomeScanNode*) self, GNOME_SCAN_STATUS_READY, NULL);
		(format == NULL) ? NULL : (format = (g_object_unref (format), NULL));
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
	}
	return obj;
}


static void flegita_sink_class_init (FlegitaSinkClass * klass) {
	flegita_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FlegitaSinkPrivate));
	G_OBJECT_CLASS (klass)->constructor = flegita_sink_constructor;
	G_OBJECT_CLASS (klass)->finalize = flegita_sink_finalize;
	GNOME_SCAN_NODE_CLASS (klass)->start_image = flegita_sink_real_start_image;
}


static void flegita_sink_instance_init (FlegitaSink * self) {
	self->priv = FLEGITA_SINK_GET_PRIVATE (self);
	self->priv->count = 0;
}


static void flegita_sink_finalize (GObject* obj) {
	FlegitaSink * self;
	self = FLEGITA_SINK (obj);
	(self->priv->_save == NULL) ? NULL : (self->priv->_save = (g_object_unref (self->priv->_save), NULL));
	self->priv->directory = (g_free (self->priv->directory), NULL);
	self->priv->basename = (g_free (self->priv->basename), NULL);
	self->priv->suffix = (g_free (self->priv->suffix), NULL);
	G_OBJECT_CLASS (flegita_sink_parent_class)->finalize (obj);
}


GType flegita_sink_get_type (void) {
	static GType flegita_sink_type_id = 0;
	if (flegita_sink_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (FlegitaSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flegita_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlegitaSink), 0, (GInstanceInitFunc) flegita_sink_instance_init, NULL };
		flegita_sink_type_id = g_type_register_static (GNOME_SCAN_TYPE_SINK, "FlegitaSink", &g_define_type_info, 0);
	}
	return flegita_sink_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}




