/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-scanner.h>




struct _GnomeScanScannerPrivate {
	char* _name;
	char* _blurb;
	char* _icon_name;
	GeglBuffer* _buffer;
};

#define GNOME_SCAN_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerPrivate))
enum  {
	GNOME_SCAN_SCANNER_DUMMY_PROPERTY,
	GNOME_SCAN_SCANNER_NAME,
	GNOME_SCAN_SCANNER_BLURB,
	GNOME_SCAN_SCANNER_ICON_NAME,
	GNOME_SCAN_SCANNER_BUFFER
};
static gboolean gnome_scan_scanner_real_work (GnomeScanScanner* self, double* progress);
static gpointer gnome_scan_scanner_parent_class = NULL;
static void gnome_scan_scanner_finalize (GObject* obj);



/* return true while there is more work to do.*/
static gboolean gnome_scan_scanner_real_work (GnomeScanScanner* self, double* progress) {
	g_return_val_if_fail (self != NULL, FALSE);
	(*progress) = 1.0;
	g_warning ("gnome-scan-scanner.vala:35: Fake processor for %s", g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self)));
	return FALSE;
}


gboolean gnome_scan_scanner_work (GnomeScanScanner* self, double* progress) {
	return GNOME_SCAN_SCANNER_GET_CLASS (self)->work (self, progress);
}


const char* gnome_scan_scanner_get_name (GnomeScanScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void gnome_scan_scanner_set_name (GnomeScanScanner* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "name");
}


const char* gnome_scan_scanner_get_blurb (GnomeScanScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_blurb;
}


void gnome_scan_scanner_set_blurb (GnomeScanScanner* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_blurb = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_blurb = (g_free (self->priv->_blurb), NULL), _tmp2);
	g_object_notify ((GObject *) self, "blurb");
}


const char* gnome_scan_scanner_get_icon_name (GnomeScanScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_icon_name;
}


void gnome_scan_scanner_set_icon_name (GnomeScanScanner* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_icon_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_icon_name = (g_free (self->priv->_icon_name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "icon-name");
}


GeglBuffer* gnome_scan_scanner_get_buffer (GnomeScanScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_buffer;
}


void gnome_scan_scanner_set_buffer (GnomeScanScanner* self, GeglBuffer* value) {
	GeglBuffer* _tmp2;
	GeglBuffer* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_buffer = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_buffer == NULL) ? NULL : (self->priv->_buffer = (g_object_unref (self->priv->_buffer), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "buffer");
}


static void gnome_scan_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanScanner * self;
	gpointer boxed;
	self = GNOME_SCAN_SCANNER (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_NAME:
		g_value_set_string (value, gnome_scan_scanner_get_name (self));
		break;
		case GNOME_SCAN_SCANNER_BLURB:
		g_value_set_string (value, gnome_scan_scanner_get_blurb (self));
		break;
		case GNOME_SCAN_SCANNER_ICON_NAME:
		g_value_set_string (value, gnome_scan_scanner_get_icon_name (self));
		break;
		case GNOME_SCAN_SCANNER_BUFFER:
		g_value_set_object (value, gnome_scan_scanner_get_buffer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanScanner * self;
	self = GNOME_SCAN_SCANNER (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_NAME:
		gnome_scan_scanner_set_name (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_SCANNER_BLURB:
		gnome_scan_scanner_set_blurb (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_SCANNER_ICON_NAME:
		gnome_scan_scanner_set_icon_name (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_SCANNER_BUFFER:
		gnome_scan_scanner_set_buffer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_scanner_class_init (GnomeScanScannerClass * klass) {
	gnome_scan_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanScannerPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_scanner_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_scanner_finalize;
	GNOME_SCAN_SCANNER_CLASS (klass)->work = gnome_scan_scanner_real_work;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_BLURB, g_param_spec_string ("blurb", "blurb", "blurb", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_BUFFER, g_param_spec_object ("buffer", "buffer", "buffer", GEGL_TYPE_BUFFER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_scanner_instance_init (GnomeScanScanner * self) {
	self->priv = GNOME_SCAN_SCANNER_GET_PRIVATE (self);
}


static void gnome_scan_scanner_finalize (GObject* obj) {
	GnomeScanScanner * self;
	self = GNOME_SCAN_SCANNER (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	self->priv->_blurb = (g_free (self->priv->_blurb), NULL);
	self->priv->_icon_name = (g_free (self->priv->_icon_name), NULL);
	(self->priv->_buffer == NULL) ? NULL : (self->priv->_buffer = (g_object_unref (self->priv->_buffer), NULL));
	G_OBJECT_CLASS (gnome_scan_scanner_parent_class)->finalize (obj);
}


GType gnome_scan_scanner_get_type (void) {
	static GType gnome_scan_scanner_type_id = 0;
	if (gnome_scan_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanScanner), 0, (GInstanceInitFunc) gnome_scan_scanner_instance_init, NULL };
		gnome_scan_scanner_type_id = g_type_register_static (GNOME_SCAN_TYPE_NODE, "GnomeScanScanner", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_scanner_type_id;
}




