/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-option-widget.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-common.h>




struct _GnomeScanOptionWidgetPrivate {
	GnomeScanOption* _option;
	gboolean _no_label;
	gboolean _expand;
};

#define GNOME_SCAN_OPTION_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetPrivate))
enum  {
	GNOME_SCAN_OPTION_WIDGET_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_WIDGET_OPTION,
	GNOME_SCAN_OPTION_WIDGET_NO_LABEL,
	GNOME_SCAN_OPTION_WIDGET_EXPAND
};
static void gnome_scan_option_widget_on_option_active_changed (GnomeScanOptionWidget* self, GnomeScanOption* option, GParamSpec* pspec);
static void gnome_scan_option_widget_auto_hide (GnomeScanOptionWidget* self, GnomeScanOption* option);
static void _gnome_scan_option_widget_on_option_active_changed_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_option_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_option_widget_parent_class = NULL;
static void gnome_scan_option_widget_finalize (GObject* obj);



GnomeScanOptionWidget* gnome_scan_option_widget_construct (GType object_type, GnomeScanOption* option) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionWidget * self;
	g_return_val_if_fail (option != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "option";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION);
	g_value_set_object (&__params_it->value, option);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionWidget* gnome_scan_option_widget_new (GnomeScanOption* option) {
	return gnome_scan_option_widget_construct (GNOME_SCAN_TYPE_OPTION_WIDGET, option);
}


static void gnome_scan_option_widget_on_option_active_changed (GnomeScanOptionWidget* self, GnomeScanOption* option, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (pspec != NULL);
	gnome_scan_option_widget_auto_hide (self, option);
}


static void gnome_scan_option_widget_auto_hide (GnomeScanOptionWidget* self, GnomeScanOption* option) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	gtk_widget_set_no_show_all ((GtkWidget*) self, !gnome_scan_option_get_active (option));
	if (gnome_scan_option_get_active (option)) {
		gtk_widget_show_all ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_option;
}


void gnome_scan_option_widget_set_option (GnomeScanOptionWidget* self, GnomeScanOption* value) {
	GnomeScanOption* _tmp2;
	GnomeScanOption* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_option = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_option == NULL) ? NULL : (self->priv->_option = (g_object_unref (self->priv->_option), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "option");
}


gboolean gnome_scan_option_widget_get_no_label (GnomeScanOptionWidget* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_no_label;
}


void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_label = value;
	g_object_notify ((GObject *) self, "no-label");
}


gboolean gnome_scan_option_widget_get_expand (GnomeScanOptionWidget* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_expand;
}


void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_expand = value;
	g_object_notify ((GObject *) self, "expand");
}


static void _gnome_scan_option_widget_on_option_active_changed_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_option_widget_on_option_active_changed (self, _sender, pspec);
}


static GObject * gnome_scan_option_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionWidget * self;
	klass = GNOME_SCAN_OPTION_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_WIDGET (obj);
	{
		gtk_box_set_spacing ((GtkBox*) self, 4);
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 2);
		gtk_widget_set_tooltip_text ((GtkWidget*) self, gnome_scan_option_get_desc (self->priv->_option));
		g_signal_connect_object ((GObject*) self->priv->_option, "notify::active", (GCallback) _gnome_scan_option_widget_on_option_active_changed_g_object_notify, self, 0);
		gnome_scan_option_widget_auto_hide (self, self->priv->_option);
		if (gnome_scan_option_get_unit (self->priv->_option) != GNOME_SCAN_UNIT_NONE) {
			char* _tmp0;
			GtkLabel* _tmp1;
			GtkLabel* unit;
			_tmp0 = NULL;
			_tmp1 = NULL;
			unit = (_tmp1 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp0 = gnome_scan_unit_to_string (gnome_scan_option_get_unit (self->priv->_option)))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
			gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) unit, FALSE, FALSE, (guint) 0);
			(unit == NULL) ? NULL : (unit = (g_object_unref (unit), NULL));
		}
	}
	return obj;
}


static void gnome_scan_option_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionWidget * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_WIDGET (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_WIDGET_OPTION:
		g_value_set_object (value, gnome_scan_option_widget_get_option (self));
		break;
		case GNOME_SCAN_OPTION_WIDGET_NO_LABEL:
		g_value_set_boolean (value, gnome_scan_option_widget_get_no_label (self));
		break;
		case GNOME_SCAN_OPTION_WIDGET_EXPAND:
		g_value_set_boolean (value, gnome_scan_option_widget_get_expand (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionWidget * self;
	self = GNOME_SCAN_OPTION_WIDGET (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_WIDGET_OPTION:
		gnome_scan_option_widget_set_option (self, g_value_get_object (value));
		break;
		case GNOME_SCAN_OPTION_WIDGET_NO_LABEL:
		gnome_scan_option_widget_set_no_label (self, g_value_get_boolean (value));
		break;
		case GNOME_SCAN_OPTION_WIDGET_EXPAND:
		gnome_scan_option_widget_set_expand (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_widget_class_init (GnomeScanOptionWidgetClass * klass) {
	gnome_scan_option_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_WIDGET_OPTION, g_param_spec_object ("option", "option", "option", GNOME_SCAN_TYPE_OPTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_WIDGET_NO_LABEL, g_param_spec_boolean ("no-label", "no-label", "no-label", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_WIDGET_EXPAND, g_param_spec_boolean ("expand", "expand", "expand", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_widget_instance_init (GnomeScanOptionWidget * self) {
	self->priv = GNOME_SCAN_OPTION_WIDGET_GET_PRIVATE (self);
	self->priv->_no_label = FALSE;
}


static void gnome_scan_option_widget_finalize (GObject* obj) {
	GnomeScanOptionWidget * self;
	self = GNOME_SCAN_OPTION_WIDGET (obj);
	(self->priv->_option == NULL) ? NULL : (self->priv->_option = (g_object_unref (self->priv->_option), NULL));
	G_OBJECT_CLASS (gnome_scan_option_widget_parent_class)->finalize (obj);
}


GType gnome_scan_option_widget_get_type (void) {
	static GType gnome_scan_option_widget_type_id = 0;
	if (gnome_scan_option_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionWidget), 0, (GInstanceInitFunc) gnome_scan_option_widget_instance_init, NULL };
		gnome_scan_option_widget_type_id = g_type_register_static (GTK_TYPE_HBOX, "GnomeScanOptionWidget", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_option_widget_type_id;
}




