/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_JOB_H__
#define __GNOME_SCAN_JOB_H__

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gnome-scan-common.h>
#include <gnome-scan-sink.h>
#include <gnome-scan-scanner.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_JOB (gnome_scan_job_get_type ())
#define GNOME_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJob))
#define GNOME_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))
#define GNOME_SCAN_IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_IS_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))

typedef struct _GnomeScanJob GnomeScanJob;
typedef struct _GnomeScanJobClass GnomeScanJobClass;
typedef struct _GnomeScanJobPrivate GnomeScanJobPrivate;

struct _GnomeScanJob {
	GObject parent_instance;
	GnomeScanJobPrivate * priv;
};

struct _GnomeScanJobClass {
	GObjectClass parent_class;
};


GnomeScanJob* gnome_scan_job_construct (GType object_type, GnomeScanSink* sink);
GnomeScanJob* gnome_scan_job_new (GnomeScanSink* sink);
gboolean gnome_scan_job_is_running (GnomeScanJob* self);
void gnome_scan_job_run (GnomeScanJob* self);
void gnome_scan_job_end (GnomeScanJob* self);
void gnome_scan_job_cancel (GnomeScanJob* self);
gboolean gnome_scan_job_run_once (GnomeScanJob* self);
GnomeScanStatus gnome_scan_job_get_status (GnomeScanJob* self);
void gnome_scan_job_set_status (GnomeScanJob* self, GnomeScanStatus value);
GnomeScanScanner* gnome_scan_job_get_scanner (GnomeScanJob* self);
void gnome_scan_job_set_scanner (GnomeScanJob* self, GnomeScanScanner* value);
GnomeScanSink* gnome_scan_job_get_sink (GnomeScanJob* self);
void gnome_scan_job_set_sink (GnomeScanJob* self, GnomeScanSink* value);
double gnome_scan_job_get_progress (GnomeScanJob* self);
GType gnome_scan_job_get_type (void);


G_END_DECLS

#endif
