/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_ACQUISITION_WIDGET_H__
#define __GNOME_SCAN_ACQUISITION_WIDGET_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-job.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_ACQUISITION_WIDGET (gnome_scan_acquisition_widget_get_type ())
#define GNOME_SCAN_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidget))
#define GNOME_SCAN_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_ACQUISITION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))

typedef struct _GnomeScanAcquisitionWidget GnomeScanAcquisitionWidget;
typedef struct _GnomeScanAcquisitionWidgetClass GnomeScanAcquisitionWidgetClass;
typedef struct _GnomeScanAcquisitionWidgetPrivate GnomeScanAcquisitionWidgetPrivate;

struct _GnomeScanAcquisitionWidget {
	GtkAlignment parent_instance;
	GnomeScanAcquisitionWidgetPrivate * priv;
};

struct _GnomeScanAcquisitionWidgetClass {
	GtkAlignmentClass parent_class;
};


GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_construct (GType object_type, GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_new (GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
gboolean gnome_scan_acquisition_widget_monitor_job (GnomeScanAcquisitionWidget* self);
GnomeScanJob* gnome_scan_acquisition_widget_get_job (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_job (GnomeScanAcquisitionWidget* self, GnomeScanJob* value);
const char* gnome_scan_acquisition_widget_get_primary (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_primary (GnomeScanAcquisitionWidget* self, const char* value);
const char* gnome_scan_acquisition_widget_get_secondary (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_secondary (GnomeScanAcquisitionWidget* self, const char* value);
const char* gnome_scan_acquisition_widget_get_icon_name (GnomeScanAcquisitionWidget* self);
void gnome_scan_acquisition_widget_set_icon_name (GnomeScanAcquisitionWidget* self, const char* value);
GType gnome_scan_acquisition_widget_get_type (void);


G_END_DECLS

#endif
