/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */
 
using GLib;

namespace Gnome.Scan {
	public const string OPTION_GROUP_SCANNER	= N_("Scan Options");
	public const string OPTION_GROUP_SINK		= N_("Output Options");
	public const string OPTION_GROUP_FORMAT		= N_("Format");

	/**
	 * GnomeScanOptionHint:
	 *
	 * Hint for packing option widget in UI.
	 */
	public enum OptionHint {
		HIDDEN,
		PRIMARY,
		SECONDARY,
		PREVIEW,
		REPEAT, // imply PRIMARY
	}

	public abstract class Option : Object {
		public string			name		{get; set construct;}
		public string			title		{get; set construct;}
		public string			desc		{get; set construct;}
		public string			group		{get; set construct;}
		public string			domain		{get; set construct;}

		public Gnome.Scan.Unit	unit		{get; set construct; default = Unit.NONE;}
		public OptionHint		hint		{get; set construct;}
		public bool				active		{get; set; default = true;}
	}

	public class OptionBool : Option {
		public bool value {set; get;}

		public OptionBool(string name, string title, string desc, string group, string domain, bool value, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this.hint = hint;
		}
	}

	public class OptionInt : Option {
		public int value {set; get;}
		public int min {set construct; get;}
		public int step {set construct; get;}
		public int max {set construct; get;}

		public OptionInt(string name, string title, string desc, string group, string domain, int value, int min, int step, int max, Gnome.Scan.Unit unit, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this.min = min;
			this.step = step;
			this.max = max;
			this.unit = unit;
			this.hint = hint;
		}
	}

	public class OptionDouble : Option {
		public double value {set; get;}
		public double min {set construct; get;}
		public double step {set construct; get;}
		public double max {set construct; get;}

		public OptionDouble(string name, string title, string desc, string group, string domain, double value, double min, double step, double max, Gnome.Scan.Unit unit, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this.min = min;
			this.step = step;
			this.max = max;
			this.unit = unit;
			this.hint = hint;
		}
	}

	public class OptionString : Option {
		public string value {set; get;}

		public OptionString(string name, string title, string desc, string group, string domain, string value, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this.hint = hint;
		}
	}

	public class OptionEnum : Option {
		public weak Gnome.Scan.EnumValue? value {set; get;}

		private weak SList<Gnome.Scan.EnumValue?> _values;
		public weak SList<Gnome.Scan.EnumValue?> values {
			get {
				return this._values;
			}
		}

		public OptionEnum(string name, string title, string desc, string group, string domain, Gnome.Scan.EnumValue? value, SList<Gnome.Scan.EnumValue?> values, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this._values = values;
			this.hint = hint;
		}
	}

	public class OptionBoxed : Option {
		public weak Boxed value {set; get;}

		public OptionBoxed(string name, string title, string desc, string group, string domain, Boxed value, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this.hint = hint;
		}
	}

	public class OptionPointer : Option {
		public weak void* value {set; get;}

		public OptionPointer(string name, string title, string desc, string group, string domain, void* value, OptionHint hint)
		{
			this.name = name;
			this.title = title;
			this.desc = desc;
			this.group = group;
			this.domain = domain;
			this.value = value;
			this.hint = hint;
		}
	}
}
