/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

/**
 * SECTION: 
 * @short_description: #GnomeScanPageOrientationWidget class
 * 
 **/
#include <glib/gi18n.h>
#include "gnome-scan-page-orientation-widget.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_PAGE_ORIENTATION_WIDGET, GnomeScanPageOrientationWidgetPrivate))

typedef struct _GnomeScanPageOrientationWidgetPrivate GnomeScanPageOrientationWidgetPrivate;
struct _GnomeScanPageOrientationWidgetPrivate
{
	GSList*		group;
	GtkWidget*	table;
	GtkWidget*	portrait;
	/*GtkWidget*	rportrait;*/
	GtkWidget*	landscape;
	/*GtkWidget*	rlandscape;*/
};


GS_DEFINE_PARAM_WIDGET (GnomeScanPageOrientationWidget, gnome_scan_page_orientation_widget);

static void
gnome_scan_page_orientation_widget_init (GnomeScanPageOrientationWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_page_orientation_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_page_orientation_widget_parent_class)->finalize (object);
}

static void
gspow_changed (GtkToggleButton *button, GnomeScanParamWidget *gspw)
{
	GtkPageOrientation po = gtk_toggle_button_get_active (button) ?
		GTK_PAGE_ORIENTATION_PORTRAIT : GTK_PAGE_ORIENTATION_LANDSCAPE;
	g_value_set_enum (gspw->value, po);
	gnome_scan_param_widget_changed (gspw);
}

static void
gnome_scan_page_orientation_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanPageOrientationWidgetPrivate *priv = GET_PRIVATE (gspw);
	GtkWidget *box, *icon, *label;
	
	gspw->shows_label = TRUE;
	gspw->shows_unit = TRUE;
	
	/* portrait */
	icon = gtk_image_new_from_icon_name ("gtk-orientation-portrait",
										 GTK_ICON_SIZE_BUTTON);
	label = gtk_label_new_with_mnemonic (dgettext("gtk20", "Portrait"));
	
	box = gtk_hbox_new (FALSE, 4);
	gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), label, TRUE, FALSE, 0);
	
	priv->portrait = gtk_radio_button_new (NULL);
	g_signal_connect (priv->portrait, "toggled",
					  G_CALLBACK (gspow_changed),
					  gspw);
	priv->group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (priv->portrait));
	gtk_container_add (GTK_CONTAINER (priv->portrait), box);
	
	/* landscape */
	icon = gtk_image_new_from_icon_name ("gtk-orientation-landscape",
										 GTK_ICON_SIZE_BUTTON);
	label = gtk_label_new_with_mnemonic (dgettext("gtk20", "Landscape"));
	
	box = gtk_hbox_new (FALSE, 4);
	gtk_box_pack_start (GTK_BOX (box), icon, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), label, TRUE, FALSE, 0);
	
	priv->landscape = gtk_radio_button_new (priv->group);
	gtk_container_add (GTK_CONTAINER (priv->landscape), box);
	
	
	/* reverse ? */
	
	priv->table = gtk_table_new (2, 1, TRUE);
	gtk_table_attach_defaults (GTK_TABLE (priv->table), priv->portrait,
							   0, 1, 0, 1);
	gtk_table_attach_defaults (GTK_TABLE (priv->table), priv->landscape,
							   0, 1, 1, 2);
	
	gtk_box_pack_start (GTK_BOX (gspw), priv->table, FALSE, FALSE, 0);
}

static void
gnome_scan_page_orientation_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	GnomeScanPageOrientationWidgetPrivate *priv = GET_PRIVATE (gspw);
	guint val = g_value_get_enum (value);
	
	switch (val) {
		case GTK_PAGE_ORIENTATION_PORTRAIT:
			case GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT:
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (priv->portrait), TRUE);
		break;
		case GTK_PAGE_ORIENTATION_LANDSCAPE:
			case GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE:
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (priv->landscape), TRUE);
		break;
	}
}


