/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */


#ifndef _GNOME_SCAN_SETTINGS_H_
#define _GNOME_SCAN_SETTINGS_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_SETTINGS             (gnome_scan_settings_get_type ())
#define GNOME_SCAN_SETTINGS(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_SETTINGS, GnomeScanSettings))
#define GNOME_SCAN_SETTINGS_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_SETTINGS, GnomeScanSettingsClass))
#define GNOME_IS_SCAN_SETTINGS(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_SETTINGS))
#define GNOME_IS_SCAN_SETTINGS_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_SETTINGS))
#define GNOME_SCAN_SETTINGS_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_SETTINGS, GnomeScanSettingsClass))

typedef struct _GnomeScanSettingsClass GnomeScanSettingsClass;
typedef struct _GnomeScanSettings GnomeScanSettings;

struct _GnomeScanSettingsClass
{
  GObjectClass parent_class;
	
  void	(* changed)	(GnomeScanSettings *settings, gchar *key, gpointer data);
};

/**
 * GnomeScanSettings:
 *
 * A #GnomeScanSettings manage a table of #GValue indexed by the name
 * of the param spec they where associated to.
 **/
struct _GnomeScanSettings
{
  /*< private >*/
  GObject parent_instance;
};

GType		gnome_scan_settings_get_type		(void) G_GNUC_CONST;
GnomeScanSettings*
gnome_scan_settings_new				(void);
void		gnome_scan_settings_init_value		(GnomeScanSettings *settings,
							 GParamSpec *pspec);
void		gnome_scan_settings_set			(GnomeScanSettings *settings,
							 const gchar *name,
							 const GValue *value);

void		gnome_scan_settings_set_transform	(GnomeScanSettings *settings,
							 const gchar *name,
							 const GValue *value);

void		gnome_scan_settings_set_double		(GnomeScanSettings *settings,
							 const gchar *name,
							 gdouble value);

void		gnome_scan_settings_set_int		(GnomeScanSettings *settings,
							 const gchar *name,
							 gint value);

void		gnome_scan_settings_set_enum		(GnomeScanSettings *settings,
							 const gchar *name,
							 GType type,
							 gint value);

void		gnome_scan_settings_set_boxed		(GnomeScanSettings *settings,
							 const gchar *name,
							 GType type,
							 gpointer value);

void		gnome_scan_settings_set_object		(GnomeScanSettings *settings,
							 const gchar *name,
							 GObject *value);

void		gnome_scan_settings_set_pointer		(GnomeScanSettings *settings,
							 const gchar *name,
							 gpointer value);

GValue*		gnome_scan_settings_get			(GnomeScanSettings *settings,
							 const gchar *name);

GValue* 	gnome_scan_settings_get_transformed	(GnomeScanSettings *settings,
							 const gchar *name,
							 GType type);

gchar*		gnome_scan_settings_get_string		(GnomeScanSettings *settings,
							 const gchar *name);

gdouble 	gnome_scan_settings_get_double		(GnomeScanSettings *settings,
							 const gchar *name);

gint		gnome_scan_settings_get_int		(GnomeScanSettings *settings,
							 const gchar *name);

gint		gnome_scan_settings_get_enum		(GnomeScanSettings *settings,
							 const gchar *name,
							 GType type);

gpointer	gnome_scan_settings_get_boxed		(GnomeScanSettings *settings,
							 const gchar *name,
							 GType type);

GObject*	gnome_scan_settings_get_object		(GnomeScanSettings *settings,
							 const gchar *name);

gpointer	gnome_scan_settings_get_pointer		(GnomeScanSettings *settings,
							 const gchar *name);

GHashTable*
gnome_scan_settings_get_all		(GnomeScanSettings *settings);

G_END_DECLS

#endif /* _GNOME_SCAN_SETTINGS_H_ */
