/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include "gnome-scan-boolean-widget.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_BOOLEAN_WIDGET, GnomeScanBooleanWidgetPrivate))

typedef struct _GnomeScanBooleanWidgetPrivate GnomeScanBooleanWidgetPrivate;
struct _GnomeScanBooleanWidgetPrivate
{
	GtkWidget *check;
};

static void gsbw_toggled (GtkToggleButton *button, GnomeScanParamWidget *gspw);

GS_DEFINE_PARAM_WIDGET (GnomeScanBooleanWidget, gnome_scan_boolean_widget);

static void
gnome_scan_boolean_widget_init (GnomeScanBooleanWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_boolean_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_boolean_widget_parent_class)->finalize (object);
}


static void
gnome_scan_boolean_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanBooleanWidgetPrivate *priv = GET_PRIVATE (gspw);
	gspw->shows_label = TRUE;
	priv->check = gtk_check_button_new_with_label (g_param_spec_get_nick (gspw->pspec));
	gtk_box_pack_start (GTK_BOX (gspw), priv->check, TRUE, TRUE, FALSE);
	
	g_signal_connect (GET_PRIVATE (gspw)->check, "toggled",
					  (GCallback) gsbw_toggled,
					  gspw);
}

static void
gnome_scan_boolean_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (GET_PRIVATE (gspw)->check),
								  g_value_get_boolean (gspw->value));
}

static void
gsbw_toggled (GtkToggleButton *button, GnomeScanParamWidget *gspw)
{
	g_value_set_boolean (gspw->value,
						 gtk_toggle_button_get_active (button));
	gnome_scan_param_widget_changed (gspw);
}

