/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanresolutionselector.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gnomescan.h"
#include "gnomescanui.h"
#include "gnomescanui-intl.h"

#define GNOME_SCAN_RESOLUTION_SELECTOR_ERROR			(g_type_qname (GNOME_TYPE_SCAN_RESOLUTION_SELECTOR))
#define	GNOME_SCAN_RESOLUTION_SELECTOR_PARENT_CLASS(klass)	(GTK_WIDGET_CLASS (g_type_class_peek_parent ((klass))))
#define GET_PRIVATE(obj)					(G_TYPE_INSTANCE_GET_PRIVATE ((obj), GNOME_TYPE_SCAN_RESOLUTION_SELECTOR, GnomeScanResolutionSelectorPrivate))

typedef struct _GnomeScanResolutionSelectorPrivate		GnomeScanResolutionSelectorPrivate;

struct _GnomeScanResolutionSelectorPrivate {
  gboolean		dispose_has_run;
  GtkWidget		*scale;
  GtkWidget		*spin;
};

/********************************
 * 	      CALLBACKS		*
 ********************************/

void				gsrs_scanner_selected				(GnomeScanContext *context,
										 GnomeScanner *scanner,
										 GnomeScanResolutionSelector *gsrs);

gchar*				gsrs_format_value				(GtkScale *scale,
										 gdouble value);

void				gsrs_value_changed				(GtkRange *range,
										 GnomeScanResolutionSelector *gsrs);
/********************************
 * 	       OTHERS		*
 ********************************/


/********************************
 * 	      GOBJECT		*
 ********************************/

void				gnome_scan_resolution_selector_set_property	(GObject *obj,
										 guint property_id,
										 const GValue *value,
										 GParamSpec *pspec);

void				gnome_scan_resolution_selector_get_property	(GObject *obj,
										 guint property_id,
										 GValue *value,
										 GParamSpec *pspec);

void				gnome_scan_resolution_selector_finalize		(GObject *obj);

void				gnome_scan_resolution_selector_dispose		(GObject *obj);


enum {
  PROP_0,
  PROP_CONTEXT
};

enum {
  N_SIGNALS
};

static guint signals[N_SIGNALS];


G_DEFINE_TYPE (GnomeScanResolutionSelector, gnome_scan_resolution_selector, GNOME_TYPE_SCAN_OPTION_WIDGET);


void
gnome_scan_resolution_selector_class_init (GnomeScanResolutionSelectorClass *klass)
{
  GObjectClass* gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = gnome_scan_resolution_selector_set_property;
  gobject_class->get_property = gnome_scan_resolution_selector_get_property;
  gobject_class->dispose 	= gnome_scan_resolution_selector_dispose;
  /*   gobject_class->finalize 	= gnome_scan_resolution_selector_finalize; */

  g_type_class_add_private (gobject_class,
			    sizeof (GnomeScanResolutionSelectorPrivate));

  /* Properties */
  /* Signals */
}

void
gnome_scan_resolution_selector_init (GnomeScanResolutionSelector *widget)
{
  GnomeScanResolutionSelectorPrivate *priv = GET_PRIVATE (widget);

  priv->dispose_has_run = FALSE;
  priv->scale		= NULL;
  priv->spin		= NULL;
}

void
gnome_scan_resolution_selector_dispose (GObject *obj)
{
  GnomeScanResolutionSelector *widget = GNOME_SCAN_RESOLUTION_SELECTOR (obj);
  GnomeScanResolutionSelectorPrivate *priv = GET_PRIVATE (widget);
  GnomeScanResolutionSelectorClass *b_klass = GNOME_SCAN_RESOLUTION_SELECTOR_GET_CLASS (obj);

  /* That would be nice if g_return_if_fail were noiseless. */
  if (priv->dispose_has_run == TRUE) {
    return;
  }

  /* unref devices */
  priv->dispose_has_run = TRUE;

  /* chain */
  /*   GNOME_SCAN_RESOLUTION_SELECTOR_PARENT_CLASS (b_klass)->dispose (obj); */
}

void
gnome_scan_resolution_selector_finalize (GObject *obj)
{
  GnomeScanResolutionSelector *widget = GNOME_SCAN_RESOLUTION_SELECTOR (obj);
  GnomeScanResolutionSelectorClass *b_klass = GNOME_SCAN_RESOLUTION_SELECTOR_GET_CLASS (obj);

  /*   GNOME_SCAN_RESOLUTION_SELECTOR_PARENT_CLASS (b_klass)->finalize (obj); */
}

void
gnome_scan_resolution_selector_set_property (GObject *obj,
				guint property_id,
				const GValue *value,
				GParamSpec *pspec)
{
  GnomeScanResolutionSelector *widget = GNOME_SCAN_RESOLUTION_SELECTOR (obj);
  GnomeScanResolutionSelectorPrivate *priv = GET_PRIVATE (widget);

  switch (property_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID(obj,
				      property_id,
				      pspec);
    break;
  }
}

void
gnome_scan_resolution_selector_get_property (GObject *obj,
				guint property_id,
				GValue *value,
				GParamSpec *pspec)
{
  GnomeScanResolutionSelector *widget = GNOME_SCAN_RESOLUTION_SELECTOR (obj);
  GnomeScanResolutionSelectorPrivate *priv = GET_PRIVATE (widget);

  switch (property_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID(obj,
				      property_id,
				      pspec);
    break;
  }
}




/********************************
 * 	      METHODS		*
 ********************************/

/**
 * gnome_scan_resolution_selector_new:
 * @context: a #GnomeScanContext
 * 
 * Create a new #GnomeScanResolutionSelector connected to @context.
 * 
 * Return value: a new #GnomeScanResolutionSelector
 **/
GtkWidget*
gnome_scan_resolution_selector_new (GnomeScanContext *context)
{
  GtkWidget *widget, *hbox;
  GnomeScanResolutionSelector *gsrs;
  GnomeScanResolutionSelectorPrivate *priv;

  widget = GTK_WIDGET (g_object_new (GNOME_TYPE_SCAN_RESOLUTION_SELECTOR,
				     "context", context,
				     NULL));

  gnome_scan_option_widget_set_label (GNOME_SCAN_OPTION_WIDGET (widget),
				      _("Resolution"));

  
  gsrs = GNOME_SCAN_RESOLUTION_SELECTOR (widget);
  priv = GET_PRIVATE (gsrs);

  priv->scale = gtk_hscale_new (NULL);
  gtk_scale_set_draw_value (GTK_SCALE (priv->scale), FALSE);
  gtk_range_set_update_policy (GTK_RANGE (priv->scale),
			       GTK_UPDATE_CONTINUOUS);
  gtk_range_set_increments (GTK_RANGE (priv->scale),
			    5,	/* seems buggy, value is doubled */
			    100);

  priv->spin = gtk_spin_button_new (gtk_range_get_adjustment (GTK_RANGE (priv->scale)),
				    .5,
				    0);

  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (priv->spin),
				     GTK_UPDATE_CONTINUOUS);

  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (priv->spin), TRUE);

  hbox = gtk_hbox_new (FALSE, 6);

  gtk_box_pack_start (GTK_BOX (hbox),
		      priv->scale,
		      TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (hbox),
		      priv->spin,
		      FALSE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (hbox),
		      gtk_label_new (_("dpi")),
		      FALSE, TRUE, 0);

  gnome_scan_option_widget_pack_child (GNOME_SCAN_OPTION_WIDGET (widget),
				       hbox,
				       TRUE, TRUE);

  g_signal_connect (GTK_RANGE (priv->scale),
		    "value-changed",
		    G_CALLBACK (gsrs_value_changed),
		    gsrs);

  g_signal_connect (context,
		    "scanner-selected",
		    G_CALLBACK (gsrs_scanner_selected),
		    gsrs);

  return widget;
}

/********************************
 * 	      CALLBACKS		*
 ********************************/

void
gsrs_scanner_selected (GnomeScanContext *context,
		       GnomeScanner *scanner,
		       GnomeScanResolutionSelector *gsrs)
{
  GnomeScanResolutionSelectorPrivate *priv = GET_PRIVATE (gsrs);
  GnomeScanRange *range = gnome_scanner_get_resolution_range (scanner);
  gdouble resolution;

  resolution = (gdouble) gnome_scan_context_get_resolution (context);
  gtk_range_set_range (GTK_RANGE (priv->scale), range->lower, range->upper);
  gtk_range_set_value (GTK_RANGE (priv->scale), resolution);
}

void
gsrs_value_changed (GtkRange *range,
		    GnomeScanResolutionSelector *gsrs)
{
  gnome_scan_context_set_resolution (GNOME_SCAN_OPTION_WIDGET (gsrs)->context,
				     (gint) gtk_range_get_value (range));
}

/********************************
 * 	       OTHERS		*
 ********************************/

