/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescansourceselector.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gnomescan.h"
#include "gnomescanui.h"
#include "gnomescanui-intl.h"

#define GNOME_SCAN_SOURCE_SELECTOR_ERROR		(g_type_qname (GNOME_TYPE_SCAN_SOURCE_SELECTOR))
#define	GNOME_SCAN_SOURCE_SELECTOR_PARENT_CLASS(klass)	(GTK_WIDGET_CLASS (g_type_class_peek_parent ((klass))))
#define GET_PRIVATE(obj)				(G_TYPE_INSTANCE_GET_PRIVATE ((obj), GNOME_TYPE_SCAN_SOURCE_SELECTOR, GnomeScanSourceSelectorPrivate))

typedef struct _GnomeScanSourceSelectorPrivate		GnomeScanSourceSelectorPrivate;

struct _GnomeScanSourceSelectorPrivate {
  gboolean		dispose_has_run;
  GtkWidget 		*combo;

  /* PROPERTIES */
};

enum {
  COLUMN_ICON,
  COLUMN_LABEL,
  N_COLUMNS
};

void				gnome_scan_source_selector_scanner_selected	(GnomeScanContext *context,
										 GnomeScanner *scanner,
										 GnomeScanSourceSelector *selector);

void				gnome_scan_source_selector_source_choosed	(GtkComboBox *combo,
										 GnomeScanSourceSelector *selector);
										 

/********************************
 * 	      GOBJECT		*
 ********************************/

void				gnome_scan_source_selector_set_property 	(GObject *obj,
										 guint property_id,
										 const GValue *value,
										 GParamSpec *pspec);

void				gnome_scan_source_selector_get_property 	(GObject *obj,
										 guint property_id,
										 GValue *value,
										 GParamSpec *pspec);

void				gnome_scan_source_selector_finalize		(GObject *obj);

void				gnome_scan_source_selector_dispose		(GObject *obj);


enum {
  PROP_0,
  PROP_CONTEXT
};

enum {
  N_SIGNALS
};

static guint signals[N_SIGNALS];


G_DEFINE_TYPE (GnomeScanSourceSelector, gnome_scan_source_selector, GNOME_TYPE_SCAN_OPTION_WIDGET);


void
gnome_scan_source_selector_class_init (GnomeScanSourceSelectorClass *klass)
{
  GObjectClass* gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = gnome_scan_source_selector_set_property;
  gobject_class->get_property = gnome_scan_source_selector_get_property;
  gobject_class->dispose 	= gnome_scan_source_selector_dispose;
  /*   gobject_class->finalize 	= gnome_scan_source_selector_finalize; */

  g_type_class_add_private (gobject_class,
			    sizeof (GnomeScanSourceSelectorPrivate));
}

void
gnome_scan_source_selector_init (GnomeScanSourceSelector *widget)
{
  GnomeScanSourceSelectorPrivate *priv = GET_PRIVATE (widget);

  widget->context = NULL;

  priv->dispose_has_run = FALSE;
}

void
gnome_scan_source_selector_dispose (GObject *obj)
{
  GnomeScanSourceSelector *widget = GNOME_SCAN_SOURCE_SELECTOR (obj);
  GnomeScanSourceSelectorPrivate *priv = GET_PRIVATE (widget);
  GnomeScanSourceSelectorClass *b_klass = GNOME_SCAN_SOURCE_SELECTOR_GET_CLASS (obj);

  /* That would be nice if g_return_if_fail were noiseless. */
  if (priv->dispose_has_run == TRUE) {
    return;
  }

  /* unref devices */
  g_object_unref (widget->context);
  priv->dispose_has_run = TRUE;

  /* chain */
  /*   GNOME_SCAN_SOURCE_SELECTOR_PARENT_CLASS (b_klass)->dispose (obj); */
}

void
gnome_scan_source_selector_finalize (GObject *obj)
{
  GnomeScanSourceSelector *widget = GNOME_SCAN_SOURCE_SELECTOR (obj);
  GnomeScanSourceSelectorClass *b_klass = GNOME_SCAN_SOURCE_SELECTOR_GET_CLASS (obj);

  /*   GNOME_SCAN_SOURCE_SELECTOR_PARENT_CLASS (b_klass)->finalize (obj); */
}

void
gnome_scan_source_selector_set_property (GObject *obj,
				guint property_id,
				const GValue *value,
				GParamSpec *pspec)
{
  GnomeScanSourceSelector *widget = GNOME_SCAN_SOURCE_SELECTOR (obj);
  GnomeScanSourceSelectorPrivate *priv = GET_PRIVATE (widget);

  switch (property_id) {
  case PROP_CONTEXT:
    widget->context = GNOME_SCAN_CONTEXT (g_value_dup_object (value));
    break;
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID(obj,
				      property_id,
				      pspec);
    break;
  }
}

void
gnome_scan_source_selector_get_property (GObject *obj,
				guint property_id,
				GValue *value,
				GParamSpec *pspec)
{
  GnomeScanSourceSelector *widget = GNOME_SCAN_SOURCE_SELECTOR (obj);
  GnomeScanSourceSelectorPrivate *priv = GET_PRIVATE (widget);

  switch (property_id) {
  case PROP_CONTEXT:
    g_value_set_object (value, widget->context);
    break;
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID(obj,
				      property_id,
				      pspec);
    break;
  }
}




/********************************
 * 	      METHODS		*
 ********************************/

/**
 * gnome_scan_source_selector_new:
 * @context: a #GnomeScanContext
 * 
 * Create a new #GnomeScanSourceSelector connected to @context.
 * 
 * Return value: a new #GnomeScanSourceSelector
 **/
GtkWidget*
gnome_scan_source_selector_new (GnomeScanContext *context)
{
  GtkWidget *selector, *combo;
  GtkListStore *store;
  GtkCellRenderer *renderer;

  selector = GTK_WIDGET (g_object_new (GNOME_TYPE_SCAN_SOURCE_SELECTOR,
				       "context", context,
				       NULL));

  store = gtk_list_store_new (N_COLUMNS,
			      GDK_TYPE_PIXBUF,
			      G_TYPE_STRING);

  /* combo */
  combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL (store));
  GET_PRIVATE (GNOME_SCAN_SOURCE_SELECTOR (selector))->combo = combo;

  gnome_scan_option_widget_pack_child (GNOME_SCAN_OPTION_WIDGET (selector),
				       combo,
				       FALSE,
				       TRUE);

  gnome_scan_option_widget_set_label (GNOME_SCAN_OPTION_WIDGET (selector),
				      _("Source"));

  renderer = gtk_cell_renderer_pixbuf_new ();
  gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (combo),
			      renderer,
			      FALSE);
  gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT (combo),
				 renderer,
				 "pixbuf",
				 COLUMN_ICON);

  renderer = gtk_cell_renderer_text_new ();
  gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (combo),
			      renderer,
			      TRUE);
  gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT (combo),
				 renderer,
				 "markup",
				 COLUMN_LABEL);

  /* signals */
  g_signal_connect (context,
		    "scanner-selected",
		    (GCallback) gnome_scan_source_selector_scanner_selected,
		    GNOME_SCAN_SOURCE_SELECTOR (selector));

  g_signal_connect (combo,
		    "changed",
		    (GCallback) gnome_scan_source_selector_source_choosed,
		    GNOME_SCAN_SOURCE_SELECTOR (selector));

  gtk_widget_set_no_show_all (selector, TRUE);

  return selector;
}

/********************************
 * 	      OTHER		*
 ********************************/

void
gnome_scan_source_selector_scanner_selected (GnomeScanContext *context,
					     GnomeScanner *scanner,
					     GnomeScanSourceSelector *selector)
{
  GnomeScanSourceSelectorPrivate *priv = GET_PRIVATE (selector);
  GValueArray *sources;
  GValue *source;
  GnomeScannerSource v_enum;
  const gchar *title;
  gint i;
  GtkListStore *store;
  GtkTreeIter iter;

  sources = gnome_scanner_get_sources (scanner);
/*   g_debug ("sources = %p", sources); */
  store = GTK_LIST_STORE (gtk_combo_box_get_model (GTK_COMBO_BOX (priv->combo)));
  gtk_list_store_clear (store);

  for (i = 0; i < sources->n_values ; i++) {
    gtk_list_store_append (store,
			   &iter);
    source = g_value_array_get_nth (sources, i);
    v_enum = g_value_get_enum (source);
    title = gnome_scanner_source_get_title (v_enum);

    gtk_list_store_set (store, &iter,
			COLUMN_LABEL, title,
			-1);
  }

  gtk_combo_box_set_active (GTK_COMBO_BOX (priv->combo),
			    0);

  /* show or hide the selector */
  gtk_widget_set_no_show_all (GTK_WIDGET (selector), FALSE);
  if (i == 1) {
    gtk_widget_hide (GTK_WIDGET (selector));
  }
  else {
    gtk_widget_show_all (GTK_WIDGET (selector));
  }
}

void
gnome_scan_source_selector_source_choosed (GtkComboBox *combo,
					   GnomeScanSourceSelector *selector)
{
  GnomeScanContext *context;
  GValueArray *sources;
  GnomeScannerSource source;
  gint index;

  context = gnome_scan_option_widget_get_context (GNOME_SCAN_OPTION_WIDGET (selector));
  sources = gnome_scanner_get_sources (gnome_scan_context_get_scanner (context));
  index = gtk_combo_box_get_active (combo);
  source = g_value_get_enum (g_value_array_get_nth (sources,
						    index));
  gnome_scan_context_set_source (context,
				 source);
}
