/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __AGSERVERCONFIG_H__
#define __AGSERVERCONFIG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <AGTypes.h>
#include <AGArray.h>
#include <AGReader.h>
#include <AGWriter.h>
#include <AGRecord.h>
#include <AGDBConfig.h>

#define AGSERVERCONFIG_MAX_PASSWORD_LENGTH (14)

/* AGServerConfig resides on the desktop and the device.
 It is editable on both the desktop and the device.
 The server modifies the database configurations 
 when it needs to do so (as well as the adminURL 
 and description).
*/

enum {
    AG_HASH_PASSWORD_NO = 0,
    AG_HASH_PASSWORD_YES = 1,
    AG_HASH_PASSWORD_UNKNOWN
};
    
/*  Note:  This data structure has been published to the world.
    If anything in it changes, it must remain compatible with previous
    versions.
*/
typedef struct AGServerConfig {

    int32 uid;
    AGRecordStatus status;

    /* device/desktop modifies */
    char *serverName;
    int16 serverPort;
    char *userName;
    char *cleartextPassword;
    uint8 password[16]; /* hash */
    AGBool disabled;

    /* server modifies */
    char *friendlyName;
    char *serverType;
    char *userUrl;
    char *description;
    char *serverUri;
    int32 sequenceCookieLength;
    uint8 *sequenceCookie;
    AGArray *dbconfigs;
    uint8 nonce[16];
    AGBool sendDeviceInfo;
    uint8 hashPassword;

    uint32 connectTimeout;
    uint32 writeTimeout;
    uint32 readTimeout;

    AGBool connectSecurely;
    AGBool allowSecureConnection;

} AGServerConfig;


ExportFunc AGServerConfig *AGServerConfigNew();
ExportFunc AGServerConfig *AGServerConfigInit(AGServerConfig *config);
ExportFunc void AGServerConfigFinalize(AGServerConfig *config);
ExportFunc void AGServerConfigFree(AGServerConfig *config);

ExportFunc AGServerConfig *AGServerConfigCopy(AGServerConfig *dstConfig, 
                                              AGServerConfig *srcConfig);
ExportFunc AGServerConfig *AGServerConfigDup(AGServerConfig *srcConfig);

ExportFunc void AGServerConfigReadData(AGServerConfig *config, AGReader *r);
ExportFunc AGServerConfig * AGServerConfigNewAndReadData(AGReader *r);
ExportFunc void AGServerConfigWriteData(AGServerConfig *config, AGWriter *w);
    
ExportFunc AGDBConfig *AGServerConfigGetDBConfigNamed(AGServerConfig *config, 
                                                      char *dbname);
ExportFunc AGDBConfig *
AGServerConfigDeleteDBConfigNamed(AGServerConfig *config, 
                                  char *dbname);
ExportFunc void AGServerConfigAddDBConfig(AGServerConfig *config, 
                                          AGDBConfig *dbconfig);
#ifndef REMOVE_SYNCHRONIZE_FEATURE
ExportFunc AGServerConfig * AGServerConfigSynchronize(AGServerConfig *agreed,
                                                      AGServerConfig *device,
                                                      AGServerConfig *desktop);
#endif
ExportFunc AGBool AGServerConfigIsValid(AGServerConfig *config);
ExportFunc void AGServerConfigResetCookie(AGServerConfig *config);
ExportFunc void AGServerConfigResetNonce(AGServerConfig *config);
ExportFunc void AGServerConfigResetHashState(AGServerConfig *config);
ExportFunc void AGServerConfigResetStates(AGServerConfig *config);
ExportFunc void AGServerConfigChangeHashPasswordState(AGServerConfig *config,
                                                      uint8 newstate);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __AGSERVERCONFIG_H__ */
