/* gnome-ppp - The GNOME PPP Dialer
 * Copyright (C) 1997, 1998 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <unistd.h>
#include <gnome.h>
#include "gnome-ppp.h"
#include "command-line.h"
#include "dial-window.h"
#include "global.h"


/* prototypes */
static void usage(char *argv[]);
void exit_gppp();


int
main(int argc, char *argv[])
{
  int arg, command_line_flag, dial_flag, list_flag;
  char *account_name;

  /* initalize flags to defaults */
  command_line_flag = 0;
  dial_flag = 0;
  list_flag = 0;

  /* arguments:
   *    -c : command line mode
   *    -d account : dial account
   *    -l : list configured accounts (command line mode)
   */
  while ((arg = getopt(argc, argv, "h?cld:")) != EOF)
    {
      switch (arg)
	{
	case 'c':
	  command_line_flag = 1;
	  break;

	case 'l':
	  list_flag = 1;
	  break;

	case 'd':
	  dial_flag = 1;
	  account_name = optarg;
	  break;

	case 'h':
	case '?':
	default:
	  usage(argv);
	    break;
	}
    }

  /* GUI mode */
  if (!command_line_flag)
    {
      gnome_init("gnome_ppp", "0.1", argc, argv);
      gnomeppplib_init();

      account_load();
      open_dial_window();
      gtk_main();
      return 0;
    }
  else
    {
      /* list accounts */
      if (list_flag)
	{
	  command_line_list();
	}

      /* dial */
      if (dial_flag)
	{
	  command_line_dial(account_name);
	}
    }

  exit(0);
}


static void
usage(char *argv[])
{
  fprintf(stdout, "Usage: %s [OPTION] [ACCOUNT]\n", argv[0]);
  fprintf(stdout, "  -c\t\t\tcommand line mode (no gui)\n");
  fprintf(stdout, "  -l\t\t\tlist configured accounts\n");
  fprintf(stdout, "  -d <account name>\tdial account\n");
  exit(1);
}


void
exit_gppp()
{
  account_save();
  gtk_exit(0);
}



