/* gnome-ppp - The GNOME PPP Dialer
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gnome.h>
#include "gnome-ppp.h"
#include "account-window.h"
#include "configure-window.h"
#include "global.h"
#include "misc.h"


typedef struct _ConfigureWindow
{
  GtkWidget *window;
  GtkWidget *account_list;
  GtkWidget *modem_device;
  GtkWidget *flow_control;
  GtkWidget *modem_command_clist;
  GtkWidget *modem_commend_entry;
} ConfigureWindow;
static ConfigureWindow *cw = NULL;


/* notebook pages */
GtkWidget *create_accounts_page();


/* callbacks */
static void close_configure_window();


/* account page callbacks */
static void account_list_select_cb(GtkWidget * widget, gint row, gint col, GdkEventButton * bevent);
static void account_edit_cb();
static void account_new_cb();
static void account_duplicate_cb();
static void account_delete_cb();


void
open_configure_window()
{
  GtkWidget *vbox;
  GtkWidget *notebook;
  GtkWidget *hbox;
  GtkWidget *bbox;
  GtkWidget *button;
  GtkWidget *label;

  if(cw)
    {
      return;
    }

  cw = g_malloc(sizeof(ConfigureWindow));

  cw->window = gtk_dialog_new();
  gtk_widget_set_usize(GTK_WIDGET(cw->window), CONFIGURE_WINDOW_WIDTH, CONFIGURE_WINDOW_HEIGHT);
  gtk_window_set_title(GTK_WINDOW(cw->window), "Configure PPP");
  gtk_container_border_width(GTK_CONTAINER(cw->window), 0);

  gtk_signal_connect(
      GTK_OBJECT(cw->window),
      "destroy",
      (GtkSignalFunc) close_configure_window,
      NULL
      );

  gtk_signal_connect(
      GTK_OBJECT(cw->window),
      "delete_event",
      (GtkSignalFunc) gtk_false,
      NULL
      );

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cw->window)->vbox), hbox, TRUE, TRUE, 5);
  gtk_widget_show(hbox);

  /* notbook */
  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
  gtk_box_pack_start(GTK_BOX (hbox), notebook, TRUE, TRUE, 5);
  gtk_widget_show(notebook);

  /* close button (bottom dialog) */
  bbox = gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cw->window)->action_area), bbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_child_size(GTK_BUTTON_BOX(bbox), GPPP_BUTTON_WIDTH, GPPP_BUTTON_HEIGHT);
  gtk_widget_show(bbox);

  button = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
  gtk_container_add (GTK_CONTAINER (bbox), button);
  gtk_signal_connect_object(
      GTK_OBJECT(button),
      "clicked",
      GTK_SIGNAL_FUNC(gtk_widget_destroy),
      GTK_OBJECT(cw->window)
      );
  gtk_widget_show(button);

  /* accounts notbook page */
  label = gtk_label_new("Accounts");
  gtk_notebook_append_page(GTK_NOTEBOOK (notebook), create_accounts_page(), label);

  refresh_configure_window();
  gtk_widget_show(cw->window);
}


void
refresh_configure_window ()
{
  GList *list;

  if (!cw)
    {
      return;
    }

  /* list accounts */
  gtk_clist_freeze(GTK_CLIST(cw->account_list));
  gtk_clist_clear(GTK_CLIST(cw->account_list));

  list = account_list();
  while (list)
    {
      Account *account;
      gchar *text[1];

      account = (Account *) list->data;
      list = list->next;

      text[0] = account->name->str;
      gtk_clist_set_row_data(
          GTK_CLIST(cw->account_list),
	  gtk_clist_append(GTK_CLIST(cw->account_list), text),
	  (gpointer) account
	  );
    }

  gtk_clist_thaw(GTK_CLIST(cw->account_list));
}


/* page widgets */
GtkWidget *
create_accounts_page()
{
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *button;

  static char *titles[] =
  {
    "Account"
  };

  /* main return widget */
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_set_spacing(GTK_BOX(hbox), 5);
  gtk_container_border_width(GTK_CONTAINER(hbox), 5);
  gtk_widget_show(hbox);

  /* accounts clist */
  cw->account_list = gtk_clist_new_with_titles(1, titles);
  gtk_clist_column_titles_passive(GTK_CLIST(cw->account_list));
  gtk_clist_set_selection_mode(GTK_CLIST(cw->account_list), GTK_SELECTION_SINGLE);
  gtk_box_pack_start(GTK_BOX(hbox), cw->account_list, TRUE, TRUE, 0);
  gtk_signal_connect(
      GTK_OBJECT(cw->account_list),
      "select_row",
      (GtkSignalFunc) account_list_select_cb,
      NULL
      );
  gtk_widget_show(cw->account_list);

  /* one vbox to hold them all... */
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_box_set_spacing(GTK_BOX(vbox), 10);
  gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);
  gtk_widget_show(vbox);

  /* edit account button */
  button = gtk_button_new_with_label("Edit...");
  gtk_widget_set_usize(button, GPPP_BUTTON_WIDTH, GPPP_BUTTON_HEIGHT);
  gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect(
      GTK_OBJECT(button),
      "clicked",
      (GtkSignalFunc) account_edit_cb,
      NULL
      );
  gtk_widget_show(button);

  /* new account button */
  button = gtk_button_new_with_label("New...");
  gtk_widget_set_usize(button, GPPP_BUTTON_WIDTH, GPPP_BUTTON_HEIGHT);
  gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect(
      GTK_OBJECT (button),
      "clicked",
      (GtkSignalFunc) account_new_cb,
      NULL
      );
  gtk_widget_show(button);

  /* duplicate account button */
  button = gtk_button_new_with_label("Duplicate");
  gtk_widget_set_usize(button, GPPP_BUTTON_WIDTH, GPPP_BUTTON_HEIGHT);
  gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect_object(
      GTK_OBJECT(button),
      "clicked",
      (GtkSignalFunc) account_duplicate_cb,
      NULL
      );
  gtk_widget_show(button);

  /* delete account button */
  button = gtk_button_new_with_label("Delete");
  gtk_widget_set_usize (button, GPPP_BUTTON_WIDTH, GPPP_BUTTON_HEIGHT);
  gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
  gtk_signal_connect_object(
      GTK_OBJECT (button),
      "clicked",
      (GtkSignalFunc) account_delete_cb,
      NULL
      );
  gtk_widget_show(button);

  /* return main widget */
  return hbox;
}


/* 
 * callbacks
 */
static void 
close_configure_window ()
{
  if (cw)
    {
      g_free(cw);
      cw = NULL;
    }
}


/*
 * account page callbacks
 */
static void 
account_list_select_cb(GtkWidget * widget, gint row, gint col, GdkEventButton * bevent)
{
  if (bevent)
    {
      /* double-clicking edits an account */
      if (bevent->type == GDK_2BUTTON_PRESS)
	{
	  open_account_window((Account *) gtk_clist_get_row_data(GTK_CLIST(cw->account_list), row));
	}
    }
}


static void
account_edit_cb()
{
  gint row;

  if (!GTK_CLIST(cw->account_list)->selection)
    {
      return;
    }

  row = (gint) GTK_CLIST(cw->account_list)->selection->data;
  open_account_window(
      (Account *) gtk_clist_get_row_data (GTK_CLIST (cw->account_list), row)
      );
}


static void
account_new_cb()
{
  open_account_window(NULL);
}


static void
account_duplicate_cb()
{
  gint row;
  gchar *text[1];
  Account *account;

  if (!GTK_CLIST(cw->account_list)->selection)
    {
      return;
    }

  row = (gint) GTK_CLIST (cw->account_list)->selection->data;
  account = (Account *) gtk_clist_get_row_data (GTK_CLIST (cw->account_list), row);

  account = account_clone(account);
  text[0] = account->name->str;
  row = gtk_clist_append(GTK_CLIST(cw->account_list), text);
  gtk_clist_set_row_data(GTK_CLIST(cw->account_list), row, (gpointer) account);
  gtk_clist_select_row(GTK_CLIST(cw->account_list), row, -1);
  
  open_account_window(account);
}


static void
account_delete_cb()
{
  gint row;
  Account *account;

  if (!GTK_CLIST(cw->account_list)->selection)
    {
      return;
    }

  row = (gint) GTK_CLIST(cw->account_list)->selection->data;
  account = (Account *) gtk_clist_get_row_data(GTK_CLIST(cw->account_list), row);
  gtk_clist_remove(GTK_CLIST(cw->account_list), row);

  /* remove row from global account list */
  account_free(account);

  refresh_dial_window();
}
