# Note that this is NOT a relocatable package
%define name     gnome-libs
%define ver      1.0.2
%define rel      1
%define prefix   /usr

Name: %name
Summary: The libraries needed by the GNOME GUI desktop environment.
Version: %ver
Release: %rel
Copyright: LGPL
Group: System Environment/Libraries
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gnome-libs/%name-%{ver}.tar.gz
URL: http://www.gnome.org/
Requires: gtk+ >= 1.2
Docdir: %{prefix}/doc

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on Open Source software.
The gnome-libs package includes libraries that are needed by GNOME.

You should install the gnome-libs package if you would like to use the
GNOME desktop environment.  You'll also need to install the gnome-core
package.  If you would like to develop GNOME applications, you'll also
need to install gnome-libs-devel.

%package devel
Summary: Libraries and include files for developing GNOME applications.
Group: Development/Libraries
Requires: %name = %{PACKAGE_VERSION}
Obsoletes: %name

%description devel
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on Open Source software. 
The gnome-libs-devel package includes the libraries and include files that
you will need to develop GNOME applications.  

You should install the gnome-libs-devel package if you would like to
develop GNOME applications.  You don't need to install gnome-libs-devel
if you just want to use the GNOME desktop environment.  If you are going
to develop GNOME applications and/or you're going to use the GNOME desktop
environment, you'll also need to install the gnome-core and gnome-libs
packages.

%changelog
* Tue Mar 2  1999 Gregory McLean <gregm@comstar.net>

- Added some hackage in for the brain dead libtool on the alpha
- Cleaned up the spec file abit to be more consistant.

* Wed Feb 17 1999 Elliot Lee <sopwith@redhat.com>

- Add debugging disabling flags to $CFLAGS

* Fri Nov 20 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- use --localstatedir=/var/lib in config state (score files for games
  for exemple will go there).
- added several more files to %files section, in particular language
  files and corba IDLs

* Wed Sep 23 1998 Michael Fulbright <msf@redhat.com>

- Updated to version 0.30

* Mon Apr 13 1998 Marc Ewing <marc@redhat.com>
- Added %{prefix}/lib/gnome-libs

* Fri Mar 13 1998 Marc Ewing <marc@redhat.com>

- Integrate into gnome-libs source tree

%prep
%setup

%build
%ifarch alpha
 MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif
# Needed for snapshot releases.

MYCFLAGS="$RPM_OPT_FLAGS"

if [ ! -f configure ]; then
  CFLAGS="$MYCFLAGS" ./autogen.sh $MYARCH_FLAGS --prefix=%prefix --localstatedir=/var/lib
else
  CFLAGS="$MYCFLAGS" ./configure $MYARCH_FLAGS --prefix=%prefix --localstatedir=/var/lib
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post 
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi

/sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/lib/lib*.so.*
%{prefix}/bin/*
%{prefix}/sbin/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/idl/*
%{prefix}/share/pixmaps/*
%config %{prefix}/share/gtkrc*
%{prefix}/share/mime-info/gnome.mime
%{prefix}/share/type-convert/type.convert
%config %{prefix}/etc/*

%files devel
%defattr(-, root, root)

%doc devel-docs

%{prefix}/lib/lib*.so
%{prefix}/lib/*.a
%{prefix}/lib/*.sh
%{prefix}/lib/gnome-libs
%{prefix}/include/*
%{prefix}/share/aclocal/*
%{prefix}/share/doc/*
