#include <config.h>
#include <gtk/gtktypeutils.h>
#include "libgnomeui.h"

#include "gnometypebuiltins_vars.c"
#include "gnometypebuiltins_evals.c"

/* maybe this should be put in GTK */
static GtkType
gnome_type_register_boxed (gchar *name) {
  GtkTypeInfo info;

  info.type_name = name;
  info.object_size = 0;
  info.class_size = 0;
  info.class_init_func = NULL;
  info.object_init_func = NULL;
  info.reserved_1 = NULL;
  info.reserved_2 = NULL;

  return gtk_type_unique(GTK_TYPE_BOXED, &info);
}

void
gnome_type_init() {
  int i;

  struct {
    gchar * type_name;
    GtkType *type_id;
    GtkType parent;
    GtkEnumValue *values;
  } builtin_info[GNOME_TYPE_NUM_BUILTINS + 1] = {
#include "gnometypebuiltins_ids.c"
    { NULL }
  };

  for (i = 0; i < GNOME_TYPE_NUM_BUILTINS; i++)
    {
      GtkType type_id = GTK_TYPE_INVALID;
      g_assert (builtin_info[i].type_name != NULL);
      if ( builtin_info[i].parent == GTK_TYPE_ENUM )
      	type_id = gtk_type_register_enum (builtin_info[i].type_name, builtin_info[i].values);
      else if ( builtin_info[i].parent == GTK_TYPE_FLAGS )
      	type_id = gtk_type_register_flags (builtin_info[i].type_name, builtin_info[i].values);
      else if ( builtin_info[i].parent == GTK_TYPE_BOXED )
        type_id = gnome_type_register_boxed (builtin_info[i].type_name);

      g_assert (type_id != GTK_TYPE_INVALID);
      (*builtin_info[i].type_id) = type_id;
    }

}

