/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2005 Imendio AB
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <libgnomevfs/gnome-vfs.h>
#include <menu-tree.h>

static void
applications_add_directory (GSList **applications, MenuTreeDirectory *dir)
{
	GSList *entries;
	GSList *subdirs;
	GSList *l;

	entries = menu_tree_directory_get_entries (dir);
	subdirs = menu_tree_directory_get_subdirs (dir);

	if (entries) {
		*applications = g_slist_concat (*applications, entries);
	}

	for (l = subdirs; l; l = l->next) {
		MenuTreeDirectory *subdir;

		subdir = (MenuTreeDirectory *) l->data;
		applications_add_directory (applications, subdir);
		menu_tree_directory_unref (subdir);
	}

	g_slist_free (subdirs);
}

static GSList *
applications_get_list (void)
{
	MenuTree          *tree;
	MenuTreeDirectory *root;
	GSList            *applications;

	tree = menu_tree_lookup ("applications.menu");
	if (!tree) {
		g_warning ("Failed to look up applications.menu");
		return NULL;
	}

	root = menu_tree_get_root_directory (tree);
	if (!root) {
		g_warning ("Menu tree empty");
		menu_tree_unref (tree);
		return NULL;
	}

	applications = NULL;

	applications_add_directory (&applications, root);

	menu_tree_directory_unref (root);
	menu_tree_unref (tree);

	return applications;
}

int
main (int argc, char **argv)
{
	GSList *applications;
	GSList *l;

	gnome_vfs_init ();

	applications = applications_get_list ();

	for (l = applications; l; l = l->next) {
		MenuTreeEntry *entry;

		entry = (MenuTreeEntry *) l->data;
		g_print ("%s - %s\n",
			 menu_tree_entry_get_name (entry),
			 menu_tree_entry_get_icon (entry));
		menu_tree_entry_unref (entry);
	}

	g_slist_free (applications);

	gnome_vfs_shutdown ();

	return 0;
}
