/* IDBusChannelList.c generated by valac 0.25.1, the Vala compiler
 * generated from IDBusChannelList.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_TYPE_CHANNEL_INFO (dvb_channel_info_get_type ())
typedef struct _DVBChannelInfo DVBChannelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

#define DVB_TYPE_ID_BUS_CHANNEL_LIST_PROXY (dvb_id_bus_channel_list_proxy_get_type ())
typedef GDBusProxy DVBIDBusChannelListProxy;
typedef GDBusProxyClass DVBIDBusChannelListProxyClass;

struct _DVBChannelInfo {
	guint id;
	gchar* name;
	gboolean is_radio;
};

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error);
	gboolean (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
	gboolean (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error);
	DVBChannelInfo* (*GetChannelInfos) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelsOfGroup) (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
	gboolean (*AddChannelToGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
	gboolean (*RemoveChannelFromGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
};



GType dvb_channel_info_get_type (void) G_GNUC_CONST;
DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self);
void dvb_channel_info_free (DVBChannelInfo* self);
void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest);
void dvb_channel_info_destroy (DVBChannelInfo* self);
GType dvb_id_bus_channel_list_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_channel_list_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_channel_list_get_type (void) G_GNUC_CONST;
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1, GError** error);
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1, GError** error);
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1, GError** error);
gboolean dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error);
gboolean dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error);
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
gboolean dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error);
DVBChannelInfo* dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1, GError** error);
gboolean dvb_id_bus_channel_list_GetChannelsOfGroup (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
gboolean dvb_id_bus_channel_list_AddChannelToGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
gboolean dvb_id_bus_channel_list_RemoveChannelFromGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dvb_id_bus_channel_list_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_channel_list_changed (DVBIDBusChannelList* self, GVariant* parameters);
static guint* dvb_id_bus_channel_list_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1, GError** error);
static guint* dvb_id_bus_channel_list_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1, GError** error);
static guint* dvb_id_bus_channel_list_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error);
static DVBChannelInfo* dvb_id_bus_channel_list_proxy_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_GetChannelsOfGroup (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_AddChannelToGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
static gboolean dvb_id_bus_channel_list_proxy_RemoveChannelFromGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
static void dvb_id_bus_channel_list_proxy_dvb_id_bus_channel_list_interface_init (DVBIDBusChannelListIface* iface);
static void _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length);
static void _dbus_dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_GetChannelsOfGroup (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_AddChannelToGroup (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_channel_list_RemoveChannelFromGroup (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void dvb_id_bus_channel_list_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_channel_list_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_channel_list_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, gpointer* _data);
static void _dvb_id_bus_channel_list_unregister_object (gpointer user_data);

static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannels_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannels_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannels_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannels_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetChannels = {-1, "GetChannels", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannels_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannels_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetRadioChannels_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetRadioChannels_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetRadioChannels_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetRadioChannels_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetRadioChannels = {-1, "GetRadioChannels", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetRadioChannels_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetRadioChannels_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetTVChannels_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetTVChannels_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetTVChannels_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetTVChannels_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetTVChannels = {-1, "GetTVChannels", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetTVChannels_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetTVChannels_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_channel_name = {-1, "channel_name", "s"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_channel_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_channel_name, &_dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetChannelName = {-1, "GetChannelName", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelName_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_network = {-1, "network", "s"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_channel_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_network, &_dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetChannelNetwork = {-1, "GetChannelNetwork", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelNetwork_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_radio = {-1, "radio", "b"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_channel_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_radio, &_dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_IsRadioChannel = {-1, "IsRadioChannel", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_IsRadioChannel_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_url = {-1, "url", "s"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_channel_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_url, &_dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetChannelURL = {-1, "GetChannelURL", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelURL_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelInfos_result = {-1, "result", "a(usb)"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelInfos_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelInfos_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelInfos_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetChannelInfos = {-1, "GetChannelInfos", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelInfos_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelInfos_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_channel_group_id = {-1, "channel_group_id", "i"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_channel_ids = {-1, "channel_ids", "au"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_channel_group_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_channel_ids, &_dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_GetChannelsOfGroup = {-1, "GetChannelsOfGroup", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_GetChannelsOfGroup_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_channel_group_id = {-1, "channel_group_id", "i"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_channel_id, &_dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_channel_group_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_AddChannelToGroup = {-1, "AddChannelToGroup", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_AddChannelToGroup_out)};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_channel_group_id = {-1, "channel_group_id", "i"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_in[] = {&_dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_channel_id, &_dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_channel_group_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_out[] = {&_dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_channel_list_dbus_method_info_RemoveChannelFromGroup = {-1, "RemoveChannelFromGroup", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_RemoveChannelFromGroup_out)};
static const GDBusMethodInfo * const _dvb_id_bus_channel_list_dbus_method_info[] = {&_dvb_id_bus_channel_list_dbus_method_info_GetChannels, &_dvb_id_bus_channel_list_dbus_method_info_GetRadioChannels, &_dvb_id_bus_channel_list_dbus_method_info_GetTVChannels, &_dvb_id_bus_channel_list_dbus_method_info_GetChannelName, &_dvb_id_bus_channel_list_dbus_method_info_GetChannelNetwork, &_dvb_id_bus_channel_list_dbus_method_info_IsRadioChannel, &_dvb_id_bus_channel_list_dbus_method_info_GetChannelURL, &_dvb_id_bus_channel_list_dbus_method_info_GetChannelInfos, &_dvb_id_bus_channel_list_dbus_method_info_GetChannelsOfGroup, &_dvb_id_bus_channel_list_dbus_method_info_AddChannelToGroup, &_dvb_id_bus_channel_list_dbus_method_info_RemoveChannelFromGroup, NULL};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_changed_channel_id = {-1, "channel_id", "u"};
static const GDBusArgInfo _dvb_id_bus_channel_list_dbus_arg_info_changed_type = {-1, "type", "u"};
static const GDBusArgInfo * const _dvb_id_bus_channel_list_dbus_arg_info_changed[] = {&_dvb_id_bus_channel_list_dbus_arg_info_changed_channel_id, &_dvb_id_bus_channel_list_dbus_arg_info_changed_type, NULL};
static const GDBusSignalInfo _dvb_id_bus_channel_list_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_dvb_id_bus_channel_list_dbus_arg_info_changed)};
static const GDBusSignalInfo * const _dvb_id_bus_channel_list_dbus_signal_info[] = {&_dvb_id_bus_channel_list_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_channel_list_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_channel_list_dbus_interface_info = {-1, "org.gnome.DVB.ChannelList", (GDBusMethodInfo **) (&_dvb_id_bus_channel_list_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_channel_list_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_channel_list_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_channel_list_dbus_interface_vtable = {dvb_id_bus_channel_list_dbus_interface_method_call, dvb_id_bus_channel_list_dbus_interface_get_property, dvb_id_bus_channel_list_dbus_interface_set_property};

void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest) {
	guint _tmp0_ = 0U;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
	_tmp3_ = (*self).is_radio;
	(*dest).is_radio = _tmp3_;
}


void dvb_channel_info_destroy (DVBChannelInfo* self) {
	_g_free0 ((*self).name);
}


DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self) {
	DVBChannelInfo* dup;
	dup = g_new0 (DVBChannelInfo, 1);
	dvb_channel_info_copy (self, dup);
	return dup;
}


void dvb_channel_info_free (DVBChannelInfo* self) {
	dvb_channel_info_destroy (self);
	g_free (self);
}


GType dvb_channel_info_get_type (void) {
	static volatile gsize dvb_channel_info_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_info_type_id__volatile)) {
		GType dvb_channel_info_type_id;
		dvb_channel_info_type_id = g_boxed_type_register_static ("DVBChannelInfo", (GBoxedCopyFunc) dvb_channel_info_dup, (GBoxedFreeFunc) dvb_channel_info_free);
		g_once_init_leave (&dvb_channel_info_type_id__volatile, dvb_channel_info_type_id);
	}
	return dvb_channel_info_type_id__volatile;
}


/**
         * @returns: List of channel IDs aka SIDs of all channels
         */
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannels (self, result_length1, error);
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetRadioChannels (self, result_length1, error);
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetTVChannels (self, result_length1, error);
}


/**
         * @channel_id: ID of channel
         * @channel_name: Name of channel if channel with id exists
         * otherwise an empty string
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelName (self, channel_id, channel_name, error);
}


/**
         * @channel_id: ID of channel
         * @network: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelNetwork (self, channel_id, network, error);
}


/**
         * @channel_id: ID of channel
         * @radio: Whether the channel is a radio channel or not
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->IsRadioChannel (self, channel_id, radio, error);
}


/**
         * @channel_id: ID of channel
         * @url: URL to watch the channel
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelURL (self, channel_id, url, error);
}


DVBChannelInfo* dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelInfos (self, result_length1, error);
}


/**
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_GetChannelsOfGroup (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelsOfGroup (self, channel_group_id, channel_ids, channel_ids_length1, error);
}


/**
         * @channel_id: ID of channel
     * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_AddChannelToGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->AddChannelToGroup (self, channel_id, channel_group_id, error);
}


/**
 * @channel_id: ID of channel
     * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_channel_list_RemoveChannelFromGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->RemoveChannelFromGroup (self, channel_id, channel_group_id, error);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void dvb_id_bus_channel_list_base_init (DVBIDBusChannelListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		         * @type: 0: added, 1: deleted, 2: updated
		         */
		g_signal_new ("changed", DVB_TYPE_ID_BUS_CHANNEL_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	}
}


GType dvb_id_bus_channel_list_get_type (void) {
	static volatile gsize dvb_id_bus_channel_list_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_channel_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusChannelListIface), (GBaseInitFunc) dvb_id_bus_channel_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_channel_list_type_id;
		dvb_id_bus_channel_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusChannelList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_channel_list_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_channel_list_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_channel_list_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_channel_list_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.ChannelList");
		g_type_set_qdata (dvb_id_bus_channel_list_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_channel_list_register_object);
		g_once_init_leave (&dvb_id_bus_channel_list_type_id__volatile, dvb_id_bus_channel_list_type_id);
	}
	return dvb_id_bus_channel_list_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusChannelListProxy, dvb_id_bus_channel_list_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_CHANNEL_LIST, dvb_id_bus_channel_list_proxy_dvb_id_bus_channel_list_interface_init) )
static void dvb_id_bus_channel_list_proxy_class_init (DVBIDBusChannelListProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_channel_list_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_channel_list_changed (DVBIDBusChannelList* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp0_;
	guint type = 0U;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "changed", channel_id, type);
}


static void dvb_id_bus_channel_list_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_dvb_id_bus_channel_list_changed ((DVBIDBusChannelList*) proxy, parameters);
	}
}


static void dvb_id_bus_channel_list_proxy_init (DVBIDBusChannelListProxy* self) {
}


static guint* dvb_id_bus_channel_list_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _result;
	int _result_length1;
	GVariant* _tmp2_;
	guint* _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	GVariantIter _tmp4_;
	GVariant* _tmp5_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetChannels");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_tmp3_ = g_new (guint, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	g_variant_iter_init (&_tmp4_, _tmp2_);
	for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp3__length1++) {
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (guint, _tmp3_, _tmp3__size + 1);
		}
		_tmp3_[_tmp3__length++] = g_variant_get_uint32 (_tmp5_);
		g_variant_unref (_tmp5_);
	}
	_result_length1 = _tmp3__length1;
	_result = _tmp3_;
	g_variant_unref (_tmp2_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static guint* dvb_id_bus_channel_list_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _result;
	int _result_length1;
	GVariant* _tmp6_;
	guint* _tmp7_;
	int _tmp7__length;
	int _tmp7__size;
	int _tmp7__length1;
	GVariantIter _tmp8_;
	GVariant* _tmp9_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetRadioChannels");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp6_ = g_variant_iter_next_value (&_reply_iter);
	_tmp7_ = g_new (guint, 5);
	_tmp7__length = 0;
	_tmp7__size = 4;
	_tmp7__length1 = 0;
	g_variant_iter_init (&_tmp8_, _tmp6_);
	for (; (_tmp9_ = g_variant_iter_next_value (&_tmp8_)) != NULL; _tmp7__length1++) {
		if (_tmp7__size == _tmp7__length) {
			_tmp7__size = 2 * _tmp7__size;
			_tmp7_ = g_renew (guint, _tmp7_, _tmp7__size + 1);
		}
		_tmp7_[_tmp7__length++] = g_variant_get_uint32 (_tmp9_);
		g_variant_unref (_tmp9_);
	}
	_result_length1 = _tmp7__length1;
	_result = _tmp7_;
	g_variant_unref (_tmp6_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static guint* dvb_id_bus_channel_list_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _result;
	int _result_length1;
	GVariant* _tmp10_;
	guint* _tmp11_;
	int _tmp11__length;
	int _tmp11__size;
	int _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetTVChannels");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp10_ = g_variant_iter_next_value (&_reply_iter);
	_tmp11_ = g_new (guint, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
	g_variant_iter_init (&_tmp12_, _tmp10_);
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
		if (_tmp11__size == _tmp11__length) {
			_tmp11__size = 2 * _tmp11__size;
			_tmp11_ = g_renew (guint, _tmp11_, _tmp11__size + 1);
		}
		_tmp11_[_tmp11__length++] = g_variant_get_uint32 (_tmp13_);
		g_variant_unref (_tmp13_);
	}
	_result_length1 = _tmp11__length1;
	_result = _tmp11_;
	g_variant_unref (_tmp10_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_channel_name;
	GVariant* _tmp14_;
	gboolean _result;
	GVariant* _tmp15_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetChannelName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp14_ = g_variant_iter_next_value (&_reply_iter);
	_vala_channel_name = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	*channel_name = _vala_channel_name;
	_tmp15_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp15_);
	g_variant_unref (_tmp15_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_network;
	GVariant* _tmp16_;
	gboolean _result;
	GVariant* _tmp17_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetChannelNetwork");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp16_ = g_variant_iter_next_value (&_reply_iter);
	_vala_network = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	*network = _vala_network;
	_tmp17_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp17_);
	g_variant_unref (_tmp17_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _vala_radio;
	GVariant* _tmp18_;
	gboolean _result;
	GVariant* _tmp19_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "IsRadioChannel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp18_ = g_variant_iter_next_value (&_reply_iter);
	_vala_radio = g_variant_get_boolean (_tmp18_);
	g_variant_unref (_tmp18_);
	*radio = _vala_radio;
	_tmp19_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp19_);
	g_variant_unref (_tmp19_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_url;
	GVariant* _tmp20_;
	gboolean _result;
	GVariant* _tmp21_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetChannelURL");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp20_ = g_variant_iter_next_value (&_reply_iter);
	_vala_url = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	*url = _vala_url;
	_tmp21_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp21_);
	g_variant_unref (_tmp21_);
	g_object_unref (_reply_message);
	return _result;
}


static DVBChannelInfo* dvb_id_bus_channel_list_proxy_GetChannelInfos (DVBIDBusChannelList* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBChannelInfo* _result;
	int _result_length1;
	GVariant* _tmp22_;
	DVBChannelInfo* _tmp23_;
	int _tmp23__length;
	int _tmp23__size;
	int _tmp23__length1;
	GVariantIter _tmp24_;
	GVariant* _tmp25_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetChannelInfos");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp22_ = g_variant_iter_next_value (&_reply_iter);
	_tmp23_ = g_new (DVBChannelInfo, 5);
	_tmp23__length = 0;
	_tmp23__size = 4;
	_tmp23__length1 = 0;
	g_variant_iter_init (&_tmp24_, _tmp22_);
	for (; (_tmp25_ = g_variant_iter_next_value (&_tmp24_)) != NULL; _tmp23__length1++) {
		DVBChannelInfo _tmp26_;
		GVariantIter _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		if (_tmp23__size == _tmp23__length) {
			_tmp23__size = 2 * _tmp23__size;
			_tmp23_ = g_renew (DVBChannelInfo, _tmp23_, _tmp23__size + 1);
		}
		g_variant_iter_init (&_tmp27_, _tmp25_);
		_tmp28_ = g_variant_iter_next_value (&_tmp27_);
		_tmp26_.id = g_variant_get_uint32 (_tmp28_);
		g_variant_unref (_tmp28_);
		_tmp29_ = g_variant_iter_next_value (&_tmp27_);
		_tmp26_.name = g_variant_dup_string (_tmp29_, NULL);
		g_variant_unref (_tmp29_);
		_tmp30_ = g_variant_iter_next_value (&_tmp27_);
		_tmp26_.is_radio = g_variant_get_boolean (_tmp30_);
		g_variant_unref (_tmp30_);
		_tmp23_[_tmp23__length++] = _tmp26_;
		g_variant_unref (_tmp25_);
	}
	_result_length1 = _tmp23__length1;
	_result = _tmp23_;
	g_variant_unref (_tmp22_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_GetChannelsOfGroup (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _vala_channel_ids;
	int _vala_channel_ids_length1;
	GVariant* _tmp31_;
	guint* _tmp32_;
	int _tmp32__length;
	int _tmp32__size;
	int _tmp32__length1;
	GVariantIter _tmp33_;
	GVariant* _tmp34_;
	gboolean _result;
	GVariant* _tmp35_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "GetChannelsOfGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (channel_group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_channel_ids_length1 = 0;
	_tmp31_ = g_variant_iter_next_value (&_reply_iter);
	_tmp32_ = g_new (guint, 5);
	_tmp32__length = 0;
	_tmp32__size = 4;
	_tmp32__length1 = 0;
	g_variant_iter_init (&_tmp33_, _tmp31_);
	for (; (_tmp34_ = g_variant_iter_next_value (&_tmp33_)) != NULL; _tmp32__length1++) {
		if (_tmp32__size == _tmp32__length) {
			_tmp32__size = 2 * _tmp32__size;
			_tmp32_ = g_renew (guint, _tmp32_, _tmp32__size + 1);
		}
		_tmp32_[_tmp32__length++] = g_variant_get_uint32 (_tmp34_);
		g_variant_unref (_tmp34_);
	}
	_vala_channel_ids_length1 = _tmp32__length1;
	_vala_channel_ids = _tmp32_;
	g_variant_unref (_tmp31_);
	*channel_ids = _vala_channel_ids;
	*channel_ids_length1 = _vala_channel_ids_length1;
	_tmp35_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp35_);
	g_variant_unref (_tmp35_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_AddChannelToGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp36_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "AddChannelToGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (channel_group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp36_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp36_);
	g_variant_unref (_tmp36_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_channel_list_proxy_RemoveChannelFromGroup (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp37_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.ChannelList", "RemoveChannelFromGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (channel_group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp37_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp37_);
	g_variant_unref (_tmp37_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_channel_list_proxy_dvb_id_bus_channel_list_interface_init (DVBIDBusChannelListIface* iface) {
	iface->GetChannels = dvb_id_bus_channel_list_proxy_GetChannels;
	iface->GetRadioChannels = dvb_id_bus_channel_list_proxy_GetRadioChannels;
	iface->GetTVChannels = dvb_id_bus_channel_list_proxy_GetTVChannels;
	iface->GetChannelName = dvb_id_bus_channel_list_proxy_GetChannelName;
	iface->GetChannelNetwork = dvb_id_bus_channel_list_proxy_GetChannelNetwork;
	iface->IsRadioChannel = dvb_id_bus_channel_list_proxy_IsRadioChannel;
	iface->GetChannelURL = dvb_id_bus_channel_list_proxy_GetChannelURL;
	iface->GetChannelInfos = dvb_id_bus_channel_list_proxy_GetChannelInfos;
	iface->GetChannelsOfGroup = dvb_id_bus_channel_list_proxy_GetChannelsOfGroup;
	iface->AddChannelToGroup = dvb_id_bus_channel_list_proxy_AddChannelToGroup;
	iface->RemoveChannelFromGroup = dvb_id_bus_channel_list_proxy_RemoveChannelFromGroup;
}


static void _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	int result_length1 = 0;
	guint* _tmp38_;
	GVariantBuilder _tmp39_;
	int _tmp40_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_channel_list_GetChannels (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp38_ = result;
	g_variant_builder_init (&_tmp39_, G_VARIANT_TYPE ("au"));
	for (_tmp40_ = 0; _tmp40_ < result_length1; _tmp40_++) {
		g_variant_builder_add_value (&_tmp39_, g_variant_new_uint32 (*_tmp38_));
		_tmp38_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp39_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	int result_length1 = 0;
	guint* _tmp41_;
	GVariantBuilder _tmp42_;
	int _tmp43_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_channel_list_GetRadioChannels (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp41_ = result;
	g_variant_builder_init (&_tmp42_, G_VARIANT_TYPE ("au"));
	for (_tmp43_ = 0; _tmp43_ < result_length1; _tmp43_++) {
		g_variant_builder_add_value (&_tmp42_, g_variant_new_uint32 (*_tmp41_));
		_tmp41_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp42_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	int result_length1 = 0;
	guint* _tmp44_;
	GVariantBuilder _tmp45_;
	int _tmp46_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_channel_list_GetTVChannels (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp44_ = result;
	g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE ("au"));
	for (_tmp46_ = 0; _tmp46_ < result_length1; _tmp46_++) {
		g_variant_builder_add_value (&_tmp45_, g_variant_new_uint32 (*_tmp44_));
		_tmp44_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp45_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp47_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* channel_name = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp47_);
	g_variant_unref (_tmp47_);
	result = dvb_id_bus_channel_list_GetChannelName (self, channel_id, &channel_name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (channel_name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (channel_name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp48_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* network = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp48_);
	g_variant_unref (_tmp48_);
	result = dvb_id_bus_channel_list_GetChannelNetwork (self, channel_id, &network, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (network));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (network);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp49_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean radio = FALSE;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp49_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp49_);
	g_variant_unref (_tmp49_);
	result = dvb_id_bus_channel_list_IsRadioChannel (self, channel_id, &radio, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (radio));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp50_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* url = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp50_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp50_);
	g_variant_unref (_tmp50_);
	result = dvb_id_bus_channel_list_GetChannelURL (self, channel_id, &url, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (url));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (url);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_dvb_id_bus_channel_list_GetChannelInfos (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBChannelInfo* result;
	int result_length1 = 0;
	DVBChannelInfo* _tmp51_;
	GVariantBuilder _tmp52_;
	int _tmp53_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_channel_list_GetChannelInfos (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp51_ = result;
	g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE ("a(usb)"));
	for (_tmp53_ = 0; _tmp53_ < result_length1; _tmp53_++) {
		GVariantBuilder _tmp54_;
		g_variant_builder_init (&_tmp54_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp54_, g_variant_new_uint32 ((*_tmp51_).id));
		g_variant_builder_add_value (&_tmp54_, g_variant_new_string ((*_tmp51_).name));
		g_variant_builder_add_value (&_tmp54_, g_variant_new_boolean ((*_tmp51_).is_radio));
		g_variant_builder_add_value (&_tmp52_, g_variant_builder_end (&_tmp54_));
		_tmp51_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp52_));
	result = (_vala_DVBChannelInfo_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_GetChannelsOfGroup (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint channel_group_id = 0;
	GVariant* _tmp55_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* channel_ids = NULL;
	int channel_ids_length1 = 0;
	guint* _tmp56_;
	GVariantBuilder _tmp57_;
	int _tmp58_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp55_ = g_variant_iter_next_value (&_arguments_iter);
	channel_group_id = g_variant_get_int32 (_tmp55_);
	g_variant_unref (_tmp55_);
	result = dvb_id_bus_channel_list_GetChannelsOfGroup (self, channel_group_id, &channel_ids, &channel_ids_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp56_ = channel_ids;
	g_variant_builder_init (&_tmp57_, G_VARIANT_TYPE ("au"));
	for (_tmp58_ = 0; _tmp58_ < channel_ids_length1; _tmp58_++) {
		g_variant_builder_add_value (&_tmp57_, g_variant_new_uint32 (*_tmp56_));
		_tmp56_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp57_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	channel_ids = (g_free (channel_ids), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_AddChannelToGroup (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp59_;
	gint channel_group_id = 0;
	GVariant* _tmp60_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp59_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp59_);
	g_variant_unref (_tmp59_);
	_tmp60_ = g_variant_iter_next_value (&_arguments_iter);
	channel_group_id = g_variant_get_int32 (_tmp60_);
	g_variant_unref (_tmp60_);
	result = dvb_id_bus_channel_list_AddChannelToGroup (self, channel_id, channel_group_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_channel_list_RemoveChannelFromGroup (DVBIDBusChannelList* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint channel_id = 0U;
	GVariant* _tmp61_;
	gint channel_group_id = 0;
	GVariant* _tmp62_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp61_ = g_variant_iter_next_value (&_arguments_iter);
	channel_id = g_variant_get_uint32 (_tmp61_);
	g_variant_unref (_tmp61_);
	_tmp62_ = g_variant_iter_next_value (&_arguments_iter);
	channel_group_id = g_variant_get_int32 (_tmp62_);
	g_variant_unref (_tmp62_);
	result = dvb_id_bus_channel_list_RemoveChannelFromGroup (self, channel_id, channel_group_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_channel_list_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetChannels") == 0) {
		_dbus_dvb_id_bus_channel_list_GetChannels (object, parameters, invocation);
	} else if (strcmp (method_name, "GetRadioChannels") == 0) {
		_dbus_dvb_id_bus_channel_list_GetRadioChannels (object, parameters, invocation);
	} else if (strcmp (method_name, "GetTVChannels") == 0) {
		_dbus_dvb_id_bus_channel_list_GetTVChannels (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelName") == 0) {
		_dbus_dvb_id_bus_channel_list_GetChannelName (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelNetwork") == 0) {
		_dbus_dvb_id_bus_channel_list_GetChannelNetwork (object, parameters, invocation);
	} else if (strcmp (method_name, "IsRadioChannel") == 0) {
		_dbus_dvb_id_bus_channel_list_IsRadioChannel (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelURL") == 0) {
		_dbus_dvb_id_bus_channel_list_GetChannelURL (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelInfos") == 0) {
		_dbus_dvb_id_bus_channel_list_GetChannelInfos (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelsOfGroup") == 0) {
		_dbus_dvb_id_bus_channel_list_GetChannelsOfGroup (object, parameters, invocation);
	} else if (strcmp (method_name, "AddChannelToGroup") == 0) {
		_dbus_dvb_id_bus_channel_list_AddChannelToGroup (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveChannelFromGroup") == 0) {
		_dbus_dvb_id_bus_channel_list_RemoveChannelFromGroup (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_channel_list_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_channel_list_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (channel_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.ChannelList", "Changed", _arguments, NULL);
}


guint dvb_id_bus_channel_list_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_channel_list_dbus_interface_info), &_dvb_id_bus_channel_list_dbus_interface_vtable, data, _dvb_id_bus_channel_list_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_channel_list_changed, data);
	return result;
}


static void _dvb_id_bus_channel_list_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_channel_list_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



