/* ChannelListReader.c generated by valac 0.14.0, the Vala compiler
 * generated from ChannelListReader.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_IO_TYPE_CHANNEL_LIST_READER (dvb_io_channel_list_reader_get_type ())
#define DVB_IO_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader))
#define DVB_IO_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))
#define DVB_IO_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))

typedef struct _DVBioChannelListReader DVBioChannelListReader;
typedef struct _DVBioChannelListReaderClass DVBioChannelListReaderClass;
typedef struct _DVBioChannelListReaderPrivate DVBioChannelListReaderPrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;

#define DVB_TYPE_SATELLITE_CHANNEL (dvb_satellite_channel_get_type ())
#define DVB_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannel))
#define DVB_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))
#define DVB_IS_SATELLITE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_IS_SATELLITE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SATELLITE_CHANNEL))
#define DVB_SATELLITE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelClass))

typedef struct _DVBSatelliteChannel DVBSatelliteChannel;
typedef struct _DVBSatelliteChannelClass DVBSatelliteChannelClass;

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

struct _DVBioChannelListReader {
	GObject parent_instance;
	DVBioChannelListReaderPrivate * priv;
};

struct _DVBioChannelListReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBioChannelListReaderPrivate {
	DVBChannelList* _channels;
	DVBAdapterType _Type;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;


static gpointer dvb_io_channel_list_reader_parent_class = NULL;
static DVBLoggingLogger* dvb_io_channel_list_reader_log;
static DVBLoggingLogger* dvb_io_channel_list_reader_log = NULL;

GType dvb_io_channel_list_reader_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
#define DVB_IO_CHANNEL_LIST_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderPrivate))
enum  {
	DVB_IO_CHANNEL_LIST_READER_DUMMY_PROPERTY,
	DVB_IO_CHANNEL_LIST_READER_CHANNELS,
	DVB_IO_CHANNEL_LIST_READER_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type);
DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type);
void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error);
DVBChannelList* dvb_io_channel_list_reader_get_channels (DVBioChannelListReader* self);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
GType dvb_channel_get_type (void) G_GNUC_CONST;
static DVBChannel* dvb_io_channel_list_reader_parse_line (DVBioChannelListReader* self, const gchar* line);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
DVBAdapterType dvb_io_channel_list_reader_get_Type (DVBioChannelListReader* self);
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
static DVBTerrestrialChannel* dvb_io_channel_list_reader_parse_terrestrial_channel (DVBioChannelListReader* self, const gchar* line);
GType dvb_satellite_channel_get_type (void) G_GNUC_CONST;
static DVBSatelliteChannel* dvb_io_channel_list_reader_parse_satellite_channel (DVBioChannelListReader* self, const gchar* line);
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
static DVBCableChannel* dvb_io_channel_list_reader_parse_cable_channel (DVBioChannelListReader* self, const gchar* line);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_channel_is_valid (DVBChannel* self);
gchar* dvb_channel_to_string (DVBChannel* self);
guint dvb_channel_list_get_GroupId (DVBChannelList* self);
DVBTerrestrialChannel* dvb_terrestrial_channel_new (guint group_id);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type, guint group_id);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
static gboolean dvb_io_channel_list_reader_get_value_with_prefix (GType enumtype, const gchar* name, const gchar* prefix, gint* val);
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
DVBSatelliteChannel* dvb_satellite_channel_new (guint group_id);
DVBSatelliteChannel* dvb_satellite_channel_construct (GType object_type, guint group_id);
void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const gchar* value);
void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value);
void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value);
DVBCableChannel* dvb_cable_channel_new (guint group_id);
DVBCableChannel* dvb_cable_channel_construct (GType object_type, guint group_id);
void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value);
void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value);
void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value);
void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue);
static void dvb_io_channel_list_reader_set_channels (DVBioChannelListReader* self, DVBChannelList* value);
static void dvb_io_channel_list_reader_set_Type (DVBioChannelListReader* self, DVBAdapterType value);
static void dvb_io_channel_list_reader_finalize (GObject* obj);
static void _vala_dvb_io_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type) {
	DVBioChannelListReader * self = NULL;
	DVBChannelList* _tmp0_;
	DVBAdapterType _tmp1_;
	g_return_val_if_fail (channels != NULL, NULL);
	_tmp0_ = channels;
	_tmp1_ = type;
	self = (DVBioChannelListReader*) g_object_new (object_type, "channels", _tmp0_, "Type", _tmp1_, NULL);
	return self;
}


DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type) {
	return dvb_io_channel_list_reader_construct (DVB_IO_TYPE_CHANNEL_LIST_READER, channels, type);
}


void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error) {
	DVBChannelList* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	DVBChannelList* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_ = NULL;
	GFileInputStream* _tmp7_;
	GFileInputStream* _tmp8_;
	GDataInputStream* _tmp9_;
	GDataInputStream* _tmp10_;
	GDataInputStream* reader;
	gchar* line;
	gsize len = 0UL;
	GDataInputStream* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_channels;
	_tmp1_ = dvb_channel_list_get_channels_file (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_channels;
	_tmp4_ = dvb_channel_list_get_channels_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp8_ = _tmp7_;
	_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	reader = _tmp10_;
	line = NULL;
	while (TRUE) {
		GDataInputStream* _tmp11_;
		gsize _tmp12_ = 0UL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gsize _tmp16_;
		_tmp11_ = reader;
		_tmp13_ = g_data_input_stream_read_line (_tmp11_, &_tmp12_, NULL, &_inner_error_);
		len = _tmp12_;
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (reader);
			return;
		}
		_g_free0 (line);
		line = _tmp14_;
		_tmp15_ = line;
		if (!(_tmp15_ != NULL)) {
			break;
		}
		_tmp16_ = len;
		if (_tmp16_ > ((gsize) 0)) {
			const gchar* _tmp17_;
			DVBChannel* _tmp18_ = NULL;
			DVBChannel* c;
			DVBChannel* _tmp19_;
			_tmp17_ = line;
			_tmp18_ = dvb_io_channel_list_reader_parse_line (self, _tmp17_);
			c = _tmp18_;
			_tmp19_ = c;
			if (_tmp19_ != NULL) {
				DVBChannelList* _tmp20_;
				DVBChannel* _tmp21_;
				_tmp20_ = self->priv->_channels;
				_tmp21_ = c;
				dvb_channel_list_add (_tmp20_, _tmp21_);
			} else {
				g_warning ("ChannelListReader.vala:50: Could not parse channel");
			}
			_g_object_unref0 (c);
		}
	}
	_tmp22_ = reader;
	g_input_stream_close ((GInputStream*) _tmp22_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (reader);
		return;
	}
	_g_free0 (line);
	_g_object_unref0 (reader);
}


static DVBChannel* dvb_io_channel_list_reader_parse_line (DVBioChannelListReader* self, const gchar* line) {
	DVBChannel* result = NULL;
	DVBChannel* c;
	DVBAdapterType _tmp0_;
	gboolean _tmp8_ = FALSE;
	DVBChannel* _tmp9_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	c = NULL;
	_tmp0_ = self->priv->_Type;
	switch (_tmp0_) {
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			const gchar* _tmp1_;
			DVBTerrestrialChannel* _tmp2_ = NULL;
			_tmp1_ = line;
			_tmp2_ = dvb_io_channel_list_reader_parse_terrestrial_channel (self, _tmp1_);
			_g_object_unref0 (c);
			c = (DVBChannel*) _tmp2_;
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_S:
		{
			const gchar* _tmp3_;
			DVBSatelliteChannel* _tmp4_ = NULL;
			_tmp3_ = line;
			_tmp4_ = dvb_io_channel_list_reader_parse_satellite_channel (self, _tmp3_);
			_g_object_unref0 (c);
			c = (DVBChannel*) _tmp4_;
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_C:
		{
			const gchar* _tmp5_;
			DVBCableChannel* _tmp6_ = NULL;
			_tmp5_ = line;
			_tmp6_ = dvb_io_channel_list_reader_parse_cable_channel (self, _tmp5_);
			_g_object_unref0 (c);
			c = (DVBChannel*) _tmp6_;
			break;
		}
		default:
		{
			DVBLoggingLogger* _tmp7_;
			_tmp7_ = dvb_io_channel_list_reader_log;
			dvb_logging_logger_error (_tmp7_, "ChannelListReader.vala:72: Unknown adapter type");
			break;
		}
	}
	_tmp9_ = c;
	if (_tmp9_ != NULL) {
		DVBChannel* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = c;
		_tmp11_ = dvb_channel_is_valid (_tmp10_);
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		result = c;
		return result;
	} else {
		gchar* _tmp13_ = NULL;
		DVBChannel* _tmp14_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* val;
		const gchar* _tmp20_;
		_tmp14_ = c;
		if (_tmp14_ == NULL) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("(null)");
			_g_free0 (_tmp13_);
			_tmp13_ = _tmp15_;
		} else {
			DVBChannel* _tmp16_;
			gchar* _tmp17_ = NULL;
			_tmp16_ = c;
			_tmp17_ = dvb_channel_to_string (_tmp16_);
			_g_free0 (_tmp13_);
			_tmp13_ = _tmp17_;
		}
		_tmp18_ = _tmp13_;
		_tmp19_ = g_strdup (_tmp18_);
		val = _tmp19_;
		_tmp20_ = val;
		g_warning ("ChannelListReader.vala:80: Channel is not valid: %s", _tmp20_);
		result = NULL;
		_g_free0 (val);
		_g_free0 (_tmp13_);
		_g_object_unref0 (c);
		return result;
	}
	_g_object_unref0 (c);
}


/**
         * @line: The line to parse
         * @returns: #TerrestrialChannel representing that line
         * 
         * A line looks like
         * Das Erste:212500000:INVERSION_AUTO:BANDWIDTH_7_MHZ:FEC_3_4:FEC_1_2:QAM_16:TRANSMISSION_MODE_8K:GUARD_INTERVAL_1_4:HIERARCHY_NONE:513:514:32
         */
static DVBTerrestrialChannel* dvb_io_channel_list_reader_parse_terrestrial_channel (DVBioChannelListReader* self, const gchar* line) {
	DVBTerrestrialChannel* result = NULL;
	DVBChannelList* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	DVBTerrestrialChannel* _tmp3_;
	DVBTerrestrialChannel* channel;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gint i;
	gchar* val = NULL;
	gboolean failed;
	gboolean _tmp85_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = self->priv->_channels;
	_tmp1_ = dvb_channel_list_get_GroupId (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_terrestrial_channel_new (_tmp2_);
	channel = _tmp3_;
	_tmp4_ = line;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
	fields = _tmp6_;
	fields_length1 = _vala_array_length (_tmp5_);
	_fields_size_ = fields_length1;
	i = 0;
	failed = FALSE;
	while (TRUE) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp84_;
		_tmp7_ = fields;
		_tmp7__length1 = fields_length1;
		_tmp8_ = i;
		_tmp9_ = _tmp7_[_tmp8_];
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (val);
		val = _tmp10_;
		_tmp11_ = val;
		if (!(_tmp11_ != NULL)) {
			break;
		}
		_tmp12_ = i;
		if (_tmp12_ == 0) {
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = val;
			_tmp14_ = g_utf8_validate (_tmp13_, (gssize) (-1), NULL);
			if (_tmp14_) {
				DVBTerrestrialChannel* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = channel;
				_tmp16_ = val;
				dvb_channel_set_Name ((DVBChannel*) _tmp15_, _tmp16_);
			} else {
				DVBTerrestrialChannel* _tmp17_;
				g_warning ("ChannelListReader.vala:105: Bad UTF-8 encoded channel name");
				_tmp17_ = channel;
				dvb_channel_set_Name ((DVBChannel*) _tmp17_, "Bad encoding");
			}
		} else {
			gint _tmp18_;
			_tmp18_ = i;
			if (_tmp18_ == 1) {
				DVBTerrestrialChannel* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				_tmp19_ = channel;
				_tmp20_ = val;
				_tmp21_ = atoi (_tmp20_);
				dvb_channel_set_Frequency ((DVBChannel*) _tmp19_, (guint) _tmp21_);
			} else {
				gint _tmp22_;
				_tmp22_ = i;
				if (_tmp22_ == 2) {
					gint eval = 0;
					const gchar* _tmp23_;
					gint _tmp24_ = 0;
					gboolean _tmp25_ = FALSE;
					_tmp23_ = val;
					_tmp25_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_INVERSION, _tmp23_, "DVB_DVB_SRC_INVERSION_", &_tmp24_);
					eval = _tmp24_;
					if (_tmp25_) {
						DVBTerrestrialChannel* _tmp26_;
						gint _tmp27_;
						_tmp26_ = channel;
						_tmp27_ = eval;
						dvb_terrestrial_channel_set_Inversion (_tmp26_, (DVBDvbSrcInversion) _tmp27_);
					} else {
						failed = TRUE;
						break;
					}
				} else {
					gint _tmp28_;
					_tmp28_ = i;
					if (_tmp28_ == 3) {
						gint eval = 0;
						const gchar* _tmp29_;
						gint _tmp30_ = 0;
						gboolean _tmp31_ = FALSE;
						_tmp29_ = val;
						_tmp31_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_BANDWIDTH, _tmp29_, "DVB_DVB_SRC_BANDWIDTH_", &_tmp30_);
						eval = _tmp30_;
						if (_tmp31_) {
							DVBTerrestrialChannel* _tmp32_;
							gint _tmp33_;
							_tmp32_ = channel;
							_tmp33_ = eval;
							dvb_terrestrial_channel_set_Bandwidth (_tmp32_, (DVBDvbSrcBandwidth) _tmp33_);
						} else {
							failed = TRUE;
							break;
						}
					} else {
						gint _tmp34_;
						_tmp34_ = i;
						if (_tmp34_ == 4) {
							gint eval = 0;
							const gchar* _tmp35_;
							gint _tmp36_ = 0;
							gboolean _tmp37_ = FALSE;
							_tmp35_ = val;
							_tmp37_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, _tmp35_, "DVB_DVB_SRC_CODE_RATE_", &_tmp36_);
							eval = _tmp36_;
							if (_tmp37_) {
								DVBTerrestrialChannel* _tmp38_;
								gint _tmp39_;
								_tmp38_ = channel;
								_tmp39_ = eval;
								dvb_terrestrial_channel_set_CodeRateHP (_tmp38_, (DVBDvbSrcCodeRate) _tmp39_);
							} else {
								failed = TRUE;
								break;
							}
						} else {
							gint _tmp40_;
							_tmp40_ = i;
							if (_tmp40_ == 5) {
								gint eval = 0;
								const gchar* _tmp41_;
								gint _tmp42_ = 0;
								gboolean _tmp43_ = FALSE;
								_tmp41_ = val;
								_tmp43_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, _tmp41_, "DVB_DVB_SRC_CODE_RATE_", &_tmp42_);
								eval = _tmp42_;
								if (_tmp43_) {
									DVBTerrestrialChannel* _tmp44_;
									gint _tmp45_;
									_tmp44_ = channel;
									_tmp45_ = eval;
									dvb_terrestrial_channel_set_CodeRateLP (_tmp44_, (DVBDvbSrcCodeRate) _tmp45_);
								} else {
									failed = TRUE;
									break;
								}
							} else {
								gint _tmp46_;
								_tmp46_ = i;
								if (_tmp46_ == 6) {
									gint eval = 0;
									const gchar* _tmp47_;
									gint _tmp48_ = 0;
									gboolean _tmp49_ = FALSE;
									_tmp47_ = val;
									_tmp49_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_MODULATION, _tmp47_, "DVB_DVB_SRC_MODULATION_", &_tmp48_);
									eval = _tmp48_;
									if (_tmp49_) {
										DVBTerrestrialChannel* _tmp50_;
										gint _tmp51_;
										_tmp50_ = channel;
										_tmp51_ = eval;
										dvb_terrestrial_channel_set_Constellation (_tmp50_, (DVBDvbSrcModulation) _tmp51_);
									} else {
										failed = TRUE;
										break;
									}
								} else {
									gint _tmp52_;
									_tmp52_ = i;
									if (_tmp52_ == 7) {
										gint eval = 0;
										const gchar* _tmp53_;
										gint _tmp54_ = 0;
										gboolean _tmp55_ = FALSE;
										_tmp53_ = val;
										_tmp55_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, _tmp53_, "DVB_DVB_SRC_TRANSMISSION_MODE_", &_tmp54_);
										eval = _tmp54_;
										if (_tmp55_) {
											DVBTerrestrialChannel* _tmp56_;
											gint _tmp57_;
											_tmp56_ = channel;
											_tmp57_ = eval;
											dvb_terrestrial_channel_set_TransmissionMode (_tmp56_, (DVBDvbSrcTransmissionMode) _tmp57_);
										} else {
											failed = TRUE;
											break;
										}
									} else {
										gint _tmp58_;
										_tmp58_ = i;
										if (_tmp58_ == 8) {
											gint eval = 0;
											const gchar* _tmp59_;
											gint _tmp60_ = 0;
											gboolean _tmp61_ = FALSE;
											_tmp59_ = val;
											_tmp61_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_GUARD, _tmp59_, "DVB_DVB_SRC_GUARD_", &_tmp60_);
											eval = _tmp60_;
											if (_tmp61_) {
												DVBTerrestrialChannel* _tmp62_;
												gint _tmp63_;
												_tmp62_ = channel;
												_tmp63_ = eval;
												dvb_terrestrial_channel_set_GuardInterval (_tmp62_, (DVBDvbSrcGuard) _tmp63_);
											} else {
												failed = TRUE;
												break;
											}
										} else {
											gint _tmp64_;
											_tmp64_ = i;
											if (_tmp64_ == 9) {
												gint eval = 0;
												const gchar* _tmp65_;
												gint _tmp66_ = 0;
												gboolean _tmp67_ = FALSE;
												_tmp65_ = val;
												_tmp67_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_HIERARCHY, _tmp65_, "DVB_DVB_SRC_HIERARCHY_", &_tmp66_);
												eval = _tmp66_;
												if (_tmp67_) {
													DVBTerrestrialChannel* _tmp68_;
													gint _tmp69_;
													_tmp68_ = channel;
													_tmp69_ = eval;
													dvb_terrestrial_channel_set_Hierarchy (_tmp68_, (DVBDvbSrcHierarchy) _tmp69_);
												} else {
													failed = TRUE;
													break;
												}
											} else {
												gint _tmp70_;
												_tmp70_ = i;
												if (_tmp70_ == 10) {
													DVBTerrestrialChannel* _tmp71_;
													const gchar* _tmp72_;
													gint _tmp73_ = 0;
													_tmp71_ = channel;
													_tmp72_ = val;
													_tmp73_ = atoi (_tmp72_);
													dvb_channel_set_VideoPID ((DVBChannel*) _tmp71_, (guint) _tmp73_);
												} else {
													gint _tmp74_;
													_tmp74_ = i;
													if (_tmp74_ == 11) {
														DVBTerrestrialChannel* _tmp75_;
														GeeList* _tmp76_;
														GeeList* _tmp77_;
														const gchar* _tmp78_;
														gint _tmp79_ = 0;
														_tmp75_ = channel;
														_tmp76_ = dvb_channel_get_AudioPIDs ((DVBChannel*) _tmp75_);
														_tmp77_ = _tmp76_;
														_tmp78_ = val;
														_tmp79_ = atoi (_tmp78_);
														gee_collection_add ((GeeCollection*) _tmp77_, GUINT_TO_POINTER ((guint) _tmp79_));
													} else {
														gint _tmp80_;
														_tmp80_ = i;
														if (_tmp80_ == 12) {
															DVBTerrestrialChannel* _tmp81_;
															const gchar* _tmp82_;
															gint _tmp83_ = 0;
															_tmp81_ = channel;
															_tmp82_ = val;
															_tmp83_ = atoi (_tmp82_);
															dvb_channel_set_Sid ((DVBChannel*) _tmp81_, (guint) _tmp83_);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp84_ = i;
		i = _tmp84_ + 1;
	}
	_tmp85_ = failed;
	if (_tmp85_) {
		result = NULL;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (channel);
		return result;
	} else {
		result = channel;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_g_free0 (val);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (channel);
}


/**
         *
         * A line looks like
         * Das Erste:11836:h:0:27500:101:102:28106
         */
static DVBSatelliteChannel* dvb_io_channel_list_reader_parse_satellite_channel (DVBioChannelListReader* self, const gchar* line) {
	DVBSatelliteChannel* result = NULL;
	DVBChannelList* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	DVBSatelliteChannel* _tmp3_;
	DVBSatelliteChannel* channel;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gint i;
	gchar* val = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = self->priv->_channels;
	_tmp1_ = dvb_channel_list_get_GroupId (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_satellite_channel_new (_tmp2_);
	channel = _tmp3_;
	_tmp4_ = line;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
	fields = _tmp6_;
	fields_length1 = _vala_array_length (_tmp5_);
	_fields_size_ = fields_length1;
	i = 0;
	while (TRUE) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp47_;
		_tmp7_ = fields;
		_tmp7__length1 = fields_length1;
		_tmp8_ = i;
		_tmp9_ = _tmp7_[_tmp8_];
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (val);
		val = _tmp10_;
		_tmp11_ = val;
		if (!(_tmp11_ != NULL)) {
			break;
		}
		_tmp12_ = i;
		if (_tmp12_ == 0) {
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = val;
			_tmp14_ = g_utf8_validate (_tmp13_, (gssize) (-1), NULL);
			if (_tmp14_) {
				DVBSatelliteChannel* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = channel;
				_tmp16_ = val;
				dvb_channel_set_Name ((DVBChannel*) _tmp15_, _tmp16_);
			} else {
				DVBSatelliteChannel* _tmp17_;
				g_warning ("ChannelListReader.vala:214: Bad UTF-8 encoded channel name");
				_tmp17_ = channel;
				dvb_channel_set_Name ((DVBChannel*) _tmp17_, "Bad encoding");
			}
		} else {
			gint _tmp18_;
			_tmp18_ = i;
			if (_tmp18_ == 1) {
				DVBSatelliteChannel* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				_tmp19_ = channel;
				_tmp20_ = val;
				_tmp21_ = atoi (_tmp20_);
				dvb_channel_set_Frequency ((DVBChannel*) _tmp19_, (guint) (_tmp21_ * 1000));
			} else {
				gint _tmp22_;
				_tmp22_ = i;
				if (_tmp22_ == 2) {
					DVBSatelliteChannel* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = channel;
					_tmp24_ = val;
					dvb_satellite_channel_set_Polarization (_tmp23_, _tmp24_);
				} else {
					gint _tmp25_;
					_tmp25_ = i;
					if (_tmp25_ == 3) {
						DVBSatelliteChannel* _tmp26_;
						const gchar* _tmp27_;
						gint _tmp28_ = 0;
						_tmp26_ = channel;
						_tmp27_ = val;
						_tmp28_ = atoi (_tmp27_);
						dvb_satellite_channel_set_DiseqcSource (_tmp26_, _tmp28_);
					} else {
						gint _tmp29_;
						_tmp29_ = i;
						if (_tmp29_ == 4) {
							DVBSatelliteChannel* _tmp30_;
							const gchar* _tmp31_;
							gint _tmp32_ = 0;
							_tmp30_ = channel;
							_tmp31_ = val;
							_tmp32_ = atoi (_tmp31_);
							dvb_satellite_channel_set_SymbolRate (_tmp30_, (guint) _tmp32_);
						} else {
							gint _tmp33_;
							_tmp33_ = i;
							if (_tmp33_ == 5) {
								DVBSatelliteChannel* _tmp34_;
								const gchar* _tmp35_;
								gint _tmp36_ = 0;
								_tmp34_ = channel;
								_tmp35_ = val;
								_tmp36_ = atoi (_tmp35_);
								dvb_channel_set_VideoPID ((DVBChannel*) _tmp34_, (guint) _tmp36_);
							} else {
								gint _tmp37_;
								_tmp37_ = i;
								if (_tmp37_ == 6) {
									DVBSatelliteChannel* _tmp38_;
									GeeList* _tmp39_;
									GeeList* _tmp40_;
									const gchar* _tmp41_;
									gint _tmp42_ = 0;
									_tmp38_ = channel;
									_tmp39_ = dvb_channel_get_AudioPIDs ((DVBChannel*) _tmp38_);
									_tmp40_ = _tmp39_;
									_tmp41_ = val;
									_tmp42_ = atoi (_tmp41_);
									gee_collection_add ((GeeCollection*) _tmp40_, GUINT_TO_POINTER ((guint) _tmp42_));
								} else {
									gint _tmp43_;
									_tmp43_ = i;
									if (_tmp43_ == 7) {
										DVBSatelliteChannel* _tmp44_;
										const gchar* _tmp45_;
										gint _tmp46_ = 0;
										_tmp44_ = channel;
										_tmp45_ = val;
										_tmp46_ = atoi (_tmp45_);
										dvb_channel_set_Sid ((DVBChannel*) _tmp44_, (guint) _tmp46_);
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp47_ = i;
		i = _tmp47_ + 1;
	}
	result = channel;
	_g_free0 (val);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
         *
         * line looks like
         * ProSieben:330000000:INVERSION_AUTO:6900000:FEC_NONE:QAM_64:255:256:898
         */
static DVBCableChannel* dvb_io_channel_list_reader_parse_cable_channel (DVBioChannelListReader* self, const gchar* line) {
	DVBCableChannel* result = NULL;
	DVBChannelList* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	DVBCableChannel* _tmp3_;
	DVBCableChannel* channel;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gint i;
	gchar* val = NULL;
	gboolean failed;
	gboolean _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = self->priv->_channels;
	_tmp1_ = dvb_channel_list_get_GroupId (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_cable_channel_new (_tmp2_);
	channel = _tmp3_;
	_tmp4_ = line;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
	fields = _tmp6_;
	fields_length1 = _vala_array_length (_tmp5_);
	_fields_size_ = fields_length1;
	i = 0;
	failed = FALSE;
	while (TRUE) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp58_;
		_tmp7_ = fields;
		_tmp7__length1 = fields_length1;
		_tmp8_ = i;
		_tmp9_ = _tmp7_[_tmp8_];
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (val);
		val = _tmp10_;
		_tmp11_ = val;
		if (!(_tmp11_ != NULL)) {
			break;
		}
		_tmp12_ = i;
		if (_tmp12_ == 0) {
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = val;
			_tmp14_ = g_utf8_validate (_tmp13_, (gssize) (-1), NULL);
			if (_tmp14_) {
				DVBCableChannel* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = channel;
				_tmp16_ = val;
				dvb_channel_set_Name ((DVBChannel*) _tmp15_, _tmp16_);
			} else {
				DVBCableChannel* _tmp17_;
				g_warning ("ChannelListReader.vala:260: Bad UTF-8 encoded channel name");
				_tmp17_ = channel;
				dvb_channel_set_Name ((DVBChannel*) _tmp17_, "Bad encoding");
			}
		} else {
			gint _tmp18_;
			_tmp18_ = i;
			if (_tmp18_ == 1) {
				DVBCableChannel* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				_tmp19_ = channel;
				_tmp20_ = val;
				_tmp21_ = atoi (_tmp20_);
				dvb_channel_set_Frequency ((DVBChannel*) _tmp19_, (guint) _tmp21_);
			} else {
				gint _tmp22_;
				_tmp22_ = i;
				if (_tmp22_ == 2) {
					gint eval = 0;
					const gchar* _tmp23_;
					gint _tmp24_ = 0;
					gboolean _tmp25_ = FALSE;
					_tmp23_ = val;
					_tmp25_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_INVERSION, _tmp23_, "DVB_DVB_SRC_INVERSION_", &_tmp24_);
					eval = _tmp24_;
					if (_tmp25_) {
						DVBCableChannel* _tmp26_;
						gint _tmp27_;
						_tmp26_ = channel;
						_tmp27_ = eval;
						dvb_cable_channel_set_Inversion (_tmp26_, (DVBDvbSrcInversion) _tmp27_);
					} else {
						failed = TRUE;
						break;
					}
				} else {
					gint _tmp28_;
					_tmp28_ = i;
					if (_tmp28_ == 3) {
						DVBCableChannel* _tmp29_;
						const gchar* _tmp30_;
						gint _tmp31_ = 0;
						_tmp29_ = channel;
						_tmp30_ = val;
						_tmp31_ = atoi (_tmp30_);
						dvb_cable_channel_set_SymbolRate (_tmp29_, (guint) (_tmp31_ / 1000));
					} else {
						gint _tmp32_;
						_tmp32_ = i;
						if (_tmp32_ == 4) {
							gint eval = 0;
							const gchar* _tmp33_;
							gint _tmp34_ = 0;
							gboolean _tmp35_ = FALSE;
							_tmp33_ = val;
							_tmp35_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, _tmp33_, "DVB_DVB_SRC_CODE_RATE_", &_tmp34_);
							eval = _tmp34_;
							if (_tmp35_) {
								DVBCableChannel* _tmp36_;
								gint _tmp37_;
								_tmp36_ = channel;
								_tmp37_ = eval;
								dvb_cable_channel_set_CodeRate (_tmp36_, (DVBDvbSrcCodeRate) _tmp37_);
							} else {
								failed = TRUE;
								break;
							}
						} else {
							gint _tmp38_;
							_tmp38_ = i;
							if (_tmp38_ == 5) {
								gint eval = 0;
								const gchar* _tmp39_;
								gint _tmp40_ = 0;
								gboolean _tmp41_ = FALSE;
								_tmp39_ = val;
								_tmp41_ = dvb_io_channel_list_reader_get_value_with_prefix (DVB_TYPE_DVB_SRC_MODULATION, _tmp39_, "DVB_DVB_SRC_MODULATION_", &_tmp40_);
								eval = _tmp40_;
								if (_tmp41_) {
									DVBCableChannel* _tmp42_;
									gint _tmp43_;
									_tmp42_ = channel;
									_tmp43_ = eval;
									dvb_cable_channel_set_Modulation (_tmp42_, (DVBDvbSrcModulation) _tmp43_);
								} else {
									failed = TRUE;
									break;
								}
							} else {
								gint _tmp44_;
								_tmp44_ = i;
								if (_tmp44_ == 6) {
									DVBCableChannel* _tmp45_;
									const gchar* _tmp46_;
									gint _tmp47_ = 0;
									_tmp45_ = channel;
									_tmp46_ = val;
									_tmp47_ = atoi (_tmp46_);
									dvb_channel_set_VideoPID ((DVBChannel*) _tmp45_, (guint) _tmp47_);
								} else {
									gint _tmp48_;
									_tmp48_ = i;
									if (_tmp48_ == 7) {
										DVBCableChannel* _tmp49_;
										GeeList* _tmp50_;
										GeeList* _tmp51_;
										const gchar* _tmp52_;
										gint _tmp53_ = 0;
										_tmp49_ = channel;
										_tmp50_ = dvb_channel_get_AudioPIDs ((DVBChannel*) _tmp49_);
										_tmp51_ = _tmp50_;
										_tmp52_ = val;
										_tmp53_ = atoi (_tmp52_);
										gee_collection_add ((GeeCollection*) _tmp51_, GUINT_TO_POINTER ((guint) _tmp53_));
									} else {
										gint _tmp54_;
										_tmp54_ = i;
										if (_tmp54_ == 8) {
											DVBCableChannel* _tmp55_;
											const gchar* _tmp56_;
											gint _tmp57_ = 0;
											_tmp55_ = channel;
											_tmp56_ = val;
											_tmp57_ = atoi (_tmp56_);
											dvb_channel_set_Sid ((DVBChannel*) _tmp55_, (guint) _tmp57_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp58_ = i;
		i = _tmp58_ + 1;
	}
	_tmp59_ = failed;
	if (_tmp59_) {
		result = NULL;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (channel);
		return result;
	} else {
		result = channel;
		_g_free0 (val);
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_g_free0 (val);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (channel);
}


static gboolean dvb_io_channel_list_reader_get_value_with_prefix (GType enumtype, const gchar* name, const gchar* prefix, gint* val) {
	gint _vala_val = 0;
	gboolean result = FALSE;
	GType _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (prefix != NULL, FALSE);
	_tmp0_ = enumtype;
	_tmp1_ = prefix;
	_tmp2_ = name;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp6_ = dvb_utils_get_value_by_name_from_enum (_tmp0_, _tmp4_, &_tmp5_);
	_vala_val = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	result = _tmp7_;
	if (val) {
		*val = _vala_val;
	}
	return result;
}


DVBChannelList* dvb_io_channel_list_reader_get_channels (DVBioChannelListReader* self) {
	DVBChannelList* result;
	DVBChannelList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_channels;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_channel_list_reader_set_channels (DVBioChannelListReader* self, DVBChannelList* value) {
	DVBChannelList* _tmp0_;
	DVBChannelList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_channels);
	self->priv->_channels = _tmp1_;
	g_object_notify ((GObject *) self, "channels");
}


DVBAdapterType dvb_io_channel_list_reader_get_Type (DVBioChannelListReader* self) {
	DVBAdapterType result;
	DVBAdapterType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Type;
	result = _tmp0_;
	return result;
}


static void dvb_io_channel_list_reader_set_Type (DVBioChannelListReader* self, DVBAdapterType value) {
	DVBAdapterType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Type = _tmp0_;
	g_object_notify ((GObject *) self, "Type");
}


static void dvb_io_channel_list_reader_class_init (DVBioChannelListReaderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_channel_list_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioChannelListReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_channel_list_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_channel_list_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_channel_list_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_READER_CHANNELS, g_param_spec_object ("channels", "channels", "channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_READER_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_channel_list_reader_log = _tmp1_;
}


static void dvb_io_channel_list_reader_instance_init (DVBioChannelListReader * self) {
	self->priv = DVB_IO_CHANNEL_LIST_READER_GET_PRIVATE (self);
}


static void dvb_io_channel_list_reader_finalize (GObject* obj) {
	DVBioChannelListReader * self;
	self = DVB_IO_CHANNEL_LIST_READER (obj);
	_g_object_unref0 (self->priv->_channels);
	G_OBJECT_CLASS (dvb_io_channel_list_reader_parent_class)->finalize (obj);
}


GType dvb_io_channel_list_reader_get_type (void) {
	static volatile gsize dvb_io_channel_list_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_channel_list_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioChannelListReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_channel_list_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioChannelListReader), 0, (GInstanceInitFunc) dvb_io_channel_list_reader_instance_init, NULL };
		GType dvb_io_channel_list_reader_type_id;
		dvb_io_channel_list_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioChannelListReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_channel_list_reader_type_id__volatile, dvb_io_channel_list_reader_type_id);
	}
	return dvb_io_channel_list_reader_type_id__volatile;
}


static void _vala_dvb_io_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioChannelListReader * self;
	self = DVB_IO_CHANNEL_LIST_READER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_READER_CHANNELS:
		g_value_set_object (value, dvb_io_channel_list_reader_get_channels (self));
		break;
		case DVB_IO_CHANNEL_LIST_READER_TYPE:
		g_value_set_enum (value, dvb_io_channel_list_reader_get_Type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioChannelListReader * self;
	self = DVB_IO_CHANNEL_LIST_READER (object);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_READER_CHANNELS:
		dvb_io_channel_list_reader_set_channels (self, g_value_get_object (value));
		break;
		case DVB_IO_CHANNEL_LIST_READER_TYPE:
		dvb_io_channel_list_reader_set_Type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



