/* CableChannel.c generated by valac 0.12.0, the Vala compiler
 * generated from CableChannel.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBChannelPrivate DVBChannelPrivate;

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;
typedef struct _DVBCableChannelPrivate DVBCableChannelPrivate;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	gboolean (*equals) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	gchar* (*to_string) (DVBChannel* self);
};

struct _DVBCableChannel {
	DVBChannel parent_instance;
	DVBCableChannelPrivate * priv;
};

struct _DVBCableChannelClass {
	DVBChannelClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

struct _DVBCableChannelPrivate {
	DVBDvbSrcInversion _Inversion;
	guint _SymbolRate;
	DVBDvbSrcCodeRate _CodeRate;
	DVBDvbSrcModulation _Modulation;
};


static gpointer dvb_cable_channel_parent_class = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_cable_channel_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
#define DVB_CABLE_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelPrivate))
enum  {
	DVB_CABLE_CHANNEL_DUMMY_PROPERTY,
	DVB_CABLE_CHANNEL_INVERSION,
	DVB_CABLE_CHANNEL_SYMBOL_RATE,
	DVB_CABLE_CHANNEL_CODE_RATE,
	DVB_CABLE_CHANNEL_MODULATION
};
DVBCableChannel* dvb_cable_channel_new_without_schedule (void);
DVBCableChannel* dvb_cable_channel_construct_without_schedule (GType object_type);
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
static void dvb_cable_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
guint dvb_channel_get_Frequency (DVBChannel* self);
DVBDvbSrcInversion dvb_cable_channel_get_Inversion (DVBCableChannel* self);
guint dvb_cable_channel_get_SymbolRate (DVBCableChannel* self);
DVBDvbSrcCodeRate dvb_cable_channel_get_CodeRate (DVBCableChannel* self);
DVBDvbSrcModulation dvb_cable_channel_get_Modulation (DVBCableChannel* self);
static gchar* dvb_cable_channel_real_to_string (DVBChannel* base);
const gchar* dvb_channel_get_Name (DVBChannel* self);
const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
guint dvb_channel_get_VideoPID (DVBChannel* self);
gchar* dvb_channel_get_audio_pids_string (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBCableChannel* dvb_cable_channel_new (void);
DVBCableChannel* dvb_cable_channel_construct (GType object_type);
DVBChannel* dvb_channel_construct (GType object_type);
void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value);
void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value);
void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value);
void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value);
static void dvb_cable_channel_finalize (GObject* obj);
static void _vala_dvb_cable_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_cable_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBCableChannel* dvb_cable_channel_construct_without_schedule (GType object_type) {
	DVBCableChannel * self = NULL;
	self = (DVBCableChannel*) dvb_channel_construct_without_schedule (object_type);
	return self;
}


DVBCableChannel* dvb_cable_channel_new_without_schedule (void) {
	return dvb_cable_channel_construct_without_schedule (DVB_TYPE_CABLE_CHANNEL);
}


static void dvb_cable_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBCableChannel * self;
	guint _tmp0_;
	self = (DVBCableChannel*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = dvb_channel_get_Frequency ((DVBChannel*) self);
	g_object_set ((GObject*) source, "frequency", _tmp0_, NULL);
	g_object_set ((GObject*) source, "inversion", self->priv->_Inversion, NULL);
	g_object_set ((GObject*) source, "symbol-rate", self->priv->_SymbolRate, NULL);
	g_object_set ((GObject*) source, "code-rate-hp", self->priv->_CodeRate, NULL);
	g_object_set ((GObject*) source, "modulation", self->priv->_Modulation, NULL);
}


static gchar* dvb_cable_channel_real_to_string (DVBChannel* base) {
	DVBCableChannel * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	guint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	guint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	self = (DVBCableChannel*) base;
	_tmp0_ = dvb_channel_get_Name (DVB_CHANNEL (self));
	_tmp1_ = dvb_channel_get_Frequency (DVB_CHANNEL (self));
	_tmp2_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_INVERSION, (gint) self->priv->_Inversion);
	_tmp3_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) self->priv->_CodeRate);
	_tmp4_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_MODULATION, (gint) self->priv->_Modulation);
	_tmp5_ = dvb_channel_get_VideoPID (DVB_CHANNEL (self));
	_tmp6_ = dvb_channel_get_audio_pids_string (DVB_CHANNEL (self));
	_tmp7_ = _tmp6_;
	_tmp8_ = dvb_channel_get_Sid (DVB_CHANNEL (self));
	_tmp9_ = g_strdup_printf ("%s:%u:%s:%u:%s:%s:%u:%s:%u", _tmp0_, _tmp1_, _tmp2_, self->priv->_SymbolRate * 1000, _tmp3_, _tmp4_, _tmp5_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp7_);
	result = _tmp10_;
	return result;
}


DVBCableChannel* dvb_cable_channel_construct (GType object_type) {
	DVBCableChannel * self = NULL;
	self = (DVBCableChannel*) dvb_channel_construct (object_type);
	return self;
}


DVBCableChannel* dvb_cable_channel_new (void) {
	return dvb_cable_channel_construct (DVB_TYPE_CABLE_CHANNEL);
}


DVBDvbSrcInversion dvb_cable_channel_get_Inversion (DVBCableChannel* self) {
	DVBDvbSrcInversion result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Inversion;
	return result;
}


void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value) {
	g_return_if_fail (self != NULL);
	self->priv->_Inversion = value;
	g_object_notify ((GObject *) self, "Inversion");
}


guint dvb_cable_channel_get_SymbolRate (DVBCableChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_SymbolRate;
	return result;
}


void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_SymbolRate = value;
	g_object_notify ((GObject *) self, "SymbolRate");
}


DVBDvbSrcCodeRate dvb_cable_channel_get_CodeRate (DVBCableChannel* self) {
	DVBDvbSrcCodeRate result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_CodeRate;
	return result;
}


void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value) {
	g_return_if_fail (self != NULL);
	self->priv->_CodeRate = value;
	g_object_notify ((GObject *) self, "CodeRate");
}


DVBDvbSrcModulation dvb_cable_channel_get_Modulation (DVBCableChannel* self) {
	DVBDvbSrcModulation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Modulation;
	return result;
}


void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value) {
	g_return_if_fail (self != NULL);
	self->priv->_Modulation = value;
	g_object_notify ((GObject *) self, "Modulation");
}


static void dvb_cable_channel_class_init (DVBCableChannelClass * klass) {
	dvb_cable_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBCableChannelPrivate));
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_cable_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_cable_channel_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_cable_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_cable_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_cable_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_INVERSION, g_param_spec_enum ("Inversion", "Inversion", "Inversion", DVB_TYPE_DVB_SRC_INVERSION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_SYMBOL_RATE, g_param_spec_uint ("SymbolRate", "SymbolRate", "SymbolRate", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_CODE_RATE, g_param_spec_enum ("CodeRate", "CodeRate", "CodeRate", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CABLE_CHANNEL_MODULATION, g_param_spec_enum ("Modulation", "Modulation", "Modulation", DVB_TYPE_DVB_SRC_MODULATION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_cable_channel_instance_init (DVBCableChannel * self) {
	self->priv = DVB_CABLE_CHANNEL_GET_PRIVATE (self);
}


static void dvb_cable_channel_finalize (GObject* obj) {
	DVBCableChannel * self;
	self = DVB_CABLE_CHANNEL (obj);
	G_OBJECT_CLASS (dvb_cable_channel_parent_class)->finalize (obj);
}


GType dvb_cable_channel_get_type (void) {
	static volatile gsize dvb_cable_channel_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_cable_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableChannel), 0, (GInstanceInitFunc) dvb_cable_channel_instance_init, NULL };
		GType dvb_cable_channel_type_id;
		dvb_cable_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBCableChannel", &g_define_type_info, 0);
		g_once_init_leave (&dvb_cable_channel_type_id__volatile, dvb_cable_channel_type_id);
	}
	return dvb_cable_channel_type_id__volatile;
}


static void _vala_dvb_cable_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBCableChannel * self;
	self = DVB_CABLE_CHANNEL (object);
	switch (property_id) {
		case DVB_CABLE_CHANNEL_INVERSION:
		g_value_set_enum (value, dvb_cable_channel_get_Inversion (self));
		break;
		case DVB_CABLE_CHANNEL_SYMBOL_RATE:
		g_value_set_uint (value, dvb_cable_channel_get_SymbolRate (self));
		break;
		case DVB_CABLE_CHANNEL_CODE_RATE:
		g_value_set_enum (value, dvb_cable_channel_get_CodeRate (self));
		break;
		case DVB_CABLE_CHANNEL_MODULATION:
		g_value_set_enum (value, dvb_cable_channel_get_Modulation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_cable_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBCableChannel * self;
	self = DVB_CABLE_CHANNEL (object);
	switch (property_id) {
		case DVB_CABLE_CHANNEL_INVERSION:
		dvb_cable_channel_set_Inversion (self, g_value_get_enum (value));
		break;
		case DVB_CABLE_CHANNEL_SYMBOL_RATE:
		dvb_cable_channel_set_SymbolRate (self, g_value_get_uint (value));
		break;
		case DVB_CABLE_CHANNEL_CODE_RATE:
		dvb_cable_channel_set_CodeRate (self, g_value_get_enum (value));
		break;
		case DVB_CABLE_CHANNEL_MODULATION:
		dvb_cable_channel_set_Modulation (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



