/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/ConfigStore.h>







GeeList* dvb_config_store_get_all_device_groups (DVBConfigStore* self) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->get_all_device_groups (self);
}


gboolean dvb_config_store_add_device_group (DVBConfigStore* self, DVBDeviceGroup* dev_group) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->add_device_group (self, dev_group);
}


gboolean dvb_config_store_remove_device_group (DVBConfigStore* self, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->remove_device_group (self, devgroup);
}


gboolean dvb_config_store_add_device_to_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->add_device_to_group (self, dev, devgroup);
}


gboolean dvb_config_store_remove_device_from_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->remove_device_from_group (self, dev, devgroup);
}


static void dvb_config_store_base_init (DVBConfigStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_config_store_get_type (void) {
	static GType dvb_config_store_type_id = 0;
	if (dvb_config_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBConfigStoreIface), (GBaseInitFunc) dvb_config_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_config_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBConfigStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_config_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_config_store_type_id;
}




