/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_RTSP_MEDIAFACTORY_H__
#define __SRC_RTSP_MEDIAFACTORY_H__

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-media-factory.h>
#include <gst/gst.h>
#include <gst/rtsp/gstrtspconnection.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define DVB_TYPE_MEDIA_FACTORY (dvb_media_factory_get_type ())
#define DVB_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory))
#define DVB_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))
#define DVB_IS_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_FACTORY))
#define DVB_IS_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_FACTORY))
#define DVB_MEDIA_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))

typedef struct _DVBMediaFactory DVBMediaFactory;
typedef struct _DVBMediaFactoryClass DVBMediaFactoryClass;
typedef struct _DVBMediaFactoryPrivate DVBMediaFactoryPrivate;

struct _DVBMediaFactory {
	GstRTSPMediaFactory parent_instance;
	DVBMediaFactoryPrivate * priv;
};

struct _DVBMediaFactoryClass {
	GstRTSPMediaFactoryClass parent_class;
};


DVBMediaFactory* dvb_media_factory_construct (GType object_type);
DVBMediaFactory* dvb_media_factory_new (void);
GType dvb_media_factory_get_type (void);


G_END_DECLS

#endif
