/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/EPGStore.h>







gboolean dvb_epg_store_add_or_update_event (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->add_or_update_event (self, event, channel_sid, group_id);
}


DVBEvent* dvb_epg_store_get_event (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->get_event (self, event_id, channel_sid, group_id);
}


gboolean dvb_epg_store_remove_event (DVBEPGStore* self, guint event_id, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->remove_event (self, event_id, channel_sid, group_id);
}


gboolean dvb_epg_store_contains_event (DVBEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->contains_event (self, event, channel_sid, group_id);
}


GeeList* dvb_epg_store_get_events (DVBEPGStore* self, guint channel_sid, guint group_id) {
	return DVB_EPG_STORE_GET_INTERFACE (self)->get_events (self, channel_sid, group_id);
}


static void dvb_epg_store_base_init (DVBEPGStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_epg_store_get_type (void) {
	static GType dvb_epg_store_type_id = 0;
	if (dvb_epg_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGStoreIface), (GBaseInitFunc) dvb_epg_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_epg_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBEPGStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_epg_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_epg_store_type_id;
}




