/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_TIMERSSTORE_H__
#define __SRC_TIMERSSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "src/DeviceGroup.h"
#include "src/Timer.h"

G_BEGIN_DECLS


#define DVB_TYPE_TIMERS_STORE (dvb_timers_store_get_type ())
#define DVB_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStore))
#define DVB_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMERS_STORE))
#define DVB_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_TIMERS_STORE, DVBTimersStoreIface))

typedef struct _DVBTimersStore DVBTimersStore;
typedef struct _DVBTimersStoreIface DVBTimersStoreIface;

struct _DVBTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBTimersStore* self, DVBDeviceGroup* dev);
	gboolean (*add_timer_to_device_group) (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
	gboolean (*remove_timer_from_device_group) (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);
};


GeeList* dvb_timers_store_get_all_timers_of_device_group (DVBTimersStore* self, DVBDeviceGroup* dev);
gboolean dvb_timers_store_add_timer_to_device_group (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev);
gboolean dvb_timers_store_remove_timer_from_device_group (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev);
GType dvb_timers_store_get_type (void);


G_END_DECLS

#endif
