/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_RECORDINGSSTORE_H__
#define __SRC_RECORDINGSSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "src/IDBusRecordingsStore.h"
#include "src/Recording.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
typedef struct _DVBRecordingsStorePrivate DVBRecordingsStorePrivate;

/**
     * This class manages the recordings off all devices
     */
struct _DVBRecordingsStore {
	GObject parent_instance;
	DVBRecordingsStorePrivate * priv;
};

struct _DVBRecordingsStoreClass {
	GObjectClass parent_class;
};


DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_shutdown (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
DVBRecordingsStore* dvb_recordings_store_construct (GType object_type);
DVBRecordingsStore* dvb_recordings_store_new (void);
void dvb_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_recordings_store_get_type (void);


G_END_DECLS

#endif
