/* Interfaces.c generated by valac 0.10.0, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define TYPE_MEDIA_OBJECT1 (media_object1_get_type ())
#define MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT1, MediaObject1))
#define IS_MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT1))
#define MEDIA_OBJECT1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT1, MediaObject1Iface))

typedef struct _MediaObject1 MediaObject1;
typedef struct _MediaObject1Iface MediaObject1Iface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObject1DBusProxy MediaObject1DBusProxy;
typedef DBusGProxyClass MediaObject1DBusProxyClass;

#define TYPE_MEDIA_CONTAINER1 (media_container1_get_type ())
#define MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1))
#define IS_MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER1))
#define MEDIA_CONTAINER1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1Iface))

typedef struct _MediaContainer1 MediaContainer1;
typedef struct _MediaContainer1Iface MediaContainer1Iface;
typedef struct _MediaContainer1DBusProxy MediaContainer1DBusProxy;
typedef DBusGProxyClass MediaContainer1DBusProxyClass;

#define TYPE_MEDIA_ITEM1 (media_item1_get_type ())
#define MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM1, MediaItem1))
#define IS_MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM1))
#define MEDIA_ITEM1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM1, MediaItem1Iface))

typedef struct _MediaItem1 MediaItem1;
typedef struct _MediaItem1Iface MediaItem1Iface;
typedef struct _MediaItem1DBusProxy MediaItem1DBusProxy;
typedef DBusGProxyClass MediaItem1DBusProxyClass;

struct _MediaObject1Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject1* self);
	char* (*get_DisplayName) (MediaObject1* self);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _MediaObject1DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MediaContainer1Iface {
	GTypeInterface parent_iface;
	char** (*get_Items) (MediaContainer1* self, int* result_length1);
	guint (*get_ItemCount) (MediaContainer1* self);
	char** (*get_Containers) (MediaContainer1* self, int* result_length1);
	guint (*get_ContainerCount) (MediaContainer1* self);
};

struct _MediaContainer1DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MediaItem1Iface {
	GTypeInterface parent_iface;
	char** (*get_URLs) (MediaItem1* self, int* result_length1);
	char* (*get_MIMEType) (MediaItem1* self);
	char* (*get_Type) (MediaItem1* self);
};

struct _MediaItem1DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};



GType media_object1_get_type (void) G_GNUC_CONST;
MediaObject1* media_object1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char* media_object1_get_Parent (MediaObject1* self);
char* media_object1_get_DisplayName (MediaObject1* self);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void media_object1_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_object1_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_object1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_object1_introspect (MediaObject1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_object1_property_get (MediaObject1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_object1_property_get_all (MediaObject1* self, DBusConnection* connection, DBusMessage* message);
GType media_object1_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult media_object1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_OBJECT1_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_OBJECT1_DBUS_PROXY_PARENT,
	MEDIA_OBJECT1_DBUS_PROXY_DISPLAY_NAME
};
static char* media_object1_dbus_proxy_get_Parent (MediaObject1* self);
static char* media_object1_dbus_proxy_get_DisplayName (MediaObject1* self);
static void media_object1_dbus_proxy_media_object1__interface_init (MediaObject1Iface* iface);
static void media_object1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_object1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType media_container1_get_type (void) G_GNUC_CONST;
MediaContainer1* media_container1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char** media_container1_get_Items (MediaContainer1* self, int* result_length1);
guint media_container1_get_ItemCount (MediaContainer1* self);
char** media_container1_get_Containers (MediaContainer1* self, int* result_length1);
guint media_container1_get_ContainerCount (MediaContainer1* self);
void media_container1_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_container1_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_container1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_container1_introspect (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container1_property_get (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container1_property_get_all (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_media_container1_updated (GObject* _sender, DBusConnection* _connection);
GType media_container1_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_media_container1_updated (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult media_container1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_CONTAINER1_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_CONTAINER1_DBUS_PROXY_ITEM_COUNT,
	MEDIA_CONTAINER1_DBUS_PROXY_CONTAINER_COUNT
};
static char** media_container1_dbus_proxy_get_Items (MediaContainer1* self, int* result_length1);
static guint media_container1_dbus_proxy_get_ItemCount (MediaContainer1* self);
static char** media_container1_dbus_proxy_get_Containers (MediaContainer1* self, int* result_length1);
static guint media_container1_dbus_proxy_get_ContainerCount (MediaContainer1* self);
static void media_container1_dbus_proxy_media_container1__interface_init (MediaContainer1Iface* iface);
static void media_container1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_container1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType media_item1_get_type (void) G_GNUC_CONST;
MediaItem1* media_item1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
char** media_item1_get_URLs (MediaItem1* self, int* result_length1);
char* media_item1_get_MIMEType (MediaItem1* self);
char* media_item1_get_Type (MediaItem1* self);
void media_item1_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_item1_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_item1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_item1_introspect (MediaItem1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_item1_property_get (MediaItem1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_item1_property_get_all (MediaItem1* self, DBusConnection* connection, DBusMessage* message);
GType media_item1_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult media_item1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_ITEM1_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_ITEM1_DBUS_PROXY_UR_LS,
	MEDIA_ITEM1_DBUS_PROXY_MIME_TYPE,
	MEDIA_ITEM1_DBUS_PROXY_TYPE
};
static char** media_item1_dbus_proxy_get_URLs (MediaItem1* self, int* result_length1);
static char* media_item1_dbus_proxy_get_MIMEType (MediaItem1* self);
static char* media_item1_dbus_proxy_get_Type (MediaItem1* self);
static void media_item1_dbus_proxy_media_item1__interface_init (MediaItem1Iface* iface);
static void media_item1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_item1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _media_object1_dbus_path_vtable = {_media_object1_dbus_unregister, media_object1_dbus_message};
static const _DBusObjectVTable _media_object1_dbus_vtable = {media_object1_dbus_register_object};
static const DBusObjectPathVTable _media_container1_dbus_path_vtable = {_media_container1_dbus_unregister, media_container1_dbus_message};
static const _DBusObjectVTable _media_container1_dbus_vtable = {media_container1_dbus_register_object};
static const DBusObjectPathVTable _media_item1_dbus_path_vtable = {_media_item1_dbus_unregister, media_item1_dbus_message};
static const _DBusObjectVTable _media_item1_dbus_vtable = {media_item1_dbus_register_object};


char* media_object1_get_Parent (MediaObject1* self) {
	return MEDIA_OBJECT1_GET_INTERFACE (self)->get_Parent (self);
}


char* media_object1_get_DisplayName (MediaObject1* self) {
	return MEDIA_OBJECT1_GET_INTERFACE (self)->get_DisplayName (self);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _media_object1_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_object1_introspect (MediaObject1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_object1_property_get (MediaObject1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "Parent") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = media_object1_get_Parent (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "DisplayName") == 0)) {
		char* result;
		const char* _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_object1_get_DisplayName (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp3_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_object1_property_get_all (MediaObject1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp4_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp5_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Parent";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = media_object1_get_Parent (self);
			_tmp5_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp5_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp6_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DisplayName";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_object1_get_DisplayName (self);
			_tmp6_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp6_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_object1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_object1_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_object1_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_object1_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void media_object1_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_object1_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void media_object1_base_init (MediaObject1Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("Parent", "Parent", "Parent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("DisplayName", "DisplayName", "DisplayName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (TYPE_MEDIA_OBJECT1, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_object1_dbus_vtable));
	}
}


GType media_object1_get_type (void) {
	static volatile gsize media_object1_type_id__volatile = 0;
	if (g_once_init_enter (&media_object1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObject1Iface), (GBaseInitFunc) media_object1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_object1_type_id;
		media_object1_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaObject1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_object1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_object1_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_object1_dbus_proxy_get_type);
		g_once_init_leave (&media_object1_type_id__volatile, media_object1_type_id);
	}
	return media_object1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaObject1DBusProxy, media_object1_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_OBJECT1, media_object1_dbus_proxy_media_object1__interface_init) );
MediaObject1* media_object1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaObject1* self;
	self = g_object_new (media_object1_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaObject1", NULL);
	return self;
}


static GObject* media_object1_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_object1_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_object1_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult media_object1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_object1_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaObject1DBusProxy*) self)->disposed) {
		return;
	}
	((MediaObject1DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_object1_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_object1_dbus_proxy_parent_class)->dispose (self);
}


static void media_object1_dbus_proxy_class_init (MediaObject1DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_object1_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_object1_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_object1_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_object1_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT1_DBUS_PROXY_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT1_DBUS_PROXY_DISPLAY_NAME, "DisplayName");
}


static void media_object1_dbus_proxy_init (MediaObject1DBusProxy* self) {
}


static char* media_object1_dbus_proxy_get_Parent (MediaObject1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp448_;
	const char* _tmp449_;
	char* _result;
	const char* _tmp450_;
	if (((MediaObject1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp448_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp448_);
	_tmp449_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp449_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp450_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp450_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_object1_dbus_proxy_get_DisplayName (MediaObject1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp451_;
	const char* _tmp452_;
	char* _result;
	const char* _tmp453_;
	if (((MediaObject1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp451_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp451_);
	_tmp452_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp452_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp453_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp453_);
	dbus_message_unref (_reply);
	return _result;
}


static void media_object1_dbus_proxy_media_object1__interface_init (MediaObject1Iface* iface) {
	iface->get_Parent = media_object1_dbus_proxy_get_Parent;
	iface->get_DisplayName = media_object1_dbus_proxy_get_DisplayName;
}


static void media_object1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_object1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** media_container1_get_Items (MediaContainer1* self, int* result_length1) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_Items (self, result_length1);
}


guint media_container1_get_ItemCount (MediaContainer1* self) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_ItemCount (self);
}


char** media_container1_get_Containers (MediaContainer1* self, int* result_length1) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_Containers (self, result_length1);
}


guint media_container1_get_ContainerCount (MediaContainer1* self) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_ContainerCount (self);
}


void _media_container1_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_container1_introspect (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container1_property_get (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Items") == 0)) {
		char** result;
		int result_length1;
		char** _tmp2_;
		DBusMessageIter _tmp3_;
		int _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "ao", &subiter);
		result = media_container1_get_Items (self, &result_length1);
		_tmp2_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "o", &_tmp3_);
		for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
			const char* _tmp5_;
			_tmp5_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp3_, DBUS_TYPE_OBJECT_PATH, &_tmp5_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp3_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ItemCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp6_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container1_get_ItemCount (self);
		_tmp6_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp6_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Containers") == 0)) {
		char** result;
		int result_length1;
		char** _tmp7_;
		DBusMessageIter _tmp8_;
		int _tmp9_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "ao", &subiter);
		result = media_container1_get_Containers (self, &result_length1);
		_tmp7_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "o", &_tmp8_);
		for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
			const char* _tmp10_;
			_tmp10_ = *_tmp7_;
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_OBJECT_PATH, &_tmp10_);
			_tmp7_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp8_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ContainerCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp11_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container1_get_ContainerCount (self);
		_tmp11_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp11_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container1_property_get_all (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp12_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp12_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp13_;
			DBusMessageIter _tmp14_;
			int _tmp15_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Items";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "ao", &value_iter);
			result = media_container1_get_Items (self, &result_length1);
			_tmp13_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "o", &_tmp14_);
			for (_tmp15_ = 0; _tmp15_ < result_length1; _tmp15_++) {
				const char* _tmp16_;
				_tmp16_ = *_tmp13_;
				dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_OBJECT_PATH, &_tmp16_);
				_tmp13_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp14_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp17_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ItemCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container1_get_ItemCount (self);
			_tmp17_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp17_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp18_;
			DBusMessageIter _tmp19_;
			int _tmp20_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Containers";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "ao", &value_iter);
			result = media_container1_get_Containers (self, &result_length1);
			_tmp18_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "o", &_tmp19_);
			for (_tmp20_ = 0; _tmp20_ < result_length1; _tmp20_++) {
				const char* _tmp21_;
				_tmp21_ = *_tmp18_;
				dbus_message_iter_append_basic (&_tmp19_, DBUS_TYPE_OBJECT_PATH, &_tmp21_);
				_tmp18_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp19_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp22_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ContainerCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container1_get_ContainerCount (self);
			_tmp22_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp22_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_container1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_container1_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_container1_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_container1_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_media_container1_updated (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.UPnP.MediaContainer1", "Updated");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void media_container1_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_container1_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_media_container1_updated, connection);
}


static void media_container1_base_init (MediaContainer1Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_uint ("ItemCount", "ItemCount", "ItemCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint ("ContainerCount", "ContainerCount", "ContainerCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("updated", TYPE_MEDIA_CONTAINER1, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_type_set_qdata (TYPE_MEDIA_CONTAINER1, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_container1_dbus_vtable));
	}
}


GType media_container1_get_type (void) {
	static volatile gsize media_container1_type_id__volatile = 0;
	if (g_once_init_enter (&media_container1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaContainer1Iface), (GBaseInitFunc) media_container1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_container1_type_id;
		media_container1_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaContainer1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_container1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_container1_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_container1_dbus_proxy_get_type);
		g_once_init_leave (&media_container1_type_id__volatile, media_container1_type_id);
	}
	return media_container1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaContainer1DBusProxy, media_container1_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_CONTAINER1, media_container1_dbus_proxy_media_container1__interface_init) );
MediaContainer1* media_container1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaContainer1* self;
	self = g_object_new (media_container1_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaContainer1", NULL);
	return self;
}


static GObject* media_container1_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_container1_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_container1_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_media_container1_updated (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "updated");
}


DBusHandlerResult media_container1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.UPnP.MediaContainer1", "Updated")) {
			_dbus_handle_media_container1_updated (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_container1_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return;
	}
	((MediaContainer1DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_container1_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_container1_dbus_proxy_parent_class)->dispose (self);
}


static void media_container1_dbus_proxy_class_init (MediaContainer1DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_container1_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_container1_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_container1_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_container1_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER1_DBUS_PROXY_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER1_DBUS_PROXY_CONTAINER_COUNT, "ContainerCount");
}


static void media_container1_dbus_proxy_init (MediaContainer1DBusProxy* self) {
}


static char** media_container1_dbus_proxy_get_Items (MediaContainer1* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp454_;
	const char* _tmp455_;
	char** _result;
	int _result_length1;
	char** _tmp456_;
	int _tmp456__length;
	int _tmp456__size;
	int _tmp456__length1;
	DBusMessageIter _tmp457_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp454_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp454_);
	_tmp455_ = "Items";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp455_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "ao")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "ao", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp456_ = g_new (char*, 5);
	_tmp456__length = 0;
	_tmp456__size = 4;
	_tmp456__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp457_);
	for (; dbus_message_iter_get_arg_type (&_tmp457_); _tmp456__length1++) {
		const char* _tmp458_;
		if (_tmp456__size == _tmp456__length) {
			_tmp456__size = 2 * _tmp456__size;
			_tmp456_ = g_renew (char*, _tmp456_, _tmp456__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp457_, &_tmp458_);
		dbus_message_iter_next (&_tmp457_);
		_tmp456_[_tmp456__length++] = g_strdup (_tmp458_);
	}
	_result_length1 = _tmp456__length1;
	_tmp456_[_tmp456__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp456_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container1_dbus_proxy_get_ItemCount (MediaContainer1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp459_;
	const char* _tmp460_;
	guint _result;
	dbus_uint32_t _tmp461_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp459_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp459_);
	_tmp460_ = "ItemCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp460_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp461_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp461_;
	dbus_message_unref (_reply);
	return _result;
}


static char** media_container1_dbus_proxy_get_Containers (MediaContainer1* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp462_;
	const char* _tmp463_;
	char** _result;
	int _result_length1;
	char** _tmp464_;
	int _tmp464__length;
	int _tmp464__size;
	int _tmp464__length1;
	DBusMessageIter _tmp465_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp462_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp462_);
	_tmp463_ = "Containers";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp463_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "ao")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "ao", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp464_ = g_new (char*, 5);
	_tmp464__length = 0;
	_tmp464__size = 4;
	_tmp464__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp465_);
	for (; dbus_message_iter_get_arg_type (&_tmp465_); _tmp464__length1++) {
		const char* _tmp466_;
		if (_tmp464__size == _tmp464__length) {
			_tmp464__size = 2 * _tmp464__size;
			_tmp464_ = g_renew (char*, _tmp464_, _tmp464__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp465_, &_tmp466_);
		dbus_message_iter_next (&_tmp465_);
		_tmp464_[_tmp464__length++] = g_strdup (_tmp466_);
	}
	_result_length1 = _tmp464__length1;
	_tmp464_[_tmp464__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp464_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container1_dbus_proxy_get_ContainerCount (MediaContainer1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp467_;
	const char* _tmp468_;
	guint _result;
	dbus_uint32_t _tmp469_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp467_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp467_);
	_tmp468_ = "ContainerCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp468_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp469_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp469_;
	dbus_message_unref (_reply);
	return _result;
}


static void media_container1_dbus_proxy_media_container1__interface_init (MediaContainer1Iface* iface) {
	iface->get_Items = media_container1_dbus_proxy_get_Items;
	iface->get_ItemCount = media_container1_dbus_proxy_get_ItemCount;
	iface->get_Containers = media_container1_dbus_proxy_get_Containers;
	iface->get_ContainerCount = media_container1_dbus_proxy_get_ContainerCount;
}


static void media_container1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_container1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** media_item1_get_URLs (MediaItem1* self, int* result_length1) {
	return MEDIA_ITEM1_GET_INTERFACE (self)->get_URLs (self, result_length1);
}


char* media_item1_get_MIMEType (MediaItem1* self) {
	return MEDIA_ITEM1_GET_INTERFACE (self)->get_MIMEType (self);
}


char* media_item1_get_Type (MediaItem1* self) {
	return MEDIA_ITEM1_GET_INTERFACE (self)->get_Type (self);
}


void _media_item1_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_item1_introspect (MediaItem1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem1\">\n  <property name=\"URLs\" type=\"as\" access=\"read\"/>\n  <property name=\"MIMEType\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_item1_property_get (MediaItem1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "URLs") == 0)) {
		char** result;
		int result_length1;
		char** _tmp2_;
		DBusMessageIter _tmp3_;
		int _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = media_item1_get_URLs (self, &result_length1);
		_tmp2_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp3_);
		for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
			const char* _tmp5_;
			_tmp5_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp3_, DBUS_TYPE_STRING, &_tmp5_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp3_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "MIMEType") == 0)) {
		char* result;
		const char* _tmp6_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_item1_get_MIMEType (self);
		_tmp6_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp6_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Type") == 0)) {
		char* result;
		const char* _tmp7_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_item1_get_Type (self);
		_tmp7_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp7_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_item1_property_get_all (MediaItem1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp8_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp8_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp9_;
			DBusMessageIter _tmp10_;
			int _tmp11_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "URLs";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = media_item1_get_URLs (self, &result_length1);
			_tmp9_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp10_);
			for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
				const char* _tmp12_;
				_tmp12_ = *_tmp9_;
				dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_STRING, &_tmp12_);
				_tmp9_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp10_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp13_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "MIMEType";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_item1_get_MIMEType (self);
			_tmp13_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp13_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp14_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Type";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_item1_get_Type (self);
			_tmp14_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp14_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_item1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_item1_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_item1_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_item1_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void media_item1_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_item1_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void media_item1_base_init (MediaItem1Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_boxed ("URLs", "URLs", "URLs", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("MIMEType", "MIMEType", "MIMEType", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("Type", "Type", "Type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (TYPE_MEDIA_ITEM1, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_item1_dbus_vtable));
	}
}


GType media_item1_get_type (void) {
	static volatile gsize media_item1_type_id__volatile = 0;
	if (g_once_init_enter (&media_item1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaItem1Iface), (GBaseInitFunc) media_item1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_item1_type_id;
		media_item1_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaItem1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_item1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_item1_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_item1_dbus_proxy_get_type);
		g_once_init_leave (&media_item1_type_id__volatile, media_item1_type_id);
	}
	return media_item1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaItem1DBusProxy, media_item1_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_ITEM1, media_item1_dbus_proxy_media_item1__interface_init) );
MediaItem1* media_item1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaItem1* self;
	self = g_object_new (media_item1_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaItem1", NULL);
	return self;
}


static GObject* media_item1_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_item1_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_item1_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult media_item1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_item1_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return;
	}
	((MediaItem1DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_item1_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_item1_dbus_proxy_parent_class)->dispose (self);
}


static void media_item1_dbus_proxy_class_init (MediaItem1DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_item1_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_item1_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_item1_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_item1_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM1_DBUS_PROXY_UR_LS, "URLs");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM1_DBUS_PROXY_MIME_TYPE, "MIMEType");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM1_DBUS_PROXY_TYPE, "Type");
}


static void media_item1_dbus_proxy_init (MediaItem1DBusProxy* self) {
}


static char** media_item1_dbus_proxy_get_URLs (MediaItem1* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp470_;
	const char* _tmp471_;
	char** _result;
	int _result_length1;
	char** _tmp472_;
	int _tmp472__length;
	int _tmp472__size;
	int _tmp472__length1;
	DBusMessageIter _tmp473_;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp470_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp470_);
	_tmp471_ = "URLs";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp471_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp472_ = g_new (char*, 5);
	_tmp472__length = 0;
	_tmp472__size = 4;
	_tmp472__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp473_);
	for (; dbus_message_iter_get_arg_type (&_tmp473_); _tmp472__length1++) {
		const char* _tmp474_;
		if (_tmp472__size == _tmp472__length) {
			_tmp472__size = 2 * _tmp472__size;
			_tmp472_ = g_renew (char*, _tmp472_, _tmp472__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp473_, &_tmp474_);
		dbus_message_iter_next (&_tmp473_);
		_tmp472_[_tmp472__length++] = g_strdup (_tmp474_);
	}
	_result_length1 = _tmp472__length1;
	_tmp472_[_tmp472__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp472_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* media_item1_dbus_proxy_get_MIMEType (MediaItem1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp475_;
	const char* _tmp476_;
	char* _result;
	const char* _tmp477_;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp475_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp475_);
	_tmp476_ = "MIMEType";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp476_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp477_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp477_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_item1_dbus_proxy_get_Type (MediaItem1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp478_;
	const char* _tmp479_;
	char* _result;
	const char* _tmp480_;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp478_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp478_);
	_tmp479_ = "Type";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp479_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp480_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp480_);
	dbus_message_unref (_reply);
	return _result;
}


static void media_item1_dbus_proxy_media_item1__interface_init (MediaItem1Iface* iface) {
	iface->get_URLs = media_item1_dbus_proxy_get_URLs;
	iface->get_MIMEType = media_item1_dbus_proxy_get_MIMEType;
	iface->get_Type = media_item1_dbus_proxy_get_Type;
}


static void media_item1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_item1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




