
#ifndef __SRC_CABLE_CABLESCANNER_H__
#define __SRC_CABLE_CABLESCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include "src/Scanner.h"
#include "src/Device.h"
#include "src/ScannedItem.h"
#include "src/Channel.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_CABLE_SCANNER (dvb_id_bus_cable_scanner_get_type ())
#define DVB_ID_BUS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CABLE_SCANNER, DVBIDBusCableScanner))
#define DVB_IS_ID_BUS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CABLE_SCANNER))
#define DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CABLE_SCANNER, DVBIDBusCableScannerIface))

typedef struct _DVBIDBusCableScanner DVBIDBusCableScanner;
typedef struct _DVBIDBusCableScannerIface DVBIDBusCableScannerIface;

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;
typedef struct _DVBCableScannerPrivate DVBCableScannerPrivate;

struct _DVBIDBusCableScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusCableScanner* self);
	void (*Destroy) (DVBIDBusCableScanner* self);
	gboolean (*WriteChannelsToFile) (DVBIDBusCableScanner* self, const char* path);
	void (*AddScanningData) (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate);
	gboolean (*AddScanningDataFromFile) (DVBIDBusCableScanner* self, const char* path);
};

struct _DVBCableScanner {
	DVBScanner parent_instance;
	DVBCableScannerPrivate * priv;
};

struct _DVBCableScannerClass {
	DVBScannerClass parent_class;
};


void dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self);
void dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self);
gboolean dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path);
void dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate);
gboolean dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path);
void dvb_id_bus_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_id_bus_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_id_bus_cable_scanner_get_type (void);
DVBIDBusCableScanner* dvb_id_bus_cable_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
void dvb_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_cable_scanner_get_type (void);


G_END_DECLS

#endif
