
#include <src/IDBusRecordingsStore.h>

typedef DBusGProxy DVBIDBusRecordingsStoreDBusProxy;
typedef DBusGProxyClass DVBIDBusRecordingsStoreDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_recordings_store_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_introspect (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_get (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_set (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_get_all (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_recordings_store_changed (GObject* _sender, guint32 rec_id, guint type, DBusConnection* _connection);
static guint32* dvb_id_bus_recordings_store_dbus_proxy_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id);
static char* dvb_id_bus_recordings_store_dbus_proxy_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id);
static guint* dvb_id_bus_recordings_store_dbus_proxy_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1);
static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id);
static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id);
static gboolean dvb_id_bus_recordings_store_dbus_proxy_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id);
static void dvb_id_bus_recordings_store_dbus_proxy_interface_init (DVBIDBusRecordingsStoreIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_recordings_store_dbus_path_vtable = {_dvb_id_bus_recordings_store_dbus_unregister, dvb_id_bus_recordings_store_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_recordings_store_dbus_vtable = {dvb_id_bus_recordings_store_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @returns: A list of ids for all recordings
         */
guint32* dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetRecordings (self, result_length1);
}


/**
         * @rec_id: The id of the recording
         * @returns: The location of the recording on the filesystem
         */
char* dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLocation (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The name of the recording (e.g. the name of
         * a TV show)
         */
char* dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetName (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: A short text describing the recorded item
         * (e.g. the description from EPG)
         */
char* dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetDescription (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The starting time of the recording
         */
guint* dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTime (self, rec_id, result_length1);
}


/**
         * @rec_id: The id of the recording
         * @returns: Start time as UNIX timestamp
         */
gint64 dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetStartTimestamp (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: The length of the recording in seconds
         * or -1 if no recording with the given id exists
         */
gint64 dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->GetLength (self, rec_id);
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
gboolean dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	return DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE (self)->Delete (self, rec_id);
}


void _dvb_id_bus_recordings_store_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_introspect (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.RecordingsStore\">\n  <method name=\"GetRecordings\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocation\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDescription\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTime\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStartTimestamp\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"x\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLength\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"x\" direction=\"out\"/>\n  </method>\n  <method name=\"Delete\">\n    <arg name=\"rec_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"rec_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_get (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_set (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_property_get_all (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp4;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4);
	if (strcmp (interface_name, "org.gnome.DVB.RecordingsStore") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetRecordings (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint32* result;
	DBusMessage* reply;
	DBusMessageIter _tmp5;
	int _tmp6;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_recordings_store_GetRecordings (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp5);
	for (_tmp6 = 0; _tmp6 < result_length1; _tmp6++) {
		dbus_uint32_t _tmp7;
		_tmp7 = result[_tmp6];
		dbus_message_iter_append_basic (&_tmp5, DBUS_TYPE_UINT32, &_tmp7);
	}
	dbus_message_iter_close_container (&iter, &_tmp5);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLocation (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp8;
	char* result;
	DBusMessage* reply;
	const char* _tmp9;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp8);
	dbus_message_iter_next (&iter);
	rec_id = _tmp8;
	result = dvb_id_bus_recordings_store_GetLocation (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp9 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp9);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetName (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp10;
	char* result;
	DBusMessage* reply;
	const char* _tmp11;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp10);
	dbus_message_iter_next (&iter);
	rec_id = _tmp10;
	result = dvb_id_bus_recordings_store_GetName (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp11 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp11);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetDescription (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp12;
	char* result;
	DBusMessage* reply;
	const char* _tmp13;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp12);
	dbus_message_iter_next (&iter);
	rec_id = _tmp12;
	result = dvb_id_bus_recordings_store_GetDescription (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp13 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp13);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTime (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp14;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	DBusMessageIter _tmp15;
	int _tmp16;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp14);
	dbus_message_iter_next (&iter);
	rec_id = _tmp14;
	result_length1 = 0;
	result = dvb_id_bus_recordings_store_GetStartTime (self, rec_id, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp15);
	for (_tmp16 = 0; _tmp16 < result_length1; _tmp16++) {
		dbus_uint32_t _tmp17;
		_tmp17 = result[_tmp16];
		dbus_message_iter_append_basic (&_tmp15, DBUS_TYPE_UINT32, &_tmp17);
	}
	dbus_message_iter_close_container (&iter, &_tmp15);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp18;
	gint64 result;
	DBusMessage* reply;
	dbus_int64_t _tmp19;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18);
	dbus_message_iter_next (&iter);
	rec_id = _tmp18;
	result = dvb_id_bus_recordings_store_GetStartTimestamp (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT64, &_tmp19);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_GetLength (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp20;
	gint64 result;
	DBusMessage* reply;
	dbus_int64_t _tmp21;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp20);
	dbus_message_iter_next (&iter);
	rec_id = _tmp20;
	result = dvb_id_bus_recordings_store_GetLength (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT64, &_tmp21);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_recordings_store_Delete (DVBIDBusRecordingsStore* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 rec_id;
	dbus_uint32_t _tmp22;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp23;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	rec_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp22);
	dbus_message_iter_next (&iter);
	rec_id = _tmp22;
	result = dvb_id_bus_recordings_store_Delete (self, rec_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp23 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp23);
	return reply;
}


DBusHandlerResult dvb_id_bus_recordings_store_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_recordings_store_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		reply = _dbus_dvb_id_bus_recordings_store_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		reply = _dbus_dvb_id_bus_recordings_store_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_recordings_store_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetRecordings")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetRecordings (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetLocation")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetLocation (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetName")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetDescription")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetDescription (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetStartTime")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetStartTime (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetStartTimestamp")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetStartTimestamp (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "GetLength")) {
		reply = _dbus_dvb_id_bus_recordings_store_GetLength (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.RecordingsStore", "Delete")) {
		reply = _dbus_dvb_id_bus_recordings_store_Delete (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_recordings_store_changed (GObject* _sender, guint32 rec_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp24;
	dbus_uint32_t _tmp25;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.RecordingsStore", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp24 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp24);
	_tmp25 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp25);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_recordings_store_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_recordings_store_dbus_path_vtable, object);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_recordings_store_changed, connection);
}


static void dvb_id_bus_recordings_store_base_init (DVBIDBusRecordingsStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDINGS_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_RECORDINGS_STORE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_recordings_store_dbus_vtable));
	}
}


GType dvb_id_bus_recordings_store_get_type (void) {
	static GType dvb_id_bus_recordings_store_type_id = 0;
	if (dvb_id_bus_recordings_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecordingsStoreIface), (GBaseInitFunc) dvb_id_bus_recordings_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recordings_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecordingsStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recordings_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_recordings_store_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusRecordingsStoreDBusProxy, dvb_id_bus_recordings_store_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_RECORDINGS_STORE, dvb_id_bus_recordings_store_dbus_proxy_interface_init));
DVBIDBusRecordingsStore* dvb_id_bus_recordings_store_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	return g_object_new (dvb_id_bus_recordings_store_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.RecordingsStore", NULL);
}


static void dvb_id_bus_recordings_store_dbus_proxy_class_init (DVBIDBusRecordingsStoreDBusProxyClass* klass) {
}


static void dvb_id_bus_recordings_store_dbus_proxy_init (DVBIDBusRecordingsStoreDBusProxy* self) {
}


static guint32* dvb_id_bus_recordings_store_dbus_proxy_GetRecordings (DVBIDBusRecordingsStore* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint32* _result;
	int _result_length1;
	guint32* _tmp26;
	int _tmp26_length;
	int _tmp26_size;
	int _tmp26_length1;
	DBusMessageIter _tmp27;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetRecordings");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp26 = NULL;
	_tmp26_length = 0;
	_tmp26_size = 0;
	_tmp26_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp27);
	for (; dbus_message_iter_get_arg_type (&_tmp27); _tmp26_length1++) {
		dbus_uint32_t _tmp28;
		if (_tmp26_size == _tmp26_length) {
			_tmp26_size = (_tmp26_size > 0) ? (2 * _tmp26_size) : 4;
			_tmp26 = g_renew (guint32, _tmp26, _tmp26_size);
		}
		dbus_message_iter_get_basic (&_tmp27, &_tmp28);
		dbus_message_iter_next (&_tmp27);
		_tmp26[_tmp26_length++] = _tmp28;
	}
	_result_length1 = _tmp26_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp26;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetLocation (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp29;
	char* _result;
	const char* _tmp30;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetLocation");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp29 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp29);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp30);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp30);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetName (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp31;
	char* _result;
	const char* _tmp32;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp31 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp31);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp32);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp32);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_recordings_store_dbus_proxy_GetDescription (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp33;
	char* _result;
	const char* _tmp34;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetDescription");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp33 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp33);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp34);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp34);
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_recordings_store_dbus_proxy_GetStartTime (DVBIDBusRecordingsStore* self, guint32 rec_id, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp35;
	guint* _result;
	int _result_length1;
	guint* _tmp36;
	int _tmp36_length;
	int _tmp36_size;
	int _tmp36_length1;
	DBusMessageIter _tmp37;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetStartTime");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp35 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp35);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp36 = NULL;
	_tmp36_length = 0;
	_tmp36_size = 0;
	_tmp36_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp37);
	for (; dbus_message_iter_get_arg_type (&_tmp37); _tmp36_length1++) {
		dbus_uint32_t _tmp38;
		if (_tmp36_size == _tmp36_length) {
			_tmp36_size = (_tmp36_size > 0) ? (2 * _tmp36_size) : 4;
			_tmp36 = g_renew (guint, _tmp36, _tmp36_size);
		}
		dbus_message_iter_get_basic (&_tmp37, &_tmp38);
		dbus_message_iter_next (&_tmp37);
		_tmp36[_tmp36_length++] = _tmp38;
	}
	_result_length1 = _tmp36_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp36;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetStartTimestamp (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp39;
	gint64 _result;
	dbus_int64_t _tmp40;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetStartTimestamp");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp39 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp39);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp40);
	dbus_message_iter_next (&_iter);
	_result = _tmp40;
	dbus_message_unref (_reply);
	return _result;
}


static gint64 dvb_id_bus_recordings_store_dbus_proxy_GetLength (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp41;
	gint64 _result;
	dbus_int64_t _tmp42;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "GetLength");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp41 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp41);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp42);
	dbus_message_iter_next (&_iter);
	_result = _tmp42;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_recordings_store_dbus_proxy_Delete (DVBIDBusRecordingsStore* self, guint32 rec_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp43;
	gboolean _result;
	dbus_bool_t _tmp44;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.RecordingsStore", "Delete");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp43 = rec_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp43);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp44);
	dbus_message_iter_next (&_iter);
	_result = _tmp44;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_recordings_store_dbus_proxy_interface_init (DVBIDBusRecordingsStoreIface* iface) {
	iface->GetRecordings = dvb_id_bus_recordings_store_dbus_proxy_GetRecordings;
	iface->GetLocation = dvb_id_bus_recordings_store_dbus_proxy_GetLocation;
	iface->GetName = dvb_id_bus_recordings_store_dbus_proxy_GetName;
	iface->GetDescription = dvb_id_bus_recordings_store_dbus_proxy_GetDescription;
	iface->GetStartTime = dvb_id_bus_recordings_store_dbus_proxy_GetStartTime;
	iface->GetStartTimestamp = dvb_id_bus_recordings_store_dbus_proxy_GetStartTimestamp;
	iface->GetLength = dvb_id_bus_recordings_store_dbus_proxy_GetLength;
	iface->Delete = dvb_id_bus_recordings_store_dbus_proxy_Delete;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	vtable->register_object (connection, path, object);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



