/* contacts-revealer.c generated by valac 0.17.2.8-923a22, the Vala compiler
 * generated from contacts-revealer.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define CONTACTS_TYPE_REVEALER (contacts_revealer_get_type ())
#define CONTACTS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_REVEALER, ContactsRevealer))
#define CONTACTS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_REVEALER, ContactsRevealerClass))
#define CONTACTS_IS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_REVEALER))
#define CONTACTS_IS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_REVEALER))
#define CONTACTS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_REVEALER, ContactsRevealerClass))

typedef struct _ContactsRevealer ContactsRevealer;
typedef struct _ContactsRevealerClass ContactsRevealerClass;
typedef struct _ContactsRevealerPrivate ContactsRevealerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ContactsRevealer {
	GtkViewport parent_instance;
	ContactsRevealerPrivate * priv;
	GdkWindow* bin_window;
	GdkWindow* view_window;
	GtkAdjustment* vadjustment;
	gdouble amount_visible;
	gdouble target_amount;
};

struct _ContactsRevealerClass {
	GtkViewportClass parent_class;
};

struct _ContactsRevealerPrivate {
	guint timeout;
};


static gpointer contacts_revealer_parent_class = NULL;

GType contacts_revealer_get_type (void) G_GNUC_CONST;
#define CONTACTS_REVEALER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_REVEALER, ContactsRevealerPrivate))
enum  {
	CONTACTS_REVEALER_DUMMY_PROPERTY
};
#define CONTACTS_REVEALER_animation_time 200
#define CONTACTS_REVEALER_animation_n_steps 8
ContactsRevealer* contacts_revealer_new (void);
ContactsRevealer* contacts_revealer_construct (GType object_type);
static void contacts_revealer_ensure_timer (ContactsRevealer* self);
static gboolean contacts_revealer_animate_cb (ContactsRevealer* self);
static gboolean _contacts_revealer_animate_cb_gsource_func (gpointer self);
static void contacts_revealer_real_show (GtkWidget* base);
void contacts_revealer_reveal (ContactsRevealer* self);
static void contacts_revealer_real_hide (GtkWidget* base);
void contacts_revealer_unreveal (ContactsRevealer* self);
static void contacts_revealer_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height);
static void contacts_revealer_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height);
static void contacts_revealer_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void contacts_revealer_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ContactsRevealer* contacts_revealer_construct (GType object_type) {
	ContactsRevealer * self = NULL;
	gdouble _tmp0_;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_;
	self = (ContactsRevealer*) g_object_new (object_type, NULL);
	gtk_viewport_set_shadow_type ((GtkViewport*) self, GTK_SHADOW_NONE);
	self->amount_visible = 0.0;
	_tmp0_ = self->amount_visible;
	self->target_amount = _tmp0_;
	_tmp1_ = gtk_viewport_get_vadjustment ((GtkViewport*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->vadjustment);
	self->vadjustment = _tmp2_;
	return self;
}


ContactsRevealer* contacts_revealer_new (void) {
	return contacts_revealer_construct (CONTACTS_TYPE_REVEALER);
}


static gboolean _contacts_revealer_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_revealer_animate_cb (self);
	return result;
}


static void contacts_revealer_ensure_timer (ContactsRevealer* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timeout;
	if (_tmp0_ == ((guint) 0)) {
		gdouble _tmp1_;
		gdouble _tmp2_;
		guint _tmp3_ = 0U;
		_tmp1_ = self->amount_visible;
		_tmp2_ = self->target_amount;
		if (_tmp1_ == _tmp2_) {
			return;
		}
		_tmp3_ = gdk_threads_add_timeout ((guint) (CONTACTS_REVEALER_animation_time / CONTACTS_REVEALER_animation_n_steps), _contacts_revealer_animate_cb_gsource_func, self);
		self->priv->timeout = _tmp3_;
	}
}


static void contacts_revealer_real_show (GtkWidget* base) {
	ContactsRevealer * self;
	gdouble _tmp0_;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_VIEWPORT, GtkViewport));
	_tmp0_ = self->target_amount;
	if (_tmp0_ != 1.0) {
		contacts_revealer_reveal (self);
	}
}


static void contacts_revealer_real_hide (GtkWidget* base) {
	ContactsRevealer * self;
	guint _tmp0_;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_VIEWPORT, GtkViewport));
	self->target_amount = (gdouble) 0;
	self->amount_visible = (gdouble) 0;
	_tmp0_ = self->priv->timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->timeout;
		g_source_remove (_tmp1_);
		self->priv->timeout = (guint) 0;
	}
}


void contacts_revealer_reveal (ContactsRevealer* self) {
	g_return_if_fail (self != NULL);
	self->target_amount = 1.0;
	gtk_widget_show ((GtkWidget*) self);
	contacts_revealer_ensure_timer (self);
}


void contacts_revealer_unreveal (ContactsRevealer* self) {
	g_return_if_fail (self != NULL);
	self->target_amount = 0.0;
	contacts_revealer_ensure_timer (self);
}


static gboolean contacts_revealer_animate_cb (ContactsRevealer* self) {
	gboolean result = FALSE;
	gdouble delta;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	delta = 1.0 / CONTACTS_REVEALER_animation_n_steps;
	_tmp0_ = self->amount_visible;
	_tmp1_ = self->target_amount;
	if (_tmp0_ < _tmp1_) {
		gdouble _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_ = 0.0;
		_tmp2_ = self->target_amount;
		_tmp3_ = self->amount_visible;
		_tmp4_ = delta;
		_tmp5_ = MIN (_tmp2_, _tmp3_ + _tmp4_);
		self->amount_visible = _tmp5_;
	} else {
		gdouble _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_ = 0.0;
		_tmp6_ = self->target_amount;
		_tmp7_ = self->amount_visible;
		_tmp8_ = delta;
		_tmp9_ = MAX (_tmp6_, _tmp7_ - _tmp8_);
		self->amount_visible = _tmp9_;
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	_tmp10_ = self->amount_visible;
	_tmp11_ = self->target_amount;
	if (_tmp10_ == _tmp11_) {
		gdouble _tmp12_;
		self->priv->timeout = (guint) 0;
		_tmp12_ = self->amount_visible;
		if (_tmp12_ == ((gdouble) 0)) {
			gtk_widget_hide ((GtkWidget*) self);
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void contacts_revealer_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height) {
	ContactsRevealer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	self = (ContactsRevealer*) base;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_VIEWPORT, GtkViewport), &_tmp0_, &_tmp1_);
	_vala_minimum_height = _tmp0_;
	_vala_natural_height = _tmp1_;
	_tmp2_ = _vala_minimum_height;
	_tmp3_ = self->amount_visible;
	_vala_minimum_height = (gint) (_tmp2_ * _tmp3_);
	_tmp4_ = _vala_natural_height;
	_tmp5_ = self->amount_visible;
	_vala_natural_height = (gint) (_tmp4_ * _tmp5_);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void contacts_revealer_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height) {
	ContactsRevealer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_;
	gdouble _tmp4_;
	gint _tmp5_;
	gdouble _tmp6_;
	self = (ContactsRevealer*) base;
	_tmp0_ = width;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->get_preferred_height_for_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_VIEWPORT, GtkViewport), _tmp0_, &_tmp1_, &_tmp2_);
	_vala_minimum_height = _tmp1_;
	_vala_natural_height = _tmp2_;
	_tmp3_ = _vala_minimum_height;
	_tmp4_ = self->amount_visible;
	_vala_minimum_height = (gint) (_tmp3_ * _tmp4_);
	_tmp5_ = _vala_natural_height;
	_tmp6_ = self->amount_visible;
	_vala_natural_height = (gint) (_tmp5_ * _tmp6_);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void contacts_revealer_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	ContactsRevealer * self;
	GtkAllocation _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble upper;
	GtkAdjustment* _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	self = (ContactsRevealer*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (contacts_revealer_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_VIEWPORT, GtkViewport), &_tmp0_);
	_tmp1_ = self->vadjustment;
	_tmp2_ = gtk_adjustment_get_upper (_tmp1_);
	upper = _tmp2_;
	_tmp3_ = self->vadjustment;
	_tmp4_ = *allocation;
	_tmp5_ = _tmp4_.height;
	gtk_adjustment_set_value (_tmp3_, upper - _tmp5_);
}


static void contacts_revealer_class_init (ContactsRevealerClass * klass) {
	contacts_revealer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsRevealerPrivate));
	GTK_WIDGET_CLASS (klass)->show = contacts_revealer_real_show;
	GTK_WIDGET_CLASS (klass)->hide = contacts_revealer_real_hide;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = contacts_revealer_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->get_preferred_height_for_width = contacts_revealer_real_get_preferred_height_for_width;
	GTK_WIDGET_CLASS (klass)->size_allocate = contacts_revealer_real_size_allocate;
	G_OBJECT_CLASS (klass)->finalize = contacts_revealer_finalize;
}


static void contacts_revealer_instance_init (ContactsRevealer * self) {
	self->priv = CONTACTS_REVEALER_GET_PRIVATE (self);
}


static void contacts_revealer_finalize (GObject* obj) {
	ContactsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_REVEALER, ContactsRevealer);
	_g_object_unref0 (self->bin_window);
	_g_object_unref0 (self->view_window);
	_g_object_unref0 (self->vadjustment);
	G_OBJECT_CLASS (contacts_revealer_parent_class)->finalize (obj);
}


GType contacts_revealer_get_type (void) {
	static volatile gsize contacts_revealer_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_revealer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsRevealerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_revealer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsRevealer), 0, (GInstanceInitFunc) contacts_revealer_instance_init, NULL };
		GType contacts_revealer_type_id;
		contacts_revealer_type_id = g_type_register_static (GTK_TYPE_VIEWPORT, "ContactsRevealer", &g_define_type_info, 0);
		g_once_init_leave (&contacts_revealer_type_id__volatile, contacts_revealer_type_id);
	}
	return contacts_revealer_type_id__volatile;
}



