/* contacts-utils.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <folks/folks-telepathy.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_FREEDESKTOP_APPLICATION (contacts_freedesktop_application_get_type ())
#define CONTACTS_FREEDESKTOP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_FREEDESKTOP_APPLICATION, ContactsFreedesktopApplication))
#define CONTACTS_IS_FREEDESKTOP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_FREEDESKTOP_APPLICATION))
#define CONTACTS_FREEDESKTOP_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CONTACTS_TYPE_FREEDESKTOP_APPLICATION, ContactsFreedesktopApplicationIface))

typedef struct _ContactsFreedesktopApplication ContactsFreedesktopApplication;
typedef struct _ContactsFreedesktopApplicationIface ContactsFreedesktopApplicationIface;

#define CONTACTS_TYPE_FREEDESKTOP_APPLICATION_PROXY (contacts_freedesktop_application_proxy_get_type ())
typedef GDBusProxy ContactsFreedesktopApplicationProxy;
typedef GDBusProxyClass ContactsFreedesktopApplicationProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_CENTER (center_get_type ())
#define CENTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CENTER, Center))
#define CENTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CENTER, CenterClass))
#define IS_CENTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CENTER))
#define IS_CENTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CENTER))
#define CENTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CENTER, CenterClass))

typedef struct _Center Center;
typedef struct _CenterClass CenterClass;
typedef struct _CenterPrivate CenterPrivate;

#define CONTACTS_TYPE_UTILS (contacts_utils_get_type ())
#define CONTACTS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_UTILS, ContactsUtils))
#define CONTACTS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_UTILS, ContactsUtilsClass))
#define CONTACTS_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_UTILS))
#define CONTACTS_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_UTILS))
#define CONTACTS_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_UTILS, ContactsUtilsClass))

typedef struct _ContactsUtils ContactsUtils;
typedef struct _ContactsUtilsClass ContactsUtilsClass;
typedef struct _ContactsUtilsPrivate ContactsUtilsPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block37Data Block37Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _ContactsFreedesktopApplicationIface {
	GTypeInterface parent_iface;
	void (*ActivateAction) (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error);
};

struct _Center {
	GtkBin parent_instance;
	CenterPrivate * priv;
};

struct _CenterClass {
	GtkBinClass parent_class;
};

struct _CenterPrivate {
	gint _max_width;
	gdouble _xalign;
};

struct _ContactsUtils {
	GObject parent_instance;
	ContactsUtilsPrivate * priv;
};

struct _ContactsUtilsClass {
	GObjectClass parent_class;
};

struct _Block37Data {
	int _ref_count_;
	gulong id;
	GtkWidget* widget;
};


static gpointer center_parent_class = NULL;
static gpointer contacts_utils_parent_class = NULL;

gboolean contacts_is_set (const gchar* str);
GtkBuilder* contacts_load_ui (const gchar* ui);
GtkCssProvider* contacts_load_css (const gchar* css);
void contacts_add_separator (GtkListBoxRow* row, GtkListBoxRow* before_row);
GType contacts_freedesktop_application_proxy_get_type (void) G_GNUC_CONST;
guint contacts_freedesktop_application_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType contacts_freedesktop_application_get_type (void) G_GNUC_CONST;
void contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error);
static void contacts_freedesktop_application_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void contacts_freedesktop_application_proxy_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error);
static void contacts_freedesktop_application_proxy_contacts_freedesktop_application_interface_init (ContactsFreedesktopApplicationIface* iface);
static void _dbus_contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void contacts_freedesktop_application_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* contacts_freedesktop_application_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean contacts_freedesktop_application_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _contacts_freedesktop_application_unregister_object (gpointer user_data);
void contacts_activate_action (const gchar* app_id, const gchar* action, GVariant* parameter, guint32 timestamp);
static void _vala_array_add10 (GVariant*** array, int* length, int* size, GVariant* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GType center_get_type (void) G_GNUC_CONST;
#define CENTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CENTER, CenterPrivate))
enum  {
	CENTER_DUMMY_PROPERTY,
	CENTER_MAX_WIDTH,
	CENTER_XALIGN
};
Center* center_new (void);
Center* center_construct (GType object_type);
void center_set_xalign (Center* self, gdouble value);
static void center_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height);
static void center_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void center_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
gint center_get_max_width (Center* self);
gdouble center_get_xalign (Center* self);
void center_set_max_width (Center* self, gint value);
static void center_finalize (GObject* obj);
static void _vala_center_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_center_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType contacts_utils_get_type (void) G_GNUC_CONST;
enum  {
	CONTACTS_UTILS_DUMMY_PROPERTY
};
void contacts_utils_compose_mail (const gchar* email);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts);
void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account);
gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection);
GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label);
void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting);
void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2);
void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
static gunichar contacts_utils_strip_char (gunichar ch);
gboolean contacts_utils_string_is_empty (const gchar* str);
gchar* contacts_utils_canonicalize_for_search (const gchar* str);
void contacts_utils_grab_widget_later (GtkWidget* widget);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static void __lambda5_ (Block37Data* _data37_);
static void ___lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry);
static void contacts_utils_spawn_app (GSettings* app_settings, GError** error);
void contacts_utils_show_calendar (GDateTime* day);
gchar** contacts_utils_get_stock_avatars (int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
ContactsUtils* contacts_utils_new (void);
ContactsUtils* contacts_utils_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _contacts_freedesktop_application_dbus_arg_info_ActivateAction_action = {-1, "action", "s"};
static const GDBusArgInfo _contacts_freedesktop_application_dbus_arg_info_ActivateAction_parameter = {-1, "parameter", "av"};
static const GDBusArgInfo _contacts_freedesktop_application_dbus_arg_info_ActivateAction_data = {-1, "data", "a{sv}"};
static const GDBusArgInfo * const _contacts_freedesktop_application_dbus_arg_info_ActivateAction_in[] = {&_contacts_freedesktop_application_dbus_arg_info_ActivateAction_action, &_contacts_freedesktop_application_dbus_arg_info_ActivateAction_parameter, &_contacts_freedesktop_application_dbus_arg_info_ActivateAction_data, NULL};
static const GDBusArgInfo * const _contacts_freedesktop_application_dbus_arg_info_ActivateAction_out[] = {NULL};
static const GDBusMethodInfo _contacts_freedesktop_application_dbus_method_info_ActivateAction = {-1, "ActivateAction", (GDBusArgInfo **) (&_contacts_freedesktop_application_dbus_arg_info_ActivateAction_in), (GDBusArgInfo **) (&_contacts_freedesktop_application_dbus_arg_info_ActivateAction_out)};
static const GDBusMethodInfo * const _contacts_freedesktop_application_dbus_method_info[] = {&_contacts_freedesktop_application_dbus_method_info_ActivateAction, NULL};
static const GDBusSignalInfo * const _contacts_freedesktop_application_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _contacts_freedesktop_application_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _contacts_freedesktop_application_dbus_interface_info = {-1, "org.freedesktop.Application", (GDBusMethodInfo **) (&_contacts_freedesktop_application_dbus_method_info), (GDBusSignalInfo **) (&_contacts_freedesktop_application_dbus_signal_info), (GDBusPropertyInfo **) (&_contacts_freedesktop_application_dbus_property_info)};
static const GDBusInterfaceVTable _contacts_freedesktop_application_dbus_interface_vtable = {contacts_freedesktop_application_dbus_interface_method_call, contacts_freedesktop_application_dbus_interface_get_property, contacts_freedesktop_application_dbus_interface_set_property};

gboolean contacts_is_set (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = str;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp1_ != NULL) {
#line 231 "contacts-utils.c"
		const gchar* _tmp2_ = NULL;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = str;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
#line 237 "contacts-utils.c"
	} else {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = FALSE;
#line 241 "contacts-utils.c"
	}
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = _tmp0_;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 247 "contacts-utils.c"
}


GtkBuilder* contacts_load_ui (const gchar* ui) {
	GtkBuilder* result = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (ui != NULL, NULL);
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = gtk_builder_new ();
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	builder = _tmp0_;
#line 262 "contacts-utils.c"
	{
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp1_ = ui;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = g_strconcat ("/org/gnome/contacts/ui/", _tmp1_, NULL, NULL);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = _tmp2_;
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		gtk_builder_add_from_resource (builder, _tmp3_, &_inner_error_);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp3_);
#line 35 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "contacts-utils.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		e = _inner_error_;
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_inner_error_ = NULL;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = e->message;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_error ("contacts-utils.vala:37: loading ui file: %s", _tmp4_);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_error_free0 (e);
#line 298 "contacts-utils.c"
	}
	__finally28:
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (builder);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_clear_error (&_inner_error_);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		return NULL;
#line 311 "contacts-utils.c"
	}
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = builder;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 317 "contacts-utils.c"
}


GtkCssProvider* contacts_load_css (const gchar* css) {
	GtkCssProvider* result = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (css != NULL, NULL);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	provider = _tmp0_;
#line 332 "contacts-utils.c"
	{
		GFile* file = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp1_ = css;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = g_strconcat ("resource:///org/gnome/contacts/ui/", _tmp1_, NULL);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = _tmp2_;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = g_file_new_for_uri (_tmp3_);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = _tmp4_;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp3_);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		file = _tmp5_;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		gtk_css_provider_load_from_file (provider, file, &_inner_error_);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (file);
#line 360 "contacts-utils.c"
			goto __catch29_g_error;
		}
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (file);
#line 365 "contacts-utils.c"
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		e = _inner_error_;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_inner_error_ = NULL;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = e;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = _tmp6_->message;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_warning ("contacts-utils.vala:48: loading css: %s", _tmp7_);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_error_free0 (e);
#line 385 "contacts-utils.c"
	}
	__finally29:
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (provider);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_clear_error (&_inner_error_);
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		return NULL;
#line 398 "contacts-utils.c"
	}
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = provider;
#line 50 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 404 "contacts-utils.c"
}


void contacts_add_separator (GtkListBoxRow* row, GtkListBoxRow* before_row) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkSeparator* _tmp1_ = NULL;
	GtkSeparator* _tmp2_ = NULL;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (row != NULL);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = row;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_object_ref_sink (_tmp1_);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_list_box_row_set_header (_tmp0_, (GtkWidget*) _tmp2_);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (_tmp2_);
#line 426 "contacts-utils.c"
}


void contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error) {
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	CONTACTS_FREEDESKTOP_APPLICATION_GET_INTERFACE (self)->ActivateAction (self, action, parameter, parameter_length1, data, error);
#line 435 "contacts-utils.c"
}


static void contacts_freedesktop_application_base_init (ContactsFreedesktopApplicationIface * iface) {
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	static gboolean initialized = FALSE;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (!initialized) {
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		initialized = TRUE;
#line 446 "contacts-utils.c"
	}
}


GType contacts_freedesktop_application_get_type (void) {
	static volatile gsize contacts_freedesktop_application_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_freedesktop_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsFreedesktopApplicationIface), (GBaseInitFunc) contacts_freedesktop_application_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType contacts_freedesktop_application_type_id;
		contacts_freedesktop_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "ContactsFreedesktopApplication", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (contacts_freedesktop_application_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) contacts_freedesktop_application_proxy_get_type);
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Application");
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_contacts_freedesktop_application_dbus_interface_info));
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) contacts_freedesktop_application_register_object);
		g_once_init_leave (&contacts_freedesktop_application_type_id__volatile, contacts_freedesktop_application_type_id);
	}
	return contacts_freedesktop_application_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ContactsFreedesktopApplicationProxy, contacts_freedesktop_application_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (CONTACTS_TYPE_FREEDESKTOP_APPLICATION, contacts_freedesktop_application_proxy_contacts_freedesktop_application_interface_init) )
static void contacts_freedesktop_application_proxy_class_init (ContactsFreedesktopApplicationProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = contacts_freedesktop_application_proxy_g_signal;
}


static void contacts_freedesktop_application_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void contacts_freedesktop_application_proxy_init (ContactsFreedesktopApplicationProxy* self) {
}


static void contacts_freedesktop_application_proxy_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariant** _tmp0_;
	GVariantBuilder _tmp1_;
	int _tmp2_;
	GVariantBuilder _tmp3_;
	GHashTableIter _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Application", "ActivateAction");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	_tmp0_ = parameter;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("av"));
	for (_tmp2_ = 0; _tmp2_ < parameter_length1; _tmp2_++) {
		g_variant_builder_add_value (&_tmp1_, g_variant_new_variant (*_tmp0_));
		_tmp0_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp1_));
	g_hash_table_iter_init (&_tmp4_, data);
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp4_, &_tmp5_, &_tmp6_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp5_;
		_value = (GVariant*) _tmp6_;
		g_variant_builder_add (&_tmp3_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp3_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void contacts_freedesktop_application_proxy_contacts_freedesktop_application_interface_init (ContactsFreedesktopApplicationIface* iface) {
	iface->ActivateAction = contacts_freedesktop_application_proxy_ActivateAction;
}


static void _dbus_contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* action = NULL;
	GVariant* _tmp7_;
	GVariant** parameter = NULL;
	int parameter_length1 = 0;
	GVariant* _tmp8_;
	GVariant** _tmp9_;
	int _tmp9__length;
	int _tmp9__size;
	int _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GHashTable* data = NULL;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (GVariant*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (GVariant*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_get_variant (_tmp11_);
		g_variant_unref (_tmp11_);
	}
	parameter_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	parameter = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp13_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp14_, _tmp12_);
	while (g_variant_iter_loop (&_tmp14_, "{?*}", &_tmp15_, &_tmp16_)) {
		g_hash_table_insert (_tmp13_, g_variant_dup_string (_tmp15_, NULL), g_variant_get_variant (_tmp16_));
	}
	data = _tmp13_;
	g_variant_unref (_tmp12_);
	contacts_freedesktop_application_ActivateAction (self, action, parameter, parameter_length1, data, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (action);
	parameter = (_vala_array_free (parameter, parameter_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_hash_table_unref0 (data);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void contacts_freedesktop_application_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ActivateAction") == 0) {
		_dbus_contacts_freedesktop_application_ActivateAction (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* contacts_freedesktop_application_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean contacts_freedesktop_application_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint contacts_freedesktop_application_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_contacts_freedesktop_application_dbus_interface_info), &_contacts_freedesktop_application_dbus_interface_vtable, data, _contacts_freedesktop_application_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _contacts_freedesktop_application_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 671 "contacts-utils.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 702 "contacts-utils.c"
				goto __catch31_g_regex_error;
			}
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 711 "contacts-utils.c"
		}
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 727 "contacts-utils.c"
				goto __catch31_g_regex_error;
			}
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 738 "contacts-utils.c"
		}
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 752 "contacts-utils.c"
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 766 "contacts-utils.c"
	}
	__finally31:
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 777 "contacts-utils.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 785 "contacts-utils.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return self ? g_variant_ref (self) : NULL;
#line 792 "contacts-utils.c"
}


static void _vala_array_add10 (GVariant*** array, int* length, int* size, GVariant* value) {
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if ((*length) == (*size)) {
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*array = g_renew (GVariant*, *array, (*size) + 1);
#line 803 "contacts-utils.c"
	}
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(*array)[(*length)++] = value;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(*array)[*length] = NULL;
#line 809 "contacts-utils.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 816 "contacts-utils.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_list_free (self);
#line 825 "contacts-utils.c"
}


static void _g_free0_ (gpointer var) {
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	var = (g_free (var), NULL);
#line 832 "contacts-utils.c"
}


static void _g_variant_unref0_ (gpointer var) {
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
#line 839 "contacts-utils.c"
}


void contacts_activate_action (const gchar* app_id, const gchar* action, GVariant* parameter, guint32 timestamp) {
	ContactsFreedesktopApplication* con = NULL;
	GError * _inner_error_ = NULL;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (app_id != NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (action != NULL);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	con = NULL;
#line 852 "contacts-utils.c"
	{
		gchar* object_path = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp5_ = NULL;
		GdkDisplay* _tmp6_ = NULL;
		GDesktopAppInfo* info = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GDesktopAppInfo* _tmp10_ = NULL;
		GDesktopAppInfo* _tmp11_ = NULL;
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp12_ = NULL;
		GdkAppLaunchContext* _tmp13_ = NULL;
		ContactsFreedesktopApplication* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		ContactsFreedesktopApplication* _tmp17_ = NULL;
		ContactsFreedesktopApplication* _tmp18_ = NULL;
		GdkAppLaunchContext* _tmp19_ = NULL;
		guint32 _tmp20_ = 0U;
		GVariant** param_array = NULL;
		GVariant** _tmp21_ = NULL;
		gint param_array_length1 = 0;
		gint _param_array_size_ = 0;
		GVariant* _tmp22_ = NULL;
		gchar* startup_id = NULL;
		GdkAppLaunchContext* _tmp26_ = NULL;
		GDesktopAppInfo* _tmp27_ = NULL;
		GList* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		GHashTable* data = NULL;
		GHashFunc _tmp31_ = NULL;
		GEqualFunc _tmp32_ = NULL;
		GHashTable* _tmp33_ = NULL;
		GHashTable* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		GVariant* _tmp37_ = NULL;
		ContactsFreedesktopApplication* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		GVariant** _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		GHashTable* _tmp41_ = NULL;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = app_id;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp1_ = string_replace (_tmp0_, ".", "/");
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = _tmp1_;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = g_strconcat ("/", _tmp2_, NULL);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = _tmp3_;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp2_);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		object_path = _tmp4_;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = gdk_display_get_default ();
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		display = _tmp6_;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = app_id;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp8_ = g_strconcat (_tmp7_, ".desktop", NULL);
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_ = _tmp8_;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp10_ = g_desktop_app_info_new (_tmp9_);
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp11_ = _tmp10_;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp9_);
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		info = _tmp11_;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp12_ = display;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp13_ = gdk_display_get_app_launch_context (_tmp12_);
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		context = _tmp13_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp15_ = app_id;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp16_ = object_path;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp17_ = g_initable_new (CONTACTS_TYPE_FREEDESKTOP_APPLICATION_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp15_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp16_, "g-interface-name", "org.freedesktop.Application", "g-interface-info", g_type_get_qdata (CONTACTS_TYPE_FREEDESKTOP_APPLICATION, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp14_ = (ContactsFreedesktopApplication*) _tmp17_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (context);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (info);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (display);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (object_path);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 963 "contacts-utils.c"
				goto __catch30_g_io_error;
			}
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (context);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (info);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (display);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (object_path);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (con);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_clear_error (&_inner_error_);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			return;
#line 982 "contacts-utils.c"
		}
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp18_ = _tmp14_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp14_ = NULL;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (con);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		con = _tmp18_;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp19_ = context;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp20_ = timestamp;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		gdk_app_launch_context_set_timestamp (_tmp19_, _tmp20_);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp21_ = g_new0 (GVariant*, 0 + 1);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		param_array = _tmp21_;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		param_array_length1 = 0;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_param_array_size_ = param_array_length1;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp22_ = parameter;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (_tmp22_ != NULL) {
#line 1010 "contacts-utils.c"
			GVariant** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			GVariant* _tmp24_ = NULL;
			GVariant* _tmp25_ = NULL;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp23_ = param_array;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp23__length1 = param_array_length1;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp24_ = parameter;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp25_ = _g_variant_ref0 (_tmp24_);
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_vala_array_add10 (&param_array, &param_array_length1, &_param_array_size_, _tmp25_);
#line 1025 "contacts-utils.c"
		}
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp26_ = context;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp27_ = info;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp28_ = NULL;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp29_ = g_app_launch_context_get_startup_notify_id ((GAppLaunchContext*) _tmp26_, (GAppInfo*) _tmp27_, _tmp28_);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp30_ = _tmp29_;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		__g_list_free__g_object_unref0_0 (_tmp28_);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		startup_id = _tmp30_;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp31_ = g_str_hash;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp32_ = g_str_equal;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp33_ = g_hash_table_new_full (_tmp31_, _tmp32_, _g_free0_, _g_variant_unref0_);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		data = _tmp33_;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp34_ = data;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp35_ = g_strdup ("desktop-startup-id");
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp36_ = startup_id;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp37_ = g_variant_new_string (_tmp36_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_variant_ref_sink (_tmp37_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_hash_table_insert (_tmp34_, _tmp35_, _tmp37_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp38_ = con;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp39_ = action;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp40_ = param_array;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp40__length1 = param_array_length1;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp41_ = data;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		contacts_freedesktop_application_ActivateAction (_tmp38_, _tmp39_, _tmp40_, _tmp40__length1, _tmp41_, &_inner_error_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_hash_table_unref0 (data);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (startup_id);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			param_array = (_vala_array_free (param_array, param_array_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (_tmp14_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (context);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (info);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (display);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (object_path);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1093 "contacts-utils.c"
				goto __catch30_g_io_error;
			}
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_hash_table_unref0 (data);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (startup_id);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			param_array = (_vala_array_free (param_array, param_array_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (_tmp14_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (context);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (info);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (display);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (object_path);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (con);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_clear_error (&_inner_error_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			return;
#line 1120 "contacts-utils.c"
		}
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_hash_table_unref0 (data);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (startup_id);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		param_array = (_vala_array_free (param_array, param_array_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (_tmp14_);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (context);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (info);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (display);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (object_path);
#line 1138 "contacts-utils.c"
	}
	goto __finally30;
	__catch30_g_io_error:
	{
		GError* e = NULL;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		e = _inner_error_;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_inner_error_ = NULL;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp42_ = action;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp43_ = g_strconcat ("Failed to activate action", _tmp42_, NULL);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp44_ = _tmp43_;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_debug ("contacts-utils.vala:92: %s", _tmp44_);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp44_);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_error_free0 (e);
#line 1163 "contacts-utils.c"
	}
	__finally30:
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (con);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_clear_error (&_inner_error_);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		return;
#line 1176 "contacts-utils.c"
	}
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (con);
#line 1180 "contacts-utils.c"
}


Center* center_construct (GType object_type) {
	Center * self = NULL;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self = (Center*) g_object_new (object_type, NULL);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	center_set_xalign (self, 0.5);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return self;
#line 1192 "contacts-utils.c"
}


Center* center_new (void) {
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return center_construct (TYPE_CENTER);
#line 1199 "contacts-utils.c"
}


static void center_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height) {
	Center * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self = (Center*) base;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	child = _tmp1_;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = child;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp2_ != NULL) {
#line 1223 "contacts-utils.c"
		gint min = 0;
		gint nat = 0;
		GtkWidget* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = child;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		gtk_widget_get_preferred_height (_tmp3_, &_tmp4_, &_tmp5_);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		min = _tmp4_;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		nat = _tmp5_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = min;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_minimum_height = _tmp6_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = nat;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_natural_height = _tmp7_;
#line 1247 "contacts-utils.c"
	} else {
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_minimum_height = -1;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_natural_height = -1;
#line 1253 "contacts-utils.c"
	}
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (child);
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (minimum_height) {
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*minimum_height = _vala_minimum_height;
#line 1261 "contacts-utils.c"
	}
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (natural_height) {
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*natural_height = _vala_natural_height;
#line 1267 "contacts-utils.c"
	}
}


static void center_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	Center * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self = (Center*) base;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	child = _tmp1_;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = child;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp2_ != NULL) {
#line 1292 "contacts-utils.c"
		gint min = 0;
		gint nat = 0;
		GtkWidget* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = child;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		gtk_widget_get_preferred_width (_tmp3_, &_tmp4_, &_tmp5_);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		min = _tmp4_;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		nat = _tmp5_;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = min;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_minimum_width = _tmp6_;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = nat;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_natural_width = _tmp7_;
#line 1316 "contacts-utils.c"
	} else {
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_minimum_width = -1;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_vala_natural_width = -1;
#line 1322 "contacts-utils.c"
	}
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (child);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (minimum_width) {
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*minimum_width = _vala_minimum_width;
#line 1330 "contacts-utils.c"
	}
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (natural_width) {
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*natural_width = _vala_natural_width;
#line 1336 "contacts-utils.c"
	}
}


static void center_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	Center * self;
	GtkAllocation new_alloc = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkWidget* child = NULL;
	GtkWidget* _tmp12_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkAllocation _tmp14_ = {0};
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self = (Center*) base;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (allocation != NULL);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = *allocation;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp0_);
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = *allocation;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	new_alloc = _tmp1_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = *allocation;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = _tmp2_.width;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = self->priv->_max_width;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp3_ > _tmp4_) {
#line 1373 "contacts-utils.c"
		gint _tmp5_ = 0;
		GtkAllocation _tmp6_ = {0};
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gdouble _tmp9_ = 0.0;
		GtkAllocation _tmp10_ = {0};
		gint _tmp11_ = 0;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = self->priv->_max_width;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		new_alloc.width = _tmp5_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = *allocation;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = _tmp6_.width;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp8_ = self->priv->_max_width;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_ = self->priv->_xalign;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp10_ = *allocation;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp11_ = _tmp10_.x;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		new_alloc.x = ((gint) ((_tmp7_ - _tmp8_) * _tmp9_)) + _tmp11_;
#line 1399 "contacts-utils.c"
	}
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp12_ = gtk_bin_get_child ((GtkBin*) self);
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	child = _tmp13_;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp14_ = new_alloc;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_widget_size_allocate (child, &_tmp14_);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (child);
#line 1413 "contacts-utils.c"
}


gint center_get_max_width (Center* self) {
	gint result;
	gint _tmp0_ = 0;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = self->priv->_max_width;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = _tmp0_;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 1428 "contacts-utils.c"
}


void center_set_max_width (Center* self, gint value) {
	gint _tmp0_ = 0;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = value;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self->priv->_max_width = _tmp0_;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_object_notify ((GObject *) self, "max-width");
#line 1442 "contacts-utils.c"
}


gdouble center_get_xalign (Center* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = self->priv->_xalign;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = _tmp0_;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 1457 "contacts-utils.c"
}


void center_set_xalign (Center* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = value;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self->priv->_xalign = _tmp0_;
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_object_notify ((GObject *) self, "xalign");
#line 1471 "contacts-utils.c"
}


static void center_class_init (CenterClass * klass) {
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	center_parent_class = g_type_class_peek_parent (klass);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_type_class_add_private (klass, sizeof (CenterPrivate));
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	((GtkWidgetClass *) klass)->get_preferred_height = center_real_get_preferred_height;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	((GtkWidgetClass *) klass)->get_preferred_width = center_real_get_preferred_width;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	((GtkWidgetClass *) klass)->size_allocate = center_real_size_allocate;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_center_get_property;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_center_set_property;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	G_OBJECT_CLASS (klass)->finalize = center_finalize;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CENTER_MAX_WIDTH, g_param_spec_int ("max-width", "max-width", "max-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CENTER_XALIGN, g_param_spec_double ("xalign", "xalign", "xalign", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1496 "contacts-utils.c"
}


static void center_instance_init (Center * self) {
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self->priv = CENTER_GET_PRIVATE (self);
#line 1503 "contacts-utils.c"
}


static void center_finalize (GObject* obj) {
	Center * self;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CENTER, Center);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	G_OBJECT_CLASS (center_parent_class)->finalize (obj);
#line 1513 "contacts-utils.c"
}


GType center_get_type (void) {
	static volatile gsize center_type_id__volatile = 0;
	if (g_once_init_enter (&center_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CenterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) center_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Center), 0, (GInstanceInitFunc) center_instance_init, NULL };
		GType center_type_id;
		center_type_id = g_type_register_static (gtk_bin_get_type (), "Center", &g_define_type_info, 0);
		g_once_init_leave (&center_type_id__volatile, center_type_id);
	}
	return center_type_id__volatile;
}


static void _vala_center_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Center * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CENTER, Center);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	switch (property_id) {
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case CENTER_MAX_WIDTH:
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_value_set_int (value, center_get_max_width (self));
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		break;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case CENTER_XALIGN:
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_value_set_double (value, center_get_xalign (self));
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		break;
#line 1546 "contacts-utils.c"
		default:
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		break;
#line 1552 "contacts-utils.c"
	}
}


static void _vala_center_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Center * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CENTER, Center);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	switch (property_id) {
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case CENTER_MAX_WIDTH:
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		center_set_max_width (self, g_value_get_int (value));
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		break;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case CENTER_XALIGN:
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		center_set_xalign (self, g_value_get_double (value));
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		break;
#line 1574 "contacts-utils.c"
		default:
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		break;
#line 1580 "contacts-utils.c"
	}
}


void contacts_utils_compose_mail (const gchar* email) {
	GError * _inner_error_ = NULL;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (email != NULL);
#line 1589 "contacts-utils.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = email;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp1_ = g_uri_escape_string (_tmp0_, "@", FALSE);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = _tmp1_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = g_strconcat ("mailto:", _tmp2_, NULL);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = _tmp3_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		gtk_show_uri (NULL, _tmp4_, (guint32) 0, &_inner_error_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp4_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (_tmp2_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1614 "contacts-utils.c"
			goto __catch32_g_error;
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_clear_error (&_inner_error_);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_inner_error_ = NULL;
#line 1625 "contacts-utils.c"
	}
	__finally32:
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_clear_error (&_inner_error_);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		return;
#line 1636 "contacts-utils.c"
	}
}


static void _vala_GValue_free (GValue* self) {
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_unset (self);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_free (self);
#line 1646 "contacts-utils.c"
}


static void __vala_GValue_free0_ (gpointer var) {
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
#line 1653 "contacts-utils.c"
}


void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id) {
	TpfPersona* im_persona = NULL;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	TpfPersona* _tmp3_ = NULL;
	TpAccount* account = NULL;
	FolksPersonaStore* _tmp4_ = NULL;
	FolksPersonaStore* _tmp5_ = NULL;
	TpAccount* _tmp6_ = NULL;
	TpAccount* _tmp7_ = NULL;
	TpAccount* _tmp8_ = NULL;
	GHashTable* request_dict = NULL;
	GHashFunc _tmp9_ = NULL;
	GEqualFunc _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GValue* _tmp15_ = NULL;
	TpAccountChannelRequest* request = NULL;
	TpAccountChannelRequest* _tmp16_ = NULL;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (contact != NULL);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (protocol != NULL);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (id != NULL);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = contact;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = protocol;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = id;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = contacts_contact_find_im_persona (_tmp0_, _tmp1_, _tmp2_);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	im_persona = _tmp3_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = folks_persona_get_store ((FolksPersona*) im_persona);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp5_ = _tmp4_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6_ = tpf_persona_store_get_account (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp5_) : NULL);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp7_ = _tmp6_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	account = _tmp8_;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp9_ = g_str_hash;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp10_ = g_str_equal;
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, NULL, __vala_GValue_free0_);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	request_dict = _tmp11_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp12_ = g_new0 (GValue, 1);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp12_, G_TYPE_STRING);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_string (_tmp12_, TP_IFACE_CHANNEL_TYPE_TEXT);
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp12_);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp13_ = g_new0 (GValue, 1);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp13_, G_TYPE_INT);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_int (_tmp13_, (gint) TP_HANDLE_TYPE_CONTACT);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp13_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp14_ = id;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp15_ = g_new0 (GValue, 1);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp15_, G_TYPE_STRING);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_string (_tmp15_, _tmp14_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp15_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp16_ = tp_account_channel_request_new (account, request_dict, G_MAXINT64);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	request = _tmp16_;
#line 167 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Chat", NULL, NULL, NULL);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (request);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_hash_table_unref0 (request_dict);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (account);
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (im_persona);
#line 1755 "contacts-utils.c"
}


void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts) {
	TpAccount* account = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gpointer* _tmp5_ = NULL;
	TpAccount** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	TpAccount* _tmp7_ = NULL;
	TpAccount* _tmp8_ = NULL;
	TpAccount* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (contact_id != NULL);
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (accounts != NULL);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = accounts;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = _tmp1_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = _tmp2_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6_ = _tmp5_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6__length1 = _tmp4_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp7_ = _tmp6_[0];
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp9_ = _tmp8_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (_tmp3_);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	account = _tmp9_;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp10_ = contact_id;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	contacts_utils_start_call_with_account (_tmp10_, account);
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (account);
#line 1809 "contacts-utils.c"
}


void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account) {
	GHashTable* request_dict = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	TpAccountChannelRequest* request = NULL;
	TpAccount* _tmp8_ = NULL;
	TpAccountChannelRequest* _tmp9_ = NULL;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (contact_id != NULL);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (account != NULL);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = g_str_hash;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = g_str_equal;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __vala_GValue_free0_);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	request_dict = _tmp2_;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp3_, G_TYPE_STRING);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_string (_tmp3_, TP_IFACE_CHANNEL_TYPE_CALL);
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp3_);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp4_, G_TYPE_INT);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_int (_tmp4_, (gint) TP_HANDLE_TYPE_CONTACT);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp4_);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp5_ = contact_id;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6_ = g_new0 (GValue, 1);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp6_, G_TYPE_STRING);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_string (_tmp6_, _tmp5_);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp6_);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp7_ = g_new0 (GValue, 1);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_init (_tmp7_, G_TYPE_BOOLEAN);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_value_set_boolean (_tmp7_, TRUE);
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TYPE_CALL_INITIAL_AUDIO, _tmp7_);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp8_ = account;
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp9_ = tp_account_channel_request_new (_tmp8_, request_dict, G_MAXINT64);
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	request = _tmp9_;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Call", NULL, NULL, NULL);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (request);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_hash_table_unref0 (request_dict);
#line 1884 "contacts-utils.c"
}


gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection) {
	gpointer result = NULL;
	GeeIterator* i = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (collection != NULL, NULL);
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = collection;
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	i = _tmp1_;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = i;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = gee_iterator_next (_tmp2_);
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp3_) {
#line 1909 "contacts-utils.c"
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = i;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		result = _tmp5_;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (i);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		return result;
#line 1922 "contacts-utils.c"
	}
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = NULL;
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (i);
#line 201 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 1930 "contacts-utils.c"
}


GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label) {
	GtkMenuItem* result = NULL;
	GtkMenuItem* mi = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (menu != NULL, NULL);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (label != NULL, NULL);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = label;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_object_ref_sink (_tmp1_);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	mi = _tmp1_;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = menu;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _tmp2_, (GtkWidget*) mi);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_widget_show ((GtkWidget*) mi);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = mi;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 1962 "contacts-utils.c"
}


void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting) {
	gint y = 0;
	gint h = 0;
	GtkGrid* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gint start = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkGrid* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (grid != NULL);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (widget != NULL);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = grid;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = widget;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_container_child_get ((GtkContainer*) _tmp0_, _tmp1_, "top-attach", &y, "height", &h, NULL);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = y;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = h;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	start = _tmp2_ + _tmp3_;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = grid;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
#line 1996 "contacts-utils.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		child_collection = _tmp5_;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 2004 "contacts-utils.c"
			GtkWidget* child = NULL;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			child = (GtkWidget*) child_it->data;
#line 2008 "contacts-utils.c"
			{
				GtkGrid* _tmp6_ = NULL;
				GtkWidget* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp6_ = grid;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp7_ = child;
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				gtk_container_child_get ((GtkContainer*) _tmp6_, _tmp7_, "top-attach", &y, "height", &h, NULL);
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp8_ = y;
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp9_ = start;
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (_tmp8_ >= _tmp9_) {
#line 2026 "contacts-utils.c"
					GtkGrid* _tmp10_ = NULL;
					GtkWidget* _tmp11_ = NULL;
					gint _tmp12_ = 0;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp10_ = grid;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp11_ = child;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp12_ = y;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					gtk_container_child_set ((GtkContainer*) _tmp10_, _tmp11_, "top-attach", _tmp12_ + 1, NULL);
#line 2038 "contacts-utils.c"
				} else {
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp14_ = y;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp15_ = h;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp16_ = start;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					if ((_tmp14_ + _tmp15_) > _tmp16_) {
#line 2052 "contacts-utils.c"
						gboolean _tmp17_ = FALSE;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp17_ = expand_intersecting;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp13_ = _tmp17_;
#line 2058 "contacts-utils.c"
					} else {
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp13_ = FALSE;
#line 2062 "contacts-utils.c"
					}
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					if (_tmp13_) {
#line 2066 "contacts-utils.c"
						GtkGrid* _tmp18_ = NULL;
						GtkWidget* _tmp19_ = NULL;
						gint _tmp20_ = 0;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp18_ = grid;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp19_ = child;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp20_ = h;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						gtk_container_child_set ((GtkContainer*) _tmp18_, _tmp19_, "height", _tmp20_ + 1, NULL);
#line 2078 "contacts-utils.c"
					}
				}
			}
		}
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_list_free0 (child_collection);
#line 2085 "contacts-utils.c"
	}
}


void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2) {
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	cairo_t* _tmp10_ = NULL;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	cairo_t* _tmp16_ = NULL;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (cr != NULL);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = xradius;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp1_ <= 0.0) {
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = TRUE;
#line 2112 "contacts-utils.c"
	} else {
		gdouble _tmp2_ = 0.0;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = yradius;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = _tmp2_ <= 0.0;
#line 2119 "contacts-utils.c"
	}
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp0_) {
#line 2123 "contacts-utils.c"
		cairo_t* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = cr;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = xc;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = yc;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		cairo_line_to (_tmp3_, _tmp4_, _tmp5_);
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		return;
#line 2137 "contacts-utils.c"
	}
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6_ = cr;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	cairo_save (_tmp6_);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp7_ = cr;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp8_ = xc;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp9_ = yc;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	cairo_translate (_tmp7_, _tmp8_, _tmp9_);
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp10_ = cr;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp11_ = xradius;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp12_ = yradius;
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	cairo_scale (_tmp10_, _tmp11_, _tmp12_);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp13_ = cr;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp14_ = angle1;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp15_ = angle2;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	cairo_arc (_tmp13_, (gdouble) 0, (gdouble) 0, 1.0, _tmp14_, _tmp15_);
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp16_ = cr;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	cairo_restore (_tmp16_);
#line 2171 "contacts-utils.c"
}


void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	cairo_t* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (cr != NULL);
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = cr;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	cairo_new_sub_path (_tmp0_);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = cr;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = x;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = radius;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = y;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp5_ = radius;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp6_ = radius;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp7_ = radius;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	contacts_utils_cairo_ellipsis (_tmp1_, (gdouble) (_tmp2_ + _tmp3_), (gdouble) (_tmp4_ + _tmp5_), (gdouble) _tmp6_, (gdouble) _tmp7_, G_PI, (3 * G_PI) / 2);
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp8_ = cr;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp9_ = x;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp10_ = width;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp11_ = radius;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp12_ = y;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp13_ = radius;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp14_ = radius;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp15_ = radius;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	contacts_utils_cairo_ellipsis (_tmp8_, (gdouble) ((_tmp9_ + _tmp10_) - _tmp11_), (gdouble) (_tmp12_ + _tmp13_), (gdouble) _tmp14_, (gdouble) _tmp15_, (-G_PI) / 2, (gdouble) 0);
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp16_ = cr;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp17_ = x;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp18_ = width;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp19_ = radius;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp20_ = y;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp21_ = height;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp22_ = radius;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp23_ = radius;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp24_ = radius;
#line 265 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	contacts_utils_cairo_ellipsis (_tmp16_, (gdouble) ((_tmp17_ + _tmp18_) - _tmp19_), (gdouble) ((_tmp20_ + _tmp21_) - _tmp22_), (gdouble) _tmp23_, (gdouble) _tmp24_, (gdouble) 0, G_PI / 2);
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp25_ = cr;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp26_ = x;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp27_ = radius;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp28_ = y;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp29_ = height;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp30_ = radius;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp31_ = radius;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp32_ = radius;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	contacts_utils_cairo_ellipsis (_tmp25_, (gdouble) (_tmp26_ + _tmp27_), (gdouble) ((_tmp28_ + _tmp29_) - _tmp30_), (gdouble) _tmp31_, (gdouble) _tmp32_, G_PI / 2, G_PI);
#line 2287 "contacts-utils.c"
}


static gunichar contacts_utils_strip_char (gunichar ch) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
	GUnicodeType _tmp1_ = 0;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = ch;
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = g_unichar_type (_tmp0_);
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	switch (_tmp1_) {
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case G_UNICODE_CONTROL:
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case G_UNICODE_FORMAT:
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case G_UNICODE_UNASSIGNED:
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case G_UNICODE_NON_SPACING_MARK:
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case G_UNICODE_COMBINING_MARK:
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		case G_UNICODE_ENCLOSING_MARK:
#line 2313 "contacts-utils.c"
		{
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			result = (gunichar) 0;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			return result;
#line 2319 "contacts-utils.c"
		}
		default:
		{
			gunichar _tmp2_ = 0U;
			gunichar _tmp3_ = 0U;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp2_ = ch;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp3_ = g_unichar_tolower (_tmp2_);
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			result = _tmp3_;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			return result;
#line 2333 "contacts-utils.c"
		}
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1105 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1106 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1106 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1106 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1107 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1107 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 2357 "contacts-utils.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1108 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1108 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1108 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (c) {
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 2372 "contacts-utils.c"
		}
#line 1109 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 2376 "contacts-utils.c"
	} else {
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		if (c) {
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 2384 "contacts-utils.c"
		}
#line 1111 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 2388 "contacts-utils.c"
	}
#line 1105 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	if (c) {
#line 1105 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 2394 "contacts-utils.c"
	}
}


gboolean contacts_utils_string_is_empty (const gchar* str) {
	gboolean result = FALSE;
	gunichar c = 0U;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (str != NULL, FALSE);
#line 2404 "contacts-utils.c"
	{
		gint i = 0;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		i = 0;
#line 2409 "contacts-utils.c"
		{
			gboolean _tmp0_ = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp0_ = TRUE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			while (TRUE) {
#line 2416 "contacts-utils.c"
				const gchar* _tmp1_ = NULL;
				gunichar _tmp2_ = 0U;
				gboolean _tmp3_ = FALSE;
				gunichar _tmp4_ = 0U;
				gboolean _tmp5_ = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (!_tmp0_) {
#line 2424 "contacts-utils.c"
				}
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp0_ = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp1_ = str;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp3_ = string_get_next_char (_tmp1_, &i, &_tmp2_);
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				c = _tmp2_;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (!_tmp3_) {
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					break;
#line 2438 "contacts-utils.c"
				}
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp4_ = c;
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp5_ = g_unichar_isspace (_tmp4_);
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (!_tmp5_) {
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					result = FALSE;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					return result;
#line 2450 "contacts-utils.c"
				}
			}
		}
	}
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = TRUE;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 2459 "contacts-utils.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2477 "contacts-utils.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1116 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1117 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1117 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1117 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1117 "/home/mcatanzaro/src/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2495 "contacts-utils.c"
}


gchar* contacts_utils_canonicalize_for_search (const gchar* str) {
	gchar* result = NULL;
	const gchar* s = NULL;
	gunichar* buf = NULL;
	gunichar* _tmp0_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	GString* res = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = g_new0 (gunichar, 18);
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	buf = _tmp0_;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	buf_length1 = 18;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_buf_size_ = buf_length1;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = g_string_new ("");
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	res = _tmp1_;
#line 2525 "contacts-utils.c"
	{
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp2_ = str;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		s = _tmp2_;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = TRUE;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		while (TRUE) {
#line 2537 "contacts-utils.c"
			const gchar* _tmp6_ = NULL;
			gchar _tmp7_ = '\0';
			gunichar c = 0U;
			const gchar* _tmp8_ = NULL;
			gunichar _tmp9_ = 0U;
			gunichar _tmp10_ = 0U;
			gunichar _tmp11_ = 0U;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (!_tmp3_) {
#line 2547 "contacts-utils.c"
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp4_ = s;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp5_ = g_utf8_next_char (_tmp4_);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				s = _tmp5_;
#line 2556 "contacts-utils.c"
			}
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp3_ = FALSE;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp6_ = s;
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp7_ = string_get (_tmp6_, (glong) 0);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (!(((gint) _tmp7_) != 0)) {
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				break;
#line 2568 "contacts-utils.c"
			}
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp8_ = s;
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp9_ = string_get_char (_tmp8_, (glong) 0);
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp10_ = contacts_utils_strip_char (_tmp9_);
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			c = _tmp10_;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp11_ = c;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (_tmp11_ != ((gunichar) 0)) {
#line 2582 "contacts-utils.c"
				gsize size = 0UL;
				gunichar _tmp12_ = 0U;
				gunichar* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gsize _tmp14_ = 0UL;
				gsize _tmp15_ = 0UL;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp12_ = c;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp13_ = buf;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp13__length1 = buf_length1;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp14_ = g_unichar_fully_decompose (_tmp12_, FALSE, _tmp13_, _tmp13__length1);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				size = _tmp14_;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp15_ = size;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (_tmp15_ > ((gsize) 0)) {
#line 2603 "contacts-utils.c"
					GString* _tmp16_ = NULL;
					gunichar* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gunichar _tmp18_ = 0U;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp16_ = res;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp17_ = buf;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp17__length1 = buf_length1;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp18_ = _tmp17_[0];
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					g_string_append_unichar (_tmp16_, _tmp18_);
#line 2618 "contacts-utils.c"
				}
			}
		}
	}
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp19_ = res;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp20_ = _tmp19_->str;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = _tmp21_;
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_string_free0 (res);
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	buf = (g_free (buf), NULL);
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 2637 "contacts-utils.c"
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_atomic_int_inc (&_data37_->_ref_count_);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return _data37_;
#line 2646 "contacts-utils.c"
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (_data37_->widget);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_slice_free (Block37Data, _data37_);
#line 2659 "contacts-utils.c"
	}
}


static void __lambda5_ (Block37Data* _data37_) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = _data37_->widget;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_widget_grab_focus (_tmp0_);
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = _data37_->widget;
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = _data37_->id;
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
#line 2678 "contacts-utils.c"
}


static void ___lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	__lambda5_ (self);
#line 2685 "contacts-utils.c"
}


void contacts_utils_grab_widget_later (GtkWidget* widget) {
	Block37Data* _data37_;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (widget != NULL);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_data37_ = g_slice_new0 (Block37Data);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_data37_->_ref_count_ = 1;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = widget;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (_data37_->widget);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_data37_->widget = _tmp1_;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_data37_->id = (gulong) 0;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = _data37_->widget;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = g_signal_connect_data (_tmp2_, "size-allocate", (GCallback) ___lambda5__gtk_widget_size_allocate, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_data37_->id = _tmp3_;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	block37_data_unref (_data37_);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_data37_ = NULL;
#line 2721 "contacts-utils.c"
}


void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry) {
	gint start = 0;
	gint end = 0;
	GtkEntry* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GtkEntry* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (entry != NULL);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = entry;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = gtk_editable_get_selection_bounds ((GtkEditable*) _tmp0_, &_tmp1_, &_tmp2_);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	start = _tmp1_;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	end = _tmp2_;
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (!_tmp3_) {
#line 2748 "contacts-utils.c"
		GtkEntry* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp4_ = entry;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = gtk_editable_get_position ((GtkEditable*) _tmp4_);
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		end = _tmp5_;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = end;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		start = _tmp6_;
#line 2762 "contacts-utils.c"
	}
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp7_ = entry;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp8_ = entry;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp9_ = start;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp10_ = end;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	gtk_editable_select_region ((GtkEditable*) _tmp8_, _tmp9_, _tmp10_);
#line 2776 "contacts-utils.c"
}


static void contacts_utils_spawn_app (GSettings* app_settings, GError** error) {
	gboolean needs_term = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* exec = NULL;
	GSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	g_return_if_fail (app_settings != NULL);
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = app_settings;
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "needs-term");
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	needs_term = _tmp1_;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = app_settings;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = g_settings_get_string (_tmp2_, "exec");
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	exec = _tmp3_;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = needs_term;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp4_) {
#line 2807 "contacts-utils.c"
		GSettings* terminal_settings = NULL;
		GSettings* _tmp5_ = NULL;
		gchar* term = NULL;
		GSettings* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* arg = NULL;
		GSettings* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar** args = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = g_settings_new ("org.gnome.desktop.default-applications.terminal");
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		terminal_settings = _tmp5_;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = terminal_settings;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = g_settings_get_string (_tmp6_, "exec");
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		term = _tmp7_;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp8_ = terminal_settings;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_ = g_settings_get_string (_tmp8_, "exec-arg");
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		arg = _tmp9_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp10_ = arg;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (g_strcmp0 (_tmp10_, "") != 0) {
#line 2842 "contacts-utils.c"
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar** _tmp17_ = NULL;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp11_ = term;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp13_ = arg;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp15_ = exec;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp17_ = g_new0 (gchar*, 4 + 1);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp17_[0] = _tmp12_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp17_[1] = _tmp14_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp17_[2] = _tmp16_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp17_[3] = NULL;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args = _tmp17_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args_length1 = 4;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_args_size_ = args_length1;
#line 2880 "contacts-utils.c"
		} else {
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar** _tmp22_ = NULL;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp18_ = term;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp19_ = g_strdup (_tmp18_);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp20_ = exec;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp22_ = g_new0 (gchar*, 3 + 1);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp22_[0] = _tmp19_;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp22_[1] = _tmp21_;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp22_[2] = NULL;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args = _tmp22_;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args_length1 = 3;
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_args_size_ = args_length1;
#line 2911 "contacts-utils.c"
		}
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp23_ = args;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp23__length1 = args_length1;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_spawn_async (NULL, _tmp23_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				g_propagate_error (error, _inner_error_);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (arg);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (term);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_object_unref0 (terminal_settings);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (exec);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				return;
#line 2937 "contacts-utils.c"
			} else {
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (arg);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (term);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_object_unref0 (terminal_settings);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (exec);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				g_clear_error (&_inner_error_);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				return;
#line 2955 "contacts-utils.c"
			}
		}
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (arg);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_free0 (term);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_g_object_unref0 (terminal_settings);
#line 2966 "contacts-utils.c"
	} else {
		const gchar* _tmp24_ = NULL;
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp24_ = exec;
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		g_spawn_command_line_async (_tmp24_, &_inner_error_);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				g_propagate_error (error, _inner_error_);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (exec);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				return;
#line 2983 "contacts-utils.c"
			} else {
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (exec);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				g_clear_error (&_inner_error_);
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				return;
#line 2993 "contacts-utils.c"
			}
		}
	}
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_free0 (exec);
#line 2999 "contacts-utils.c"
}


void contacts_utils_show_calendar (GDateTime* day) {
	GSettings* calendar_settings = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* exec = NULL;
	GSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = g_settings_new ("org.gnome.desktop.default-applications.office.calendar");
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	calendar_settings = _tmp0_;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp1_ = calendar_settings;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = g_settings_get_string (_tmp1_, "exec");
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	exec = _tmp2_;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = exec;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (g_strcmp0 (_tmp4_, "") == 0) {
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = TRUE;
#line 3028 "contacts-utils.c"
	} else {
		const gchar* _tmp5_ = NULL;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp5_ = exec;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "evolution") == 0;
#line 3035 "contacts-utils.c"
	}
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (_tmp3_) {
#line 3039 "contacts-utils.c"
		gchar** args = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		GDateTime* _tmp10_ = NULL;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp6_ = g_strdup ("evolution");
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp7_ = g_strdup ("-c");
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp8_ = g_strdup ("calendar");
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_ = g_new0 (gchar*, 5 + 1);
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_[0] = _tmp6_;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_[1] = _tmp7_;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_[2] = _tmp8_;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_[3] = NULL;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp9_[4] = NULL;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		args = _tmp9_;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		args_length1 = 5;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_args_size_ = args_length1;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp10_ = day;
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (_tmp10_ != NULL) {
#line 3076 "contacts-utils.c"
			GDateTime* d = NULL;
			GDateTime* _tmp11_ = NULL;
			GDateTime* _tmp12_ = NULL;
			GDateTime* today = NULL;
			GDateTime* _tmp13_ = NULL;
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			GDateTime* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			GDateTime* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			GDateTime* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp11_ = day;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp12_ = g_date_time_to_local (_tmp11_);
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			d = _tmp12_;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp13_ = g_date_time_new_now_local ();
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			today = _tmp13_;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp14_ = args;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp14__length1 = args_length1;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp15_ = today;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp16_ = g_date_time_get_year (_tmp15_);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp17_ = d;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp18_ = g_date_time_get_month (_tmp17_);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp19_ = d;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp20_ = g_date_time_get_day_of_month (_tmp19_);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp21_ = g_strdup_printf ("calendar:///?startdate=%.4d%.2d%.2d", _tmp16_, _tmp18_, _tmp20_);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (_tmp14_[3]);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp14_[3] = _tmp21_;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp22_ = _tmp14_[3];
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_date_time_unref0 (today);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_date_time_unref0 (d);
#line 3130 "contacts-utils.c"
		}
		{
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp23_ = args;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp23__length1 = args_length1;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_spawn_async (NULL, _tmp23_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3143 "contacts-utils.c"
				goto __catch33_g_error;
			}
		}
		goto __finally33;
		__catch33_g_error:
		{
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_clear_error (&_inner_error_);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_inner_error_ = NULL;
#line 3154 "contacts-utils.c"
		}
		__finally33:
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (exec);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (calendar_settings);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_clear_error (&_inner_error_);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			return;
#line 3171 "contacts-utils.c"
		}
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 3175 "contacts-utils.c"
	} else {
		{
			GSettings* _tmp24_ = NULL;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp24_ = calendar_settings;
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			contacts_utils_spawn_app (_tmp24_, &_inner_error_);
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3185 "contacts-utils.c"
				goto __catch34_g_error;
			}
		}
		goto __finally34;
		__catch34_g_error:
		{
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_clear_error (&_inner_error_);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_inner_error_ = NULL;
#line 3196 "contacts-utils.c"
		}
		__finally34:
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_free0 (exec);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_g_object_unref0 (calendar_settings);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			g_clear_error (&_inner_error_);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			return;
#line 3211 "contacts-utils.c"
		}
	}
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_free0 (exec);
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_g_object_unref0 (calendar_settings);
#line 3218 "contacts-utils.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = g_new0 (gchar*, length + 1);
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	for (i = 0; i < length; i++) {
#line 3229 "contacts-utils.c"
		gchar* _tmp0_ = NULL;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		_tmp0_ = g_strdup (self[i]);
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		result[i] = _tmp0_;
#line 3235 "contacts-utils.c"
	}
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 3239 "contacts-utils.c"
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if ((*length) == (*size)) {
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3250 "contacts-utils.c"
	}
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(*array)[(*length)++] = value;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	(*array)[*length] = NULL;
#line 3256 "contacts-utils.c"
}


gchar** contacts_utils_get_stock_avatars (int* result_length1) {
	gchar** result = NULL;
	gchar** files = NULL;
	gchar** _tmp0_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	gchar** system_data_dirs = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint system_data_dirs_length1 = 0;
	gint _system_data_dirs_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GError * _inner_error_ = NULL;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	files = _tmp0_;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	files_length1 = 0;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_files_size_ = files_length1;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	system_data_dirs = _tmp3_;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	system_data_dirs_length1 = _tmp3__length1;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_system_data_dirs_size_ = system_data_dirs_length1;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4_ = system_data_dirs;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp4__length1 = system_data_dirs_length1;
#line 3302 "contacts-utils.c"
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		data_dir_collection = _tmp4_;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		data_dir_collection_length1 = _tmp4__length1;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		for (data_dir_it = 0; data_dir_it < _tmp4__length1; data_dir_it = data_dir_it + 1) {
#line 3314 "contacts-utils.c"
			gchar* _tmp5_ = NULL;
			gchar* data_dir = NULL;
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			_tmp5_ = g_strdup (data_dir_collection[data_dir_it]);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
			data_dir = _tmp5_;
#line 3321 "contacts-utils.c"
			{
				gchar* path = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				GDir* dir = NULL;
				GDir* _tmp12_ = NULL;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp6_ = data_dir;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp7_ = g_build_filename (_tmp6_, "pixmaps", "faces", NULL);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				path = _tmp7_;
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				dir = NULL;
#line 3336 "contacts-utils.c"
				{
					GDir* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GDir* _tmp10_ = NULL;
					GDir* _tmp11_ = NULL;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp9_ = path;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp10_ = g_dir_open (_tmp9_, (guint) 0, &_inner_error_);
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp8_ = _tmp10_;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3350 "contacts-utils.c"
						goto __catch35_g_error;
					}
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp11_ = _tmp8_;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_tmp8_ = NULL;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_g_dir_close0 (dir);
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					dir = _tmp11_;
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_g_dir_close0 (_tmp8_);
#line 3363 "contacts-utils.c"
				}
				goto __finally35;
				__catch35_g_error:
				{
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					g_clear_error (&_inner_error_);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_inner_error_ = NULL;
#line 3372 "contacts-utils.c"
				}
				__finally35:
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_g_dir_close0 (dir);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_g_free0 (path);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_g_free0 (data_dir);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					g_clear_error (&_inner_error_);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					return NULL;
#line 3393 "contacts-utils.c"
				}
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_tmp12_ = dir;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				if (_tmp12_ != NULL) {
#line 3399 "contacts-utils.c"
					gchar* face = NULL;
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					while (TRUE) {
#line 3403 "contacts-utils.c"
						GDir* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						gchar* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						gchar* filename = NULL;
						const gchar* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						gchar* _tmp19_ = NULL;
						gchar** _tmp20_ = NULL;
						gint _tmp20__length1 = 0;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp13_ = dir;
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp14_ = g_dir_read_name (_tmp13_);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp15_ = g_strdup (_tmp14_);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_g_free0 (face);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						face = _tmp15_;
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp16_ = face;
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						if (!(_tmp16_ != NULL)) {
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
							break;
#line 3432 "contacts-utils.c"
						}
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp17_ = path;
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp18_ = face;
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp19_ = g_build_filename (_tmp17_, _tmp18_, NULL);
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						filename = _tmp19_;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp20_ = files;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp20__length1 = files_length1;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp21_ = filename;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_tmp22_ = g_strdup (_tmp21_);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_vala_array_add11 (&files, &files_length1, &_files_size_, _tmp22_);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
						_g_free0 (filename);
#line 3454 "contacts-utils.c"
					}
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
					_g_free0 (face);
#line 3458 "contacts-utils.c"
				}
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_dir_close0 (dir);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (path);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
				_g_free0 (data_dir);
#line 3466 "contacts-utils.c"
			}
		}
	}
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp23_ = files;
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	_tmp23__length1 = files_length1;
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	if (result_length1) {
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
		*result_length1 = _tmp23__length1;
#line 3478 "contacts-utils.c"
	}
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	result = _tmp23_;
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return result;
#line 3486 "contacts-utils.c"
}


ContactsUtils* contacts_utils_construct (GType object_type) {
	ContactsUtils * self = NULL;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	self = (ContactsUtils*) g_object_new (object_type, NULL);
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return self;
#line 3496 "contacts-utils.c"
}


ContactsUtils* contacts_utils_new (void) {
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	return contacts_utils_construct (CONTACTS_TYPE_UTILS);
#line 3503 "contacts-utils.c"
}


static void contacts_utils_class_init (ContactsUtilsClass * klass) {
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-contacts/src/contacts-utils.vala"
	contacts_utils_parent_class = g_type_class_peek_parent (klass);
#line 3510 "contacts-utils.c"
}


static void contacts_utils_instance_init (ContactsUtils * self) {
}


GType contacts_utils_get_type (void) {
	static volatile gsize contacts_utils_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsUtils), 0, (GInstanceInitFunc) contacts_utils_instance_init, NULL };
		GType contacts_utils_type_id;
		contacts_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsUtils", &g_define_type_info, 0);
		g_once_init_leave (&contacts_utils_type_id__volatile, contacts_utils_type_id);
	}
	return contacts_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



