/* contacts-contact.c generated by valac 0.13.1.211-6e21, the Vala compiler
 * generated from contacts-contact.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <folks/folks-telepathy.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <telepathy-glib/telepathy-glib.h>
#include <config.h>
#include <gio/gio.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define CONTACTS_TYPE_CONTACT_PRESENCE (contacts_contact_presence_get_type ())
#define CONTACTS_CONTACT_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresence))
#define CONTACTS_CONTACT_PRESENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresenceClass))
#define CONTACTS_IS_CONTACT_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PRESENCE))
#define CONTACTS_IS_CONTACT_PRESENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PRESENCE))
#define CONTACTS_CONTACT_PRESENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresenceClass))

typedef struct _ContactsContactPresence ContactsContactPresence;
typedef struct _ContactsContactPresenceClass ContactsContactPresenceClass;
typedef struct _ContactsContactPresencePrivate ContactsContactPresencePrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _Block1Data Block1Data;

#define CONTACTS_CONTACT_TYPE_IM_DISPLAY (contacts_contact_im_display_get_type ())
#define _contacts_store_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define CONTACTS_CONTACT_TYPE_IM_DATA (contacts_contact_im_data_get_type ())
typedef struct _ContactsContactImData ContactsContactImData;
typedef struct _Block2Data Block2Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define CONTACTS_TYPE_TYPESET (contacts_typeset_get_type ())
#define CONTACTS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSet))
#define CONTACTS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))
#define CONTACTS_IS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPESET))
#define CONTACTS_IS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPESET))
#define CONTACTS_TYPESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))

typedef struct _ContactsTypeSet ContactsTypeSet;
typedef struct _ContactsTypeSetClass ContactsTypeSetClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _ContactsContactEnsureWritablePersonaData ContactsContactEnsureWritablePersonaData;

typedef enum  {
	CONTACT_ERROR_NOT_IMPLEMENTED
} ContactError;
#define CONTACT_ERROR contact_error_quark ()
struct _ContactsContactPresence {
	GtkGrid parent_instance;
	ContactsContactPresencePrivate * priv;
};

struct _ContactsContactPresenceClass {
	GtkGridClass parent_class;
};

struct _ContactsContactPresencePrivate {
	ContactsContact* contact;
	GtkImage* image;
	GtkLabel* label;
	gchar* last_class;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	ContactsContactPresence * self;
	gulong id;
	ContactsContact* contact;
};

struct _ContactsContactPrivate {
	guint changed_id;
	GdkPixbuf* _avatar;
	gchar* filter_data;
};

typedef enum  {
	CONTACTS_CONTACT_IM_DISPLAY_DEFAULT,
	CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE
} ContactsContactImDisplay;

struct _ContactsContactImData {
	const gchar* service;
	const gchar* display_name;
	ContactsContactImDisplay display;
};

struct _Block2Data {
	int _ref_count_;
	ContactsContact * self;
	TpfPersona* tp;
	GtkImage* i;
	gchar* last_class;
	gulong id1;
	gulong id2;
};

struct _ContactsContactEnsureWritablePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsContact* self;
	FolksPersona* result;
	FolksPersona* _tmp0_;
	FolksPersona* p;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};


static gpointer contacts_contact_presence_parent_class = NULL;
static gpointer contacts_contact_parent_class = NULL;
static GdkPixbuf* contacts_contact_fallback_avatar;
static GdkPixbuf* contacts_contact_fallback_avatar = NULL;

GQuark contact_error_quark (void);
GType contacts_contact_presence_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
#define CONTACTS_CONTACT_PRESENCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT_PRESENCE, ContactsContactPresencePrivate))
enum  {
	CONTACTS_CONTACT_PRESENCE_DUMMY_PROPERTY
};
static void contacts_contact_presence_update_presence_widgets (ContactsContactPresence* self, GtkImage* image, GtkLabel* label);
gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar* contacts_contact_presence_to_icon_full (FolksPresenceType presence);
gchar* contacts_contact_presence_to_class (FolksPresenceType presence);
gchar* contacts_contact_presence_to_string (FolksPresenceType presence);
ContactsContactPresence* contacts_contact_presence_new (ContactsContact* contact);
ContactsContactPresence* contacts_contact_presence_construct (GType object_type, ContactsContact* contact);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda1_ (ContactsContactPresence* self);
static void ___lambda1__contacts_contact_changed (ContactsContact* _sender, gpointer self);
static void __lambda2_ (Block1Data* _data1_);
static void ___lambda2__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void contacts_contact_presence_finalize (GObject* obj);
#define CONTACTS_CONTACT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT, ContactsContactPrivate))
enum  {
	CONTACTS_CONTACT_DUMMY_PROPERTY,
	CONTACTS_CONTACT_AVATAR,
	CONTACTS_CONTACT_DISPLAY_NAME,
	CONTACTS_CONTACT_INITIAL_LETTER
};
static GType contacts_contact_im_display_get_type (void) G_GNUC_UNUSED;
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
static void contacts_contact_persona_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void contacts_contact_queue_changed (ContactsContact* self);
static void contacts_contact_connect_persona (ContactsContact* self, FolksPersona* p);
static void _contacts_contact_persona_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void contacts_contact_disconnect_persona (ContactsContact* self, FolksPersona* p);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
static void __lambda0_ (ContactsContact* self, GeeSet* added, GeeSet* removed);
static void ___lambda0__folks_individual_personas_changed (FolksIndividual* _sender, GeeSet* added, GeeSet* removed, gpointer self);
static void contacts_contact_update (ContactsContact* self);
static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void contacts_contact_remove (ContactsContact* self);
static void contacts_contact_unqueue_changed (ContactsContact* self);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
gchar* contacts_contact_presence_to_icon (FolksPresenceType presence);
static gchar* contacts_contact_get_first_string (GeeCollection* collection);
static gint contacts_contact_sort_fields_helper (FolksAbstractFieldDetails* a, FolksAbstractFieldDetails* b);
GList* contacts_contact_sort_fields (GeeSet* details);
static gint _contacts_contact_sort_fields_helper_gcompare_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id);
static GType contacts_contact_im_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self);
static void contacts_contact_im_data_free (ContactsContactImData* self);
GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self);
GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void __lambda3_ (Block2Data* _data2_, GParamSpec* pspec);
static void ___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda4_ (Block2Data* _data2_, GParamSpec* pspec);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean contacts_contact_changed_cb (ContactsContact* self);
static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self);
static gboolean contacts_contact_get_is_phone (FolksPersona* persona);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void contacts_contact_update_presence (ContactsContact* self);
static void contacts_contact_update_filter_data (ContactsContact* self);
GType contacts_typeset_get_type (void) G_GNUC_CONST;
ContactsTypeSet* contacts_typeset_get_general (void);
void contacts_typeset_type_seen (ContactsTypeSet* self, FolksAbstractFieldDetails* detail);
ContactsTypeSet* contacts_typeset_get_phone (void);
static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GLoadableIcon* file);
static void contacts_contact_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2);
static void contacts_contact_rounded_box_path (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
static GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon);
GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size);
gchar* contacts_contact_format_uri_link_text (FolksUrlFieldDetails* detail);
static void contacts_contact_ensure_writable_persona_data_free (gpointer _data);
void contacts_contact_ensure_writable_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_contact_ensure_writable_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static gboolean contacts_contact_ensure_writable_persona_co (ContactsContactEnsureWritablePersonaData* _data_);
FolksPersona* contacts_contact_find_writable_persona (ContactsContact* self);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
gunichar contacts_contact_get_initial_letter (ContactsContact* self);
static void contacts_contact_finalize (GObject* obj);
static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;
static GRegex* _tmp_regex_2 = NULL;

GQuark contact_error_quark (void) {
	return g_quark_from_static_string ("contact_error-quark");
}


static void contacts_contact_presence_update_presence_widgets (ContactsContactPresence* self, GtkImage* image, GtkLabel* label) {
	FolksPresenceType type = 0;
	gchar* message = NULL;
	gboolean is_phone = FALSE;
	ContactsContact* _tmp0_;
	FolksPresenceType _tmp1_;
	ContactsContact* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	ContactsContact* _tmp5_;
	gboolean _tmp6_;
	FolksPresenceType _tmp7_;
	GtkImage* _tmp12_;
	FolksPresenceType _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	FolksPresenceType _tmp20_;
	gchar* _tmp21_ = NULL;
	GtkImage* _tmp22_;
	GtkStyleContext* _tmp23_ = NULL;
	const gchar* _tmp24_;
	GtkImage* _tmp25_;
	GtkLabel* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->contact;
	_tmp1_ = _tmp0_->presence_type;
	type = _tmp1_;
	_tmp2_ = self->priv->contact;
	_tmp3_ = _tmp2_->presence_message;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (message);
	message = _tmp4_;
	_tmp5_ = self->priv->contact;
	_tmp6_ = _tmp5_->is_phone;
	is_phone = _tmp6_;
	_tmp7_ = type;
	if (_tmp7_ == FOLKS_PRESENCE_TYPE_UNSET) {
		GtkImage* _tmp8_;
		GtkImage* _tmp9_;
		GtkLabel* _tmp10_;
		GtkLabel* _tmp11_;
		_tmp8_ = image;
		gtk_image_clear (_tmp8_);
		_tmp9_ = image;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
		_tmp10_ = label;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
		_tmp11_ = label;
		gtk_label_set_text (_tmp11_, "");
		_g_free0 (message);
		return;
	}
	_tmp12_ = image;
	_tmp13_ = type;
	_tmp14_ = contacts_contact_presence_to_icon_full (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_image_set_from_icon_name (_tmp12_, _tmp15_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->last_class;
	if (_tmp16_ != NULL) {
		GtkImage* _tmp17_;
		GtkStyleContext* _tmp18_ = NULL;
		const gchar* _tmp19_;
		_tmp17_ = image;
		_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
		_tmp19_ = self->priv->last_class;
		gtk_style_context_remove_class (_tmp18_, _tmp19_);
	}
	_tmp20_ = type;
	_tmp21_ = contacts_contact_presence_to_class (_tmp20_);
	_g_free0 (self->priv->last_class);
	self->priv->last_class = _tmp21_;
	_tmp22_ = image;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	_tmp24_ = self->priv->last_class;
	gtk_style_context_add_class (_tmp23_, _tmp24_);
	_tmp25_ = image;
	gtk_widget_show ((GtkWidget*) _tmp25_);
	_tmp26_ = label;
	gtk_widget_show ((GtkWidget*) _tmp26_);
	_tmp27_ = message;
	_tmp28_ = strlen (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		FolksPresenceType _tmp30_;
		gchar* _tmp31_ = NULL;
		_tmp30_ = type;
		_tmp31_ = contacts_contact_presence_to_string (_tmp30_);
		_g_free0 (message);
		message = _tmp31_;
	}
	_tmp32_ = is_phone;
	if (_tmp32_) {
		GtkLabel* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp33_ = label;
		_tmp34_ = message;
		_tmp35_ = g_markup_escape_text (_tmp34_, (gssize) (-1));
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, " <span color='#8e9192'>(via phone)</span>", NULL);
		_tmp38_ = _tmp37_;
		gtk_label_set_markup (_tmp33_, _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
	} else {
		GtkLabel* _tmp39_;
		const gchar* _tmp40_;
		_tmp39_ = label;
		_tmp40_ = message;
		gtk_label_set_text (_tmp39_, _tmp40_);
	}
	_g_free0 (message);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->contact);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda1_ (ContactsContactPresence* self) {
	GtkImage* _tmp0_;
	GtkLabel* _tmp1_;
	_tmp0_ = self->priv->image;
	_tmp1_ = self->priv->label;
	contacts_contact_presence_update_presence_widgets (self, _tmp0_, _tmp1_);
}


static void ___lambda1__contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	__lambda1_ (self);
}


static void __lambda2_ (Block1Data* _data1_) {
	ContactsContactPresence * self;
	ContactsContact* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->contact;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data1_->id);
}


static void ___lambda2__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda2_ (self);
}


ContactsContactPresence* contacts_contact_presence_construct (GType object_type, ContactsContact* contact) {
	ContactsContactPresence * self = NULL;
	Block1Data* _data1_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkImage* _tmp14_;
	GtkLabel* _tmp15_;
	ContactsContact* _tmp16_;
	gulong _tmp17_ = 0UL;
	g_return_val_if_fail (contact != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data1_->contact = _tmp1_;
	self = (ContactsContactPresence*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp2_ = _data1_->contact;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp3_;
	gtk_grid_set_row_spacing ((GtkGrid*) self, (guint) 4);
	_tmp4_ = (GtkImage*) gtk_image_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp5_;
	_tmp6_ = self->priv->image;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkLabel*) gtk_label_new ("");
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp9_;
	_tmp10_ = self->priv->label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->label;
	gtk_label_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_END);
	_tmp12_ = self->priv->label;
	g_object_set ((GtkMisc*) _tmp12_, "xalign", 0.0f, NULL);
	_tmp13_ = self->priv->label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->image;
	_tmp15_ = self->priv->label;
	contacts_contact_presence_update_presence_widgets (self, _tmp14_, _tmp15_);
	_tmp16_ = _data1_->contact;
	_tmp17_ = g_signal_connect_object (_tmp16_, "changed", (GCallback) ___lambda1__contacts_contact_changed, self, 0);
	_data1_->id = _tmp17_;
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) ___lambda2__gtk_widget_destroy, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


ContactsContactPresence* contacts_contact_presence_new (ContactsContact* contact) {
	return contacts_contact_presence_construct (CONTACTS_TYPE_CONTACT_PRESENCE, contact);
}


static void contacts_contact_presence_class_init (ContactsContactPresenceClass * klass) {
	contacts_contact_presence_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPresencePrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_presence_finalize;
}


static void contacts_contact_presence_instance_init (ContactsContactPresence * self) {
	self->priv = CONTACTS_CONTACT_PRESENCE_GET_PRIVATE (self);
}


static void contacts_contact_presence_finalize (GObject* obj) {
	ContactsContactPresence * self;
	self = CONTACTS_CONTACT_PRESENCE (obj);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	_g_free0 (self->priv->last_class);
	G_OBJECT_CLASS (contacts_contact_presence_parent_class)->finalize (obj);
}


GType contacts_contact_presence_get_type (void) {
	static volatile gsize contacts_contact_presence_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_presence_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPresenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_presence_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPresence), 0, (GInstanceInitFunc) contacts_contact_presence_instance_init, NULL };
		GType contacts_contact_presence_type_id;
		contacts_contact_presence_type_id = g_type_register_static (GTK_TYPE_GRID, "ContactsContactPresence", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_presence_type_id__volatile, contacts_contact_presence_type_id);
	}
	return contacts_contact_presence_type_id__volatile;
}


static GType contacts_contact_im_display_get_type (void) {
	static volatile gsize contacts_contact_im_display_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_display_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_CONTACT_IM_DISPLAY_DEFAULT, "CONTACTS_CONTACT_IM_DISPLAY_DEFAULT", "default"}, {CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE, "CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE", "alias-service"}, {0, NULL, NULL}};
		GType contacts_contact_im_display_type_id;
		contacts_contact_im_display_type_id = g_enum_register_static ("ContactsContactImDisplay", values);
		g_once_init_leave (&contacts_contact_im_display_type_id__volatile, contacts_contact_im_display_type_id);
	}
	return contacts_contact_im_display_type_id__volatile;
}


ContactsContact* contacts_contact_from_individual (FolksIndividual* i) {
	ContactsContact* result = NULL;
	FolksIndividual* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	ContactsContact* _tmp2_;
	g_return_val_if_fail (i != NULL, NULL);
	_tmp0_ = i;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "contact");
	_tmp2_ = _g_object_ref0 ((ContactsContact*) _tmp1_);
	result = _tmp2_;
	return result;
}


static void contacts_contact_persona_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	contacts_contact_queue_changed (self);
}


static void _contacts_contact_persona_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_persona_notify_cb (self, pspec);
}


static void contacts_contact_connect_persona (ContactsContact* self, FolksPersona* p) {
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	TpfPersona* _tmp3_;
	TpfPersona* tp;
	gboolean _tmp4_ = FALSE;
	TpfPersona* _tmp5_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::presence-type", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	_tmp1_ = p;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::presence-message", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	_tmp2_ = p;
	_tmp3_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp2_) ? ((TpfPersona*) _tmp2_) : NULL);
	tp = _tmp3_;
	_tmp5_ = tp;
	if (_tmp5_ != NULL) {
		TpfPersona* _tmp6_;
		TpContact* _tmp7_;
		TpContact* _tmp8_;
		_tmp6_ = tp;
		_tmp7_ = tpf_persona_get_contact (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		TpfPersona* _tmp10_;
		TpContact* _tmp11_;
		TpContact* _tmp12_;
		_tmp10_ = tp;
		_tmp11_ = tpf_persona_get_contact (_tmp10_);
		_tmp12_ = _tmp11_;
		g_signal_connect_object ((GObject*) _tmp12_, "notify::client-types", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	}
	_g_object_unref0 (tp);
}


static void contacts_contact_disconnect_persona (ContactsContact* self, FolksPersona* p) {
	FolksIndividual* _tmp0_;
	FolksPersona* _tmp1_;
	TpfPersona* _tmp2_;
	TpfPersona* tp;
	gboolean _tmp3_ = FALSE;
	TpfPersona* _tmp4_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->individual;
	g_signal_handlers_disconnect_by_func (_tmp0_, (void*) contacts_contact_persona_notify_cb, self);
	_tmp1_ = p;
	_tmp2_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp1_) ? ((TpfPersona*) _tmp1_) : NULL);
	tp = _tmp2_;
	_tmp4_ = tp;
	if (_tmp4_ != NULL) {
		TpfPersona* _tmp5_;
		TpContact* _tmp6_;
		TpContact* _tmp7_;
		_tmp5_ = tp;
		_tmp6_ = tpf_persona_get_contact (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		TpfPersona* _tmp9_;
		TpContact* _tmp10_;
		TpContact* _tmp11_;
		_tmp9_ = tp;
		_tmp10_ = tpf_persona_get_contact (_tmp9_);
		_tmp11_ = _tmp10_;
		g_signal_handlers_disconnect_by_func (_tmp11_, (void*) contacts_contact_persona_notify_cb, self);
	}
	_g_object_unref0 (tp);
}


static gpointer _contacts_store_ref0 (gpointer self) {
	return self ? contacts_store_ref (self) : NULL;
}


static void __lambda0_ (ContactsContact* self, GeeSet* added, GeeSet* removed) {
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = added;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp6_;
			_tmp2_ = _p_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			contacts_contact_connect_persona (self, _tmp6_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	{
		GeeSet* _tmp7_;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _p_it;
		_tmp7_ = removed;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_p_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			GeeIterator* _tmp11_;
			gpointer _tmp12_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp13_;
			_tmp9_ = _p_it;
			_tmp10_ = gee_iterator_next (_tmp9_);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _p_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			p = (FolksPersona*) _tmp12_;
			_tmp13_ = p;
			contacts_contact_disconnect_persona (self, _tmp13_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


static void ___lambda0__folks_individual_personas_changed (FolksIndividual* _sender, GeeSet* added, GeeSet* removed, gpointer self) {
	__lambda0_ (self, added, removed);
}


static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_notify_cb (self, pspec);
}


ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i) {
	ContactsContact * self = NULL;
	ContactsStore* _tmp0_;
	ContactsStore* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	ContactsContact* _tmp5_;
	FolksIndividual* _tmp15_;
	FolksIndividual* _tmp16_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (ContactsContact*) g_object_new (object_type, NULL);
	_tmp0_ = store;
	_tmp1_ = _contacts_store_ref0 (_tmp0_);
	_contacts_store_unref0 (self->store);
	self->store = _tmp1_;
	_tmp2_ = i;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->individual);
	self->individual = _tmp3_;
	_tmp4_ = self->individual;
	_tmp5_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) _tmp4_, "contact", _tmp5_, g_object_unref);
	{
		FolksIndividual* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _p_it;
		_tmp6_ = self->individual;
		_tmp7_ = folks_individual_get_personas (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_p_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp14_;
			_tmp10_ = _p_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _p_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			p = (FolksPersona*) _tmp13_;
			_tmp14_ = p;
			contacts_contact_connect_persona (self, _tmp14_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp15_ = self->individual;
	g_signal_connect_object (_tmp15_, "personas-changed", (GCallback) ___lambda0__folks_individual_personas_changed, self, 0);
	contacts_contact_update (self);
	_tmp16_ = self->individual;
	g_signal_connect_object ((GObject*) _tmp16_, "notify", (GCallback) _contacts_contact_notify_cb_g_object_notify, self, 0);
	return self;
}


ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i) {
	return contacts_contact_construct (CONTACTS_TYPE_CONTACT, store, i);
}


void contacts_contact_remove (ContactsContact* self) {
	FolksIndividual* _tmp9_;
	guint _tmp10_ = 0U;
	g_return_if_fail (self != NULL);
	contacts_contact_unqueue_changed (self);
	{
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp8_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			contacts_contact_disconnect_persona (self, _tmp8_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp9_ = self->individual;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _contacts_contact_notify_cb_g_object_notify, self);
}


gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address) {
	gboolean result = FALSE;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* addrs;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (email_address != NULL, FALSE);
	_tmp0_ = self->individual;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	addrs = _tmp3_;
	{
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _detail_it;
		_tmp4_ = addrs;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_detail_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			FolksEmailFieldDetails* detail;
			FolksEmailFieldDetails* _tmp10_;
			gconstpointer _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = _detail_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _detail_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			detail = (FolksEmailFieldDetails*) _tmp9_;
			_tmp10_ = detail;
			_tmp11_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = email_address;
			if (g_strcmp0 ((const gchar*) _tmp12_, _tmp13_) == 0) {
				result = TRUE;
				_g_object_unref0 (detail);
				_g_object_unref0 (_detail_it);
				_g_object_unref0 (addrs);
				return result;
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	result = FALSE;
	_g_object_unref0 (addrs);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = strings;
	_tmp0__length1 = strings_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp0_;
		i_collection_length1 = _tmp0__length1;
		for (i_it = 0; i_it < _tmp0__length1; i_it = i_it + 1) {
			gchar* _tmp1_;
			gchar* i = NULL;
			_tmp1_ = g_strdup (i_collection[i_it]);
			i = _tmp1_;
			{
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_ = FALSE;
				_tmp2_ = self->priv->filter_data;
				_tmp3_ = i;
				_tmp4_ = string_contains (_tmp2_, _tmp3_);
				if (!_tmp4_) {
					result = FALSE;
					_g_free0 (i);
					return result;
				}
				_g_free0 (i);
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* contacts_contact_presence_to_string (FolksPresenceType presence) {
	gchar* result = NULL;
	FolksPresenceType _tmp0_;
	_tmp0_ = presence;
	switch (_tmp0_) {
		default:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = _ ("Unknown status");
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = _ ("Offline");
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_UNSET:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("Error");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("Available");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("Away");
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = _ ("Extended away");
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp14_ = _ ("Busy");
			_tmp15_ = g_strdup (_tmp14_);
			result = _tmp15_;
			return result;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp16_ = _ ("Hidden");
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			return result;
		}
	}
}


gchar* contacts_contact_presence_to_icon (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* iconname;
	FolksPresenceType _tmp0_;
	iconname = NULL;
	_tmp0_ = presence;
	switch (_tmp0_) {
		default:
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		case FOLKS_PRESENCE_TYPE_UNSET:
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			break;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("user-available-symbolic");
			_g_free0 (iconname);
			iconname = _tmp1_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("user-away-symbolic");
			_g_free0 (iconname);
			iconname = _tmp2_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("user-busy-symbolic");
			_g_free0 (iconname);
			iconname = _tmp3_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("user-invisible-symbolic");
			_g_free0 (iconname);
			iconname = _tmp4_;
			break;
		}
	}
	result = iconname;
	return result;
}


gchar* contacts_contact_presence_to_icon_full (FolksPresenceType presence) {
	gchar* result = NULL;
	FolksPresenceType _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* iconname;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = presence;
	_tmp1_ = contacts_contact_presence_to_icon (_tmp0_);
	iconname = _tmp1_;
	_tmp2_ = iconname;
	if (_tmp2_ != NULL) {
		result = iconname;
		return result;
	}
	_tmp3_ = g_strdup ("user-offline-symbolic");
	result = _tmp3_;
	_g_free0 (iconname);
	return result;
}


gchar* contacts_contact_presence_to_class (FolksPresenceType presence) {
	gchar* result = NULL;
	gchar* classname;
	FolksPresenceType _tmp0_;
	classname = NULL;
	_tmp0_ = presence;
	switch (_tmp0_) {
		default:
		case FOLKS_PRESENCE_TYPE_HIDDEN:
		case FOLKS_PRESENCE_TYPE_OFFLINE:
		case FOLKS_PRESENCE_TYPE_UNSET:
		case FOLKS_PRESENCE_TYPE_ERROR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("presence-icon-offline");
			_g_free0 (classname);
			classname = _tmp1_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AVAILABLE:
		case FOLKS_PRESENCE_TYPE_UNKNOWN:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("presence-icon-available");
			_g_free0 (classname);
			classname = _tmp2_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_AWAY:
		case FOLKS_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("presence-icon-away");
			_g_free0 (classname);
			classname = _tmp3_;
			break;
		}
		case FOLKS_PRESENCE_TYPE_BUSY:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("presence-icon-busy");
			_g_free0 (classname);
			classname = _tmp4_;
			break;
		}
	}
	result = classname;
	return result;
}


static gchar* contacts_contact_get_first_string (GeeCollection* collection) {
	gchar* result = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* i;
	GeeIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = collection;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	i = _tmp1_;
	_tmp2_ = i;
	_tmp3_ = gee_iterator_next (_tmp2_);
	if (_tmp3_) {
		GeeIterator* _tmp4_;
		gpointer _tmp5_ = NULL;
		_tmp4_ = i;
		_tmp5_ = gee_iterator_get (_tmp4_);
		result = (gchar*) _tmp5_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


static gint contacts_contact_sort_fields_helper (FolksAbstractFieldDetails* a, FolksAbstractFieldDetails* b) {
	gint result = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if ((&a) == (&b)) {
		result = 0;
		return result;
	}
	if ((&a) < (&b)) {
		result = -1;
		return result;
	}
	result = 1;
	return result;
}


static gint _contacts_contact_sort_fields_helper_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = contacts_contact_sort_fields_helper (a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* contacts_contact_sort_fields (GeeSet* details) {
	GList* result = NULL;
	GList* pref;
	GList* rest;
	GList* _tmp34_;
	g_return_val_if_fail (details != NULL, NULL);
	pref = NULL;
	rest = NULL;
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _detail_it;
		_tmp0_ = details;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_detail_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksAbstractFieldDetails* detail;
			FolksAbstractFieldDetails* _tmp6_;
			GeeMultiMap* _tmp7_;
			GeeMultiMap* _tmp8_;
			GeeCollection* _tmp9_ = NULL;
			GeeCollection* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_tmp2_ = _detail_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _detail_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			detail = (FolksAbstractFieldDetails*) _tmp5_;
			_tmp6_ = detail;
			_tmp7_ = folks_abstract_field_details_get_parameters (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_multi_map_get (_tmp8_, "x-evolution-ui-slot");
			_tmp10_ = _tmp9_;
			_tmp11_ = contacts_contact_get_first_string (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, "1") == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				FolksAbstractFieldDetails* _tmp14_;
				FolksAbstractFieldDetails* _tmp15_;
				_tmp14_ = detail;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				pref = g_list_prepend (pref, _tmp15_);
			} else {
				gboolean found;
				gboolean _tmp29_;
				found = FALSE;
				{
					FolksAbstractFieldDetails* _tmp16_;
					GeeMultiMap* _tmp17_;
					GeeMultiMap* _tmp18_;
					GeeCollection* _tmp19_ = NULL;
					GeeCollection* _tmp20_;
					GeeIterator* _tmp21_ = NULL;
					GeeIterator* _tmp22_;
					GeeIterator* _param_it;
					_tmp16_ = detail;
					_tmp17_ = folks_abstract_field_details_get_parameters (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = gee_multi_map_get (_tmp18_, "type");
					_tmp20_ = _tmp19_;
					_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
					_tmp22_ = _tmp21_;
					_g_object_unref0 (_tmp20_);
					_param_it = _tmp22_;
					while (TRUE) {
						GeeIterator* _tmp23_;
						gboolean _tmp24_ = FALSE;
						GeeIterator* _tmp25_;
						gpointer _tmp26_ = NULL;
						gchar* param;
						const gchar* _tmp27_;
						gint _tmp28_ = 0;
						_tmp23_ = _param_it;
						_tmp24_ = gee_iterator_next (_tmp23_);
						if (!_tmp24_) {
							break;
						}
						_tmp25_ = _param_it;
						_tmp26_ = gee_iterator_get (_tmp25_);
						param = (gchar*) _tmp26_;
						_tmp27_ = param;
						_tmp28_ = g_ascii_strcasecmp (_tmp27_, "PREF");
						if (_tmp28_ == 0) {
							found = TRUE;
							_g_free0 (param);
							break;
						}
						_g_free0 (param);
					}
					_g_object_unref0 (_param_it);
				}
				_tmp29_ = found;
				if (_tmp29_) {
					FolksAbstractFieldDetails* _tmp30_;
					FolksAbstractFieldDetails* _tmp31_;
					_tmp30_ = detail;
					_tmp31_ = _g_object_ref0 (_tmp30_);
					pref = g_list_prepend (pref, _tmp31_);
				} else {
					FolksAbstractFieldDetails* _tmp32_;
					FolksAbstractFieldDetails* _tmp33_;
					_tmp32_ = detail;
					_tmp33_ = _g_object_ref0 (_tmp32_);
					rest = g_list_prepend (rest, _tmp33_);
				}
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	pref = g_list_sort (pref, _contacts_contact_sort_fields_helper_gcompare_func);
	rest = g_list_sort (rest, _contacts_contact_sort_fields_helper_gcompare_func);
	_tmp34_ = rest;
	rest = NULL;
	pref = g_list_concat (pref, _tmp34_);
	result = pref;
	__g_list_free__g_object_unref0_0 (rest);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar* str = NULL;
	FolksPostalAddress* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp10_;
	FolksPostalAddress* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gboolean _tmp23_;
	FolksPostalAddress* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_;
	gboolean _tmp36_;
	FolksPostalAddress* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	gboolean _tmp49_;
	FolksPostalAddress* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gboolean _tmp57_ = FALSE;
	const gchar* _tmp58_;
	gboolean _tmp62_;
	FolksPostalAddress* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gboolean _tmp70_ = FALSE;
	const gchar* _tmp71_;
	gboolean _tmp75_;
	FolksPostalAddress* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gboolean _tmp83_ = FALSE;
	const gchar* _tmp84_;
	gboolean _tmp88_;
	FolksPostalAddress* _tmp92_;
	const gchar* _tmp93_;
	const gchar* _tmp94_;
	gchar* _tmp95_;
	gboolean _tmp96_ = FALSE;
	const gchar* _tmp97_;
	gboolean _tmp101_;
	gchar** _tmp105_;
	gint _tmp105__length1;
	g_return_val_if_fail (addr != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp1_ = addr;
	_tmp2_ = folks_postal_address_get_street (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (str);
	str = _tmp4_;
	_tmp6_ = str;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = str;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ > 0;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp10_ = _tmp5_;
	if (_tmp10_) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = lines;
		_tmp11__length1 = lines_length1;
		_tmp12_ = str;
		_tmp13_ = g_strdup (_tmp12_);
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp13_);
	}
	_tmp14_ = addr;
	_tmp15_ = folks_postal_address_get_extension (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (str);
	str = _tmp17_;
	_tmp19_ = str;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = str;
		_tmp21_ = strlen (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp23_ = _tmp18_;
	if (_tmp23_) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp24_ = lines;
		_tmp24__length1 = lines_length1;
		_tmp25_ = str;
		_tmp26_ = g_strdup (_tmp25_);
		_vala_array_add2 (&lines, &lines_length1, &_lines_size_, _tmp26_);
	}
	_tmp27_ = addr;
	_tmp28_ = folks_postal_address_get_locality (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup (_tmp29_);
	_g_free0 (str);
	str = _tmp30_;
	_tmp32_ = str;
	if (_tmp32_ != NULL) {
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp33_ = str;
		_tmp34_ = strlen (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_ > 0;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp36_ = _tmp31_;
	if (_tmp36_) {
		gchar** _tmp37_;
		gint _tmp37__length1;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp37_ = lines;
		_tmp37__length1 = lines_length1;
		_tmp38_ = str;
		_tmp39_ = g_strdup (_tmp38_);
		_vala_array_add3 (&lines, &lines_length1, &_lines_size_, _tmp39_);
	}
	_tmp40_ = addr;
	_tmp41_ = folks_postal_address_get_region (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_strdup (_tmp42_);
	_g_free0 (str);
	str = _tmp43_;
	_tmp45_ = str;
	if (_tmp45_ != NULL) {
		const gchar* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp46_ = str;
		_tmp47_ = strlen (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp44_ = _tmp48_ > 0;
	} else {
		_tmp44_ = FALSE;
	}
	_tmp49_ = _tmp44_;
	if (_tmp49_) {
		gchar** _tmp50_;
		gint _tmp50__length1;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp50_ = lines;
		_tmp50__length1 = lines_length1;
		_tmp51_ = str;
		_tmp52_ = g_strdup (_tmp51_);
		_vala_array_add4 (&lines, &lines_length1, &_lines_size_, _tmp52_);
	}
	_tmp53_ = addr;
	_tmp54_ = folks_postal_address_get_postal_code (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strdup (_tmp55_);
	_g_free0 (str);
	str = _tmp56_;
	_tmp58_ = str;
	if (_tmp58_ != NULL) {
		const gchar* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		_tmp59_ = str;
		_tmp60_ = strlen (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp57_ = _tmp61_ > 0;
	} else {
		_tmp57_ = FALSE;
	}
	_tmp62_ = _tmp57_;
	if (_tmp62_) {
		gchar** _tmp63_;
		gint _tmp63__length1;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp63_ = lines;
		_tmp63__length1 = lines_length1;
		_tmp64_ = str;
		_tmp65_ = g_strdup (_tmp64_);
		_vala_array_add5 (&lines, &lines_length1, &_lines_size_, _tmp65_);
	}
	_tmp66_ = addr;
	_tmp67_ = folks_postal_address_get_po_box (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strdup (_tmp68_);
	_g_free0 (str);
	str = _tmp69_;
	_tmp71_ = str;
	if (_tmp71_ != NULL) {
		const gchar* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		_tmp72_ = str;
		_tmp73_ = strlen (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp70_ = _tmp74_ > 0;
	} else {
		_tmp70_ = FALSE;
	}
	_tmp75_ = _tmp70_;
	if (_tmp75_) {
		gchar** _tmp76_;
		gint _tmp76__length1;
		const gchar* _tmp77_;
		gchar* _tmp78_;
		_tmp76_ = lines;
		_tmp76__length1 = lines_length1;
		_tmp77_ = str;
		_tmp78_ = g_strdup (_tmp77_);
		_vala_array_add6 (&lines, &lines_length1, &_lines_size_, _tmp78_);
	}
	_tmp79_ = addr;
	_tmp80_ = folks_postal_address_get_country (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = g_strdup (_tmp81_);
	_g_free0 (str);
	str = _tmp82_;
	_tmp84_ = str;
	if (_tmp84_ != NULL) {
		const gchar* _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		_tmp85_ = str;
		_tmp86_ = strlen (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp83_ = _tmp87_ > 0;
	} else {
		_tmp83_ = FALSE;
	}
	_tmp88_ = _tmp83_;
	if (_tmp88_) {
		gchar** _tmp89_;
		gint _tmp89__length1;
		const gchar* _tmp90_;
		gchar* _tmp91_;
		_tmp89_ = lines;
		_tmp89__length1 = lines_length1;
		_tmp90_ = str;
		_tmp91_ = g_strdup (_tmp90_);
		_vala_array_add7 (&lines, &lines_length1, &_lines_size_, _tmp91_);
	}
	_tmp92_ = addr;
	_tmp93_ = folks_postal_address_get_address_format (_tmp92_);
	_tmp94_ = _tmp93_;
	_tmp95_ = g_strdup (_tmp94_);
	_g_free0 (str);
	str = _tmp95_;
	_tmp97_ = str;
	if (_tmp97_ != NULL) {
		const gchar* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		_tmp98_ = str;
		_tmp99_ = strlen (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp96_ = _tmp100_ > 0;
	} else {
		_tmp96_ = FALSE;
	}
	_tmp101_ = _tmp96_;
	if (_tmp101_) {
		gchar** _tmp102_;
		gint _tmp102__length1;
		const gchar* _tmp103_;
		gchar* _tmp104_;
		_tmp102_ = lines;
		_tmp102__length1 = lines_length1;
		_tmp103_ = str;
		_tmp104_ = g_strdup (_tmp103_);
		_vala_array_add8 (&lines, &lines_length1, &_lines_size_, _tmp104_);
	}
	_tmp105_ = lines;
	_tmp105__length1 = lines_length1;
	if (result_length1) {
		*result_length1 = _tmp105__length1;
	}
	result = _tmp105_;
	_g_free0 (str);
	return result;
}


TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	TpfPersona* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* iid;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_tmp0_ = protocol;
	_tmp1_ = g_strconcat (_tmp0_, ":", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = im_address;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	iid = _tmp5_;
	{
		FolksIndividual* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _p_it;
		_tmp6_ = self->individual;
		_tmp7_ = folks_individual_get_personas (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_p_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp14_;
			TpfPersona* _tmp15_;
			TpfPersona* tp;
			gboolean _tmp16_ = FALSE;
			TpfPersona* _tmp17_;
			gboolean _tmp22_;
			_tmp10_ = _p_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _p_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			p = (FolksPersona*) _tmp13_;
			_tmp14_ = p;
			_tmp15_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp14_) ? ((TpfPersona*) _tmp14_) : NULL);
			tp = _tmp15_;
			_tmp17_ = tp;
			if (_tmp17_ != NULL) {
				TpfPersona* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp18_ = tp;
				_tmp19_ = folks_persona_get_iid ((FolksPersona*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = iid;
				_tmp16_ = g_strcmp0 (_tmp20_, _tmp21_) == 0;
			} else {
				_tmp16_ = FALSE;
			}
			_tmp22_ = _tmp16_;
			if (_tmp22_) {
				result = tp;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				_g_free0 (iid);
				return result;
			}
			_g_object_unref0 (tp);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	_g_free0 (iid);
	return result;
}


gchar* contacts_contact_format_im_name (ContactsContact* self, const gchar* protocol, const gchar* id) {
	gchar* result = NULL;
	gchar* service;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpfPersona* _tmp2_ = NULL;
	TpfPersona* persona;
	TpfPersona* _tmp3_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp17_;
	static const ContactsContactImData data[] = {{"google-talk", "Google Talk"}, {"ovi-chat", "Ovi Chat"}, {"facebook", "Facebook", CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE}, {"lj-talk", "Livejournal"}, {"aim", "AOL Instant Messenger"}, {"gadugadu", "Gadu-Gadu"}, {"groupwise", "Novell Groupwise"}, {"icq", "ICQ"}, {"irc", "IRC"}, {"jabber", "Jabber"}, {"local-xmpp", "Local network"}, {"msn", "Windows Live Messenger"}, {"myspace", "MySpace"}, {"mxit", "MXit"}, {"napster", "Napster"}, {"qq", "Tencent QQ"}, {"sametime", "IBM Lotus Sametime"}, {"silc", "SILC"}, {"sip", "sip"}, {"skype", "Skype"}, {"tel", "Telephony"}, {"trepia", "Trepia"}, {"yahoo", "Yahoo! Messenger"}, {"yahoojp", "Yahoo! Messenger"}, {"zephyr", "Zephyr"}};
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	service = NULL;
	_tmp0_ = protocol;
	_tmp1_ = id;
	_tmp2_ = contacts_contact_find_im_persona (self, _tmp0_, _tmp1_);
	persona = _tmp2_;
	_tmp3_ = persona;
	if (_tmp3_ != NULL) {
		TpfPersona* _tmp4_;
		FolksPersonaStore* _tmp5_;
		FolksPersonaStore* _tmp6_;
		TpAccount* _tmp7_;
		TpAccount* _tmp8_;
		TpAccount* _tmp9_;
		TpAccount* account;
		TpAccount* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp4_ = persona;
		_tmp5_ = folks_persona_get_store ((FolksPersona*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = tpf_persona_store_get_account (TPF_IS_PERSONA_STORE (_tmp6_) ? ((TpfPersonaStore*) _tmp6_) : NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		account = _tmp9_;
		_tmp10_ = account;
		_tmp11_ = tp_account_get_service (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (service);
		service = _tmp13_;
		_g_object_unref0 (account);
	}
	_tmp15_ = service;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = service;
		_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
	}
	_tmp17_ = _tmp14_;
	if (_tmp17_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = protocol;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (service);
		service = _tmp19_;
	}
	{
		ContactsContactImData* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = data;
		d_collection_length1 = G_N_ELEMENTS (data);
		for (d_it = 0; d_it < G_N_ELEMENTS (data); d_it = d_it + 1) {
			ContactsContactImData d = {0};
			d = d_collection[d_it];
			{
				ContactsContactImData _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp20_ = d;
				_tmp21_ = _tmp20_.service;
				_tmp22_ = service;
				if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
					ContactsContactImData _tmp23_;
					ContactsContactImDisplay _tmp24_;
					_tmp23_ = d;
					_tmp24_ = _tmp23_.display;
					switch (_tmp24_) {
						default:
						case CONTACTS_CONTACT_IM_DISPLAY_DEFAULT:
						{
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							ContactsContactImData _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_ = NULL;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							_tmp25_ = id;
							_tmp26_ = g_strconcat (_tmp25_, " (", NULL);
							_tmp27_ = _tmp26_;
							_tmp28_ = d;
							_tmp29_ = _tmp28_.display_name;
							_tmp30_ = g_dgettext (GETTEXT_PACKAGE, _tmp29_);
							_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_strconcat (_tmp32_, ")", NULL);
							_tmp34_ = _tmp33_;
							_g_free0 (_tmp32_);
							_g_free0 (_tmp27_);
							result = _tmp34_;
							_g_object_unref0 (persona);
							_g_free0 (service);
							return result;
						}
						case CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE:
						{
							TpfPersona* _tmp35_;
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							ContactsContactImData _tmp40_;
							const gchar* _tmp41_;
							const gchar* _tmp42_ = NULL;
							gchar* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							gchar* _tmp46_;
							_tmp35_ = persona;
							_tmp36_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = g_strconcat (_tmp37_, " (", NULL);
							_tmp39_ = _tmp38_;
							_tmp40_ = d;
							_tmp41_ = _tmp40_.display_name;
							_tmp42_ = g_dgettext (GETTEXT_PACKAGE, _tmp41_);
							_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
							_tmp44_ = _tmp43_;
							_tmp45_ = g_strconcat (_tmp44_, ")", NULL);
							_tmp46_ = _tmp45_;
							_g_free0 (_tmp44_);
							_g_free0 (_tmp39_);
							result = _tmp46_;
							_g_object_unref0 (persona);
							_g_free0 (service);
							return result;
						}
					}
				}
			}
		}
	}
	_tmp47_ = id;
	_tmp48_ = g_strconcat (_tmp47_, " (", NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = protocol;
	_tmp51_ = g_strconcat (_tmp49_, _tmp50_, NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strconcat (_tmp52_, ")", NULL);
	_tmp54_ = _tmp53_;
	_g_free0 (_tmp52_);
	_g_free0 (_tmp49_);
	result = _tmp54_;
	_g_object_unref0 (persona);
	_g_free0 (service);
	return result;
}


GtkWidget* contacts_contact_create_merged_presence_widget (ContactsContact* self) {
	GtkWidget* result = NULL;
	ContactsContactPresence* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_contact_presence_new (self);
	_tmp1_ = (GtkWidget*) g_object_ref_sink (_tmp0_);
	result = _tmp1_;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->last_class);
		_g_object_unref0 (_data2_->i);
		_g_object_unref0 (_data2_->tp);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda3_ (Block2Data* _data2_, GParamSpec* pspec) {
	ContactsContact * self;
	GtkImage* _tmp0_;
	TpfPersona* _tmp1_;
	FolksPresenceType _tmp2_;
	FolksPresenceType _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GtkImage* _tmp6_;
	GtkStyleContext* _tmp7_ = NULL;
	const gchar* _tmp8_;
	TpfPersona* _tmp9_;
	FolksPresenceType _tmp10_;
	FolksPresenceType _tmp11_;
	gchar* _tmp12_ = NULL;
	GtkImage* _tmp13_;
	GtkStyleContext* _tmp14_ = NULL;
	const gchar* _tmp15_;
	self = _data2_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _data2_->i;
	_tmp1_ = _data2_->tp;
	_tmp2_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_contact_presence_to_icon_full (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_image_set_from_icon_name (_tmp0_, _tmp5_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp5_);
	_tmp6_ = _data2_->i;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	_tmp8_ = _data2_->last_class;
	gtk_style_context_remove_class (_tmp7_, _tmp8_);
	_tmp9_ = _data2_->tp;
	_tmp10_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = contacts_contact_presence_to_class (_tmp11_);
	_g_free0 (_data2_->last_class);
	_data2_->last_class = _tmp12_;
	_tmp13_ = _data2_->i;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
	_tmp15_ = _data2_->last_class;
	gtk_style_context_add_class (_tmp14_, _tmp15_);
}


static void ___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda3_ (self, pspec);
}


static void __lambda4_ (Block2Data* _data2_, GParamSpec* pspec) {
	ContactsContact * self;
	GtkImage* _tmp0_;
	TpfPersona* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data2_->self;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _data2_->i;
	_tmp1_ = _data2_->tp;
	_tmp2_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp3_);
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ (self, pspec);
}


static void __lambda5_ (Block2Data* _data2_) {
	ContactsContact * self;
	TpfPersona* _tmp0_;
	gulong _tmp1_;
	TpfPersona* _tmp2_;
	gulong _tmp3_;
	self = _data2_->self;
	_tmp0_ = _data2_->tp;
	_tmp1_ = _data2_->id1;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data2_->tp;
	_tmp3_ = _data2_->id2;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _tmp3_);
}


static void ___lambda5__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda5_ (self);
}


GtkWidget* contacts_contact_create_presence_widget (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	GtkWidget* result = NULL;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpfPersona* _tmp2_ = NULL;
	TpfPersona* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	TpfPersona* _tmp7_;
	FolksPresenceType _tmp8_;
	FolksPresenceType _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	TpfPersona* _tmp12_;
	FolksPresenceType _tmp13_;
	FolksPresenceType _tmp14_;
	gchar* _tmp15_ = NULL;
	GtkImage* _tmp16_;
	GtkStyleContext* _tmp17_ = NULL;
	const gchar* _tmp18_;
	GtkImage* _tmp19_;
	TpfPersona* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	TpfPersona* _tmp23_;
	gulong _tmp24_ = 0UL;
	TpfPersona* _tmp25_;
	gulong _tmp26_ = 0UL;
	GtkImage* _tmp27_;
	GtkImage* _tmp28_;
	GtkWidget* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = protocol;
	_tmp1_ = im_address;
	_tmp2_ = contacts_contact_find_im_persona (self, _tmp0_, _tmp1_);
	_data2_->tp = _tmp2_;
	_tmp3_ = _data2_->tp;
	if (_tmp3_ == NULL) {
		result = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp4_ = (GtkImage*) gtk_image_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_data2_->i = _tmp5_;
	_tmp6_ = _data2_->i;
	_tmp7_ = _data2_->tp;
	_tmp8_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = contacts_contact_presence_to_icon_full (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_image_set_from_icon_name (_tmp6_, _tmp11_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp11_);
	_tmp12_ = _data2_->tp;
	_tmp13_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = contacts_contact_presence_to_class (_tmp14_);
	_data2_->last_class = _tmp15_;
	_tmp16_ = _data2_->i;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	_tmp18_ = _data2_->last_class;
	gtk_style_context_add_class (_tmp17_, _tmp18_);
	_tmp19_ = _data2_->i;
	_tmp20_ = _data2_->tp;
	_tmp21_ = folks_presence_details_get_presence_message ((FolksPresenceDetails*) _tmp20_);
	_tmp22_ = _tmp21_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _tmp22_);
	_tmp23_ = _data2_->tp;
	_tmp24_ = g_signal_connect_data ((GObject*) _tmp23_, "notify::presence-type", (GCallback) ___lambda3__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id1 = _tmp24_;
	_tmp25_ = _data2_->tp;
	_tmp26_ = g_signal_connect_data ((GObject*) _tmp25_, "notify::presence-message", (GCallback) ___lambda4__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id2 = _tmp26_;
	_tmp27_ = _data2_->i;
	g_signal_connect_data ((GtkWidget*) _tmp27_, "destroy", (GCallback) ___lambda5__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp28_ = _data2_->i;
	_tmp29_ = _g_object_ref0 ((GtkWidget*) _tmp28_);
	result = _tmp29_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static gboolean contacts_contact_changed_cb (ContactsContact* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->changed_id = (guint) 0;
	contacts_contact_update (self);
	g_signal_emit_by_name (self, "changed");
	result = FALSE;
	return result;
}


static void contacts_contact_unqueue_changed (ContactsContact* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->changed_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->changed_id;
		g_source_remove (_tmp1_);
		self->priv->changed_id = (guint) 0;
	}
}


static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_contact_changed_cb (self);
	return result;
}


static void contacts_contact_queue_changed (ContactsContact* self) {
	guint _tmp0_;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->changed_id;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _contacts_contact_changed_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->changed_id = _tmp1_;
}


static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = g_param_spec_get_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "avatar") == 0) {
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = NULL;
	}
	contacts_contact_queue_changed (self);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean contacts_contact_get_is_phone (FolksPersona* persona) {
	gboolean result = FALSE;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp;
	gboolean _tmp2_ = FALSE;
	TpfPersona* _tmp3_;
	gboolean _tmp7_;
	TpfPersona* _tmp8_;
	TpContact* _tmp9_;
	TpContact* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** types;
	gint types_length1;
	gint _types_size_;
	gboolean _tmp14_ = FALSE;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gboolean _tmp18_;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (TPF_IS_PERSONA (_tmp0_) ? ((TpfPersona*) _tmp0_) : NULL);
	tp = _tmp1_;
	_tmp3_ = tp;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		TpfPersona* _tmp4_;
		TpContact* _tmp5_;
		TpContact* _tmp6_;
		_tmp4_ = tp;
		_tmp5_ = tpf_persona_get_contact (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		result = FALSE;
		_g_object_unref0 (tp);
		return result;
	}
	_tmp8_ = tp;
	_tmp9_ = tpf_persona_get_contact (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = tp_contact_get_client_types (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	_tmp13_ = (_tmp12_ != NULL) ? _vala_array_dup1 (_tmp12_, _tmp12__length1) : ((gpointer) _tmp12_);
	_tmp13__length1 = _tmp12__length1;
	types = _tmp13_;
	types_length1 = _tmp13__length1;
	_types_size_ = types_length1;
	_tmp15_ = types;
	_tmp15__length1 = types_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		_tmp16_ = types;
		_tmp16__length1 = types_length1;
		_tmp17_ = _tmp16_[0];
		_tmp14_ = g_strcmp0 (_tmp17_, "phone") == 0;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp18_ = _tmp14_;
	result = _tmp18_;
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (tp);
	return result;
}


static void contacts_contact_update_presence (ContactsContact* self) {
	const gchar* _tmp37_;
	g_return_if_fail (self != NULL);
	_g_free0 (self->presence_message);
	self->presence_message = NULL;
	self->presence_type = FOLKS_PRESENCE_TYPE_UNSET;
	self->is_phone = FALSE;
	{
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp8_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			if (FOLKS_IS_PRESENCE_DETAILS (_tmp8_)) {
				FolksPersona* _tmp9_;
				FolksPresenceDetails* presence;
				FolksPersona* _tmp10_;
				gboolean _tmp11_ = FALSE;
				gboolean p_is_phone;
				gboolean _tmp12_ = FALSE;
				FolksPresenceDetails* _tmp13_;
				FolksPresenceType _tmp14_;
				FolksPresenceType _tmp15_;
				FolksPresenceType _tmp16_;
				gint _tmp17_ = 0;
				gboolean _tmp28_;
				_tmp9_ = p;
				presence = FOLKS_PRESENCE_DETAILS (_tmp9_);
				_tmp10_ = p;
				_tmp11_ = contacts_contact_get_is_phone (_tmp10_);
				p_is_phone = _tmp11_;
				_tmp13_ = presence;
				_tmp14_ = folks_presence_details_get_presence_type (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->presence_type;
				_tmp17_ = folks_presence_details_typecmp (_tmp15_, _tmp16_);
				if (_tmp17_ > 0) {
					_tmp12_ = TRUE;
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					FolksPresenceDetails* _tmp20_;
					FolksPresenceType _tmp21_;
					FolksPresenceType _tmp22_;
					FolksPresenceType _tmp23_;
					gboolean _tmp25_;
					gboolean _tmp27_;
					_tmp20_ = presence;
					_tmp21_ = folks_presence_details_get_presence_type (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = self->presence_type;
					if (_tmp22_ == _tmp23_) {
						gboolean _tmp24_;
						_tmp24_ = self->is_phone;
						_tmp19_ = _tmp24_;
					} else {
						_tmp19_ = FALSE;
					}
					_tmp25_ = _tmp19_;
					if (_tmp25_) {
						gboolean _tmp26_;
						_tmp26_ = p_is_phone;
						_tmp18_ = !_tmp26_;
					} else {
						_tmp18_ = FALSE;
					}
					_tmp27_ = _tmp18_;
					_tmp12_ = _tmp27_;
				}
				_tmp28_ = _tmp12_;
				if (_tmp28_) {
					FolksPresenceDetails* _tmp29_;
					FolksPresenceType _tmp30_;
					FolksPresenceType _tmp31_;
					FolksPresenceDetails* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gboolean _tmp36_;
					_tmp29_ = presence;
					_tmp30_ = folks_presence_details_get_presence_type (_tmp29_);
					_tmp31_ = _tmp30_;
					self->presence_type = _tmp31_;
					_tmp32_ = presence;
					_tmp33_ = folks_presence_details_get_presence_message (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strdup (_tmp34_);
					_g_free0 (self->presence_message);
					self->presence_message = _tmp35_;
					_tmp36_ = p_is_phone;
					self->is_phone = _tmp36_;
				}
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp37_ = self->presence_message;
	if (_tmp37_ == NULL) {
		gchar* _tmp38_;
		_tmp38_ = g_strdup ("");
		_g_free0 (self->presence_message);
		self->presence_message = _tmp38_;
	}
}


static void contacts_contact_update_filter_data (ContactsContact* self) {
	GString* _tmp0_;
	GString* builder;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FolksIndividual* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	FolksIndividual* _tmp31_;
	GeeMultiMap* _tmp32_;
	GeeMultiMap* _tmp33_;
	GeeMultiMap* _tmp34_;
	GeeMultiMap* im_addresses;
	FolksIndividual* _tmp53_;
	GeeSet* _tmp54_;
	GeeSet* _tmp55_;
	GeeSet* _tmp56_;
	GeeSet* emails;
	GString* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->individual;
	_tmp2_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		FolksIndividual* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GString* _tmp10_;
		_tmp4_ = builder;
		_tmp5_ = self->individual;
		_tmp6_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_utf8_casefold (_tmp7_, (gssize) (-1));
		_tmp9_ = _tmp8_;
		g_string_append (_tmp4_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = builder;
		g_string_append_unichar (_tmp10_, (gunichar) ' ');
	}
	_tmp11_ = self->individual;
	_tmp12_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		GString* _tmp14_;
		FolksIndividual* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GString* _tmp20_;
		_tmp14_ = builder;
		_tmp15_ = self->individual;
		_tmp16_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_utf8_casefold (_tmp17_, (gssize) (-1));
		_tmp19_ = _tmp18_;
		g_string_append (_tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = builder;
		g_string_append_unichar (_tmp20_, (gunichar) ' ');
	}
	_tmp21_ = self->individual;
	_tmp22_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		GString* _tmp24_;
		FolksIndividual* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		GString* _tmp30_;
		_tmp24_ = builder;
		_tmp25_ = self->individual;
		_tmp26_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_utf8_casefold (_tmp27_, (gssize) (-1));
		_tmp29_ = _tmp28_;
		g_string_append (_tmp24_, _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = builder;
		g_string_append_unichar (_tmp30_, (gunichar) ' ');
	}
	_tmp31_ = self->individual;
	_tmp32_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	im_addresses = _tmp34_;
	{
		GeeMultiMap* _tmp35_;
		GeeCollection* _tmp36_ = NULL;
		GeeCollection* _tmp37_;
		GeeIterator* _tmp38_ = NULL;
		GeeIterator* _tmp39_;
		GeeIterator* _detail_it;
		_tmp35_ = im_addresses;
		_tmp36_ = gee_multi_map_get_values (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
		_tmp39_ = _tmp38_;
		_g_object_unref0 (_tmp37_);
		_detail_it = _tmp39_;
		while (TRUE) {
			GeeIterator* _tmp40_;
			gboolean _tmp41_ = FALSE;
			GeeIterator* _tmp42_;
			gpointer _tmp43_ = NULL;
			FolksImFieldDetails* detail;
			FolksImFieldDetails* _tmp44_;
			gconstpointer _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* addr;
			GString* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_;
			GString* _tmp52_;
			_tmp40_ = _detail_it;
			_tmp41_ = gee_iterator_next (_tmp40_);
			if (!_tmp41_) {
				break;
			}
			_tmp42_ = _detail_it;
			_tmp43_ = gee_iterator_get (_tmp42_);
			detail = (FolksImFieldDetails*) _tmp43_;
			_tmp44_ = detail;
			_tmp45_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup ((const gchar*) _tmp46_);
			addr = _tmp47_;
			_tmp48_ = builder;
			_tmp49_ = addr;
			_tmp50_ = g_utf8_casefold (_tmp49_, (gssize) (-1));
			_tmp51_ = _tmp50_;
			g_string_append (_tmp48_, _tmp51_);
			_g_free0 (_tmp51_);
			_tmp52_ = builder;
			g_string_append_unichar (_tmp52_, (gunichar) ' ');
			_g_free0 (addr);
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	_tmp53_ = self->individual;
	_tmp54_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	emails = _tmp56_;
	{
		GeeSet* _tmp57_;
		GeeIterator* _tmp58_ = NULL;
		GeeIterator* _email_it;
		_tmp57_ = emails;
		_tmp58_ = gee_iterable_iterator ((GeeIterable*) _tmp57_);
		_email_it = _tmp58_;
		while (TRUE) {
			GeeIterator* _tmp59_;
			gboolean _tmp60_ = FALSE;
			GeeIterator* _tmp61_;
			gpointer _tmp62_ = NULL;
			FolksEmailFieldDetails* email;
			GString* _tmp63_;
			FolksEmailFieldDetails* _tmp64_;
			gconstpointer _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_;
			GString* _tmp69_;
			_tmp59_ = _email_it;
			_tmp60_ = gee_iterator_next (_tmp59_);
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = _email_it;
			_tmp62_ = gee_iterator_get (_tmp61_);
			email = (FolksEmailFieldDetails*) _tmp62_;
			_tmp63_ = builder;
			_tmp64_ = email;
			_tmp65_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_utf8_casefold ((const gchar*) _tmp66_, (gssize) (-1));
			_tmp68_ = _tmp67_;
			g_string_append (_tmp63_, _tmp68_);
			_g_free0 (_tmp68_);
			_tmp69_ = builder;
			g_string_append_unichar (_tmp69_, (gunichar) ' ');
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	_tmp70_ = builder;
	_tmp71_ = _tmp70_->str;
	_tmp72_ = g_strdup (_tmp71_);
	_g_free0 (self->priv->filter_data);
	self->priv->filter_data = _tmp72_;
	_g_object_unref0 (emails);
	_g_object_unref0 (im_addresses);
	_g_string_free0 (builder);
}


static void contacts_contact_update (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	{
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _email_it;
		_tmp0_ = self->individual;
		_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_email_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksEmailFieldDetails* email;
			ContactsTypeSet* _tmp8_;
			ContactsTypeSet* _tmp9_;
			FolksEmailFieldDetails* _tmp10_;
			_tmp4_ = _email_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _email_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			email = (FolksEmailFieldDetails*) _tmp7_;
			_tmp8_ = contacts_typeset_get_general ();
			_tmp9_ = _tmp8_;
			_tmp10_ = email;
			contacts_typeset_type_seen (_tmp9_, (FolksAbstractFieldDetails*) _tmp10_);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	{
		FolksIndividual* _tmp11_;
		GeeSet* _tmp12_;
		GeeSet* _tmp13_;
		GeeIterator* _tmp14_ = NULL;
		GeeIterator* _phone_it;
		_tmp11_ = self->individual;
		_tmp12_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_phone_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GeeIterator* _tmp17_;
			gpointer _tmp18_ = NULL;
			FolksPhoneFieldDetails* phone;
			ContactsTypeSet* _tmp19_;
			ContactsTypeSet* _tmp20_;
			FolksPhoneFieldDetails* _tmp21_;
			_tmp15_ = _phone_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _phone_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			phone = (FolksPhoneFieldDetails*) _tmp18_;
			_tmp19_ = contacts_typeset_get_phone ();
			_tmp20_ = _tmp19_;
			_tmp21_ = phone;
			contacts_typeset_type_seen (_tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
			_g_object_unref0 (phone);
		}
		_g_object_unref0 (_phone_it);
	}
	contacts_contact_update_presence (self);
	contacts_contact_update_filter_data (self);
}


static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GLoadableIcon* file) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* res;
	GLoadableIcon* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_contact_fallback_avatar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	res = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ != NULL) {
		{
			GCancellable* _tmp3_;
			GCancellable* c;
			GLoadableIcon* _tmp4_;
			GCancellable* _tmp5_;
			GInputStream* _tmp6_ = NULL;
			GInputStream* stream;
			GInputStream* _tmp7_;
			GCancellable* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			_tmp3_ = g_cancellable_new ();
			c = _tmp3_;
			_tmp4_ = file;
			_tmp5_ = c;
			_tmp6_ = g_loadable_icon_load (_tmp4_, 48, NULL, _tmp5_, &_inner_error_);
			stream = _tmp6_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (c);
				goto __catch0_g_error;
			}
			_tmp7_ = stream;
			_tmp8_ = c;
			_tmp9_ = gdk_pixbuf_new_from_stream_at_scale (_tmp7_, 48, 48, TRUE, _tmp8_, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stream);
				_g_object_unref0 (c);
				goto __catch0_g_error;
			}
			_g_object_unref0 (res);
			res = _tmp10_;
			_g_object_unref0 (stream);
			_g_object_unref0 (c);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = res;
	return result;
}


static void contacts_contact_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2) {
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean _tmp3_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	cairo_t* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	cairo_t* _tmp17_;
	g_return_if_fail (cr != NULL);
	_tmp1_ = xradius;
	if (_tmp1_ <= 0.0) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp2_;
		_tmp2_ = yradius;
		_tmp0_ = _tmp2_ <= 0.0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		cairo_t* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp4_ = cr;
		_tmp5_ = xc;
		_tmp6_ = yc;
		cairo_line_to (_tmp4_, _tmp5_, _tmp6_);
		return;
	}
	_tmp7_ = cr;
	cairo_save (_tmp7_);
	_tmp8_ = cr;
	_tmp9_ = xc;
	_tmp10_ = yc;
	cairo_translate (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = cr;
	_tmp12_ = xradius;
	_tmp13_ = yradius;
	cairo_scale (_tmp11_, _tmp12_, _tmp13_);
	_tmp14_ = cr;
	_tmp15_ = angle1;
	_tmp16_ = angle2;
	cairo_arc (_tmp14_, (gdouble) 0, (gdouble) 0, 1.0, _tmp15_, _tmp16_);
	_tmp17_ = cr;
	cairo_restore (_tmp17_);
}


static void contacts_contact_rounded_box_path (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	cairo_t* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	cairo_t* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_new_sub_path (_tmp0_);
	_tmp1_ = cr;
	_tmp2_ = x;
	_tmp3_ = radius;
	_tmp4_ = y;
	_tmp5_ = radius;
	_tmp6_ = radius;
	_tmp7_ = radius;
	contacts_contact_cairo_ellipsis (_tmp1_, (gdouble) (_tmp2_ + _tmp3_), (gdouble) (_tmp4_ + _tmp5_), (gdouble) _tmp6_, (gdouble) _tmp7_, G_PI, (3 * G_PI) / 2);
	_tmp8_ = cr;
	_tmp9_ = x;
	_tmp10_ = width;
	_tmp11_ = radius;
	_tmp12_ = y;
	_tmp13_ = radius;
	_tmp14_ = radius;
	_tmp15_ = radius;
	contacts_contact_cairo_ellipsis (_tmp8_, (gdouble) ((_tmp9_ + _tmp10_) - _tmp11_), (gdouble) (_tmp12_ + _tmp13_), (gdouble) _tmp14_, (gdouble) _tmp15_, (-G_PI) / 2, (gdouble) 0);
	_tmp16_ = cr;
	_tmp17_ = x;
	_tmp18_ = width;
	_tmp19_ = radius;
	_tmp20_ = y;
	_tmp21_ = height;
	_tmp22_ = radius;
	_tmp23_ = radius;
	_tmp24_ = radius;
	contacts_contact_cairo_ellipsis (_tmp16_, (gdouble) ((_tmp17_ + _tmp18_) - _tmp19_), (gdouble) ((_tmp20_ + _tmp21_) - _tmp22_), (gdouble) _tmp23_, (gdouble) _tmp24_, (gdouble) 0, G_PI / 2);
	_tmp25_ = cr;
	_tmp26_ = x;
	_tmp27_ = radius;
	_tmp28_ = y;
	_tmp29_ = height;
	_tmp30_ = radius;
	_tmp31_ = radius;
	_tmp32_ = radius;
	contacts_contact_cairo_ellipsis (_tmp25_, (gdouble) (_tmp26_ + _tmp27_), (gdouble) ((_tmp28_ + _tmp29_) - _tmp30_), (gdouble) _tmp31_, (gdouble) _tmp32_, G_PI / 2, G_PI);
}


static GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon) {
	GdkPixbuf* result = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* cst;
	cairo_t* _tmp1_;
	cairo_t* cr;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_;
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 52, 52);
	cst = _tmp0_;
	_tmp1_ = cairo_create (cst);
	cr = _tmp1_;
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) 52, (gdouble) 52);
	cairo_fill (cr);
	_tmp2_ = icon;
	gdk_cairo_set_source_pixbuf (cr, _tmp2_, (gdouble) 2, (gdouble) 2);
	cairo_paint (cr);
	contacts_contact_rounded_box_path (cr, 0, 0, 52, 52, 5);
	contacts_contact_rounded_box_path (cr, 2, 2, 48, 48, 3);
	cairo_set_source_rgb (cr, 0.533333, 0.541176, 0.521568);
	cairo_set_fill_rule (cr, CAIRO_FILL_RULE_EVEN_ODD);
	cairo_fill (cr);
	_tmp3_ = gdk_pixbuf_get_from_surface (cst, 0, 0, 52, 52);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size) {
	GdkPixbuf* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* cst;
	cairo_t* _tmp3_;
	cairo_t* cr;
	gint _tmp8_;
	gint _tmp9_;
	GdkPixbuf* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_;
	GError * _inner_error_ = NULL;
	_tmp0_ = size;
	_tmp1_ = size;
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp0_, _tmp1_);
	cst = _tmp2_;
	_tmp3_ = cairo_create (cst);
	cr = _tmp3_;
	{
		GtkIconTheme* _tmp4_ = NULL;
		gint _tmp5_;
		GtkIconInfo* _tmp6_ = NULL;
		GtkIconInfo* icon_info;
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* image;
		_tmp4_ = gtk_icon_theme_get_default ();
		_tmp5_ = size;
		_tmp6_ = gtk_icon_theme_lookup_icon (_tmp4_, "avatar-default", _tmp5_, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		icon_info = _tmp6_;
		_tmp7_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
		image = _tmp7_;
		if (_inner_error_ != NULL) {
			_gtk_icon_info_free0 (icon_info);
			goto __catch1_g_error;
		}
		if (image != NULL) {
			gdk_cairo_set_source_pixbuf (cr, image, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
		}
		_g_object_unref0 (image);
		_gtk_icon_info_free0 (icon_info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (cst);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = size;
	_tmp9_ = size;
	_tmp10_ = gdk_pixbuf_get_from_surface (cst, 0, 0, _tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


gchar* contacts_contact_format_uri_link_text (FolksUrlFieldDetails* detail) {
	gchar* result = NULL;
	FolksUrlFieldDetails* _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* uri;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (detail != NULL, NULL);
	_tmp0_ = detail;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	uri = _tmp3_;
	_tmp5_ = uri;
	_tmp6_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_0, "https?:\\/\\/www.facebook.com\\/profile\\.php\\?id=[0-9]+$", 0), _tmp5_, 0, NULL);
	if (_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = uri;
		_tmp8_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_1, "https?:\\/\\/www.facebook.com\\/[a-zA-Z0-9]+$", 0), _tmp7_, 0, NULL);
		_tmp4_ = _tmp8_;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp10_ = _ ("Facebook");
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		_g_free0 (uri);
		return result;
	}
	_tmp12_ = uri;
	_tmp13_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_2, "https?:\\/\\/twitter.com\\/#!\\/[a-zA-Z0-9]+$", 0), _tmp12_, 0, NULL);
	if (_tmp13_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = _ ("Twitter");
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_free0 (uri);
		return result;
	}
	result = uri;
	return result;
}


static void contacts_contact_ensure_writable_persona_data_free (gpointer _data) {
	ContactsContactEnsureWritablePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactEnsureWritablePersonaData, _data_);
}


void contacts_contact_ensure_writable_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactEnsureWritablePersonaData* _data_;
	ContactsContact* _tmp0_;
	_data_ = g_slice_new0 (ContactsContactEnsureWritablePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_contact_ensure_writable_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_contact_ensure_writable_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_contact_ensure_writable_persona_co (_data_);
}


FolksPersona* contacts_contact_ensure_writable_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsContactEnsureWritablePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean contacts_contact_ensure_writable_persona_co (ContactsContactEnsureWritablePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = contacts_contact_find_writable_persona (_data_->self);
	_data_->p = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->p;
	if (_data_->_tmp1_ != NULL) {
		_data_->result = _data_->p;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->p;
	g_print ("new writable persona: %p\n", _data_->_tmp2_);
	_data_->_tmp3_ = g_error_new_literal (CONTACT_ERROR, CONTACT_ERROR_NOT_IMPLEMENTED, "Not implemented yet");
	_data_->_inner_error_ = _data_->_tmp3_;
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	_g_object_unref0 (_data_->p);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->p);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


FolksPersona* contacts_contact_find_writable_persona (ContactsContact* self) {
	FolksPersona* result = NULL;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* primary_store;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->store;
	_tmp1_ = contacts_store_get_aggregator (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_individual_aggregator_get_primary_store (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	primary_store = _tmp5_;
	{
		FolksIndividual* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _persona_it;
		_tmp6_ = self->individual;
		_tmp7_ = folks_individual_get_personas (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_persona_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			FolksPersona* persona;
			FolksPersona* _tmp14_;
			FolksPersonaStore* _tmp15_;
			FolksPersonaStore* _tmp16_;
			FolksPersonaStore* _tmp17_;
			_tmp10_ = _persona_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _persona_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			persona = (FolksPersona*) _tmp13_;
			_tmp14_ = persona;
			_tmp15_ = folks_persona_get_store (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = primary_store;
			if (_tmp16_ == _tmp17_) {
				result = persona;
				_g_object_unref0 (_persona_it);
				_g_object_unref0 (primary_store);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	{
		FolksIndividual* _tmp18_;
		GeeSet* _tmp19_;
		GeeSet* _tmp20_;
		GeeIterator* _tmp21_ = NULL;
		GeeIterator* _persona_it;
		_tmp18_ = self->individual;
		_tmp19_ = folks_individual_get_personas (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_persona_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_;
			gboolean _tmp23_ = FALSE;
			GeeIterator* _tmp24_;
			gpointer _tmp25_ = NULL;
			FolksPersona* persona;
			FolksPersona* _tmp26_;
			FolksPersonaStore* _tmp27_;
			FolksPersonaStore* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			_tmp22_ = _persona_it;
			_tmp23_ = gee_iterator_next (_tmp22_);
			if (!_tmp23_) {
				break;
			}
			_tmp24_ = _persona_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			persona = (FolksPersona*) _tmp25_;
			_tmp26_ = persona;
			_tmp27_ = folks_persona_get_store (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = folks_persona_store_get_is_writeable (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				result = persona;
				_g_object_unref0 (_persona_it);
				_g_object_unref0 (primary_store);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	result = NULL;
	_g_object_unref0 (primary_store);
	return result;
}


GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_avatar;
	if (_tmp0_ == NULL) {
		FolksIndividual* _tmp1_;
		GLoadableIcon* _tmp2_;
		GLoadableIcon* _tmp3_;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_ = NULL;
		_tmp1_ = self->individual;
		_tmp2_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = contacts_contact_load_icon (self, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = contacts_contact_frame_icon (_tmp5_);
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp7_ = self->priv->_avatar;
	result = _tmp7_;
	return result;
}


const gchar* contacts_contact_get_display_name (ContactsContact* self) {
	const gchar* result;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* name;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp8_;
	FolksIndividual* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* alias;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->individual;
	_tmp1_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	name = _tmp2_;
	_tmp4_ = name;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = name;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		_tmp9_ = name;
		result = _tmp9_;
		return result;
	}
	_tmp10_ = self->individual;
	_tmp11_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp10_);
	_tmp12_ = _tmp11_;
	alias = _tmp12_;
	_tmp14_ = alias;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp15_ = alias;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ > 0;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp18_ = _tmp13_;
	if (_tmp18_) {
		FolksIndividual* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = self->individual;
		_tmp20_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp19_);
		_tmp21_ = _tmp20_;
		result = _tmp21_;
		return result;
	}
	{
		FolksIndividual* _tmp22_;
		GeeSet* _tmp23_;
		GeeSet* _tmp24_;
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _email_it;
		_tmp22_ = self->individual;
		_tmp23_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
		_email_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_;
			gboolean _tmp27_ = FALSE;
			GeeIterator* _tmp28_;
			gpointer _tmp29_ = NULL;
			FolksEmailFieldDetails* email;
			FolksEmailFieldDetails* _tmp30_;
			gconstpointer _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* e;
			gboolean _tmp34_ = FALSE;
			const gchar* _tmp35_;
			gboolean _tmp39_;
			_tmp26_ = _email_it;
			_tmp27_ = gee_iterator_next (_tmp26_);
			if (!_tmp27_) {
				break;
			}
			_tmp28_ = _email_it;
			_tmp29_ = gee_iterator_get (_tmp28_);
			email = (FolksEmailFieldDetails*) _tmp29_;
			_tmp30_ = email;
			_tmp31_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup ((const gchar*) _tmp32_);
			e = _tmp33_;
			_tmp35_ = e;
			if (_tmp35_ != NULL) {
				const gchar* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				_tmp36_ = e;
				_tmp37_ = strlen (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp34_ = _tmp38_ > 0;
			} else {
				_tmp34_ = FALSE;
			}
			_tmp39_ = _tmp34_;
			if (_tmp39_) {
				FolksEmailFieldDetails* _tmp40_;
				gconstpointer _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = email;
				_tmp41_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp40_);
				_tmp42_ = _tmp41_;
				result = (const gchar*) _tmp42_;
				_g_free0 (e);
				_g_object_unref0 (email);
				_g_object_unref0 (_email_it);
				return result;
			}
			_g_free0 (e);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	result = "";
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gunichar contacts_contact_get_initial_letter (ContactsContact* self) {
	gunichar result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gunichar _tmp7_ = 0U;
	gunichar _tmp8_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = contacts_contact_get_display_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = (gunichar) 0;
		_g_free0 (name);
		return result;
	}
	_tmp6_ = name;
	_tmp7_ = string_get_char (_tmp6_, (glong) 0);
	_tmp8_ = g_unichar_totitle (_tmp7_);
	result = _tmp8_;
	_g_free0 (name);
	return result;
}


static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self) {
	ContactsContactImData* dup;
	dup = g_new0 (ContactsContactImData, 1);
	memcpy (dup, self, sizeof (ContactsContactImData));
	return dup;
}


static void contacts_contact_im_data_free (ContactsContactImData* self) {
	g_free (self);
}


static GType contacts_contact_im_data_get_type (void) {
	static volatile gsize contacts_contact_im_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_data_type_id__volatile)) {
		GType contacts_contact_im_data_type_id;
		contacts_contact_im_data_type_id = g_boxed_type_register_static ("ContactsContactImData", (GBoxedCopyFunc) contacts_contact_im_data_dup, (GBoxedFreeFunc) contacts_contact_im_data_free);
		g_once_init_leave (&contacts_contact_im_data_type_id__volatile, contacts_contact_im_data_type_id);
	}
	return contacts_contact_im_data_type_id__volatile;
}


static void contacts_contact_class_init (ContactsContactClass * klass) {
	GdkPixbuf* _tmp0_ = NULL;
	contacts_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_INITIAL_LETTER, g_param_spec_uint ("initial-letter", "initial-letter", "initial-letter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", CONTACTS_TYPE_CONTACT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = contacts_contact_draw_fallback_avatar (48);
	_g_object_unref0 (contacts_contact_fallback_avatar);
	contacts_contact_fallback_avatar = _tmp0_;
}


static void contacts_contact_instance_init (ContactsContact * self) {
	self->priv = CONTACTS_CONTACT_GET_PRIVATE (self);
}


static void contacts_contact_finalize (GObject* obj) {
	ContactsContact * self;
	self = CONTACTS_CONTACT (obj);
	_contacts_store_unref0 (self->store);
	_g_free0 (self->presence_message);
	_g_object_unref0 (self->individual);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->filter_data);
	G_OBJECT_CLASS (contacts_contact_parent_class)->finalize (obj);
}


GType contacts_contact_get_type (void) {
	static volatile gsize contacts_contact_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContact), 0, (GInstanceInitFunc) contacts_contact_instance_init, NULL };
		GType contacts_contact_type_id;
		contacts_contact_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsContact", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_type_id__volatile, contacts_contact_type_id);
	}
	return contacts_contact_type_id__volatile;
}


static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsContact * self;
	self = CONTACTS_CONTACT (object);
	switch (property_id) {
		case CONTACTS_CONTACT_AVATAR:
		g_value_set_object (value, contacts_contact_get_avatar (self));
		break;
		case CONTACTS_CONTACT_DISPLAY_NAME:
		g_value_set_string (value, contacts_contact_get_display_name (self));
		break;
		case CONTACTS_CONTACT_INITIAL_LETTER:
		g_value_set_uint (value, contacts_contact_get_initial_letter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



