/* contacts-store.c generated by valac 0.13.1.211-6e21, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;

#define CONTACTS_STORE_TYPE_CONTACT_DATA (contacts_store_contact_data_get_type ())
#define CONTACTS_STORE_CONTACT_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_STORE_TYPE_CONTACT_DATA, ContactsStoreContactData))
#define CONTACTS_STORE_CONTACT_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_STORE_TYPE_CONTACT_DATA, ContactsStoreContactDataClass))
#define CONTACTS_STORE_IS_CONTACT_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_STORE_TYPE_CONTACT_DATA))
#define CONTACTS_STORE_IS_CONTACT_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_STORE_TYPE_CONTACT_DATA))
#define CONTACTS_STORE_CONTACT_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_STORE_TYPE_CONTACT_DATA, ContactsStoreContactDataClass))

typedef struct _ContactsStoreContactData ContactsStoreContactData;
typedef struct _ContactsStoreContactDataClass ContactsStoreContactDataClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _ContactsStoreContactDataPrivate ContactsStoreContactDataPrivate;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _contacts_store_contact_data_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_contact_data_unref (var), NULL)))
typedef struct _ContactsStoreParamSpecContactData ContactsStoreParamSpecContactData;
typedef struct _ContactsParamSpecStore ContactsParamSpecStore;

struct _ContactsStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContactsStorePrivate * priv;
};

struct _ContactsStoreClass {
	GTypeClass parent_class;
	void (*finalize) (ContactsStore *self);
};

struct _ContactsStorePrivate {
	GtkListStore* list_store;
	FolksIndividualAggregator* _aggregator;
	GeeArrayList* contacts;
	gchar** filter_values;
	gint filter_values_length1;
	gint _filter_values_size_;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _ContactsStoreContactData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContactsStoreContactDataPrivate * priv;
	ContactsContact* contact;
	GtkTreeIter iter;
	gboolean visible;
	gboolean is_first;
};

struct _ContactsStoreContactDataClass {
	GTypeClass parent_class;
	void (*finalize) (ContactsStoreContactData *self);
};

struct _ContactsStoreParamSpecContactData {
	GParamSpec parent_instance;
};

struct _ContactsParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer contacts_store_parent_class = NULL;
static gpointer contacts_store_contact_data_parent_class = NULL;

gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
static gpointer contacts_store_contact_data_ref (gpointer instance);
static void contacts_store_contact_data_unref (gpointer instance);
static GParamSpec* contacts_store_param_spec_contact_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void contacts_store_value_set_contact_data (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void contacts_store_value_take_contact_data (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer contacts_store_value_get_contact_data (const GValue* value) G_GNUC_UNUSED;
static GType contacts_store_contact_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CONTACTS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_STORE, ContactsStorePrivate))
enum  {
	CONTACTS_STORE_DUMMY_PROPERTY
};
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
GType contacts_contact_get_type (void) G_GNUC_CONST;
static gint __lambda6_ (ContactsStore* self, GtkTreeModel* model, GtkTreeIter* iter_a, GtkTreeIter* iter_b);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static gint ___lambda6__gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void __lambda7_ (ContactsStore* self, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r);
void contacts_store_remove (ContactsStore* self, ContactsContact* c);
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
void contacts_store_add (ContactsStore* self, ContactsContact* c);
static void ___lambda7__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean contacts_store_apply_filter (ContactsStore* self, ContactsContact* contact);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
gboolean contacts_store_is_first (ContactsStore* self, GtkTreeIter* iter);
static ContactsStoreContactData* contacts_store_get_previous (ContactsStore* self, ContactsStoreContactData* data);
static ContactsStoreContactData* contacts_store_get_next (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_row_changed_no_resort (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_row_changed_resort (ContactsStore* self, ContactsStoreContactData* data);
static gboolean contacts_store_update_is_first (ContactsStore* self, ContactsStoreContactData* data, ContactsStoreContactData* previous);
gunichar contacts_contact_get_initial_letter (ContactsContact* self);
static void contacts_store_add_to_model (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_remove_from_model (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_update_visible (ContactsStore* self, ContactsStoreContactData* data);
static void contacts_store_refilter (ContactsStore* self);
void contacts_store_set_filter_values (ContactsStore* self, gchar** values, int values_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c);
static ContactsStoreContactData* contacts_store_lookup_data (ContactsStore* self, ContactsContact* c);
gboolean contacts_store_lookup_iter (ContactsStore* self, ContactsContact* c, GtkTreeIter* iter);
ContactsContact* contacts_store_find_contact_with_id (ContactsStore* self, const gchar* individual_id);
ContactsContact* contacts_store_find_contact_with_email (ContactsStore* self, const gchar* email_address);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona);
static ContactsStoreContactData* contacts_store_contact_data_new (void);
static ContactsStoreContactData* contacts_store_contact_data_construct (GType object_type);
static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self);
GtkTreeModel* contacts_store_get_model (ContactsStore* self);
enum  {
	CONTACTS_STORE_CONTACT_DATA_DUMMY_PROPERTY
};
static void contacts_store_contact_data_finalize (ContactsStoreContactData* obj);
static void contacts_store_finalize (ContactsStore* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gint __lambda6_ (ContactsStore* self, GtkTreeModel* model, GtkTreeIter* iter_a, GtkTreeIter* iter_b) {
	gint result = 0;
	ContactsContact* a = NULL;
	ContactsContact* b = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_ = 0;
	g_return_val_if_fail (model != NULL, 0);
	_tmp0_ = model;
	_tmp1_ = *iter_a;
	gtk_tree_model_get (_tmp0_, &_tmp1_, 0, &a, -1);
	_tmp2_ = model;
	_tmp3_ = *iter_b;
	gtk_tree_model_get (_tmp2_, &_tmp3_, 0, &b, -1);
	_tmp4_ = contacts_contact_get_display_name (a);
	_tmp5_ = _tmp4_;
	_tmp6_ = contacts_contact_get_display_name (b);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate (_tmp5_, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}


static gint ___lambda6__gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = __lambda6_ (self, model, a, b);
	return result;
}


static void __lambda7_ (ContactsStore* self, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r) {
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp6_;
			ContactsContact* _tmp7_ = NULL;
			ContactsContact* _tmp8_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp6_ = i;
			_tmp7_ = contacts_contact_from_individual (_tmp6_);
			_tmp8_ = _tmp7_;
			contacts_store_remove (self, _tmp8_);
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _i_it;
		_tmp9_ = added;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_i_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp15_;
			ContactsContact* _tmp16_;
			ContactsContact* c;
			ContactsContact* _tmp17_;
			_tmp11_ = _i_it;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _i_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			i = (FolksIndividual*) _tmp14_;
			_tmp15_ = i;
			_tmp16_ = contacts_contact_new (self, _tmp15_);
			c = _tmp16_;
			_tmp17_ = c;
			contacts_store_add (self, _tmp17_);
			_g_object_unref0 (c);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void ___lambda7__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	__lambda7_ (self, added, removed, message, actor, reason);
}


ContactsStore* contacts_store_construct (GType object_type) {
	ContactsStore* self = NULL;
	GtkListStore* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	self = (ContactsStore*) g_type_create_instance (object_type);
	_tmp0_ = gtk_list_store_new (2, CONTACTS_TYPE_CONTACT, G_TYPE_POINTER);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp0_;
	_tmp1_ = gee_array_list_new (CONTACTS_STORE_TYPE_CONTACT_DATA, (GBoxedCopyFunc) contacts_store_contact_data_ref, contacts_store_contact_data_unref, NULL);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp1_;
	_tmp2_ = self->priv->list_store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp2_, 0, ___lambda6__gtk_tree_iter_compare_func, contacts_store_ref (self), contacts_store_unref);
	_tmp3_ = self->priv->list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp3_, 0, GTK_SORT_ASCENDING);
	_tmp4_ = folks_individual_aggregator_new ();
	_tmp5_ = _tmp4_;
	contacts_store_set_aggregator (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_aggregator;
	g_signal_connect (_tmp6_, "individuals-changed", (GCallback) ___lambda7__folks_individual_aggregator_individuals_changed, self);
	_tmp7_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp7_, NULL, NULL);
	return self;
}


ContactsStore* contacts_store_new (void) {
	return contacts_store_construct (CONTACTS_TYPE_STORE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean contacts_store_apply_filter (ContactsStore* self, ContactsContact* contact) {
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	FolksIndividual* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ContactsContact* _tmp4_;
	FolksIndividual* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* personas;
	GeeSet* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* i;
	gboolean _tmp11_ = FALSE;
	GeeIterator* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp16_;
	gboolean _tmp34_ = FALSE;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gboolean _tmp37_;
	ContactsContact* _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gboolean _tmp40_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contact != NULL, FALSE);
	_tmp0_ = contact;
	_tmp1_ = _tmp0_->individual;
	_tmp2_ = folks_individual_get_is_user (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = contact;
	_tmp5_ = _tmp4_->individual;
	_tmp6_ = folks_individual_get_personas (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	personas = _tmp8_;
	_tmp9_ = personas;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	i = _tmp10_;
	_tmp12_ = i;
	_tmp13_ = gee_iterator_next (_tmp12_);
	if (_tmp13_) {
		GeeIterator* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = i;
		_tmp15_ = gee_iterator_has_next (_tmp14_);
		_tmp11_ = !_tmp15_;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = _tmp11_;
	if (_tmp16_) {
		GeeIterator* _tmp17_;
		gpointer _tmp18_ = NULL;
		FolksPersona* persona;
		FolksPersona* _tmp19_;
		FolksPersonaStore* _tmp20_;
		FolksPersonaStore* _tmp21_;
		FolksPersonaStore* _tmp22_;
		FolksPersonaStore* store;
		FolksPersonaStore* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gboolean _tmp26_ = FALSE;
		FolksPersonaStore* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp33_;
		_tmp17_ = i;
		_tmp18_ = gee_iterator_get (_tmp17_);
		persona = (FolksPersona*) _tmp18_;
		_tmp19_ = persona;
		_tmp20_ = folks_persona_get_store (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		store = _tmp22_;
		_tmp23_ = store;
		_tmp24_ = folks_persona_store_get_type_id (_tmp23_);
		_tmp25_ = _tmp24_;
		if (g_strcmp0 (_tmp25_, "key-file") == 0) {
			result = FALSE;
			_g_object_unref0 (store);
			_g_object_unref0 (persona);
			_g_object_unref0 (i);
			_g_object_unref0 (personas);
			return result;
		}
		_tmp27_ = store;
		_tmp28_ = folks_persona_store_get_type_id (_tmp27_);
		_tmp29_ = _tmp28_;
		if (g_strcmp0 (_tmp29_, "telepathy") == 0) {
			FolksPersonaStore* _tmp30_;
			FolksPersonaStoreTrust _tmp31_;
			FolksPersonaStoreTrust _tmp32_;
			_tmp30_ = store;
			_tmp31_ = folks_persona_store_get_trust_level (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp26_ = _tmp32_ == FOLKS_PERSONA_STORE_TRUST_NONE;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp33_ = _tmp26_;
		if (_tmp33_) {
			result = FALSE;
			_g_object_unref0 (store);
			_g_object_unref0 (persona);
			_g_object_unref0 (i);
			_g_object_unref0 (personas);
			return result;
		}
		_g_object_unref0 (store);
		_g_object_unref0 (persona);
	}
	_tmp35_ = self->priv->filter_values;
	_tmp35__length1 = self->priv->filter_values_length1;
	if (_tmp35_ == NULL) {
		_tmp34_ = TRUE;
	} else {
		gchar** _tmp36_;
		gint _tmp36__length1;
		_tmp36_ = self->priv->filter_values;
		_tmp36__length1 = self->priv->filter_values_length1;
		_tmp34_ = _tmp36__length1 == 0;
	}
	_tmp37_ = _tmp34_;
	if (_tmp37_) {
		result = TRUE;
		_g_object_unref0 (i);
		_g_object_unref0 (personas);
		return result;
	}
	_tmp38_ = contact;
	_tmp39_ = self->priv->filter_values;
	_tmp39__length1 = self->priv->filter_values_length1;
	_tmp40_ = contacts_contact_contains_strings (_tmp38_, _tmp39_, _tmp39__length1);
	result = _tmp40_;
	_g_object_unref0 (i);
	_g_object_unref0 (personas);
	return result;
}


gboolean contacts_store_is_first (ContactsStore* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	ContactsStoreContactData* data = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	ContactsStoreContactData* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, 1, &data, -1);
	_tmp2_ = data;
	if (_tmp2_ != NULL) {
		ContactsStoreContactData* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = data;
		_tmp4_ = _tmp3_->is_first;
		result = _tmp4_;
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _contacts_store_contact_data_ref0 (gpointer self) {
	return self ? contacts_store_contact_data_ref (self) : NULL;
}


static ContactsStoreContactData* contacts_store_get_previous (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* result = NULL;
	ContactsStoreContactData* previous;
	ContactsStoreContactData* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter iter;
	GtkListStore* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ContactsStoreContactData* _tmp6_;
	ContactsStoreContactData* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	previous = NULL;
	_tmp0_ = data;
	_tmp1_ = _tmp0_->iter;
	iter = _tmp1_;
	_tmp2_ = self->priv->list_store;
	_tmp3_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp2_, &iter);
	if (_tmp3_) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->list_store;
		_tmp5_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 1, &previous, -1);
	}
	_tmp6_ = previous;
	_tmp7_ = _contacts_store_contact_data_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static ContactsStoreContactData* contacts_store_get_next (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* result = NULL;
	ContactsStoreContactData* next;
	ContactsStoreContactData* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter iter;
	GtkListStore* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ContactsStoreContactData* _tmp6_;
	ContactsStoreContactData* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	next = NULL;
	_tmp0_ = data;
	_tmp1_ = _tmp0_->iter;
	iter = _tmp1_;
	_tmp2_ = self->priv->list_store;
	_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp2_, &iter);
	if (_tmp3_) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->list_store;
		_tmp5_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 1, &next, -1);
	}
	_tmp6_ = next;
	_tmp7_ = _contacts_store_contact_data_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void contacts_store_row_changed_no_resort (ContactsStore* self, ContactsStoreContactData* data) {
	GtkListStore* _tmp0_;
	ContactsStoreContactData* _tmp1_;
	GtkTreeIter _tmp2_;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* path;
	GtkListStore* _tmp4_;
	ContactsStoreContactData* _tmp5_;
	GtkTreeIter _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = data;
	_tmp2_ = _tmp1_->iter;
	_tmp3_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp0_, &_tmp2_);
	path = _tmp3_;
	_tmp4_ = self->priv->list_store;
	_tmp5_ = data;
	_tmp6_ = _tmp5_->iter;
	gtk_tree_model_row_changed ((GtkTreeModel*) _tmp4_, path, &_tmp6_);
	_gtk_tree_path_free0 (path);
}


static void contacts_store_row_changed_resort (ContactsStore* self, ContactsStoreContactData* data) {
	GtkListStore* _tmp0_;
	ContactsStoreContactData* _tmp1_;
	GtkTreeIter _tmp2_;
	ContactsStoreContactData* _tmp3_;
	ContactsContact* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = data;
	_tmp2_ = _tmp1_->iter;
	_tmp3_ = data;
	_tmp4_ = _tmp3_->contact;
	gtk_list_store_set (_tmp0_, &_tmp2_, 0, _tmp4_, -1);
}


static gboolean contacts_store_update_is_first (ContactsStore* self, ContactsStoreContactData* data, ContactsStoreContactData* previous) {
	gboolean result = FALSE;
	ContactsStoreContactData* _tmp0_;
	gboolean _tmp1_;
	gboolean old_is_first;
	ContactsStoreContactData* _tmp2_;
	gboolean _tmp15_;
	ContactsStoreContactData* _tmp16_;
	gboolean _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->is_first;
	old_is_first = _tmp1_;
	_tmp2_ = previous;
	if (_tmp2_ != NULL) {
		ContactsStoreContactData* _tmp3_;
		ContactsContact* _tmp4_;
		gunichar _tmp5_;
		gunichar _tmp6_;
		gunichar previous_initial;
		ContactsStoreContactData* _tmp7_;
		ContactsContact* _tmp8_;
		gunichar _tmp9_;
		gunichar _tmp10_;
		gunichar initial;
		ContactsStoreContactData* _tmp11_;
		gunichar _tmp12_;
		gunichar _tmp13_;
		_tmp3_ = previous;
		_tmp4_ = _tmp3_->contact;
		_tmp5_ = contacts_contact_get_initial_letter (_tmp4_);
		_tmp6_ = _tmp5_;
		previous_initial = _tmp6_;
		_tmp7_ = data;
		_tmp8_ = _tmp7_->contact;
		_tmp9_ = contacts_contact_get_initial_letter (_tmp8_);
		_tmp10_ = _tmp9_;
		initial = _tmp10_;
		_tmp11_ = data;
		_tmp12_ = previous_initial;
		_tmp13_ = initial;
		_tmp11_->is_first = _tmp12_ != _tmp13_;
	} else {
		ContactsStoreContactData* _tmp14_;
		_tmp14_ = data;
		_tmp14_->is_first = TRUE;
	}
	_tmp15_ = old_is_first;
	_tmp16_ = data;
	_tmp17_ = _tmp16_->is_first;
	if (_tmp15_ != _tmp17_) {
		ContactsStoreContactData* _tmp18_;
		_tmp18_ = data;
		contacts_store_row_changed_no_resort (self, _tmp18_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void contacts_store_add_to_model (ContactsStore* self, ContactsStoreContactData* data) {
	GtkListStore* _tmp0_;
	ContactsStoreContactData* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	ContactsStoreContactData* _tmp4_;
	GtkTreeIter _tmp5_;
	ContactsStoreContactData* _tmp6_;
	ContactsContact* _tmp7_;
	ContactsStoreContactData* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ContactsStoreContactData* _tmp10_;
	ContactsStoreContactData* _tmp11_;
	ContactsStoreContactData* _tmp12_ = NULL;
	ContactsStoreContactData* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = data;
	gtk_list_store_append (_tmp0_, &_tmp2_);
	_tmp1_->iter = _tmp2_;
	_tmp3_ = self->priv->list_store;
	_tmp4_ = data;
	_tmp5_ = _tmp4_->iter;
	_tmp6_ = data;
	_tmp7_ = _tmp6_->contact;
	_tmp8_ = data;
	gtk_list_store_set (_tmp3_, &_tmp5_, 0, _tmp7_, 1, _tmp8_, -1);
	_tmp10_ = data;
	_tmp11_ = data;
	_tmp12_ = contacts_store_get_previous (self, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = contacts_store_update_is_first (self, _tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	_contacts_store_contact_data_unref0 (_tmp13_);
	if (_tmp15_) {
		ContactsStoreContactData* _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = data;
		_tmp17_ = _tmp16_->is_first;
		_tmp9_ = _tmp17_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp18_ = _tmp9_;
	if (_tmp18_) {
		ContactsStoreContactData* _tmp19_;
		ContactsStoreContactData* _tmp20_ = NULL;
		ContactsStoreContactData* next;
		ContactsStoreContactData* _tmp21_;
		_tmp19_ = data;
		_tmp20_ = contacts_store_get_next (self, _tmp19_);
		next = _tmp20_;
		_tmp21_ = next;
		if (_tmp21_ != NULL) {
			ContactsStoreContactData* _tmp22_;
			ContactsStoreContactData* _tmp23_;
			_tmp22_ = next;
			_tmp23_ = data;
			contacts_store_update_is_first (self, _tmp22_, _tmp23_);
		}
		_contacts_store_contact_data_unref0 (next);
	}
}


static void contacts_store_remove_from_model (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* next;
	ContactsStoreContactData* _tmp0_;
	gboolean _tmp1_;
	GtkListStore* _tmp4_;
	ContactsStoreContactData* _tmp5_;
	GtkTreeIter _tmp6_;
	ContactsStoreContactData* _tmp7_;
	ContactsStoreContactData* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	next = NULL;
	_tmp0_ = data;
	_tmp1_ = _tmp0_->is_first;
	if (_tmp1_) {
		ContactsStoreContactData* _tmp2_;
		ContactsStoreContactData* _tmp3_ = NULL;
		_tmp2_ = data;
		_tmp3_ = contacts_store_get_next (self, _tmp2_);
		_contacts_store_contact_data_unref0 (next);
		next = _tmp3_;
	}
	_tmp4_ = self->priv->list_store;
	_tmp5_ = data;
	_tmp6_ = _tmp5_->iter;
	gtk_list_store_remove (_tmp4_, &_tmp6_);
	_tmp7_ = data;
	_tmp7_->is_first = FALSE;
	_tmp8_ = next;
	if (_tmp8_ != NULL) {
		ContactsStoreContactData* _tmp9_;
		ContactsStoreContactData* _tmp10_;
		ContactsStoreContactData* _tmp11_ = NULL;
		ContactsStoreContactData* _tmp12_;
		_tmp9_ = next;
		_tmp10_ = next;
		_tmp11_ = contacts_store_get_previous (self, _tmp10_);
		_tmp12_ = _tmp11_;
		contacts_store_update_is_first (self, _tmp9_, _tmp12_);
		_contacts_store_contact_data_unref0 (_tmp12_);
	}
	_contacts_store_contact_data_unref0 (next);
}


static void contacts_store_update_visible (ContactsStore* self, ContactsStoreContactData* data) {
	ContactsStoreContactData* _tmp0_;
	gboolean _tmp1_;
	gboolean was_visible;
	ContactsStoreContactData* _tmp2_;
	ContactsStoreContactData* _tmp3_;
	ContactsContact* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->visible;
	was_visible = _tmp1_;
	_tmp2_ = data;
	_tmp3_ = data;
	_tmp4_ = _tmp3_->contact;
	_tmp5_ = contacts_store_apply_filter (self, _tmp4_);
	_tmp2_->visible = _tmp5_;
	_tmp7_ = was_visible;
	if (!_tmp7_) {
		ContactsStoreContactData* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = data;
		_tmp9_ = _tmp8_->visible;
		_tmp6_ = _tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		ContactsStoreContactData* _tmp11_;
		_tmp11_ = data;
		contacts_store_add_to_model (self, _tmp11_);
	}
	_tmp13_ = was_visible;
	if (_tmp13_) {
		ContactsStoreContactData* _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = data;
		_tmp15_ = _tmp14_->visible;
		_tmp12_ = !_tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp16_ = _tmp12_;
	if (_tmp16_) {
		ContactsStoreContactData* _tmp17_;
		_tmp17_ = data;
		contacts_store_remove_from_model (self, _tmp17_);
	}
}


static void contacts_store_refilter (ContactsStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _d_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _d_size;
		gint _d_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_d_list = _tmp1_;
		_tmp2_ = _d_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_d_size = _tmp4_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsStoreContactData* d;
			ContactsStoreContactData* _tmp11_;
			_tmp5_ = _d_index;
			_d_index = _tmp5_ + 1;
			_tmp6_ = _d_index;
			_tmp7_ = _d_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _d_list;
			_tmp9_ = _d_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			d = (ContactsStoreContactData*) _tmp10_;
			_tmp11_ = d;
			contacts_store_update_visible (self, _tmp11_);
			_contacts_store_contact_data_unref0 (d);
		}
		_g_object_unref0 (_d_list);
	}
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void contacts_store_set_filter_values (ContactsStore* self, gchar** values, int values_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->filter_values = (_vala_array_free (self->priv->filter_values, self->priv->filter_values_length1, (GDestroyNotify) g_free), NULL);
	self->priv->filter_values = _tmp1_;
	self->priv->filter_values_length1 = _tmp1__length1;
	self->priv->_filter_values_size_ = self->priv->filter_values_length1;
	contacts_store_refilter (self);
}


static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_;
	ContactsStoreContactData* _tmp1_ = NULL;
	ContactsStoreContactData* data;
	ContactsStoreContactData* _tmp2_;
	gboolean _tmp3_;
	gboolean was_visible;
	ContactsStoreContactData* next;
	ContactsStoreContactData* _tmp4_;
	gboolean _tmp5_;
	ContactsStoreContactData* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp13_;
	ContactsContact* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = contacts_store_lookup_data (self, _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	_tmp3_ = _tmp2_->visible;
	was_visible = _tmp3_;
	next = NULL;
	_tmp4_ = data;
	_tmp5_ = _tmp4_->visible;
	if (_tmp5_) {
		ContactsStoreContactData* _tmp6_;
		ContactsStoreContactData* _tmp7_ = NULL;
		_tmp6_ = data;
		_tmp7_ = contacts_store_get_next (self, _tmp6_);
		_contacts_store_contact_data_unref0 (next);
		next = _tmp7_;
	}
	_tmp8_ = data;
	contacts_store_update_visible (self, _tmp8_);
	_tmp10_ = was_visible;
	if (_tmp10_) {
		ContactsStoreContactData* _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = data;
		_tmp12_ = _tmp11_->visible;
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp13_ = _tmp9_;
	if (_tmp13_) {
		ContactsStoreContactData* _tmp14_;
		ContactsStoreContactData* _tmp15_;
		ContactsStoreContactData* _tmp20_;
		ContactsStoreContactData* _tmp21_ = NULL;
		ContactsStoreContactData* _tmp22_;
		_tmp14_ = data;
		contacts_store_row_changed_resort (self, _tmp14_);
		_tmp15_ = next;
		if (_tmp15_ != NULL) {
			ContactsStoreContactData* _tmp16_;
			ContactsStoreContactData* _tmp17_;
			ContactsStoreContactData* _tmp18_ = NULL;
			ContactsStoreContactData* _tmp19_;
			_tmp16_ = next;
			_tmp17_ = next;
			_tmp18_ = contacts_store_get_previous (self, _tmp17_);
			_tmp19_ = _tmp18_;
			contacts_store_update_is_first (self, _tmp16_, _tmp19_);
			_contacts_store_contact_data_unref0 (_tmp19_);
		}
		_tmp20_ = data;
		_tmp21_ = contacts_store_get_next (self, _tmp20_);
		_contacts_store_contact_data_unref0 (next);
		next = _tmp21_;
		_tmp22_ = next;
		if (_tmp22_ != NULL) {
			ContactsStoreContactData* _tmp23_;
			ContactsStoreContactData* _tmp24_;
			_tmp23_ = next;
			_tmp24_ = data;
			contacts_store_update_is_first (self, _tmp23_, _tmp24_);
		}
	}
	_tmp25_ = c;
	g_signal_emit_by_name (self, "changed", _tmp25_);
	_contacts_store_contact_data_unref0 (next);
	_contacts_store_contact_data_unref0 (data);
}


static ContactsStoreContactData* contacts_store_lookup_data (ContactsStore* self, ContactsContact* c) {
	ContactsStoreContactData* result = NULL;
	ContactsContact* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	ContactsStoreContactData* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	_tmp0_ = c;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "contact-data");
	_tmp2_ = _contacts_store_contact_data_ref0 ((ContactsStoreContactData*) _tmp1_);
	result = _tmp2_;
	return result;
}


gboolean contacts_store_lookup_iter (ContactsStore* self, ContactsContact* c, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	ContactsStoreContactData* _tmp1_ = NULL;
	ContactsStoreContactData* data;
	GtkTreeIter _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = contacts_store_lookup_data (self, _tmp0_);
	data = _tmp1_;
	_tmp2_ = data->iter;
	_vala_iter = _tmp2_;
	_tmp3_ = data->visible;
	result = _tmp3_;
	_contacts_store_contact_data_unref0 (data);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


ContactsContact* contacts_store_find_contact_with_id (ContactsStore* self, const gchar* individual_id) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (individual_id != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _data_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _data_size;
		gint _data_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_data_list = _tmp1_;
		_tmp2_ = _data_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_data_size = _tmp4_;
		_data_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsStoreContactData* data;
			ContactsStoreContactData* _tmp11_;
			ContactsContact* _tmp12_;
			FolksIndividual* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp5_ = _data_index;
			_data_index = _tmp5_ + 1;
			_tmp6_ = _data_index;
			_tmp7_ = _data_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _data_list;
			_tmp9_ = _data_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			data = (ContactsStoreContactData*) _tmp10_;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->contact;
			_tmp13_ = _tmp12_->individual;
			_tmp14_ = folks_individual_get_id (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = individual_id;
			if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
				ContactsStoreContactData* _tmp17_;
				ContactsContact* _tmp18_;
				ContactsContact* _tmp19_;
				_tmp17_ = data;
				_tmp18_ = _tmp17_->contact;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				result = _tmp19_;
				_contacts_store_contact_data_unref0 (data);
				_g_object_unref0 (_data_list);
				return result;
			}
			_contacts_store_contact_data_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = NULL;
	return result;
}


ContactsContact* contacts_store_find_contact_with_email (ContactsStore* self, const gchar* email_address) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (email_address != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _data_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _data_size;
		gint _data_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_data_list = _tmp1_;
		_tmp2_ = _data_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_data_size = _tmp4_;
		_data_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsStoreContactData* data;
			ContactsStoreContactData* _tmp11_;
			ContactsContact* _tmp12_;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp5_ = _data_index;
			_data_index = _tmp5_ + 1;
			_tmp6_ = _data_index;
			_tmp7_ = _data_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _data_list;
			_tmp9_ = _data_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			data = (ContactsStoreContactData*) _tmp10_;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->contact;
			_tmp13_ = email_address;
			_tmp14_ = contacts_contact_has_email (_tmp12_, _tmp13_);
			if (_tmp14_) {
				ContactsStoreContactData* _tmp15_;
				ContactsContact* _tmp16_;
				ContactsContact* _tmp17_;
				_tmp15_ = data;
				_tmp16_ = _tmp15_->contact;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				result = _tmp17_;
				_contacts_store_contact_data_unref0 (data);
				_g_object_unref0 (_data_list);
				return result;
			}
			_contacts_store_contact_data_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = NULL;
	return result;
}


ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _data_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _data_size;
		gint _data_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_data_list = _tmp1_;
		_tmp2_ = _data_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_data_size = _tmp4_;
		_data_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsStoreContactData* data;
			ContactsStoreContactData* _tmp11_;
			ContactsContact* _tmp12_;
			FolksIndividual* _tmp13_;
			GeeSet* _tmp14_;
			GeeSet* _tmp15_;
			FolksPersona* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp5_ = _data_index;
			_data_index = _tmp5_ + 1;
			_tmp6_ = _data_index;
			_tmp7_ = _data_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _data_list;
			_tmp9_ = _data_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			data = (ContactsStoreContactData*) _tmp10_;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->contact;
			_tmp13_ = _tmp12_->individual;
			_tmp14_ = folks_individual_get_personas (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = persona;
			_tmp17_ = gee_collection_contains ((GeeCollection*) _tmp15_, _tmp16_);
			if (_tmp17_) {
				ContactsStoreContactData* _tmp18_;
				ContactsContact* _tmp19_;
				ContactsContact* _tmp20_;
				_tmp18_ = data;
				_tmp19_ = _tmp18_->contact;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				result = _tmp20_;
				_contacts_store_contact_data_unref0 (data);
				_g_object_unref0 (_data_list);
				return result;
			}
			_contacts_store_contact_data_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = NULL;
	return result;
}


static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_store_contact_changed_cb (self, _sender);
}


void contacts_store_add (ContactsStore* self, ContactsContact* c) {
	ContactsStoreContactData* _tmp0_;
	ContactsStoreContactData* data;
	ContactsContact* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsStoreContactData* _tmp4_;
	GeeArrayList* _tmp5_;
	ContactsContact* _tmp6_;
	ContactsContact* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = contacts_store_contact_data_new ();
	data = _tmp0_;
	_tmp1_ = c;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (data->contact);
	data->contact = _tmp2_;
	data->visible = FALSE;
	_tmp3_ = c;
	_tmp4_ = _contacts_store_contact_data_ref0 (data);
	g_object_set_data_full ((GObject*) _tmp3_, "contact-data", _tmp4_, contacts_store_contact_data_unref);
	_tmp5_ = self->priv->contacts;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, data);
	_tmp6_ = c;
	g_signal_connect (_tmp6_, "changed", (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self);
	contacts_store_update_visible (self, data);
	_tmp7_ = c;
	g_signal_emit_by_name (self, "added", _tmp7_);
	_contacts_store_contact_data_unref0 (data);
}


void contacts_store_remove (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_;
	guint _tmp1_ = 0U;
	ContactsContact* _tmp2_;
	ContactsStoreContactData* _tmp3_ = NULL;
	ContactsStoreContactData* data;
	ContactsStoreContactData* _tmp4_;
	gboolean _tmp5_;
	GeeArrayList* _tmp7_;
	ContactsStoreContactData* _tmp8_;
	gint _tmp9_ = 0;
	gint i;
	gint _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_ = NULL;
	ContactsStoreContactData* _tmp27_;
	ContactsContact* _tmp28_;
	ContactsContact* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self);
	_tmp2_ = c;
	_tmp3_ = contacts_store_lookup_data (self, _tmp2_);
	data = _tmp3_;
	_tmp4_ = data;
	_tmp5_ = _tmp4_->visible;
	if (_tmp5_) {
		ContactsStoreContactData* _tmp6_;
		_tmp6_ = data;
		contacts_store_remove_from_model (self, _tmp6_);
	}
	_tmp7_ = self->priv->contacts;
	_tmp8_ = data;
	_tmp9_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp7_, _tmp8_);
	i = _tmp9_;
	_tmp10_ = i;
	_tmp11_ = self->priv->contacts;
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp10_ != (_tmp13_ - 1)) {
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gpointer _tmp20_ = NULL;
		ContactsStoreContactData* _tmp21_;
		_tmp14_ = self->priv->contacts;
		_tmp15_ = i;
		_tmp16_ = self->priv->contacts;
		_tmp17_ = self->priv->contacts;
		_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp19_ - 1);
		_tmp21_ = (ContactsStoreContactData*) _tmp20_;
		gee_abstract_list_set ((GeeAbstractList*) _tmp14_, _tmp15_, _tmp21_);
		_contacts_store_contact_data_unref0 (_tmp21_);
	}
	_tmp22_ = self->priv->contacts;
	_tmp23_ = self->priv->contacts;
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp22_, _tmp25_ - 1);
	_tmp27_ = (ContactsStoreContactData*) _tmp26_;
	_contacts_store_contact_data_unref0 (_tmp27_);
	_tmp28_ = c;
	g_object_set_data_full ((GObject*) _tmp28_, "contact-data", NULL, NULL);
	_tmp29_ = c;
	g_signal_emit_by_name (self, "removed", _tmp29_);
	_contacts_store_contact_data_unref0 (data);
}


FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self) {
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}


static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value) {
	FolksIndividualAggregator* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_aggregator);
	self->priv->_aggregator = _tmp1_;
}


GtkTreeModel* contacts_store_get_model (ContactsStore* self) {
	GtkTreeModel* result;
	GtkListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->list_store;
	result = (GtkTreeModel*) _tmp0_;
	return result;
}


static ContactsStoreContactData* contacts_store_contact_data_construct (GType object_type) {
	ContactsStoreContactData* self = NULL;
	self = (ContactsStoreContactData*) g_type_create_instance (object_type);
	return self;
}


static ContactsStoreContactData* contacts_store_contact_data_new (void) {
	return contacts_store_contact_data_construct (CONTACTS_STORE_TYPE_CONTACT_DATA);
}


static void contacts_store_value_contact_data_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void contacts_store_value_contact_data_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		contacts_store_contact_data_unref (value->data[0].v_pointer);
	}
}


static void contacts_store_value_contact_data_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contacts_store_contact_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer contacts_store_value_contact_data_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* contacts_store_value_contact_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ContactsStoreContactData* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contacts_store_contact_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* contacts_store_value_contact_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ContactsStoreContactData** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contacts_store_contact_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* contacts_store_param_spec_contact_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ContactsStoreParamSpecContactData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTACTS_STORE_TYPE_CONTACT_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer contacts_store_value_get_contact_data (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_STORE_TYPE_CONTACT_DATA), NULL);
	return value->data[0].v_pointer;
}


static void contacts_store_value_set_contact_data (GValue* value, gpointer v_object) {
	ContactsStoreContactData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_STORE_TYPE_CONTACT_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_STORE_TYPE_CONTACT_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contacts_store_contact_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_contact_data_unref (old);
	}
}


static void contacts_store_value_take_contact_data (GValue* value, gpointer v_object) {
	ContactsStoreContactData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_STORE_TYPE_CONTACT_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_STORE_TYPE_CONTACT_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_contact_data_unref (old);
	}
}


static void contacts_store_contact_data_class_init (ContactsStoreContactDataClass * klass) {
	contacts_store_contact_data_parent_class = g_type_class_peek_parent (klass);
	CONTACTS_STORE_CONTACT_DATA_CLASS (klass)->finalize = contacts_store_contact_data_finalize;
}


static void contacts_store_contact_data_instance_init (ContactsStoreContactData * self) {
	self->ref_count = 1;
}


static void contacts_store_contact_data_finalize (ContactsStoreContactData* obj) {
	ContactsStoreContactData * self;
	self = CONTACTS_STORE_CONTACT_DATA (obj);
	_g_object_unref0 (self->contact);
}


static GType contacts_store_contact_data_get_type (void) {
	static volatile gsize contacts_store_contact_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_contact_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { contacts_store_value_contact_data_init, contacts_store_value_contact_data_free_value, contacts_store_value_contact_data_copy_value, contacts_store_value_contact_data_peek_pointer, "p", contacts_store_value_contact_data_collect_value, "p", contacts_store_value_contact_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreContactDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_contact_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStoreContactData), 0, (GInstanceInitFunc) contacts_store_contact_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType contacts_store_contact_data_type_id;
		contacts_store_contact_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContactsStoreContactData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&contacts_store_contact_data_type_id__volatile, contacts_store_contact_data_type_id);
	}
	return contacts_store_contact_data_type_id__volatile;
}


static gpointer contacts_store_contact_data_ref (gpointer instance) {
	ContactsStoreContactData* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void contacts_store_contact_data_unref (gpointer instance) {
	ContactsStoreContactData* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTACTS_STORE_CONTACT_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void contacts_value_store_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void contacts_value_store_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		contacts_store_unref (value->data[0].v_pointer);
	}
}


static void contacts_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contacts_store_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer contacts_value_store_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* contacts_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ContactsStore* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contacts_store_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* contacts_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ContactsStore** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contacts_store_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ContactsParamSpecStore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTACTS_TYPE_STORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer contacts_value_get_store (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_TYPE_STORE), NULL);
	return value->data[0].v_pointer;
}


void contacts_value_set_store (GValue* value, gpointer v_object) {
	ContactsStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contacts_store_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_unref (old);
	}
}


void contacts_value_take_store (GValue* value, gpointer v_object) {
	ContactsStore* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_store_unref (old);
	}
}


static void contacts_store_class_init (ContactsStoreClass * klass) {
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	CONTACTS_STORE_CLASS (klass)->finalize = contacts_store_finalize;
	g_type_class_add_private (klass, sizeof (ContactsStorePrivate));
	g_signal_new ("changed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("added", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("removed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
}


static void contacts_store_instance_init (ContactsStore * self) {
	self->priv = CONTACTS_STORE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void contacts_store_finalize (ContactsStore* obj) {
	ContactsStore * self;
	self = CONTACTS_STORE (obj);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->contacts);
	self->priv->filter_values = (_vala_array_free (self->priv->filter_values, self->priv->filter_values_length1, (GDestroyNotify) g_free), NULL);
}


GType contacts_store_get_type (void) {
	static volatile gsize contacts_store_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { contacts_value_store_init, contacts_value_store_free_value, contacts_value_store_copy_value, contacts_value_store_peek_pointer, "p", contacts_value_store_collect_value, "p", contacts_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType contacts_store_type_id;
		contacts_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContactsStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&contacts_store_type_id__volatile, contacts_store_type_id);
	}
	return contacts_store_type_id__volatile;
}


gpointer contacts_store_ref (gpointer instance) {
	ContactsStore* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void contacts_store_unref (gpointer instance) {
	ContactsStore* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTACTS_STORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



