/* ide-vala-index.c generated by valac 0.30.0, the Vala compiler
 * generated from ide-vala-index.vala, do not modify */

/* ide-vala-index.vala
 *
 * Copyright (C) 2015 Christian Hergert <christian@hergert.me>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * The point of Ide.ValaIndex is somewhat analogous to Clang's CXIndex.
 * It is the top-level container for everything you can do with vala
 * files for a particular context. Typically, you would have one index
 * per project. Therefore, we use the singleton-per-project nature of
 * Ide.Service (via Ide.ValaService) to keep an index-per-project.
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <ide.h>
#include <gtksourceview/gtksource.h>


#define IDE_TYPE_VALA_INDEX (ide_vala_index_get_type ())
#define IDE_VALA_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_INDEX, IdeValaIndex))
#define IDE_VALA_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_INDEX, IdeValaIndexClass))
#define IDE_IS_VALA_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_INDEX))
#define IDE_IS_VALA_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_INDEX))
#define IDE_VALA_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_INDEX, IdeValaIndexClass))

typedef struct _IdeValaIndex IdeValaIndex;
typedef struct _IdeValaIndexClass IdeValaIndexClass;
typedef struct _IdeValaIndexPrivate IdeValaIndexPrivate;

#define IDE_TYPE_VALA_SOURCE_FILE (ide_vala_source_file_get_type ())
#define IDE_VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_SOURCE_FILE, IdeValaSourceFile))
#define IDE_VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_SOURCE_FILE, IdeValaSourceFileClass))
#define IDE_IS_VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_SOURCE_FILE))
#define IDE_IS_VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_SOURCE_FILE))
#define IDE_VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_SOURCE_FILE, IdeValaSourceFileClass))

typedef struct _IdeValaSourceFile IdeValaSourceFile;
typedef struct _IdeValaSourceFileClass IdeValaSourceFileClass;

#define IDE_TYPE_VALA_DIAGNOSTICS (ide_vala_diagnostics_get_type ())
#define IDE_VALA_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_DIAGNOSTICS, IdeValaDiagnostics))
#define IDE_VALA_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_DIAGNOSTICS, IdeValaDiagnosticsClass))
#define IDE_IS_VALA_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_DIAGNOSTICS))
#define IDE_IS_VALA_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_DIAGNOSTICS))
#define IDE_VALA_DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_DIAGNOSTICS, IdeValaDiagnosticsClass))

typedef struct _IdeValaDiagnostics IdeValaDiagnostics;
typedef struct _IdeValaDiagnosticsClass IdeValaDiagnosticsClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _IdeValaIndexAddFilesData IdeValaIndexAddFilesData;
typedef struct _Block3Data Block3Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _IdeValaIndexParseFileData IdeValaIndexParseFileData;

#define IDE_TYPE_VALA_COMPLETION_PROVIDER (ide_vala_completion_provider_get_type ())
#define IDE_VALA_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_COMPLETION_PROVIDER, IdeValaCompletionProvider))
#define IDE_VALA_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_COMPLETION_PROVIDER, IdeValaCompletionProviderClass))
#define IDE_IS_VALA_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_COMPLETION_PROVIDER))
#define IDE_IS_VALA_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_COMPLETION_PROVIDER))
#define IDE_VALA_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_COMPLETION_PROVIDER, IdeValaCompletionProviderClass))

typedef struct _IdeValaCompletionProvider IdeValaCompletionProvider;
typedef struct _IdeValaCompletionProviderClass IdeValaCompletionProviderClass;
typedef struct _IdeValaCompletionProviderPrivate IdeValaCompletionProviderPrivate;

#define IDE_TYPE_VALA_LOCATOR (ide_vala_locator_get_type ())
#define IDE_VALA_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_LOCATOR, IdeValaLocator))
#define IDE_VALA_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_LOCATOR, IdeValaLocatorClass))
#define IDE_IS_VALA_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_LOCATOR))
#define IDE_IS_VALA_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_LOCATOR))
#define IDE_VALA_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_LOCATOR, IdeValaLocatorClass))

typedef struct _IdeValaLocator IdeValaLocator;
typedef struct _IdeValaLocatorClass IdeValaLocatorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _ide_diagnostics_unref0(var) ((var == NULL) ? NULL : (var = (ide_diagnostics_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _IdeValaIndexGetDiagnosticsData IdeValaIndexGetDiagnosticsData;

#define IDE_TYPE_VALA_COMPLETION (ide_vala_completion_get_type ())
#define IDE_VALA_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_COMPLETION, IdeValaCompletion))
#define IDE_VALA_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_COMPLETION, IdeValaCompletionClass))
#define IDE_IS_VALA_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_COMPLETION))
#define IDE_IS_VALA_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_COMPLETION))
#define IDE_VALA_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_COMPLETION, IdeValaCompletionClass))

typedef struct _IdeValaCompletion IdeValaCompletion;
typedef struct _IdeValaCompletionClass IdeValaCompletionClass;

#define IDE_TYPE_VALA_COMPLETION_ITEM (ide_vala_completion_item_get_type ())
#define IDE_VALA_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_COMPLETION_ITEM, IdeValaCompletionItem))
#define IDE_VALA_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_COMPLETION_ITEM, IdeValaCompletionItemClass))
#define IDE_IS_VALA_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_COMPLETION_ITEM))
#define IDE_IS_VALA_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_COMPLETION_ITEM))
#define IDE_VALA_COMPLETION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_COMPLETION_ITEM, IdeValaCompletionItemClass))

typedef struct _IdeValaCompletionItem IdeValaCompletionItem;
typedef struct _IdeValaCompletionItemClass IdeValaCompletionItemClass;
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _IdeValaIndexFindSymbolAtData IdeValaIndexFindSymbolAtData;
typedef struct _Block6Data Block6Data;

#define IDE_TYPE_VALA_SYMBOL_TREE_VISITOR (ide_vala_symbol_tree_visitor_get_type ())
#define IDE_VALA_SYMBOL_TREE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_SYMBOL_TREE_VISITOR, IdeValaSymbolTreeVisitor))
#define IDE_VALA_SYMBOL_TREE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_SYMBOL_TREE_VISITOR, IdeValaSymbolTreeVisitorClass))
#define IDE_IS_VALA_SYMBOL_TREE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_SYMBOL_TREE_VISITOR))
#define IDE_IS_VALA_SYMBOL_TREE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_SYMBOL_TREE_VISITOR))
#define IDE_VALA_SYMBOL_TREE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_SYMBOL_TREE_VISITOR, IdeValaSymbolTreeVisitorClass))

typedef struct _IdeValaSymbolTreeVisitor IdeValaSymbolTreeVisitor;
typedef struct _IdeValaSymbolTreeVisitorClass IdeValaSymbolTreeVisitorClass;
typedef struct _IdeValaIndexGetSymbolTreeData IdeValaIndexGetSymbolTreeData;

struct _IdeValaIndex {
	GObject parent_instance;
	IdeValaIndexPrivate * priv;
};

struct _IdeValaIndexClass {
	GObjectClass parent_class;
};

struct _IdeValaIndexPrivate {
	ValaCodeContext* code_context;
	GRecMutex __lock_code_context;
	ValaParser* parser;
	ValaHashMap* source_files;
	IdeValaDiagnostics* report;
};

struct _Block2Data {
	int _ref_count_;
	IdeValaIndex* self;
	ValaArrayList* files;
	gpointer _async_data_;
};

struct _IdeValaIndexAddFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	IdeValaIndex* self;
	ValaArrayList* files;
	GCancellable* cancellable;
	Block2Data* _data2_;
	ValaArrayList* _tmp0_;
};

struct _Block3Data {
	int _ref_count_;
	IdeValaIndex* self;
	GPtrArray* unsaved_files_copy;
	GFile* file;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _IdeValaIndexParseFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	IdeValaIndex* self;
	GFile* file;
	IdeUnsavedFiles* unsaved_files;
	GCancellable* cancellable;
	gboolean result;
	Block3Data* _data3_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	IdeUnsavedFiles* _tmp2_;
	IdeUnsavedFiles* _tmp3_;
	GPtrArray* _tmp4_;
};

struct _IdeValaCompletionProvider {
	IdeObject parent_instance;
	IdeValaCompletionProviderPrivate * priv;
	gchar* query;
};

struct _IdeValaCompletionProviderClass {
	IdeObjectClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	IdeValaIndex* self;
	IdeDiagnostics* diagnostics;
	GFile* file;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _IdeValaIndexGetDiagnosticsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	IdeValaIndex* self;
	GFile* file;
	GCancellable* cancellable;
	IdeDiagnostics* result;
	Block4Data* _data4_;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	IdeDiagnostics* _tmp2_;
};

struct _Block5Data {
	int _ref_count_;
	IdeValaIndex* self;
	ValaSymbol* symbol;
	GFile* file;
	gint line;
	gint column;
	gpointer _async_data_;
};

struct _IdeValaIndexFindSymbolAtData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	IdeValaIndex* self;
	GFile* file;
	gint line;
	gint column;
	ValaSymbol* result;
	Block5Data* _data5_;
	GFile* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaSymbol* _tmp3_;
};

struct _Block6Data {
	int _ref_count_;
	IdeValaIndex* self;
	IdeSymbolTree* ret;
	GFile* file;
	gpointer _async_data_;
};

struct _IdeValaIndexGetSymbolTreeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	IdeValaIndex* self;
	GFile* file;
	GCancellable* cancellable;
	IdeSymbolTree* result;
	Block6Data* _data6_;
	GFile* _tmp0_;
	IdeSymbolTree* _tmp1_;
};


static gpointer ide_vala_index_parent_class = NULL;
static GType ide_vala_index_type_id = 0;

GType ide_vala_index_get_type (void) G_GNUC_CONST;
GType ide_vala_index_register_type (GTypeModule * module);
GType ide_vala_source_file_get_type (void) G_GNUC_CONST;
GType ide_vala_source_file_register_type (GTypeModule * module);
GType ide_vala_diagnostics_get_type (void) G_GNUC_CONST;
GType ide_vala_diagnostics_register_type (GTypeModule * module);
#define IDE_VALA_INDEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IDE_TYPE_VALA_INDEX, IdeValaIndexPrivate))
enum  {
	IDE_VALA_INDEX_DUMMY_PROPERTY
};
IdeValaIndex* ide_vala_index_new (void);
IdeValaIndex* ide_vala_index_construct (GType object_type);
static guint _g_file_hash_ghash_func (gconstpointer key);
IdeValaDiagnostics* ide_vala_diagnostics_new (void);
IdeValaDiagnostics* ide_vala_diagnostics_construct (GType object_type);
static void ide_vala_index_add_file (IdeValaIndex* self, GFile* file);
IdeValaSourceFile* ide_vala_source_file_new (ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content, gboolean cmdline);
IdeValaSourceFile* ide_vala_source_file_construct (GType object_type, ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content, gboolean cmdline);
static void ide_vala_index_add_files_data_free (gpointer _data);
void ide_vala_index_add_files (IdeValaIndex* self, ValaArrayList* files, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void ide_vala_index_add_files_finish (IdeValaIndex* self, GAsyncResult* _res_);
static gboolean ide_vala_index_add_files_co (IdeValaIndexAddFilesData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_);
static gboolean _ide_vala_index_add_files_co_gsource_func (gpointer self);
static void ___lambda5__ide_thread_func (gpointer self);
static void ide_vala_index_parse_file_data_free (gpointer _data);
void ide_vala_index_parse_file (IdeValaIndex* self, GFile* file, IdeUnsavedFiles* unsaved_files, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean ide_vala_index_parse_file_finish (IdeValaIndex* self, GAsyncResult* _res_, GError** error);
static gboolean ide_vala_index_parse_file_co (IdeValaIndexParseFileData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_);
static void ide_vala_index_apply_unsaved_files (IdeValaIndex* self, GPtrArray* unsaved_files);
static void ide_vala_index_reparse (IdeValaIndex* self);
static gboolean _ide_vala_index_parse_file_co_gsource_func (gpointer self);
static void ___lambda6__ide_thread_func (gpointer self);
GType ide_vala_completion_provider_get_type (void) G_GNUC_CONST;
GType ide_vala_completion_provider_register_type (GTypeModule * module);
IdeCompletionResults* ide_vala_index_code_complete (IdeValaIndex* self, GFile* file, gint line, gint column, const gchar* line_text, IdeUnsavedFiles* unsaved_files, IdeValaCompletionProvider* provider, GCancellable* cancellable, gint* result_line, gint* result_column);
GType ide_vala_locator_get_type (void) G_GNUC_CONST;
GType ide_vala_locator_register_type (GTypeModule * module);
IdeValaLocator* ide_vala_locator_new (void);
IdeValaLocator* ide_vala_locator_construct (GType object_type);
ValaSymbol* ide_vala_locator_locate (IdeValaLocator* self, ValaSourceFile* file, gint line, gint column);
static void ide_vala_index_add_completions (IdeValaIndex* self, IdeValaSourceFile* source_file, gint* line, gint* column, const gchar* line_text, ValaSymbol* nearest, IdeCompletionResults* results, IdeValaCompletionProvider* provider);
static void ide_vala_index_get_diagnostics_data_free (gpointer _data);
void ide_vala_index_get_diagnostics (IdeValaIndex* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
IdeDiagnostics* ide_vala_index_get_diagnostics_finish (IdeValaIndex* self, GAsyncResult* _res_);
static gboolean ide_vala_index_get_diagnostics_co (IdeValaIndexGetDiagnosticsData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda10_ (Block4Data* _data4_);
IdeDiagnostics* ide_vala_source_file_diagnose (IdeValaSourceFile* self);
static gboolean _ide_vala_index_get_diagnostics_co_gsource_func (gpointer self);
static void ___lambda10__ide_thread_func (gpointer self);
void ide_vala_source_file_sync (IdeValaSourceFile* self, GPtrArray* unsaved_files);
void ide_vala_diagnostics_clear (IdeValaDiagnostics* self);
void ide_vala_source_file_set_dirty (IdeValaSourceFile* self, gboolean value);
GType ide_vala_completion_get_type (void) G_GNUC_CONST;
GType ide_vala_completion_register_type (GTypeModule * module);
IdeValaCompletion* ide_vala_completion_new (ValaCodeContext* context, ValaSourceLocation* location, const gchar* current_text, ValaBlock* nearest);
IdeValaCompletion* ide_vala_completion_construct (GType object_type, ValaCodeContext* context, ValaSourceLocation* location, const gchar* current_text, ValaBlock* nearest);
GList* ide_vala_completion_run (IdeValaCompletion* self, ValaSourceLocation* start_pos);
IdeValaCompletionItem* ide_vala_completion_item_new (ValaSymbol* symbol, IdeValaCompletionProvider* provider);
IdeValaCompletionItem* ide_vala_completion_item_construct (GType object_type, ValaSymbol* symbol, IdeValaCompletionProvider* provider);
GType ide_vala_completion_item_get_type (void) G_GNUC_CONST;
GType ide_vala_completion_item_register_type (GTypeModule * module);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static void ide_vala_index_find_symbol_at_data_free (gpointer _data);
void ide_vala_index_find_symbol_at (IdeValaIndex* self, GFile* file, gint line, gint column, GAsyncReadyCallback _callback_, gpointer _user_data_);
ValaSymbol* ide_vala_index_find_symbol_at_finish (IdeValaIndex* self, GAsyncResult* _res_);
static gboolean ide_vala_index_find_symbol_at_co (IdeValaIndexFindSymbolAtData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda11_ (Block5Data* _data5_);
static void ___lambda11__ide_thread_func (gpointer self);
static void ide_vala_index_get_symbol_tree_data_free (gpointer _data);
void ide_vala_index_get_symbol_tree (IdeValaIndex* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
IdeSymbolTree* ide_vala_index_get_symbol_tree_finish (IdeValaIndex* self, GAsyncResult* _res_, GError** error);
static gboolean ide_vala_index_get_symbol_tree_co (IdeValaIndexGetSymbolTreeData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda12_ (Block6Data* _data6_);
gboolean ide_vala_source_file_get_dirty (IdeValaSourceFile* self);
GType ide_vala_symbol_tree_visitor_get_type (void) G_GNUC_CONST;
GType ide_vala_symbol_tree_visitor_register_type (GTypeModule * module);
IdeValaSymbolTreeVisitor* ide_vala_symbol_tree_visitor_new (void);
IdeValaSymbolTreeVisitor* ide_vala_symbol_tree_visitor_construct (GType object_type);
IdeSymbolTree* ide_vala_symbol_tree_visitor_build_tree (IdeValaSymbolTreeVisitor* self);
static gboolean _ide_vala_index_get_symbol_tree_co_gsource_func (gpointer self);
static void ___lambda12__ide_thread_func (gpointer self);
static void ide_vala_index_finalize (GObject* obj);


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


IdeValaIndex* ide_vala_index_construct (GType object_type) {
	IdeValaIndex * self = NULL;
	GEqualFunc _tmp0_ = NULL;
	ValaHashMap* _tmp1_ = NULL;
	ValaCodeContext* _tmp2_ = NULL;
	ValaCodeContext* _tmp3_ = NULL;
	ValaCodeContext* _tmp4_ = NULL;
	ValaCodeContext* _tmp5_ = NULL;
	ValaCodeContext* _tmp6_ = NULL;
	ValaCodeContext* _tmp7_ = NULL;
	ValaCodeContext* _tmp8_ = NULL;
	ValaCodeContext* _tmp9_ = NULL;
	ValaCodeContext* _tmp10_ = NULL;
	ValaCodeContext* _tmp11_ = NULL;
	ValaCodeContext* _tmp12_ = NULL;
	ValaCodeContext* _tmp13_ = NULL;
	ValaCodeContext* _tmp14_ = NULL;
	ValaCodeContext* _tmp15_ = NULL;
	ValaCodeContext* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	ValaCodeContext* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	ValaCodeContext* _tmp22_ = NULL;
	ValaCodeContext* _tmp23_ = NULL;
	ValaCodeContext* _tmp24_ = NULL;
	ValaCodeContext* _tmp25_ = NULL;
	ValaCodeContext* _tmp26_ = NULL;
	ValaCodeContext* _tmp27_ = NULL;
	ValaCodeContext* _tmp28_ = NULL;
	ValaCodeContext* _tmp29_ = NULL;
	ValaCodeContext* _tmp44_ = NULL;
	ValaCodeContext* _tmp45_ = NULL;
	ValaCodeContext* _tmp46_ = NULL;
	ValaCodeContext* _tmp47_ = NULL;
	ValaCodeContext* _tmp48_ = NULL;
	ValaCodeContext* _tmp49_ = NULL;
	ValaCodeContext* _tmp50_ = NULL;
	ValaCodeContext* _tmp51_ = NULL;
	IdeValaDiagnostics* _tmp52_ = NULL;
	ValaCodeContext* _tmp53_ = NULL;
	IdeValaDiagnostics* _tmp54_ = NULL;
	ValaParser* _tmp55_ = NULL;
	ValaParser* _tmp56_ = NULL;
	ValaCodeContext* _tmp57_ = NULL;
	ValaCodeContext* _tmp58_ = NULL;
	self = (IdeValaIndex*) g_object_new (object_type, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, IDE_TYPE_VALA_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, _tmp0_);
	_vala_map_unref0 (self->priv->source_files);
	self->priv->source_files = _tmp1_;
	_tmp2_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->code_context);
	self->priv->code_context = _tmp2_;
	_tmp3_ = self->priv->code_context;
	vala_code_context_push (_tmp3_);
	_tmp4_ = self->priv->code_context;
	vala_code_context_set_assert (_tmp4_, TRUE);
	_tmp5_ = self->priv->code_context;
	vala_code_context_set_checking (_tmp5_, FALSE);
	_tmp6_ = self->priv->code_context;
	vala_code_context_set_deprecated (_tmp6_, FALSE);
	_tmp7_ = self->priv->code_context;
	vala_code_context_set_hide_internal (_tmp7_, FALSE);
	_tmp8_ = self->priv->code_context;
	vala_code_context_set_experimental (_tmp8_, FALSE);
	_tmp9_ = self->priv->code_context;
	vala_code_context_set_experimental_non_null (_tmp9_, FALSE);
	_tmp10_ = self->priv->code_context;
	vala_code_context_set_gobject_tracing (_tmp10_, FALSE);
	_tmp11_ = self->priv->code_context;
	vala_code_context_set_nostdpkg (_tmp11_, FALSE);
	_tmp12_ = self->priv->code_context;
	vala_code_context_set_ccode_only (_tmp12_, TRUE);
	_tmp13_ = self->priv->code_context;
	vala_code_context_set_compile_only (_tmp13_, TRUE);
	_tmp14_ = self->priv->code_context;
	vala_code_context_set_use_header (_tmp14_, FALSE);
	_tmp15_ = self->priv->code_context;
	vala_code_context_set_includedir (_tmp15_, NULL);
	_tmp16_ = self->priv->code_context;
	_tmp17_ = g_get_current_dir ();
	_tmp18_ = _tmp17_;
	vala_code_context_set_basedir (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = self->priv->code_context;
	_tmp20_ = g_get_current_dir ();
	_tmp21_ = _tmp20_;
	vala_code_context_set_directory (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = self->priv->code_context;
	vala_code_context_set_debug (_tmp22_, FALSE);
	_tmp23_ = self->priv->code_context;
	vala_code_context_set_thread (_tmp23_, TRUE);
	_tmp24_ = self->priv->code_context;
	vala_code_context_set_mem_profiler (_tmp24_, FALSE);
	_tmp25_ = self->priv->code_context;
	vala_code_context_set_save_temps (_tmp25_, FALSE);
	_tmp26_ = self->priv->code_context;
	vala_code_context_set_profile (_tmp26_, VALA_PROFILE_GOBJECT);
	_tmp27_ = self->priv->code_context;
	vala_code_context_add_define (_tmp27_, "GOBJECT");
	_tmp28_ = self->priv->code_context;
	vala_code_context_set_entry_point_name (_tmp28_, NULL);
	_tmp29_ = self->priv->code_context;
	vala_code_context_set_run_output (_tmp29_, FALSE);
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_ = 0;
				ValaCodeContext* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				if (!_tmp30_) {
					gint _tmp31_ = 0;
					_tmp31_ = i;
					i = _tmp31_ + 2;
				}
				_tmp30_ = FALSE;
				_tmp32_ = i;
				if (!(_tmp32_ <= 32)) {
					break;
				}
				_tmp33_ = self->priv->code_context;
				_tmp34_ = i;
				_tmp35_ = g_strdup_printf ("VALA_0_%d", _tmp34_);
				_tmp36_ = _tmp35_;
				vala_code_context_add_define (_tmp33_, _tmp36_);
				_g_free0 (_tmp36_);
			}
		}
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				gint _tmp39_ = 0;
				ValaCodeContext* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				if (!_tmp37_) {
					gint _tmp38_ = 0;
					_tmp38_ = i;
					i = _tmp38_ + 2;
				}
				_tmp37_ = FALSE;
				_tmp39_ = i;
				if (!(((guint) _tmp39_) < glib_minor_version)) {
					break;
				}
				_tmp40_ = self->priv->code_context;
				_tmp41_ = i;
				_tmp42_ = g_strdup_printf ("GLIB_2_%d", _tmp41_);
				_tmp43_ = _tmp42_;
				vala_code_context_add_define (_tmp40_, _tmp43_);
				_g_free0 (_tmp43_);
			}
		}
	}
	_tmp44_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp44_, "glib-2.0");
	_tmp45_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp45_, "gobject-2.0");
	_tmp46_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp46_, "gio-2.0");
	_tmp47_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp47_, "gtk+-3.0");
	_tmp48_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp48_, "gtksourceview-3.0");
	_tmp49_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp49_, "libide-1.0");
	_tmp50_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp50_, "libpeas-1.0");
	_tmp51_ = self->priv->code_context;
	vala_code_context_add_external_package (_tmp51_, "libvala-0.32");
	_tmp52_ = ide_vala_diagnostics_new ();
	_g_object_unref0 (self->priv->report);
	self->priv->report = _tmp52_;
	_tmp53_ = self->priv->code_context;
	_tmp54_ = self->priv->report;
	vala_code_context_set_report (_tmp53_, (ValaReport*) _tmp54_);
	_tmp55_ = vala_parser_new ();
	_vala_code_visitor_unref0 (self->priv->parser);
	self->priv->parser = _tmp55_;
	_tmp56_ = self->priv->parser;
	_tmp57_ = self->priv->code_context;
	vala_parser_parse (_tmp56_, _tmp57_);
	_tmp58_ = self->priv->code_context;
	vala_code_context_check (_tmp58_);
	vala_code_context_pop ();
	return self;
}


IdeValaIndex* ide_vala_index_new (void) {
	return ide_vala_index_construct (IDE_TYPE_VALA_INDEX);
}


static void ide_vala_index_add_file (IdeValaIndex* self, GFile* file) {
	gchar* path = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IdeValaSourceFile* source_file = NULL;
	ValaCodeContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	IdeValaSourceFile* _tmp5_ = NULL;
	ValaCodeContext* _tmp6_ = NULL;
	IdeValaSourceFile* _tmp7_ = NULL;
	ValaHashMap* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	IdeValaSourceFile* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_path (_tmp0_);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp3_ = self->priv->code_context;
	_tmp4_ = path;
	_tmp5_ = ide_vala_source_file_new (_tmp3_, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp4_, NULL, FALSE);
	source_file = _tmp5_;
	_tmp6_ = self->priv->code_context;
	_tmp7_ = source_file;
	vala_code_context_add_source_file (_tmp6_, (ValaSourceFile*) _tmp7_);
	_tmp8_ = self->priv->source_files;
	_tmp9_ = file;
	_tmp10_ = source_file;
	vala_map_set ((ValaMap*) _tmp8_, _tmp9_, _tmp10_);
	_vala_source_file_unref0 (source_file);
	_g_free0 (path);
}


static void ide_vala_index_add_files_data_free (gpointer _data) {
	IdeValaIndexAddFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (IdeValaIndexAddFilesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void ide_vala_index_add_files (IdeValaIndex* self, ValaArrayList* files, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IdeValaIndexAddFilesData* _data_;
	IdeValaIndex* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (IdeValaIndexAddFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, ide_vala_index_add_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, ide_vala_index_add_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = files;
	_tmp2_ = _vala_iterable_ref0 (_tmp1_);
	_vala_iterable_unref0 (_data_->files);
	_data_->files = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	ide_vala_index_add_files_co (_data_);
}


void ide_vala_index_add_files_finish (IdeValaIndex* self, GAsyncResult* _res_) {
	IdeValaIndexAddFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		IdeValaIndex* self;
		self = _data2_->self;
		_vala_iterable_unref0 (_data2_->files);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _ide_vala_index_add_files_co_gsource_func (gpointer self) {
	gboolean result;
	result = ide_vala_index_add_files_co (self);
	return result;
}


static void __lambda5_ (Block2Data* _data2_) {
	IdeValaIndex* self;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	{
		ValaCodeContext* _tmp0_ = NULL;
		_tmp0_ = self->priv->code_context;
		g_rec_mutex_lock (&self->priv->__lock_code_context);
		{
			ValaCodeContext* _tmp1_ = NULL;
			_tmp1_ = self->priv->code_context;
			vala_code_context_push (_tmp1_);
			{
				ValaArrayList* _file_list = NULL;
				ValaArrayList* _tmp2_ = NULL;
				ValaArrayList* _tmp3_ = NULL;
				gint _file_size = 0;
				ValaArrayList* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _file_index = 0;
				_tmp2_ = _data2_->files;
				_tmp3_ = _vala_iterable_ref0 (_tmp2_);
				_file_list = _tmp3_;
				_tmp4_ = _file_list;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				_file_size = _tmp6_;
				_file_index = -1;
				while (TRUE) {
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					GFile* file = NULL;
					ValaArrayList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gpointer _tmp12_ = NULL;
					GFile* _tmp13_ = NULL;
					_tmp7_ = _file_index;
					_file_index = _tmp7_ + 1;
					_tmp8_ = _file_index;
					_tmp9_ = _file_size;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = _file_list;
					_tmp11_ = _file_index;
					_tmp12_ = vala_list_get ((ValaList*) _tmp10_, _tmp11_);
					file = (GFile*) _tmp12_;
					_tmp13_ = file;
					ide_vala_index_add_file (self, _tmp13_);
					_g_object_unref0 (file);
				}
				_vala_iterable_unref0 (_file_list);
			}
			vala_code_context_pop ();
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _ide_vala_index_add_files_co_gsource_func, _data2_->_async_data_, NULL);
		}
		__finally2:
		{
			ValaCodeContext* _tmp14_ = NULL;
			_tmp14_ = self->priv->code_context;
			g_rec_mutex_unlock (&self->priv->__lock_code_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void ___lambda5__ide_thread_func (gpointer self) {
	__lambda5_ (self);
	block2_data_unref (self);
}


static gboolean ide_vala_index_add_files_co (IdeValaIndexAddFilesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->files;
	_vala_iterable_unref0 (_data_->_data2_->files);
	_data_->_data2_->files = _data_->_tmp0_;
	_data_->_data2_->_async_data_ = _data_;
	ide_thread_pool_push (IDE_THREAD_POOL_COMPILER, ___lambda5__ide_thread_func, block2_data_ref (_data_->_data2_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void ide_vala_index_parse_file_data_free (gpointer _data) {
	IdeValaIndexParseFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->unsaved_files);
	_g_object_unref0 (_data_->self);
	g_slice_free (IdeValaIndexParseFileData, _data_);
}


void ide_vala_index_parse_file (IdeValaIndex* self, GFile* file, IdeUnsavedFiles* unsaved_files, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IdeValaIndexParseFileData* _data_;
	IdeValaIndex* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	IdeUnsavedFiles* _tmp3_ = NULL;
	IdeUnsavedFiles* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	_data_ = g_slice_new0 (IdeValaIndexParseFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, ide_vala_index_parse_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, ide_vala_index_parse_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = unsaved_files;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->unsaved_files);
	_data_->unsaved_files = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	ide_vala_index_parse_file_co (_data_);
}


gboolean ide_vala_index_parse_file_finish (IdeValaIndex* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	IdeValaIndexParseFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		IdeValaIndex* self;
		self = _data3_->self;
		_g_ptr_array_unref0 (_data3_->unsaved_files_copy);
		_g_object_unref0 (_data3_->file);
		_g_object_unref0 (_data3_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _ide_vala_index_parse_file_co_gsource_func (gpointer self) {
	gboolean result;
	result = ide_vala_index_parse_file_co (self);
	return result;
}


static void __lambda6_ (Block3Data* _data3_) {
	IdeValaIndex* self;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	_tmp1_ = _data3_->cancellable;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _data3_->cancellable;
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		{
			ValaCodeContext* _tmp4_ = NULL;
			_tmp4_ = self->priv->code_context;
			g_rec_mutex_lock (&self->priv->__lock_code_context);
			{
				ValaCodeContext* _tmp5_ = NULL;
				ValaHashMap* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GPtrArray* _tmp10_ = NULL;
				ValaCodeContext* _tmp11_ = NULL;
				_tmp5_ = self->priv->code_context;
				vala_code_context_push (_tmp5_);
				_tmp6_ = self->priv->source_files;
				_tmp7_ = _data3_->file;
				_tmp8_ = vala_map_contains ((ValaMap*) _tmp6_, _tmp7_);
				if (!_tmp8_) {
					GFile* _tmp9_ = NULL;
					_tmp9_ = _data3_->file;
					ide_vala_index_add_file (self, _tmp9_);
				}
				_tmp10_ = _data3_->unsaved_files_copy;
				ide_vala_index_apply_unsaved_files (self, _tmp10_);
				ide_vala_index_reparse (self);
				_tmp11_ = self->priv->code_context;
				vala_code_context_check (_tmp11_);
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _ide_vala_index_parse_file_co_gsource_func, _data3_->_async_data_, NULL);
				vala_code_context_pop ();
			}
			__finally3:
			{
				ValaCodeContext* _tmp12_ = NULL;
				_tmp12_ = self->priv->code_context;
				g_rec_mutex_unlock (&self->priv->__lock_code_context);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static void ___lambda6__ide_thread_func (gpointer self) {
	__lambda6_ (self);
	block3_data_unref (self);
}


static gboolean ide_vala_index_parse_file_co (IdeValaIndexParseFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->file;
	_g_object_unref0 (_data_->_data3_->file);
	_data_->_data3_->file = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_g_object_unref0 (_data_->_data3_->cancellable);
	_data_->_data3_->cancellable = _data_->_tmp1_;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_data3_->unsaved_files_copy = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->unsaved_files;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->unsaved_files;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = ide_unsaved_files_to_array (_data_->_tmp3_);
		_g_ptr_array_unref0 (_data_->_data3_->unsaved_files_copy);
		_data_->_data3_->unsaved_files_copy = _data_->_tmp4_;
	}
	ide_thread_pool_push (IDE_THREAD_POOL_COMPILER, ___lambda6__ide_thread_func, block3_data_ref (_data_->_data3_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = TRUE;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


IdeCompletionResults* ide_vala_index_code_complete (IdeValaIndex* self, GFile* file, gint line, gint column, const gchar* line_text, IdeUnsavedFiles* unsaved_files, IdeValaCompletionProvider* provider, GCancellable* cancellable, gint* result_line, gint* result_column) {
	gint _vala_result_line = 0;
	gint _vala_result_column = 0;
	IdeCompletionResults* result = NULL;
	GPtrArray* unsaved_files_copy = NULL;
	IdeUnsavedFiles* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	IdeCompletionResults* _result_ = NULL;
	IdeValaCompletionProvider* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	IdeCompletionResults* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GCancellable* _tmp6_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (provider != NULL, NULL);
	_tmp0_ = unsaved_files;
	_tmp1_ = ide_unsaved_files_to_array (_tmp0_);
	unsaved_files_copy = _tmp1_;
	_tmp2_ = provider;
	_tmp3_ = _tmp2_->query;
	_tmp4_ = ide_completion_results_new (_tmp3_);
	_result_ = _tmp4_;
	_tmp6_ = cancellable;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		GCancellable* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = cancellable;
		_tmp8_ = g_cancellable_is_cancelled (_tmp7_);
		_tmp5_ = !_tmp8_;
	}
	if (_tmp5_) {
		{
			ValaCodeContext* _tmp9_ = NULL;
			_tmp9_ = self->priv->code_context;
			g_rec_mutex_lock (&self->priv->__lock_code_context);
			{
				ValaCodeContext* _tmp10_ = NULL;
				GPtrArray* _tmp11_ = NULL;
				ValaCodeContext* _tmp12_ = NULL;
				ValaHashMap* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				_tmp10_ = self->priv->code_context;
				vala_code_context_push (_tmp10_);
				_tmp11_ = unsaved_files_copy;
				ide_vala_index_apply_unsaved_files (self, _tmp11_);
				ide_vala_index_reparse (self);
				_tmp12_ = self->priv->code_context;
				vala_code_context_check (_tmp12_);
				_tmp13_ = self->priv->source_files;
				_tmp14_ = file;
				_tmp15_ = vala_map_contains ((ValaMap*) _tmp13_, _tmp14_);
				if (_tmp15_) {
					IdeValaSourceFile* source_file = NULL;
					ValaHashMap* _tmp16_ = NULL;
					GFile* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* text = NULL;
					gchar* _tmp26_ = NULL;
					IdeValaLocator* locator = NULL;
					IdeValaLocator* _tmp27_ = NULL;
					ValaSymbol* nearest = NULL;
					IdeValaLocator* _tmp28_ = NULL;
					IdeValaSourceFile* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					ValaSymbol* _tmp32_ = NULL;
					IdeValaSourceFile* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					ValaSymbol* _tmp35_ = NULL;
					IdeCompletionResults* _tmp36_ = NULL;
					IdeValaCompletionProvider* _tmp37_ = NULL;
					_tmp16_ = self->priv->source_files;
					_tmp17_ = file;
					_tmp18_ = vala_map_get ((ValaMap*) _tmp16_, _tmp17_);
					source_file = (IdeValaSourceFile*) _tmp18_;
					_tmp20_ = line_text;
					if (_tmp20_ == NULL) {
						IdeValaSourceFile* _tmp21_ = NULL;
						gint _tmp22_ = 0;
						gchar* _tmp23_ = NULL;
						_tmp21_ = source_file;
						_tmp22_ = line;
						_tmp23_ = vala_source_file_get_source_line ((ValaSourceFile*) _tmp21_, _tmp22_);
						_g_free0 (_tmp19_);
						_tmp19_ = _tmp23_;
					} else {
						const gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						_tmp24_ = line_text;
						_tmp25_ = g_strdup (_tmp24_);
						_g_free0 (_tmp19_);
						_tmp19_ = _tmp25_;
					}
					_tmp26_ = g_strdup (_tmp19_);
					text = _tmp26_;
					_tmp27_ = ide_vala_locator_new ();
					locator = _tmp27_;
					_tmp28_ = locator;
					_tmp29_ = source_file;
					_tmp30_ = line;
					_tmp31_ = column;
					_tmp32_ = ide_vala_locator_locate (_tmp28_, (ValaSourceFile*) _tmp29_, _tmp30_, _tmp31_);
					nearest = _tmp32_;
					_tmp33_ = source_file;
					_tmp34_ = text;
					_tmp35_ = nearest;
					_tmp36_ = _result_;
					_tmp37_ = provider;
					ide_vala_index_add_completions (self, _tmp33_, &line, &column, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
					_vala_code_node_unref0 (nearest);
					_vala_code_visitor_unref0 (locator);
					_g_free0 (text);
					_g_free0 (_tmp19_);
					_vala_source_file_unref0 (source_file);
				}
				vala_code_context_pop ();
			}
			__finally4:
			{
				ValaCodeContext* _tmp38_ = NULL;
				_tmp38_ = self->priv->code_context;
				g_rec_mutex_unlock (&self->priv->__lock_code_context);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (_result_);
				_g_ptr_array_unref0 (unsaved_files_copy);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp39_ = line;
	_vala_result_line = _tmp39_;
	_tmp40_ = column;
	_vala_result_column = _tmp40_;
	result = _result_;
	_g_ptr_array_unref0 (unsaved_files_copy);
	if (result_line) {
		*result_line = _vala_result_line;
	}
	if (result_column) {
		*result_column = _vala_result_column;
	}
	return result;
}


static void ide_vala_index_get_diagnostics_data_free (gpointer _data) {
	IdeValaIndexGetDiagnosticsData* _data_;
	_data_ = _data;
	_ide_diagnostics_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (IdeValaIndexGetDiagnosticsData, _data_);
}


void ide_vala_index_get_diagnostics (IdeValaIndex* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IdeValaIndexGetDiagnosticsData* _data_;
	IdeValaIndex* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (IdeValaIndexGetDiagnosticsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, ide_vala_index_get_diagnostics);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, ide_vala_index_get_diagnostics_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	ide_vala_index_get_diagnostics_co (_data_);
}


IdeDiagnostics* ide_vala_index_get_diagnostics_finish (IdeValaIndex* self, GAsyncResult* _res_) {
	IdeDiagnostics* result;
	IdeValaIndexGetDiagnosticsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		IdeValaIndex* self;
		self = _data4_->self;
		_ide_diagnostics_unref0 (_data4_->diagnostics);
		_g_object_unref0 (_data4_->file);
		_g_object_unref0 (_data4_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _ide_vala_index_get_diagnostics_co_gsource_func (gpointer self) {
	gboolean result;
	result = ide_vala_index_get_diagnostics_co (self);
	return result;
}


static void __lambda10_ (Block4Data* _data4_) {
	IdeValaIndex* self;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	_tmp1_ = _data4_->cancellable;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _data4_->cancellable;
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		{
			ValaCodeContext* _tmp4_ = NULL;
			_tmp4_ = self->priv->code_context;
			g_rec_mutex_lock (&self->priv->__lock_code_context);
			{
				ValaCodeContext* _tmp5_ = NULL;
				ValaHashMap* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp5_ = self->priv->code_context;
				vala_code_context_push (_tmp5_);
				_tmp6_ = self->priv->source_files;
				_tmp7_ = _data4_->file;
				_tmp8_ = vala_map_contains ((ValaMap*) _tmp6_, _tmp7_);
				if (_tmp8_) {
					ValaHashMap* _tmp9_ = NULL;
					GFile* _tmp10_ = NULL;
					gpointer _tmp11_ = NULL;
					IdeValaSourceFile* _tmp12_ = NULL;
					IdeDiagnostics* _tmp13_ = NULL;
					_tmp9_ = self->priv->source_files;
					_tmp10_ = _data4_->file;
					_tmp11_ = vala_map_get ((ValaMap*) _tmp9_, _tmp10_);
					_tmp12_ = (IdeValaSourceFile*) _tmp11_;
					_tmp13_ = ide_vala_source_file_diagnose (_tmp12_);
					_ide_diagnostics_unref0 (_data4_->diagnostics);
					_data4_->diagnostics = _tmp13_;
					_vala_source_file_unref0 (_tmp12_);
				}
				vala_code_context_pop ();
			}
			__finally5:
			{
				ValaCodeContext* _tmp14_ = NULL;
				_tmp14_ = self->priv->code_context;
				g_rec_mutex_unlock (&self->priv->__lock_code_context);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _ide_vala_index_get_diagnostics_co_gsource_func, _data4_->_async_data_, NULL);
}


static void ___lambda10__ide_thread_func (gpointer self) {
	__lambda10_ (self);
	block4_data_unref (self);
}


static gpointer _ide_diagnostics_ref0 (gpointer self) {
	return self ? ide_diagnostics_ref (self) : NULL;
}


static gboolean ide_vala_index_get_diagnostics_co (IdeValaIndexGetDiagnosticsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->file;
	_g_object_unref0 (_data_->_data4_->file);
	_data_->_data4_->file = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_g_object_unref0 (_data_->_data4_->cancellable);
	_data_->_data4_->cancellable = _data_->_tmp1_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_data4_->diagnostics = NULL;
	ide_thread_pool_push (IDE_THREAD_POOL_COMPILER, ___lambda10__ide_thread_func, block4_data_ref (_data_->_data4_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _ide_diagnostics_ref0 (_data_->_data4_->diagnostics);
	_data_->result = _data_->_tmp2_;
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void ide_vala_index_apply_unsaved_files (IdeValaIndex* self, GPtrArray* unsaved_files) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (unsaved_files != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_ = NULL;
		ValaList* _tmp1_ = NULL;
		gint _source_file_size = 0;
		ValaList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->code_context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			ValaSourceFile* _tmp12_ = NULL;
			ValaSourceFileType _tmp13_ = 0;
			ValaSourceFileType _tmp14_ = 0;
			_tmp5_ = _source_file_index;
			_source_file_index = _tmp5_ + 1;
			_tmp6_ = _source_file_index;
			_tmp7_ = _source_file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _source_file_list;
			_tmp9_ = _source_file_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			source_file = (ValaSourceFile*) _tmp10_;
			_tmp12_ = source_file;
			_tmp13_ = vala_source_file_get_file_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaSourceFile* _tmp15_ = NULL;
				_tmp15_ = source_file;
				_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, IDE_TYPE_VALA_SOURCE_FILE);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaSourceFile* _tmp16_ = NULL;
				GPtrArray* _tmp17_ = NULL;
				_tmp16_ = source_file;
				_tmp17_ = unsaved_files;
				ide_vala_source_file_sync (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, IDE_TYPE_VALA_SOURCE_FILE) ? ((IdeValaSourceFile*) _tmp16_) : NULL, _tmp17_);
			}
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


static void ide_vala_index_reparse (IdeValaIndex* self) {
	IdeValaDiagnostics* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->report;
	ide_vala_diagnostics_clear (_tmp0_);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp1_ = NULL;
		ValaList* _tmp2_ = NULL;
		gint _source_file_size = 0;
		ValaList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _source_file_index = 0;
		_tmp1_ = self->priv->code_context;
		_tmp2_ = vala_code_context_get_source_files (_tmp1_);
		_source_file_list = _tmp2_;
		_tmp3_ = _source_file_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_source_file_size = _tmp5_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			ValaSourceFile* _tmp12_ = NULL;
			ValaList* _tmp13_ = NULL;
			ValaList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			_tmp6_ = _source_file_index;
			_source_file_index = _tmp6_ + 1;
			_tmp7_ = _source_file_index;
			_tmp8_ = _source_file_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _source_file_list;
			_tmp10_ = _source_file_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			source_file = (ValaSourceFile*) _tmp11_;
			_tmp12_ = source_file;
			_tmp13_ = vala_source_file_get_nodes (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ == 0;
			_vala_iterable_unref0 (_tmp14_);
			if (_tmp17_) {
				ValaSourceFile* _tmp18_ = NULL;
				_tmp18_ = source_file;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, IDE_TYPE_VALA_SOURCE_FILE)) {
					ValaParser* _tmp19_ = NULL;
					ValaSourceFile* _tmp20_ = NULL;
					ValaSourceFile* _tmp21_ = NULL;
					_tmp19_ = self->priv->parser;
					_tmp20_ = source_file;
					vala_code_visitor_visit_source_file ((ValaCodeVisitor*) _tmp19_, _tmp20_);
					_tmp21_ = source_file;
					ide_vala_source_file_set_dirty (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, IDE_TYPE_VALA_SOURCE_FILE) ? ((IdeValaSourceFile*) _tmp21_) : NULL, FALSE);
				} else {
					ValaParser* _tmp22_ = NULL;
					ValaSourceFile* _tmp23_ = NULL;
					_tmp22_ = self->priv->parser;
					_tmp23_ = source_file;
					vala_code_visitor_visit_source_file ((ValaCodeVisitor*) _tmp22_, _tmp23_);
				}
			}
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static void ide_vala_index_add_completions (IdeValaIndex* self, IdeValaSourceFile* source_file, gint* line, gint* column, const gchar* line_text, ValaSymbol* nearest, IdeCompletionResults* results, IdeValaCompletionProvider* provider) {
	ValaBlock* block = NULL;
	ValaSymbol* _tmp0_ = NULL;
	ValaBlock* _tmp1_ = NULL;
	ValaSourceLocation cursor = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	IdeValaCompletion* completion = NULL;
	ValaCodeContext* _tmp4_ = NULL;
	ValaSourceLocation _tmp5_ = {0};
	const gchar* _tmp6_ = NULL;
	ValaBlock* _tmp7_ = NULL;
	IdeValaCompletion* _tmp8_ = NULL;
	GList* list = NULL;
	IdeValaCompletion* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	ValaSourceLocation _tmp25_ = {0};
	gint _tmp26_ = 0;
	ValaSourceLocation _tmp27_ = {0};
	gint _tmp28_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	g_return_if_fail (line_text != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (provider != NULL);
	_tmp0_ = nearest;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp0_) : NULL);
	block = _tmp1_;
	_tmp2_ = *line;
	_tmp3_ = *column;
	vala_source_location_init (&cursor, NULL, _tmp2_, _tmp3_);
	_tmp4_ = self->priv->code_context;
	_tmp5_ = cursor;
	_tmp6_ = line_text;
	_tmp7_ = block;
	_tmp8_ = ide_vala_completion_new (_tmp4_, &_tmp5_, _tmp6_, _tmp7_);
	completion = _tmp8_;
	_tmp9_ = completion;
	_tmp10_ = ide_vala_completion_run (_tmp9_, &cursor);
	list = _tmp10_;
	_tmp11_ = list;
	{
		GList* symbol_collection = NULL;
		GList* symbol_it = NULL;
		symbol_collection = _tmp11_;
		for (symbol_it = symbol_collection; symbol_it != NULL; symbol_it = symbol_it->next) {
			ValaSymbol* _tmp12_ = NULL;
			ValaSymbol* symbol = NULL;
			_tmp12_ = _vala_code_node_ref0 ((ValaSymbol*) symbol_it->data);
			symbol = _tmp12_;
			{
				gboolean _tmp13_ = FALSE;
				ValaSymbol* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				_tmp14_ = symbol;
				_tmp15_ = vala_symbol_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ != NULL) {
					ValaSymbol* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gchar _tmp20_ = '\0';
					_tmp17_ = symbol;
					_tmp18_ = vala_symbol_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = string_get (_tmp19_, (glong) 0);
					_tmp13_ = _tmp20_ != '\0';
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					IdeCompletionResults* _tmp21_ = NULL;
					ValaSymbol* _tmp22_ = NULL;
					IdeValaCompletionProvider* _tmp23_ = NULL;
					IdeValaCompletionItem* _tmp24_ = NULL;
					_tmp21_ = results;
					_tmp22_ = symbol;
					_tmp23_ = provider;
					_tmp24_ = ide_vala_completion_item_new (_tmp22_, _tmp23_);
					ide_completion_results_take_proposal (_tmp21_, (IdeCompletionItem*) _tmp24_);
				}
				_vala_code_node_unref0 (symbol);
			}
		}
	}
	_tmp25_ = cursor;
	_tmp26_ = _tmp25_.line;
	*line = _tmp26_;
	_tmp27_ = cursor;
	_tmp28_ = _tmp27_.column;
	*column = _tmp28_;
	__g_list_free__vala_code_node_unref0_0 (list);
	_g_object_unref0 (completion);
	_vala_code_node_unref0 (block);
}


static void ide_vala_index_find_symbol_at_data_free (gpointer _data) {
	IdeValaIndexFindSymbolAtData* _data_;
	_data_ = _data;
	_vala_code_node_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (IdeValaIndexFindSymbolAtData, _data_);
}


void ide_vala_index_find_symbol_at (IdeValaIndex* self, GFile* file, gint line, gint column, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IdeValaIndexFindSymbolAtData* _data_;
	IdeValaIndex* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	_data_ = g_slice_new0 (IdeValaIndexFindSymbolAtData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, ide_vala_index_find_symbol_at);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, ide_vala_index_find_symbol_at_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = line;
	_data_->line = _tmp3_;
	_tmp4_ = column;
	_data_->column = _tmp4_;
	ide_vala_index_find_symbol_at_co (_data_);
}


ValaSymbol* ide_vala_index_find_symbol_at_finish (IdeValaIndex* self, GAsyncResult* _res_) {
	ValaSymbol* result;
	IdeValaIndexFindSymbolAtData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		IdeValaIndex* self;
		self = _data5_->self;
		_vala_code_node_unref0 (_data5_->symbol);
		_g_object_unref0 (_data5_->file);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda11_ (Block5Data* _data5_) {
	IdeValaIndex* self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	{
		ValaCodeContext* _tmp0_ = NULL;
		_tmp0_ = self->priv->code_context;
		g_rec_mutex_lock (&self->priv->__lock_code_context);
		{
			ValaCodeContext* _tmp1_ = NULL;
			ValaHashMap* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			IdeValaSourceFile* source_file = NULL;
			ValaHashMap* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			IdeValaLocator* locator = NULL;
			IdeValaLocator* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			ValaSymbol* _tmp12_ = NULL;
			_tmp1_ = self->priv->code_context;
			vala_code_context_push (_tmp1_);
			_tmp2_ = self->priv->source_files;
			_tmp3_ = _data5_->file;
			_tmp4_ = vala_map_contains ((ValaMap*) _tmp2_, _tmp3_);
			if (!_tmp4_) {
				GFile* _tmp5_ = NULL;
				_tmp5_ = _data5_->file;
				ide_vala_index_add_file (self, _tmp5_);
				ide_vala_index_reparse (self);
			}
			_tmp6_ = self->priv->source_files;
			_tmp7_ = _data5_->file;
			_tmp8_ = vala_map_get ((ValaMap*) _tmp6_, _tmp7_);
			source_file = (IdeValaSourceFile*) _tmp8_;
			_tmp9_ = ide_vala_locator_new ();
			locator = _tmp9_;
			_tmp10_ = _data5_->line;
			_tmp11_ = _data5_->column;
			_tmp12_ = ide_vala_locator_locate (locator, (ValaSourceFile*) source_file, _tmp10_, _tmp11_);
			_vala_code_node_unref0 (_data5_->symbol);
			_data5_->symbol = _tmp12_;
			vala_code_context_pop ();
			_vala_code_visitor_unref0 (locator);
			_vala_source_file_unref0 (source_file);
		}
		__finally6:
		{
			ValaCodeContext* _tmp13_ = NULL;
			_tmp13_ = self->priv->code_context;
			g_rec_mutex_unlock (&self->priv->__lock_code_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	ide_vala_index_find_symbol_at_co (_data5_->_async_data_);
}


static void ___lambda11__ide_thread_func (gpointer self) {
	__lambda11_ (self);
	block5_data_unref (self);
}


static gboolean ide_vala_index_find_symbol_at_co (IdeValaIndexFindSymbolAtData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->file;
	_g_object_unref0 (_data_->_data5_->file);
	_data_->_data5_->file = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->line;
	_data_->_data5_->line = _data_->_tmp1_;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->column;
	_data_->_data5_->column = _data_->_tmp2_;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_data5_->symbol = NULL;
	ide_thread_pool_push (IDE_THREAD_POOL_COMPILER, ___lambda11__ide_thread_func, block5_data_ref (_data_->_data5_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _vala_code_node_ref0 (_data_->_data5_->symbol);
	_data_->result = _data_->_tmp3_;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void ide_vala_index_get_symbol_tree_data_free (gpointer _data) {
	IdeValaIndexGetSymbolTreeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (IdeValaIndexGetSymbolTreeData, _data_);
}


void ide_vala_index_get_symbol_tree (IdeValaIndex* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IdeValaIndexGetSymbolTreeData* _data_;
	IdeValaIndex* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (IdeValaIndexGetSymbolTreeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, ide_vala_index_get_symbol_tree);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, ide_vala_index_get_symbol_tree_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	ide_vala_index_get_symbol_tree_co (_data_);
}


IdeSymbolTree* ide_vala_index_get_symbol_tree_finish (IdeValaIndex* self, GAsyncResult* _res_, GError** error) {
	IdeSymbolTree* result;
	IdeValaIndexGetSymbolTreeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		IdeValaIndex* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->ret);
		_g_object_unref0 (_data6_->file);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static gboolean _ide_vala_index_get_symbol_tree_co_gsource_func (gpointer self) {
	gboolean result;
	result = ide_vala_index_get_symbol_tree_co (self);
	return result;
}


static void __lambda12_ (Block6Data* _data6_) {
	IdeValaIndex* self;
	GError * _inner_error_ = NULL;
	self = _data6_->self;
	{
		ValaCodeContext* _tmp0_ = NULL;
		_tmp0_ = self->priv->code_context;
		g_rec_mutex_lock (&self->priv->__lock_code_context);
		{
			ValaCodeContext* _tmp1_ = NULL;
			ValaHashMap* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			IdeValaSourceFile* source_file = NULL;
			ValaHashMap* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			IdeValaSourceFile* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			IdeValaSymbolTreeVisitor* tree_builder = NULL;
			IdeValaSymbolTreeVisitor* _tmp12_ = NULL;
			IdeValaSourceFile* _tmp13_ = NULL;
			IdeSymbolTree* _tmp14_ = NULL;
			_tmp1_ = self->priv->code_context;
			vala_code_context_push (_tmp1_);
			_tmp2_ = self->priv->source_files;
			_tmp3_ = _data6_->file;
			_tmp4_ = vala_map_contains ((ValaMap*) _tmp2_, _tmp3_);
			if (!_tmp4_) {
				GFile* _tmp5_ = NULL;
				_tmp5_ = _data6_->file;
				ide_vala_index_add_file (self, _tmp5_);
				ide_vala_index_reparse (self);
			}
			_tmp6_ = self->priv->source_files;
			_tmp7_ = _data6_->file;
			_tmp8_ = vala_map_get ((ValaMap*) _tmp6_, _tmp7_);
			source_file = (IdeValaSourceFile*) _tmp8_;
			_tmp9_ = source_file;
			_tmp10_ = ide_vala_source_file_get_dirty (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				ide_vala_index_reparse (self);
			}
			_tmp12_ = ide_vala_symbol_tree_visitor_new ();
			tree_builder = _tmp12_;
			_tmp13_ = source_file;
			vala_source_file_accept_children ((ValaSourceFile*) _tmp13_, (ValaCodeVisitor*) tree_builder);
			_tmp14_ = ide_vala_symbol_tree_visitor_build_tree (tree_builder);
			_g_object_unref0 (_data6_->ret);
			_data6_->ret = _tmp14_;
			vala_code_context_pop ();
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _ide_vala_index_get_symbol_tree_co_gsource_func, _data6_->_async_data_, NULL);
			_vala_code_visitor_unref0 (tree_builder);
			_vala_source_file_unref0 (source_file);
		}
		__finally7:
		{
			ValaCodeContext* _tmp15_ = NULL;
			_tmp15_ = self->priv->code_context;
			g_rec_mutex_unlock (&self->priv->__lock_code_context);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void ___lambda12__ide_thread_func (gpointer self) {
	__lambda12_ (self);
	block6_data_unref (self);
}


static gboolean ide_vala_index_get_symbol_tree_co (IdeValaIndexGetSymbolTreeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->file;
	_g_object_unref0 (_data_->_data6_->file);
	_data_->_data6_->file = _data_->_tmp0_;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_data6_->ret = NULL;
	ide_thread_pool_push (IDE_THREAD_POOL_COMPILER, ___lambda12__ide_thread_func, block6_data_ref (_data_->_data6_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_data6_->ret);
	_data_->result = _data_->_tmp1_;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void ide_vala_index_class_init (IdeValaIndexClass * klass) {
	ide_vala_index_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IdeValaIndexPrivate));
	G_OBJECT_CLASS (klass)->finalize = ide_vala_index_finalize;
}


static void ide_vala_index_instance_init (IdeValaIndex * self) {
	self->priv = IDE_VALA_INDEX_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_code_context);
}


static void ide_vala_index_finalize (GObject* obj) {
	IdeValaIndex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IDE_TYPE_VALA_INDEX, IdeValaIndex);
	g_rec_mutex_clear (&self->priv->__lock_code_context);
	_vala_code_context_unref0 (self->priv->code_context);
	_vala_code_visitor_unref0 (self->priv->parser);
	_vala_map_unref0 (self->priv->source_files);
	_g_object_unref0 (self->priv->report);
	G_OBJECT_CLASS (ide_vala_index_parent_class)->finalize (obj);
}


GType ide_vala_index_get_type (void) {
	return ide_vala_index_type_id;
}


GType ide_vala_index_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (IdeValaIndexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ide_vala_index_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdeValaIndex), 0, (GInstanceInitFunc) ide_vala_index_instance_init, NULL };
	ide_vala_index_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "IdeValaIndex", &g_define_type_info, 0);
	return ide_vala_index_type_id;
}



