AC_ARG_ENABLE([tracing],
              [AS_HELP_STRING([--enable-tracing=@<:@no/yes@:>@],
                              [turn on tracing @<:@default=no@:>@])],
                              [],
                              [enable_tracing=no])

# use strict compiler flags only on development releases
m4_define([maintainer_flags_default], [m4_if(m4_eval(project_minor_version % 2), [1], [yes], [no])])
AC_ARG_ENABLE([maintainer-flags],
              [AS_HELP_STRING([--enable-maintainer-flags=@<:@no/yes@:>@],
                              [Use strict compiler flags @<:@default=]maintainer_flags_default[@:>@])],
              [],
              [enable_maintainer_flags=maintainer_flags_default])

dnl **************************************************************************
dnl Enable extra debugging options
dnl **************************************************************************
m4_define([debug_default],
	  [m4_if(m4_eval(project_minor_version % 2), [1],
	  [yes], [minimum])])
AC_ARG_ENABLE([debug],
	      [AS_HELP_STRING([--enable-debug=@<:@no/minimum/yes@:>@],
	      		      [turn on debugging @<:@default=debug_default@:>@])],
	      		      [],
	      		      [enable_debug=debug_default])
AS_CASE([$enable_debug],
	[yes], [],
	[minimum], [
		CFLAGS="$CFLAGS -DG_DISABLE_CAST_CHECKS"
		CFLAGS="$CFLAGS -DIDE_DISABLE_DEBUG"
		CFLAGS="$CFLAGS -DIDE_DISABLE_TRACE"
	],
	[no], [
		CFLAGS="$CFLAGS -DG_DISABLE_ASSERT"
		CFLAGS="$CFLAGS -DG_DISABLE_CHECKS"
		CFLAGS="$CFLAGS -DG_DISABLE_CAST_CHECKS"
		CFLAGS="$CFLAGS -DIDE_DISABLE_DEBUG"
		CFLAGS="$CFLAGS -DIDE_DISABLE_TRACE"
	],
	[AC_MSG_ERROR([Unknown argument to --enable-debug])]
)
# Define the minimum version of Clang compiler.
# This does not affect using clang for compiler support in Builder,
# only if CC=clang.
m4_define(clang_major_required_version, 3)
m4_define(clang_minor_required_version, 5)
AC_COMPILE_IFELSE([AC_LANG_PROGRAM([
#if !(defined(__clang__) && ((__clang_major__ > clang_major_required_version) || ((__clang_major__ == clang_major_required_version) && (__clang_minor__ >= clang_minor_required_version))))
#error Not a supported Clang compiler
#endif
])], [c_compiler="clang"], [])


# Check clang deps for building clang support in LibIDE.
AC_CHECK_PROGS([LLVM_CONFIG], [llvm-config-3.5 llvm-config35 llvm-config], [])
AS_IF([test "x$LLVM_CONFIG" = "x"],[
    AC_MSG_ERROR([Failed to locate the llvm-config program. Please install llvm-devel.])
])
CLANG_INCLUDEDIR=`$LLVM_CONFIG --includedir`
CLANG_CFLAGS="-I$CLANG_INCLUDEDIR"
CLANG_LDFLAGS=`$LLVM_CONFIG --ldflags`
AC_SUBST([CLANG_INCLUDEDIR])
AC_SUBST([CLANG_CFLAGS])
AC_SUBST([CLANG_LDFLAGS])


# Now check for clang-c/Index.h
CPPFLAGS_SAVE=${CPPFLAGS}
CPPFLAGS=-I${CLANG_INCLUDEDIR}
AC_CHECK_HEADER([clang-c/Index.h], [], [
    AC_MSG_ERROR([Failed to locage clang-c/Index.h. Please install clang-devel.])
])
CPPFLAGS=${CPPFLAGS_SAVE}
# Define the minimum version of GCC.
m4_define(gcc_major_required_version, 4)
m4_define(gcc_minor_required_version, 1)

AC_COMPILE_IFELSE([AC_LANG_PROGRAM([
#if !(defined(__GNUC__) && ((__GNUC__ > gcc_major_required_version) || ((__GNUC__ == gcc_major_required_version) && (__GNUC_MINOR__ >= gcc_minor_required_version))))
#error Not a supported GCC compiler
#endif
])], [c_compiler="gcc"], [])
# Define the minimum version of Sun C compiler.
m4_define(sunpro_c_required_version, 0x570)

AC_COMPILE_IFELSE([AC_LANG_PROGRAM([
#if !(defined(__SUNPRO_C) && __SUNPRO_C >= sunpro_c_required_version)
#error Not a supported Sun compiler
#endif
])], [c_compiler="sunpro_c"], [])
