/* ide-makecache-target.h
 *
 * Copyright (C) 2015 Christian Hergert <christian@hergert.me>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef IDE_MAKECACHE_TARGET_H
#define IDE_MAKECACHE_TARGET_H

#include <glib.h>

G_BEGIN_DECLS

typedef struct _IdeMakecacheTarget IdeMakecacheTarget;

IdeMakecacheTarget *ide_makecache_target_new        (const gchar        *subdir,
                                                     const gchar        *target);
void                ide_makecache_target_free       (IdeMakecacheTarget *self);
const gchar        *ide_makecache_target_get_target (IdeMakecacheTarget *self);
const gchar        *ide_makecache_target_get_subdir (IdeMakecacheTarget *self);
guint               ide_makecache_target_hash       (gconstpointer       data);
gboolean            ide_makecache_target_equal      (gconstpointer       data1,
                                                     gconstpointer       data2);

G_END_DECLS

#endif /* IDE_MAKECACHE_TARGET_H */
