AC_ARG_ENABLE([tracing],
              [AS_HELP_STRING([--enable-tracing=@<:@no/yes@:>@],
                              [turn on tracing @<:@default=no@:>@])],
                              [],
                              [enable_tracing=no])

# use strict compiler flags only on development releases
m4_define([maintainer_flags_default], [m4_if(m4_eval(project_minor_version % 2), [1], [yes], [no])])
AC_ARG_ENABLE([maintainer-flags],
              [AS_HELP_STRING([--enable-maintainer-flags=@<:@no/yes@:>@],
                              [Use strict compiler flags @<:@default=]maintainer_flags_default[@:>@])],
              [],
              [enable_maintainer_flags=maintainer_flags_default])
# Define the minimum version of Clang compiler.
m4_define(clang_major_required_version, 3)
m4_define(clang_minor_required_version, 3)

AC_COMPILE_IFELSE([AC_LANG_PROGRAM([
#if !(defined(__clang__) && ((__clang_major__ > clang_major_required_version) || ((__clang_major__ == clang_major_required_version) && (__clang_minor__ >= clang_minor_required_version))))
#error Not a supported Clang compiler
#endif
])], [c_compiler="clang"], [])
# Define the minimum version of GCC.
m4_define(gcc_major_required_version, 4)
m4_define(gcc_minor_required_version, 1)

AC_COMPILE_IFELSE([AC_LANG_PROGRAM([
#if !(defined(__GNUC__) && ((__GNUC__ > gcc_major_required_version) || ((__GNUC__ == gcc_major_required_version) && (__GNUC_MINOR__ >= gcc_minor_required_version))))
#error Not a supported GCC compiler
#endif
])], [c_compiler="gcc"], [])
# Define the minimum version of Sun C compiler.
m4_define(sunpro_c_required_version, 0x570)

AC_COMPILE_IFELSE([AC_LANG_PROGRAM([
#if !(defined(__SUNPRO_C) && __SUNPRO_C >= sunpro_c_required_version)
#error Not a supported Sun compiler
#endif
])], [c_compiler="sunpro_c"], [])
