PKG_CHECK_MODULES(BUILDER, [gtk+-3.0 >= 3.15.3
                            gtksourceview-3.0 >= 3.15.3
                            libdevhelp-3.0 >= 3.14.0
                            libgit2-glib-1.0 >= 0.0.24])

GLIB_TESTS

# Check for various compiler flags.
AS_IF([test "x$enable_maintainer_flags" = "xyes" && test "x$GCC" = "xyes"],
      [AX_CHECK_COMPILE_FLAG([-Wall],                         [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wall"])
       AX_CHECK_COMPILE_FLAG([-Waggregate-return],            [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Waggregate-return"])
       AX_CHECK_COMPILE_FLAG([-Wcast-align],                  [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wcast-align"])
       AX_CHECK_COMPILE_FLAG([-Wdeclaration-after-statement], [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wdeclaration-after-statement"])
       AX_CHECK_COMPILE_FLAG([-Wempty-body],                  [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wempty-body"])
       AX_CHECK_COMPILE_FLAG([-Wformat],                      [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wformat"])
       AX_CHECK_COMPILE_FLAG([-Wformat-nonliteral],           [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wformat-nonliteral"])
       AX_CHECK_COMPILE_FLAG([-Wformat-security],             [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wformat-security"])
       AX_CHECK_COMPILE_FLAG([-Winit-self],                   [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Winit-self"])
       AX_CHECK_COMPILE_FLAG([-Wmissing-include-dirs],        [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wmissing-include-dirs"])
       AX_CHECK_COMPILE_FLAG([-Wno-strict-aliasing],          [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wno-strict-aliasing"])
       AX_CHECK_COMPILE_FLAG([-Wno-uninitialized],            [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wno-uninitialized"])
       AX_CHECK_COMPILE_FLAG([-Wredundant-decls],             [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wredundant-decls"])
       AX_CHECK_COMPILE_FLAG([-Wreturn-type],                 [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wreturn-type"])
       AX_CHECK_COMPILE_FLAG([-Wshadow],                      [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wshadow"])
       AX_CHECK_COMPILE_FLAG([-Wswitch-default],              [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wswitch-default"])
       AX_CHECK_COMPILE_FLAG([-Wswitch-enum],                 [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wswitch-enum"])
       AX_CHECK_COMPILE_FLAG([-Wundef],                       [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wundef"])
       AX_CHECK_COMPILE_FLAG([-Wuninitialized],               [MAINTAINER_CFLAGS="$MAINTAINER_CFLAGS -Wuninitialized"])])
AC_SUBST(MAINTAINER_CFLAGS)

AC_PROG_INSTALL
m4_ifdef([AM_SILENT_RULES], [AM_SILENT_RULES(yes)])
AM_CONDITIONAL([ENABLE_TRACING], [test "$enable_tracing" = "yes"])
