/* gbf-mkfile-build.h
 *
 * Copyright (C) 2005  Eric Greveson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Eric Greveson
 * Based on the Autotools GBF backend (libgbf-am) by
 *   JP Rosevear
 *   Dave Camp
 *   Naba Kumar
 *   Gustavo Giráldez
 */

#ifndef _GBF_MKFILE_BUILD_H_
#define _GBF_MKFILE_BUILD_H_

#include "gbf-mkfile-project.h"

G_BEGIN_DECLS

int gbf_build_run (GbfMkfileProject    *project,
		   gchar           *id,
		   const char      *project_dir,
		   GList           *callbacks);

void gbf_build_cancel (int build_id);


/* Build ID for default targets */
#define GBF_MKFILE_BUILD_ID_ALL 		"ALL"
#define GBF_MKFILE_BUILD_ID_INSTALL 	"INSTALL"
#define GBF_MKFILE_BUILD_ID_CLEAN 		"CLEAN"

#define GBF_MKFILE_BUILD_ID_USER_PREFIX	"USER:"


G_END_DECLS

#endif /* _GBF_MKFILE_BUILD_H_ */
