/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8; coding: utf-8 -*- */
/* gbf-am-project.h
 *
 * Copyright (C) 2000  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _GBF_AM_PROJECT_H_
#define _GBF_AM_PROJECT_H_

#include <glib-object.h>
#include <gbf/gbf-project.h>
#include <gbf/glue-plugin.h>
#include "gbf-am-config.h"

G_BEGIN_DECLS

#define GBF_TYPE_AM_PROJECT		(gbf_am_project_get_type (NULL))
#define GBF_AM_PROJECT(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GBF_TYPE_AM_PROJECT, GbfAmProject))
#define GBF_AM_PROJECT_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GBF_TYPE_AM_PROJECT, GbfAmProjectClass))
#define GBF_IS_AM_PROJECT(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GBF_TYPE_AM_PROJECT))
#define GBF_IS_AM_PROJECT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((obj), GBF_TYPE_AM_PROJECT))

typedef struct _GbfAmProject        GbfAmProject;
typedef struct _GbfAmProjectClass   GbfAmProjectClass;
typedef struct _GbfAmBuildCallback  GbfAmBuildCallback;
typedef struct _GbfAmNode           GbfAmNode;

typedef enum {
	GBF_AM_NODE_GROUP,
	GBF_AM_NODE_TARGET,
	GBF_AM_NODE_SOURCE
} GbfAmNodeType;
	
struct _GbfAmNode {
	GbfAmNodeType       type;
	gchar              *id;        /* unique id among nodes of the same type */
	gchar              *name;      /* user visible string */
	GbfAmConfigMapping *config;
	gchar              *uri;       /* groups: path to Makefile.am;
					  targets: NULL;
					  sources: file uri */
	gchar              *detail;    /* groups: NULL;
					  targets: target type;
					  sources: NULL or target dependency for built sources */
};

struct _GbfAmProject {
	GbfProject          parent;

	/* uri of the project; this can be a full uri, even though we
	 * can only work with native local files */
	gchar              *project_root_uri;

	/* project data */
	gchar              *project_file;      /* configure.in uri */
	GbfAmConfigMapping *project_config;    /* project configuration
						* (i.e. from configure.in) */
	GNode              *root_node;         /* tree containing project data;
						* each GNode's data is a
						* GbfAmNode, and the root of
						* the tree is the root group. */

	/* shortcut hash tables, mapping id -> GNode from the tree above */
	GHashTable         *groups;
	GHashTable         *targets;
	GHashTable         *sources;
	
	/* project files monitors */
	GHashTable         *monitors;

	/* operations queue */
	GQueue             *queue_ops;
        guint               queue_handler_tag;

	/* build callbacks */
	GList              *callbacks;
};

struct _GbfAmProjectClass {
	GbfProjectClass parent_class;
};

/* FIXME: use closures */
struct _GbfAmBuildCallback {
	GbfBuildCallback callback;
	gpointer user_data;
};

/* convenient shortcut macro the get the GbfAmNode from a GNode */
#define GBF_AM_NODE(g_node)  ((g_node) != NULL ? (GbfAmNode *)((g_node)->data) : NULL)

GType         gbf_am_project_get_type (GluePlugin *plugin);
GbfProject   *gbf_am_project_new      (void);

G_END_DECLS

#endif /* _GBF_AM_PROJECT_H_ */
