/* media-manager.c generated by valac 0.15.1.29-64309, the Vala compiler
 * generated from media-manager.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gudev/gudev.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <osinfo/osinfo.h>


#define BOXES_TYPE_MEDIA_MANAGER (boxes_media_manager_get_type ())
#define BOXES_MEDIA_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManager))
#define BOXES_MEDIA_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManagerClass))
#define BOXES_IS_MEDIA_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MEDIA_MANAGER))
#define BOXES_IS_MEDIA_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MEDIA_MANAGER))
#define BOXES_MEDIA_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManagerClass))

typedef struct _BoxesMediaManager BoxesMediaManager;
typedef struct _BoxesMediaManagerClass BoxesMediaManagerClass;
typedef struct _BoxesMediaManagerPrivate BoxesMediaManagerPrivate;

#define BOXES_TYPE_OS_DATABASE (boxes_os_database_get_type ())
#define BOXES_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabase))
#define BOXES_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))
#define BOXES_IS_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_OS_DATABASE))
#define BOXES_IS_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_OS_DATABASE))
#define BOXES_OS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))

typedef struct _BoxesOSDatabase BoxesOSDatabase;
typedef struct _BoxesOSDatabaseClass BoxesOSDatabaseClass;
#define _boxes_os_database_unref0(var) ((var == NULL) ? NULL : (var = (boxes_os_database_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesMediaManagerCreateInstallerMediaForPathData BoxesMediaManagerCreateInstallerMediaForPathData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _BoxesMediaManagerListInstallerMediasData BoxesMediaManagerListInstallerMediasData;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;
typedef struct _BoxesMediaManagerCreateInstallerMediaFromIsoInfoData BoxesMediaManagerCreateInstallerMediaFromIsoInfoData;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;

#define BOXES_TYPE_FEDORA_INSTALLER (boxes_fedora_installer_get_type ())
#define BOXES_FEDORA_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstaller))
#define BOXES_FEDORA_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerClass))
#define BOXES_IS_FEDORA_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_FEDORA_INSTALLER))
#define BOXES_IS_FEDORA_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_FEDORA_INSTALLER))
#define BOXES_FEDORA_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerClass))

typedef struct _BoxesFedoraInstaller BoxesFedoraInstaller;
typedef struct _BoxesFedoraInstallerClass BoxesFedoraInstallerClass;

#define BOXES_TYPE_WINDOWS_INSTALLER (boxes_windows_installer_get_type ())
#define BOXES_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller))
#define BOXES_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))
#define BOXES_IS_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_IS_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_WINDOWS_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))

typedef struct _BoxesWindowsInstaller BoxesWindowsInstaller;
typedef struct _BoxesWindowsInstallerClass BoxesWindowsInstallerClass;

#define BOXES_TYPE_WIN7_INSTALLER (boxes_win7_installer_get_type ())
#define BOXES_WIN7_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7Installer))
#define BOXES_WIN7_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7InstallerClass))
#define BOXES_IS_WIN7_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIN7_INSTALLER))
#define BOXES_IS_WIN7_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIN7_INSTALLER))
#define BOXES_WIN7_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7InstallerClass))

typedef struct _BoxesWin7Installer BoxesWin7Installer;
typedef struct _BoxesWin7InstallerClass BoxesWin7InstallerClass;

#define BOXES_TYPE_WIN_XP_INSTALLER (boxes_win_xp_installer_get_type ())
#define BOXES_WIN_XP_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstaller))
#define BOXES_WIN_XP_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerClass))
#define BOXES_IS_WIN_XP_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIN_XP_INSTALLER))
#define BOXES_IS_WIN_XP_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIN_XP_INSTALLER))
#define BOXES_WIN_XP_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIN_XP_INSTALLER, BoxesWinXPInstallerClass))

typedef struct _BoxesWinXPInstaller BoxesWinXPInstaller;
typedef struct _BoxesWinXPInstallerClass BoxesWinXPInstallerClass;

struct _BoxesMediaManager {
	GObject parent_instance;
	BoxesMediaManagerPrivate * priv;
};

struct _BoxesMediaManagerClass {
	GObjectClass parent_class;
};

struct _BoxesMediaManagerPrivate {
	BoxesOSDatabase* _os_db;
	GUdevClient* _client;
	TrackerSparqlConnection* connection;
};

struct _BoxesMediaManagerCreateInstallerMediaForPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesMediaManager* self;
	gchar* path;
	GCancellable* cancellable;
	BoxesInstallerMedia* result;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	BoxesInstallerMedia* _tmp2_;
	BoxesInstallerMedia* media;
	BoxesInstallerMedia* _tmp3_;
	BoxesInstallerMedia* _tmp4_;
	BoxesInstallerMedia* _tmp5_;
	GError * _inner_error_;
};

typedef enum  {
	BOXES_ERROR_INVALID
} BoxesError;
#define BOXES_ERROR boxes_error_quark ()
struct _BoxesMediaManagerListInstallerMediasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesMediaManager* self;
	GList* result;
	GList* list;
	GUdevClient* _tmp0_;
	GUdevEnumerator* _tmp1_;
	GUdevEnumerator* enumerator;
	GUdevEnumerator* _tmp2_;
	GUdevEnumerator* _tmp3_;
	GList* _tmp4_;
	GList* device_collection;
	GList* device_it;
	GUdevDevice* _tmp5_;
	GUdevDevice* device;
	GUdevDevice* _tmp6_;
	const gchar* _tmp7_;
	GUdevDevice* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* path;
	const gchar* _tmp11_;
	BoxesInstallerMedia* _tmp12_;
	BoxesInstallerMedia* media;
	BoxesInstallerMedia* _tmp13_;
	BoxesInstallerMedia* _tmp14_;
	GError* _error_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	TrackerSparqlConnection* _tmp18_;
	TrackerSparqlCursor* _tmp19_;
	TrackerSparqlCursor* cursor;
	TrackerSparqlCursor* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	TrackerSparqlCursor* _tmp23_;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* file;
	GFile* _tmp26_;
	gchar* _tmp27_;
	gchar* _vala1_path;
	const gchar* _tmp28_;
	TrackerSparqlCursor* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* title;
	TrackerSparqlCursor* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* os_id;
	TrackerSparqlCursor* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* media_id;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	BoxesInstallerMedia* _tmp42_;
	BoxesInstallerMedia* _vala1_media;
	BoxesInstallerMedia* _tmp43_;
	BoxesInstallerMedia* _tmp44_;
	GError* _vala1__error_;
	const gchar* _tmp45_;
	GError* _tmp46_;
	const gchar* _tmp47_;
	GError* _vala2__error_;
	GError* _tmp48_;
	const gchar* _tmp49_;
	GError * _inner_error_;
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
};

typedef enum  {
	BOXES_OS_DATABASE_ERROR_NON_BOOTABLE,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID
} BoxesOSDatabaseError;
#define BOXES_OS_DATABASE_ERROR boxes_os_database_error_quark ()
struct _BoxesMediaManagerCreateInstallerMediaFromIsoInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesMediaManager* self;
	gchar* path;
	gchar* label;
	gchar* os_id;
	gchar* media_id;
	BoxesInstallerMedia* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	BoxesInstallerMedia* _tmp8_;
	BoxesInstallerMedia* _tmp9_;
	BoxesOSDatabase* _tmp10_;
	const gchar* _tmp11_;
	OsinfoOs* _tmp12_;
	OsinfoOs* os;
	BoxesOSDatabase* _tmp13_;
	OsinfoOs* _tmp14_;
	const gchar* _tmp15_;
	OsinfoMedia* _tmp16_;
	OsinfoMedia* os_media;
	BoxesOSDatabase* _tmp17_;
	OsinfoOs* _tmp18_;
	OsinfoMedia* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	OsinfoResources* _tmp23_;
	OsinfoResources* _tmp24_;
	OsinfoResources* resources;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	OsinfoOs* _tmp27_;
	OsinfoMedia* _tmp28_;
	OsinfoResources* _tmp29_;
	BoxesInstallerMedia* _tmp30_;
	BoxesInstallerMedia* media;
	BoxesInstallerMedia* _tmp31_;
	BoxesInstallerMedia* _tmp32_;
	BoxesInstallerMedia* _tmp33_;
	GError * _inner_error_;
};


static gpointer boxes_media_manager_parent_class = NULL;

GType boxes_media_manager_get_type (void) G_GNUC_CONST;
gpointer boxes_os_database_ref (gpointer instance);
void boxes_os_database_unref (gpointer instance);
GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_os_database (GValue* value, gpointer v_object);
void boxes_value_take_os_database (GValue* value, gpointer v_object);
gpointer boxes_value_get_os_database (const GValue* value);
GType boxes_os_database_get_type (void) G_GNUC_CONST;
#define BOXES_MEDIA_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManagerPrivate))
enum  {
	BOXES_MEDIA_MANAGER_DUMMY_PROPERTY,
	BOXES_MEDIA_MANAGER_OS_DB,
	BOXES_MEDIA_MANAGER_CLIENT
};
#define BOXES_MEDIA_MANAGER_SPARQL_QUERY "SELECT nie:url(?iso) nie:title(?iso) osinfo:id(?iso) osinfo:mediaId(?i" \
"so)" " { ?iso nfo:isBootable true }"
BoxesMediaManager* boxes_media_manager_new (void);
BoxesMediaManager* boxes_media_manager_construct (GType object_type);
static void boxes_media_manager_set_client (BoxesMediaManager* self, GUdevClient* value);
BoxesOSDatabase* boxes_os_database_new (GError** error);
BoxesOSDatabase* boxes_os_database_construct (GType object_type, GError** error);
static void boxes_media_manager_set_os_db (BoxesMediaManager* self, BoxesOSDatabase* value);
static void boxes_media_manager_create_installer_media_for_path_data_free (gpointer _data);
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
void boxes_media_manager_create_installer_media_for_path (BoxesMediaManager* self, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
BoxesInstallerMedia* boxes_media_manager_create_installer_media_for_path_finish (BoxesMediaManager* self, GAsyncResult* _res_, GError** error);
static gboolean boxes_media_manager_create_installer_media_for_path_co (BoxesMediaManagerCreateInstallerMediaForPathData* _data_);
void boxes_installer_media_create_for_path (const gchar* path, BoxesMediaManager* media_manager, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
BoxesInstallerMedia* boxes_installer_media_create_for_path_finish (GAsyncResult* _res_, GError** error);
static void boxes_media_manager_create_installer_media_for_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static BoxesInstallerMedia* boxes_media_manager_create_installer_media_from_media (BoxesMediaManager* self, BoxesInstallerMedia* media, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_media_manager_list_installer_medias_data_free (gpointer _data);
void boxes_media_manager_list_installer_medias (BoxesMediaManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GList* boxes_media_manager_list_installer_medias_finish (BoxesMediaManager* self, GAsyncResult* _res_);
static gboolean boxes_media_manager_list_installer_medias_co (BoxesMediaManagerListInstallerMediasData* _data_);
GUdevClient* boxes_media_manager_get_client (BoxesMediaManager* self);
static void boxes_media_manager_list_installer_medias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_media_manager_create_installer_media_from_iso_info (BoxesMediaManager* self, const gchar* path, const gchar* label, const gchar* os_id, const gchar* media_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static BoxesInstallerMedia* boxes_media_manager_create_installer_media_from_iso_info_finish (BoxesMediaManager* self, GAsyncResult* _res_, GError** error);
static gint boxes_media_manager_compare_media (BoxesInstallerMedia* media_a, BoxesInstallerMedia* media_b);
static gint _boxes_media_manager_compare_media_gcompare_func (gconstpointer a, gconstpointer b);
GQuark boxes_error_quark (void);
static void boxes_media_manager_create_installer_media_from_iso_info_data_free (gpointer _data);
static gboolean boxes_media_manager_create_installer_media_from_iso_info_co (BoxesMediaManagerCreateInstallerMediaFromIsoInfoData* _data_);
static void boxes_media_manager_create_installer_media_from_iso_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
BoxesOSDatabase* boxes_media_manager_get_os_db (BoxesMediaManager* self);
GQuark boxes_os_database_error_quark (void);
OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error);
OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error);
OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os, const gchar* architecture);
BoxesInstallerMedia* boxes_installer_media_new_from_iso_info (const gchar* path, const gchar* label, OsinfoOs* os, OsinfoMedia* media, OsinfoResources* resources);
BoxesInstallerMedia* boxes_installer_media_construct_from_iso_info (GType object_type, const gchar* path, const gchar* label, OsinfoOs* os, OsinfoMedia* media, OsinfoResources* resources);
BoxesFedoraInstaller* boxes_fedora_installer_new_copy (BoxesInstallerMedia* media, GError** error);
BoxesFedoraInstaller* boxes_fedora_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error);
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
GType boxes_fedora_installer_get_type (void) G_GNUC_CONST;
BoxesWin7Installer* boxes_win7_installer_new_copy (BoxesInstallerMedia* media, GError** error);
BoxesWin7Installer* boxes_win7_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error);
GType boxes_windows_installer_get_type (void) G_GNUC_CONST;
GType boxes_win7_installer_get_type (void) G_GNUC_CONST;
BoxesWinXPInstaller* boxes_win_xp_installer_new_copy (BoxesInstallerMedia* media, GError** error);
BoxesWinXPInstaller* boxes_win_xp_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error);
GType boxes_win_xp_installer_get_type (void) G_GNUC_CONST;
static void boxes_media_manager_finalize (GObject* obj);
static void _vala_boxes_media_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_boxes_media_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


BoxesMediaManager* boxes_media_manager_construct (GType object_type) {
	BoxesMediaManager * self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GUdevClient* _tmp3_;
	GUdevClient* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (BoxesMediaManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("block");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = g_udev_client_new (_tmp2_);
	_tmp4_ = _tmp3_;
	boxes_media_manager_set_client (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	{
		BoxesOSDatabase* _tmp5_;
		BoxesOSDatabase* _tmp6_;
		BoxesOSDatabase* _tmp7_;
		_tmp5_ = boxes_os_database_new (&_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		_tmp7_ = _tmp6_;
		boxes_media_manager_set_os_db (self, _tmp7_);
		_boxes_os_database_unref0 (_tmp7_);
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_critical ("media-manager.vala:21: Error fetching default OS database: %s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		TrackerSparqlConnection* _tmp10_ = NULL;
		TrackerSparqlConnection* _tmp11_;
		_tmp10_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp11_;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_critical ("media-manager.vala:26: Error connecting to Tracker: %s", _tmp13_);
		_g_error_free0 (_error_);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


BoxesMediaManager* boxes_media_manager_new (void) {
	return boxes_media_manager_construct (BOXES_TYPE_MEDIA_MANAGER);
}


static void boxes_media_manager_create_installer_media_for_path_data_free (gpointer _data) {
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMediaManagerCreateInstallerMediaForPathData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void boxes_media_manager_create_installer_media_for_path (BoxesMediaManager* self, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	BoxesMediaManager* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (BoxesMediaManagerCreateInstallerMediaForPathData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_media_manager_create_installer_media_for_path);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_media_manager_create_installer_media_for_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->path = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	boxes_media_manager_create_installer_media_for_path_co (_data_);
}


BoxesInstallerMedia* boxes_media_manager_create_installer_media_for_path_finish (BoxesMediaManager* self, GAsyncResult* _res_, GError** error) {
	BoxesInstallerMedia* result;
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_media_manager_create_installer_media_for_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_media_manager_create_installer_media_for_path_co (_data_);
}


static gboolean boxes_media_manager_create_installer_media_for_path_co (BoxesMediaManagerCreateInstallerMediaForPathData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->path;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_installer_media_create_for_path (_data_->_tmp0_, _data_->self, _data_->_tmp1_, boxes_media_manager_create_installer_media_for_path_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = boxes_installer_media_create_for_path_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->media = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->media;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = boxes_media_manager_create_installer_media_from_media (_data_->self, _data_->_tmp3_, &_data_->_inner_error_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp5_;
	_g_object_unref0 (_data_->media);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void boxes_media_manager_list_installer_medias_data_free (gpointer _data) {
	BoxesMediaManagerListInstallerMediasData* _data_;
	_data_ = _data;
	__g_list_free__g_object_unref0_0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMediaManagerListInstallerMediasData, _data_);
}


void boxes_media_manager_list_installer_medias (BoxesMediaManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesMediaManagerListInstallerMediasData* _data_;
	BoxesMediaManager* _tmp0_;
	_data_ = g_slice_new0 (BoxesMediaManagerListInstallerMediasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_media_manager_list_installer_medias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_media_manager_list_installer_medias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_media_manager_list_installer_medias_co (_data_);
}


GList* boxes_media_manager_list_installer_medias_finish (BoxesMediaManager* self, GAsyncResult* _res_) {
	GList* result;
	BoxesMediaManagerListInstallerMediasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_media_manager_list_installer_medias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesMediaManagerListInstallerMediasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_media_manager_list_installer_medias_co (_data_);
}


static gint _boxes_media_manager_compare_media_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = boxes_media_manager_compare_media (a, b);
	return result;
}


static gboolean boxes_media_manager_list_installer_medias_co (BoxesMediaManagerListInstallerMediasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->list = NULL;
	_data_->_tmp0_ = _data_->self->priv->_client;
	_data_->_tmp1_ = g_udev_enumerator_new (_data_->_tmp0_);
	_data_->enumerator = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->enumerator;
	g_udev_enumerator_add_match_property (_data_->_tmp2_, "OSINFO_BOOTABLE", "1");
	_data_->_tmp3_ = _data_->enumerator;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_udev_enumerator_execute (_data_->_tmp3_);
	{
		_data_->device_collection = _data_->_tmp4_;
		for (_data_->device_it = _data_->device_collection; _data_->device_it != NULL; _data_->device_it = _data_->device_it->next) {
			_data_->_tmp5_ = _g_object_ref0 ((GUdevDevice*) _data_->device_it->data);
			_data_->device = _data_->_tmp5_;
			{
				_data_->_tmp6_ = _data_->device;
				_data_->_tmp7_ = NULL;
				_data_->_tmp7_ = g_udev_device_get_property (_data_->_tmp6_, "DEVTYPE");
				if (g_strcmp0 (_data_->_tmp7_, "disk") != 0) {
					_g_object_unref0 (_data_->device);
					continue;
				}
				_data_->_tmp8_ = _data_->device;
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = g_udev_device_get_device_file (_data_->_tmp8_);
				_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
				_data_->path = _data_->_tmp10_;
				{
					_data_->_tmp11_ = _data_->path;
					_data_->_state_ = 1;
					boxes_media_manager_create_installer_media_for_path (_data_->self, _data_->_tmp11_, NULL, boxes_media_manager_list_installer_medias_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp12_ = NULL;
					_data_->_tmp12_ = boxes_media_manager_create_installer_media_for_path_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					_data_->media = _data_->_tmp12_;
					if (_data_->_inner_error_ != NULL) {
						goto __catch28_g_error;
					}
					_data_->_tmp13_ = _data_->media;
					_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
					_data_->list = g_list_append (_data_->list, _data_->_tmp14_);
					_g_object_unref0 (_data_->media);
				}
				goto __finally28;
				__catch28_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp15_ = _data_->path;
					_data_->_tmp16_ = _data_->_error_;
					_data_->_tmp17_ = _data_->_tmp16_->message;
					g_warning ("media-manager.vala:55: Failed to get information on device '%s': %s. I" \
"gnoring..", _data_->_tmp15_, _data_->_tmp17_);
					_g_error_free0 (_data_->_error_);
				}
				__finally28:
				if (_data_->_inner_error_ != NULL) {
					_g_free0 (_data_->path);
					_g_object_unref0 (_data_->device);
					__g_list_free__g_object_unref0_0 (_data_->device_collection);
					_g_object_unref0 (_data_->enumerator);
					__g_list_free__g_object_unref0_0 (_data_->list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_g_free0 (_data_->path);
				_g_object_unref0 (_data_->device);
			}
		}
		__g_list_free__g_object_unref0_0 (_data_->device_collection);
	}
	{
		_data_->_tmp18_ = _data_->self->priv->connection;
		_data_->_state_ = 2;
		tracker_sparql_connection_query_async (_data_->_tmp18_, BOXES_MEDIA_MANAGER_SPARQL_QUERY, NULL, boxes_media_manager_list_installer_medias_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = tracker_sparql_connection_query_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
		_data_->cursor = _data_->_tmp19_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
		while (TRUE) {
			_data_->_tmp20_ = _data_->cursor;
			_data_->_state_ = 3;
			tracker_sparql_cursor_next_async (_data_->_tmp20_, NULL, boxes_media_manager_list_installer_medias_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp21_ = FALSE;
			_data_->_tmp21_ = tracker_sparql_cursor_next_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp22_ = _data_->_tmp21_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->cursor);
				goto __catch29_g_error;
			}
			if (!_data_->_tmp22_) {
				break;
			}
			_data_->_tmp23_ = _data_->cursor;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = tracker_sparql_cursor_get_string (_data_->_tmp23_, 0, NULL);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = g_file_new_for_uri (_data_->_tmp24_);
			_data_->file = _data_->_tmp25_;
			_data_->_tmp26_ = _data_->file;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = g_file_get_path (_data_->_tmp26_);
			_data_->_vala1_path = _data_->_tmp27_;
			_data_->_tmp28_ = _data_->_vala1_path;
			if (_data_->_tmp28_ == NULL) {
				_g_free0 (_data_->_vala1_path);
				_g_object_unref0 (_data_->file);
				continue;
			}
			_data_->_tmp29_ = _data_->cursor;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = tracker_sparql_cursor_get_string (_data_->_tmp29_, 1, NULL);
			_data_->_tmp31_ = g_strdup (_data_->_tmp30_);
			_data_->title = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->cursor;
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = tracker_sparql_cursor_get_string (_data_->_tmp32_, 2, NULL);
			_data_->_tmp34_ = g_strdup (_data_->_tmp33_);
			_data_->os_id = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->cursor;
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = tracker_sparql_cursor_get_string (_data_->_tmp35_, 3, NULL);
			_data_->_tmp37_ = g_strdup (_data_->_tmp36_);
			_data_->media_id = _data_->_tmp37_;
			{
				_data_->_tmp38_ = _data_->_vala1_path;
				_data_->_tmp39_ = _data_->title;
				_data_->_tmp40_ = _data_->os_id;
				_data_->_tmp41_ = _data_->media_id;
				_data_->_state_ = 4;
				boxes_media_manager_create_installer_media_from_iso_info (_data_->self, _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_, _data_->_tmp41_, boxes_media_manager_list_installer_medias_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = boxes_media_manager_create_installer_media_from_iso_info_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
				_data_->_vala1_media = _data_->_tmp42_;
				if (_data_->_inner_error_ != NULL) {
					if (_data_->_inner_error_->domain == BOXES_ERROR) {
						goto __catch30_boxes_error;
					}
					goto __finally30;
				}
				_data_->_tmp43_ = _data_->_vala1_media;
				_data_->_tmp44_ = _g_object_ref0 (_data_->_tmp43_);
				_data_->list = g_list_insert_sorted (_data_->list, _data_->_tmp44_, _boxes_media_manager_compare_media_gcompare_func);
				_g_object_unref0 (_data_->_vala1_media);
			}
			goto __finally30;
			__catch30_boxes_error:
			{
				_data_->_vala1__error_ = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp45_ = _data_->_vala1_path;
				_data_->_tmp46_ = _data_->_vala1__error_;
				_data_->_tmp47_ = _data_->_tmp46_->message;
				g_warning ("media-manager.vala:76: Failed to use ISO '%s': %s", _data_->_tmp45_, _data_->_tmp47_);
				_g_error_free0 (_data_->_vala1__error_);
			}
			__finally30:
			if (_data_->_inner_error_ != NULL) {
				_g_free0 (_data_->media_id);
				_g_free0 (_data_->os_id);
				_g_free0 (_data_->title);
				_g_free0 (_data_->_vala1_path);
				_g_object_unref0 (_data_->file);
				_g_object_unref0 (_data_->cursor);
				goto __catch29_g_error;
			}
			_g_free0 (_data_->media_id);
			_g_free0 (_data_->os_id);
			_g_free0 (_data_->title);
			_g_free0 (_data_->_vala1_path);
			_g_object_unref0 (_data_->file);
		}
		_g_object_unref0 (_data_->cursor);
	}
	goto __finally29;
	__catch29_g_error:
	{
		_data_->_vala2__error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp48_ = _data_->_vala2__error_;
		_data_->_tmp49_ = _data_->_tmp48_->message;
		g_warning ("media-manager.vala:80: Failed to fetch list of ISOs from Tracker: %s.", _data_->_tmp49_);
		_g_error_free0 (_data_->_vala2__error_);
	}
	__finally29:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->enumerator);
		__g_list_free__g_object_unref0_0 (_data_->list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = _data_->list;
	_g_object_unref0 (_data_->enumerator);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->enumerator);
	__g_list_free__g_object_unref0_0 (_data_->list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint boxes_media_manager_compare_media (BoxesInstallerMedia* media_a, BoxesInstallerMedia* media_b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	const gchar* _tmp2_;
	BoxesInstallerMedia* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	g_return_val_if_fail (media_a != NULL, 0);
	g_return_val_if_fail (media_b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = media_b;
	_tmp2_ = _tmp1_->label;
	_tmp3_ = media_a;
	_tmp4_ = _tmp3_->label;
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	result = _tmp5_;
	return result;
}


static void boxes_media_manager_create_installer_media_from_iso_info_data_free (gpointer _data) {
	BoxesMediaManagerCreateInstallerMediaFromIsoInfoData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->label);
	_g_free0 (_data_->os_id);
	_g_free0 (_data_->media_id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMediaManagerCreateInstallerMediaFromIsoInfoData, _data_);
}


static void boxes_media_manager_create_installer_media_from_iso_info (BoxesMediaManager* self, const gchar* path, const gchar* label, const gchar* os_id, const gchar* media_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesMediaManagerCreateInstallerMediaFromIsoInfoData* _data_;
	BoxesMediaManager* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	_data_ = g_slice_new0 (BoxesMediaManagerCreateInstallerMediaFromIsoInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_media_manager_create_installer_media_from_iso_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_media_manager_create_installer_media_from_iso_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->path = _tmp2_;
	_tmp3_ = label;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->label = _tmp4_;
	_tmp5_ = os_id;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->os_id = _tmp6_;
	_tmp7_ = media_id;
	_tmp8_ = g_strdup (_tmp7_);
	_data_->media_id = _tmp8_;
	boxes_media_manager_create_installer_media_from_iso_info_co (_data_);
}


static BoxesInstallerMedia* boxes_media_manager_create_installer_media_from_iso_info_finish (BoxesMediaManager* self, GAsyncResult* _res_, GError** error) {
	BoxesInstallerMedia* result;
	BoxesMediaManagerCreateInstallerMediaFromIsoInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_media_manager_create_installer_media_from_iso_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesMediaManagerCreateInstallerMediaFromIsoInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_media_manager_create_installer_media_from_iso_info_co (_data_);
}


static gboolean boxes_media_manager_create_installer_media_from_iso_info_co (BoxesMediaManagerCreateInstallerMediaFromIsoInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = _data_->label;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->os_id;
		_data_->_tmp1_ = _data_->_tmp3_ == NULL;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	if (_data_->_tmp4_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->media_id;
		_data_->_tmp0_ = _data_->_tmp5_ == NULL;
	}
	_data_->_tmp6_ = _data_->_tmp0_;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->path;
		_data_->_state_ = 1;
		boxes_media_manager_create_installer_media_for_path (_data_->self, _data_->_tmp7_, NULL, boxes_media_manager_create_installer_media_from_iso_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = boxes_media_manager_create_installer_media_for_path_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = _data_->_tmp9_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->_os_db;
	_data_->_tmp11_ = _data_->os_id;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = boxes_os_database_get_os_by_id (_data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error_);
	_data_->os = _data_->_tmp12_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->self->priv->_os_db;
	_data_->_tmp14_ = _data_->os;
	_data_->_tmp15_ = _data_->media_id;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = boxes_os_database_get_media_by_id (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, &_data_->_inner_error_);
	_data_->os_media = _data_->_tmp16_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->os);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->self->priv->_os_db;
	_data_->_tmp18_ = _data_->os;
	_data_->_tmp19_ = _data_->os_media;
	_data_->_tmp20_ = NULL;
	g_object_get (_data_->_tmp19_, "architecture", &_data_->_tmp20_, NULL);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = boxes_os_database_get_resources_for_os (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_g_free0 (_data_->_tmp22_);
	_data_->resources = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->path;
	_data_->_tmp26_ = _data_->label;
	_data_->_tmp27_ = _data_->os;
	_data_->_tmp28_ = _data_->os_media;
	_data_->_tmp29_ = _data_->resources;
	_data_->_tmp30_ = boxes_installer_media_new_from_iso_info (_data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_);
	_data_->media = _data_->_tmp30_;
	_data_->_tmp31_ = _data_->media;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = boxes_media_manager_create_installer_media_from_media (_data_->self, _data_->_tmp31_, &_data_->_inner_error_);
	_data_->_tmp33_ = _data_->_tmp32_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media);
		_g_object_unref0 (_data_->resources);
		_g_object_unref0 (_data_->os_media);
		_g_object_unref0 (_data_->os);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp33_;
	_g_object_unref0 (_data_->media);
	_g_object_unref0 (_data_->resources);
	_g_object_unref0 (_data_->os_media);
	_g_object_unref0 (_data_->os);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media);
	_g_object_unref0 (_data_->resources);
	_g_object_unref0 (_data_->os_media);
	_g_object_unref0 (_data_->os);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static BoxesInstallerMedia* boxes_media_manager_create_installer_media_from_media (BoxesMediaManager* self, BoxesInstallerMedia* media, GError** error) {
	BoxesInstallerMedia* result = NULL;
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	BoxesInstallerMedia* _tmp4_;
	OsinfoOs* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	static GQuark _tmp9_label1 = 0;
	static GQuark _tmp9_label2 = 0;
	static GQuark _tmp9_label3 = 0;
	static GQuark _tmp9_label4 = 0;
	static GQuark _tmp9_label5 = 0;
	static GQuark _tmp9_label6 = 0;
	static GQuark _tmp9_label7 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = media;
	_tmp1_ = _tmp0_->os;
	if (_tmp1_ == NULL) {
		BoxesInstallerMedia* _tmp2_;
		BoxesInstallerMedia* _tmp3_;
		_tmp2_ = media;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = media;
	_tmp5_ = _tmp4_->os;
	_tmp6_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (((_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("fedora14")))) || (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("fedora15"))))) || (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("fedora16"))))) {
		switch (0) {
			default:
			{
				BoxesInstallerMedia* _tmp11_;
				BoxesFedoraInstaller* _tmp12_;
				BoxesFedoraInstaller* _tmp13_;
				_tmp11_ = media;
				_tmp12_ = boxes_fedora_installer_new_copy (_tmp11_, &_inner_error_);
				_tmp13_ = _tmp12_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
				result = (BoxesInstallerMedia*) _tmp13_;
				return result;
			}
		}
	} else if ((_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("win7")))) || (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("win2k8"))))) {
		switch (0) {
			default:
			{
				BoxesInstallerMedia* _tmp14_;
				BoxesWin7Installer* _tmp15_;
				BoxesWin7Installer* _tmp16_;
				_tmp14_ = media;
				_tmp15_ = boxes_win7_installer_new_copy (_tmp14_, &_inner_error_);
				_tmp16_ = _tmp15_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
				result = (BoxesInstallerMedia*) _tmp16_;
				return result;
			}
		}
	} else if (((_tmp10_ == ((0 != _tmp9_label5) ? _tmp9_label5 : (_tmp9_label5 = g_quark_from_static_string ("winxp")))) || (_tmp10_ == ((0 != _tmp9_label6) ? _tmp9_label6 : (_tmp9_label6 = g_quark_from_static_string ("win2k"))))) || (_tmp10_ == ((0 != _tmp9_label7) ? _tmp9_label7 : (_tmp9_label7 = g_quark_from_static_string ("win2k3"))))) {
		switch (0) {
			default:
			{
				BoxesInstallerMedia* _tmp17_;
				BoxesWinXPInstaller* _tmp18_;
				BoxesWinXPInstaller* _tmp19_;
				_tmp17_ = media;
				_tmp18_ = boxes_win_xp_installer_new_copy (_tmp17_, &_inner_error_);
				_tmp19_ = _tmp18_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				}
				result = (BoxesInstallerMedia*) _tmp19_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				BoxesInstallerMedia* _tmp20_;
				BoxesInstallerMedia* _tmp21_;
				_tmp20_ = media;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				result = _tmp21_;
				return result;
			}
		}
	}
}


BoxesOSDatabase* boxes_media_manager_get_os_db (BoxesMediaManager* self) {
	BoxesOSDatabase* result;
	BoxesOSDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_os_db;
	result = _tmp0_;
	return result;
}


static gpointer _boxes_os_database_ref0 (gpointer self) {
	return self ? boxes_os_database_ref (self) : NULL;
}


static void boxes_media_manager_set_os_db (BoxesMediaManager* self, BoxesOSDatabase* value) {
	BoxesOSDatabase* _tmp0_;
	BoxesOSDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _boxes_os_database_ref0 (_tmp0_);
	_boxes_os_database_unref0 (self->priv->_os_db);
	self->priv->_os_db = _tmp1_;
	g_object_notify ((GObject *) self, "os-db");
}


GUdevClient* boxes_media_manager_get_client (BoxesMediaManager* self) {
	GUdevClient* result;
	GUdevClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_client;
	result = _tmp0_;
	return result;
}


static void boxes_media_manager_set_client (BoxesMediaManager* self, GUdevClient* value) {
	GUdevClient* _tmp0_;
	GUdevClient* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_client);
	self->priv->_client = _tmp1_;
	g_object_notify ((GObject *) self, "client");
}


static void boxes_media_manager_class_init (BoxesMediaManagerClass * klass) {
	boxes_media_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesMediaManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_media_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_media_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_media_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MEDIA_MANAGER_OS_DB, boxes_param_spec_os_database ("os-db", "os-db", "os-db", BOXES_TYPE_OS_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MEDIA_MANAGER_CLIENT, g_param_spec_object ("client", "client", "client", g_udev_client_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void boxes_media_manager_instance_init (BoxesMediaManager * self) {
	self->priv = BOXES_MEDIA_MANAGER_GET_PRIVATE (self);
}


static void boxes_media_manager_finalize (GObject* obj) {
	BoxesMediaManager * self;
	self = BOXES_MEDIA_MANAGER (obj);
	_boxes_os_database_unref0 (self->priv->_os_db);
	_g_object_unref0 (self->priv->_client);
	_g_object_unref0 (self->priv->connection);
	G_OBJECT_CLASS (boxes_media_manager_parent_class)->finalize (obj);
}


GType boxes_media_manager_get_type (void) {
	static volatile gsize boxes_media_manager_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_media_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesMediaManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_media_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesMediaManager), 0, (GInstanceInitFunc) boxes_media_manager_instance_init, NULL };
		GType boxes_media_manager_type_id;
		boxes_media_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesMediaManager", &g_define_type_info, 0);
		g_once_init_leave (&boxes_media_manager_type_id__volatile, boxes_media_manager_type_id);
	}
	return boxes_media_manager_type_id__volatile;
}


static void _vala_boxes_media_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesMediaManager * self;
	self = BOXES_MEDIA_MANAGER (object);
	switch (property_id) {
		case BOXES_MEDIA_MANAGER_OS_DB:
		boxes_value_set_os_database (value, boxes_media_manager_get_os_db (self));
		break;
		case BOXES_MEDIA_MANAGER_CLIENT:
		g_value_set_object (value, boxes_media_manager_get_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_boxes_media_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BoxesMediaManager * self;
	self = BOXES_MEDIA_MANAGER (object);
	switch (property_id) {
		case BOXES_MEDIA_MANAGER_OS_DB:
		boxes_media_manager_set_os_db (self, boxes_value_get_os_database (value));
		break;
		case BOXES_MEDIA_MANAGER_CLIENT:
		boxes_media_manager_set_client (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



