/* archive-writer.c generated by valac 0.39.5, the Vala compiler
 * generated from archive-writer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* A non-threadsafe wrapper for libarchives write archive*/

#include <glib.h>
#include <glib-object.h>
#include <archive.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libcommon.h>
#include <archive_entry.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <sys/stat.h>


#define BOXES_TYPE_ARCHIVE_WRITER (boxes_archive_writer_get_type ())
#define BOXES_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriter))
#define BOXES_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterClass))
#define BOXES_IS_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_WRITER))
#define BOXES_IS_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_WRITER))
#define BOXES_ARCHIVE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterClass))

typedef struct _BoxesArchiveWriter BoxesArchiveWriter;
typedef struct _BoxesArchiveWriterClass BoxesArchiveWriterClass;
typedef struct _BoxesArchiveWriterPrivate BoxesArchiveWriterPrivate;
enum  {
	BOXES_ARCHIVE_WRITER_0_PROPERTY,
	BOXES_ARCHIVE_WRITER_NUM_PROPERTIES
};
static GParamSpec* boxes_archive_writer_properties[BOXES_ARCHIVE_WRITER_NUM_PROPERTIES];
#define _archive_write_finish0(var) ((var == NULL) ? NULL : (var = (archive_write_finish (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block13Data Block13Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _Block14Data Block14Data;
typedef struct _BoxesArchiveReaderPrivate BoxesArchiveReaderPrivate;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesArchiveWriter {
	GObject parent_instance;
	BoxesArchiveWriterPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveWriterClass {
	GObjectClass parent_class;
};

struct _BoxesArchiveWriterPrivate {
	GList* filters;
	int format;
};

struct _Block13Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gchar* filename;
};

struct _Block14Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gchar* filename;
};

struct _BoxesArchiveReader {
	GObject parent_instance;
	BoxesArchiveReaderPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveReaderClass {
	GObjectClass parent_class;
};

struct _Block15Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	struct archive_entry* iterator;
};

struct _Block16Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	struct archive_entry* entry;
};

struct _Block17Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	int filter;
};


static gpointer boxes_archive_writer_parent_class = NULL;

GType boxes_archive_writer_get_type (void) G_GNUC_CONST;
#define BOXES_ARCHIVE_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterPrivate))
BoxesArchiveWriter* boxes_archive_writer_new (const gchar* filename,
                                              int format,
                                              GList* filters,
                                              GError** error);
BoxesArchiveWriter* boxes_archive_writer_construct (GType object_type,
                                                    const gchar* filename,
                                                    int format,
                                                    GList* filters,
                                                    GError** error);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void boxes_archive_writer_prepare_archive (BoxesArchiveWriter* self,
                                           GError** error);
static int __lambda37_ (Block13Data* _data13_);
static int ___lambda37__boxes_libarchive_function (gpointer self);
GType boxes_archive_reader_get_type (void) G_GNUC_CONST;
BoxesArchiveWriter* boxes_archive_writer_new_from_archive_reader (BoxesArchiveReader* archive_reader,
                                                                  const gchar* filename,
                                                                  gboolean import_contents,
                                                                  GError** error);
BoxesArchiveWriter* boxes_archive_writer_construct_from_archive_reader (GType object_type,
                                                                        BoxesArchiveReader* archive_reader,
                                                                        const gchar* filename,
                                                                        gboolean import_contents,
                                                                        GError** error);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void boxes_archive_writer_copy_filters_from_read_archive (BoxesArchiveWriter* self,
                                                          struct archive* read_archive);
static int __lambda38_ (Block14Data* _data14_);
static int ___lambda38__boxes_libarchive_function (gpointer self);
void boxes_archive_reader_reset (BoxesArchiveReader* self,
                                 GError** error);
void boxes_archive_writer_import_read_archive (BoxesArchiveWriter* self,
                                               BoxesArchiveReader* archive_reader,
                                               gchar** omit_files,
                                               int omit_files_length1,
                                               gboolean omit_hardlinked_files,
                                               GError** error);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static int ___lambda39_ (Block15Data* _data15_);
static int ____lambda39__boxes_libarchive_function (gpointer self);
static void boxes_archive_writer_insert_data (BoxesArchiveWriter* self,
                                       void* data,
                                       gint64 len,
                                       GError** error);
void boxes_archive_writer_insert_files (BoxesArchiveWriter* self,
                                        gchar** src_list,
                                        int src_list_length1,
                                        gchar** dest_list,
                                        int dest_list_length1,
                                        GError** error);
void boxes_archive_writer_insert_file (BoxesArchiveWriter* self,
                                       const gchar* src,
                                       const gchar* dest,
                                       GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static struct archive_entry* boxes_archive_writer_get_entry_for_file (BoxesArchiveWriter* self,
                                                               const gchar* filename,
                                                               const gchar* dest_name);
static int __lambda40_ (Block16Data* _data16_);
static int ___lambda40__boxes_libarchive_function (gpointer self);
static int __lambda35_ (BoxesArchiveWriter* self);
static int ___lambda35__boxes_libarchive_function (gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static int _____lambda36_ (Block17Data* _data17_);
static int ______lambda36__boxes_libarchive_function (gpointer self);
static void boxes_archive_writer_finalize (GObject * obj);


static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data13_;
#line 203 "archive-writer.c"
}


static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 214 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data13_->self;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_free0 (_data13_->filename);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block13Data, _data13_);
#line 224 "archive-writer.c"
	}
}


static int
__lambda37_ (Block13Data* _data13_)
{
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data13_->self;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = archive_write_open_filename (_tmp0_, _data13_->filename);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 243 "archive-writer.c"
}


static int
___lambda37__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda37_ (self);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 254 "archive-writer.c"
}


BoxesArchiveWriter*
boxes_archive_writer_construct (GType object_type,
                                const gchar* filename,
                                int format,
                                GList* filters,
                                GError** error)
{
	BoxesArchiveWriter * self = NULL;
	Block13Data* _data13_;
	gchar* _tmp0_;
	struct archive* _tmp1_;
	GList* _tmp2_;
	struct archive* _tmp3_;
	GError * _inner_error_ = NULL;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data13_ = g_slice_new0 (Block13Data);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data13_->_ref_count_ = 1;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = g_strdup (filename);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_free0 (_data13_->filename);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data13_->filename = _tmp0_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data13_->self = g_object_ref (self);
#line 14 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = archive_write_new ();
#line 14 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_archive_write_finish0 (self->archive);
#line 14 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->archive = _tmp1_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->format = format;
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = g_list_copy (filters);
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_list_free0 (self->priv->filters);
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->filters = _tmp2_;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_prepare_archive (self, &_inner_error_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block13_data_unref (_data13_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data13_ = NULL;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 318 "archive-writer.c"
		} else {
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block13_data_unref (_data13_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data13_ = NULL;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 330 "archive-writer.c"
		}
	}
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = self->archive;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp3_, ___lambda37__boxes_libarchive_function, _data13_, (guint) 1, &_inner_error_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block13_data_unref (_data13_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data13_ = NULL;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 351 "archive-writer.c"
		} else {
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block13_data_unref (_data13_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data13_ = NULL;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 363 "archive-writer.c"
		}
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block13_data_unref (_data13_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data13_ = NULL;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return self;
#line 372 "archive-writer.c"
}


BoxesArchiveWriter*
boxes_archive_writer_new (const gchar* filename,
                          int format,
                          GList* filters,
                          GError** error)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return boxes_archive_writer_construct (BOXES_TYPE_ARCHIVE_WRITER, filename, format, filters, error);
#line 384 "archive-writer.c"
}


static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data14_;
#line 395 "archive-writer.c"
}


static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 406 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data14_->self;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_free0 (_data14_->filename);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block14Data, _data14_);
#line 416 "archive-writer.c"
	}
}


static int
__lambda38_ (Block14Data* _data14_)
{
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data14_->self;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = archive_write_open_filename (_tmp0_, _data14_->filename);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 435 "archive-writer.c"
}


static int
___lambda38__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda38_ (self);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 446 "archive-writer.c"
}


BoxesArchiveWriter*
boxes_archive_writer_construct_from_archive_reader (GType object_type,
                                                    BoxesArchiveReader* archive_reader,
                                                    const gchar* filename,
                                                    gboolean import_contents,
                                                    GError** error)
{
	BoxesArchiveWriter * self = NULL;
	Block14Data* _data14_;
	gchar* _tmp0_;
	struct archive_entry* iterator = NULL;
	struct archive* _tmp1_;
	gboolean _tmp2_ = FALSE;
	struct archive* _tmp3_;
	struct archive_entry* _tmp4_ = NULL;
	gboolean _tmp5_;
	struct archive* _tmp9_;
	struct archive* _tmp10_;
	struct archive* _tmp11_;
	GError * _inner_error_ = NULL;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (archive_reader != NULL, NULL);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_ = g_slice_new0 (Block14Data);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_->_ref_count_ = 1;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = g_strdup (filename);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_free0 (_data14_->filename);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_->filename = _tmp0_;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_->self = g_object_ref (self);
#line 27 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = archive_write_new ();
#line 27 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_archive_write_finish0 (self->archive);
#line 27 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->archive = _tmp1_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = archive_reader->archive;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp5_ = boxes_get_next_header (_tmp3_, &_tmp4_, (guint) 1, &_inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	iterator = _tmp4_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = _tmp5_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 516 "archive-writer.c"
		} else {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 528 "archive-writer.c"
		}
	}
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (!_tmp2_) {
#line 533 "archive-writer.c"
		gchar* msg = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp6_ = g_strdup ("Error creating write archive for archive '%s'. It is probably empty.");
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		msg = _tmp6_;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp7_ = msg;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp7_, _data14_->filename);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp8_;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_free0 (msg);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 562 "archive-writer.c"
		} else {
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_free0 (msg);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 576 "archive-writer.c"
		}
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_free0 (msg);
#line 580 "archive-writer.c"
	}
#line 33 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp9_ = archive_reader->archive;
#line 33 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->format = archive_format (_tmp9_);
#line 34 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp10_ = archive_reader->archive;
#line 34 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_copy_filters_from_read_archive (self, _tmp10_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_prepare_archive (self, &_inner_error_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 606 "archive-writer.c"
		} else {
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 618 "archive-writer.c"
		}
	}
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp11_ = self->archive;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp11_, ___lambda38__boxes_libarchive_function, _data14_, (guint) 1, &_inner_error_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 639 "archive-writer.c"
		} else {
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 651 "archive-writer.c"
		}
	}
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_reader_reset (archive_reader, &_inner_error_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 670 "archive-writer.c"
		} else {
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 682 "archive-writer.c"
		}
	}
#line 40 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (import_contents) {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		boxes_archive_writer_import_read_archive (self, archive_reader, NULL, 0, FALSE, &_inner_error_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_propagate_error (error, _inner_error_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block14_data_unref (_data14_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data14_ = NULL;
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_g_object_unref0 (self);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return NULL;
#line 703 "archive-writer.c"
			} else {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block14_data_unref (_data14_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data14_ = NULL;
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_clear_error (&_inner_error_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return NULL;
#line 715 "archive-writer.c"
			}
		}
	}
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block14_data_unref (_data14_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_ = NULL;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return self;
#line 725 "archive-writer.c"
}


BoxesArchiveWriter*
boxes_archive_writer_new_from_archive_reader (BoxesArchiveReader* archive_reader,
                                              const gchar* filename,
                                              gboolean import_contents,
                                              GError** error)
{
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return boxes_archive_writer_construct_from_archive_reader (BOXES_TYPE_ARCHIVE_WRITER, archive_reader, filename, import_contents, error);
#line 737 "archive-writer.c"
}


static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data15_;
#line 748 "archive-writer.c"
}


static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 759 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data15_->self;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block15Data, _data15_);
#line 767 "archive-writer.c"
	}
}


static int
___lambda39_ (Block15Data* _data15_)
{
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	struct archive_entry* _tmp1_;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data15_->self;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data15_->iterator;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = archive_write_header (_tmp0_, _tmp1_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 789 "archive-writer.c"
}


static int
____lambda39__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda39_ (self);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 800 "archive-writer.c"
}


void
boxes_archive_writer_import_read_archive (BoxesArchiveWriter* self,
                                          BoxesArchiveReader* archive_reader,
                                          gchar** omit_files,
                                          int omit_files_length1,
                                          gboolean omit_hardlinked_files,
                                          GError** error)
{
	Block15Data* _data15_;
	GError * _inner_error_ = NULL;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (archive_reader != NULL);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_->_ref_count_ = 1;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_->self = g_object_ref (self);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	while (TRUE) {
#line 826 "archive-writer.c"
		gboolean _tmp0_ = FALSE;
		struct archive* _tmp1_;
		struct archive_entry* _tmp2_ = NULL;
		gboolean _tmp3_;
		gboolean omit = FALSE;
		gboolean _tmp8_;
		gint64 len = 0LL;
		struct archive_entry* _tmp16_;
		struct archive* _tmp17_;
		gint64 _tmp18_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp1_ = archive_reader->archive;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp3_ = boxes_get_next_header (_tmp1_, &_tmp2_, (guint) 1, &_inner_error_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_data15_->iterator = _tmp2_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp0_ = _tmp3_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_propagate_error (error, _inner_error_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block15_data_unref (_data15_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data15_ = NULL;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 857 "archive-writer.c"
			} else {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block15_data_unref (_data15_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data15_ = NULL;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_clear_error (&_inner_error_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 869 "archive-writer.c"
			}
		}
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (!_tmp0_) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			break;
#line 876 "archive-writer.c"
		}
#line 53 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		omit = FALSE;
#line 880 "archive-writer.c"
		{
			gchar** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			file_collection = omit_files;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			file_collection_length1 = omit_files_length1;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			for (file_it = 0; file_it < omit_files_length1; file_it = file_it + 1) {
#line 892 "archive-writer.c"
				gchar* _tmp4_;
				gchar* file = NULL;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp4_ = g_strdup (file_collection[file_it]);
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				file = _tmp4_;
#line 899 "archive-writer.c"
				{
					const gchar* _tmp5_;
					struct archive_entry* _tmp6_;
					const gchar* _tmp7_;
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp5_ = file;
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp6_ = _data15_->iterator;
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp7_ = archive_entry_pathname (_tmp6_);
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 56 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						omit = TRUE;
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						_g_free0 (file);
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						break;
#line 918 "archive-writer.c"
					}
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_g_free0 (file);
#line 922 "archive-writer.c"
				}
			}
		}
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp8_ = omit;
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_tmp8_) {
#line 930 "archive-writer.c"
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (omit_hardlinked_files) {
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp10_ = TRUE;
#line 937 "archive-writer.c"
			} else {
				struct archive_entry* _tmp11_;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp11_ = _data15_->iterator;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp10_ = archive_entry_nlink (_tmp11_) == ((guint) 1);
#line 944 "archive-writer.c"
			}
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_tmp10_) {
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp9_ = TRUE;
#line 950 "archive-writer.c"
			} else {
				struct archive_entry* _tmp12_;
				const gchar* _tmp13_;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp12_ = _data15_->iterator;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp13_ = archive_entry_hardlink (_tmp12_);
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp9_ = _tmp13_ != NULL;
#line 960 "archive-writer.c"
			}
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_tmp9_) {
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				continue;
#line 966 "archive-writer.c"
			} else {
				struct archive_entry* _tmp14_;
				const gchar* _tmp15_;
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp14_ = _data15_->iterator;
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp15_ = archive_entry_pathname (_tmp14_);
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_warning ("archive-writer.vala:68: File '%s' cannot be omitted since a hardlink p" \
"oints to it.", _tmp15_);
#line 976 "archive-writer.c"
			}
		}
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp16_ = _data15_->iterator;
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		len = archive_entry_size (_tmp16_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp17_ = self->archive;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		boxes_execute_libarchive_function (_tmp17_, ____lambda39__boxes_libarchive_function, _data15_, (guint) 1, &_inner_error_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_propagate_error (error, _inner_error_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block15_data_unref (_data15_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data15_ = NULL;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 999 "archive-writer.c"
			} else {
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block15_data_unref (_data15_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data15_ = NULL;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_clear_error (&_inner_error_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 1011 "archive-writer.c"
			}
		}
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp18_ = len;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_tmp18_ > ((gint64) 0)) {
#line 1018 "archive-writer.c"
			guint8* buf = NULL;
			gint64 _tmp19_;
			guint8* _tmp20_;
			gint buf_length1;
			gint _buf_size_;
			guint8* _tmp21_;
			gint _tmp21__length1;
			struct archive* _tmp22_;
			guint8* _tmp23_;
			gint _tmp23__length1;
			gint64 _tmp24_;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp19_ = len;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp20_ = g_new0 (guint8, _tmp19_);
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = _tmp20_;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf_length1 = _tmp19_;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_buf_size_ = buf_length1;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp21_ = buf;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp21__length1 = buf_length1;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp22_ = archive_reader->archive;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp23_ = buf;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp23__length1 = buf_length1;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp24_ = len;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			boxes_archive_writer_insert_data (self, _tmp21_, (gint64) archive_read_data (_tmp22_, _tmp23_, (gsize) _tmp24_), &_inner_error_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					g_propagate_error (error, _inner_error_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					buf = (g_free (buf), NULL);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					block15_data_unref (_data15_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data15_ = NULL;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					return;
#line 1068 "archive-writer.c"
				} else {
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					buf = (g_free (buf), NULL);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					block15_data_unref (_data15_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data15_ = NULL;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					g_clear_error (&_inner_error_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					return;
#line 1082 "archive-writer.c"
				}
			}
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 1087 "archive-writer.c"
		}
	}
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_reader_reset (archive_reader, &_inner_error_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1104 "archive-writer.c"
		} else {
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1116 "archive-writer.c"
		}
	}
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block15_data_unref (_data15_);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_ = NULL;
#line 1123 "archive-writer.c"
}


void
boxes_archive_writer_insert_files (BoxesArchiveWriter* self,
                                   gchar** src_list,
                                   int src_list_length1,
                                   gchar** dest_list,
                                   int dest_list_length1,
                                   GError** error)
{
	GError * _inner_error_ = NULL;
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_vala_return_if_fail (src_list_length1 == dest_list_length1, "src_list.length == dest_list.length");
#line 1140 "archive-writer.c"
	{
		guint i = 0U;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		i = (guint) 0;
#line 1145 "archive-writer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp0_ = TRUE;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			while (TRUE) {
#line 1152 "archive-writer.c"
				guint _tmp2_;
				guint _tmp3_;
				const gchar* _tmp4_;
				guint _tmp5_;
				const gchar* _tmp6_;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!_tmp0_) {
#line 1160 "archive-writer.c"
					guint _tmp1_;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp1_ = i;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					i = _tmp1_ + 1;
#line 1166 "archive-writer.c"
				}
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp0_ = FALSE;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp2_ = i;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!(_tmp2_ < ((guint) src_list_length1))) {
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					break;
#line 1176 "archive-writer.c"
				}
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp3_ = i;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp4_ = src_list[_tmp3_];
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp5_ = i;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp6_ = dest_list[_tmp5_];
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				boxes_archive_writer_insert_file (self, _tmp4_, _tmp6_, &_inner_error_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					if (_inner_error_->domain == G_IO_ERROR) {
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						g_propagate_error (error, _inner_error_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						return;
#line 1196 "archive-writer.c"
					} else {
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						g_clear_error (&_inner_error_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						return;
#line 1204 "archive-writer.c"
					}
				}
			}
		}
	}
}


static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data16_;
#line 1220 "archive-writer.c"
}


static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1231 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data16_->self;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_archive_entry_free0 (_data16_->entry);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block16Data, _data16_);
#line 1241 "archive-writer.c"
	}
}


static int
__lambda40_ (Block16Data* _data16_)
{
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	struct archive_entry* _tmp1_;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data16_->self;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data16_->entry;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = archive_write_header (_tmp0_, _tmp1_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1263 "archive-writer.c"
}


static int
___lambda40__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda40_ (self);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1274 "archive-writer.c"
}


void
boxes_archive_writer_insert_file (BoxesArchiveWriter* self,
                                  const gchar* src,
                                  const gchar* dest,
                                  GError** error)
{
	Block16Data* _data16_;
	struct archive_entry* _tmp2_;
	gint64 len = 0LL;
	struct archive_entry* _tmp3_;
	guint8* buf = NULL;
	gint64 _tmp4_;
	guint8* _tmp5_;
	gint buf_length1;
	gint _buf_size_;
	FILE* filestream = NULL;
	FILE* _tmp6_;
	FILE* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gint64 _tmp9_;
	struct archive* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint64 _tmp12_;
	GError * _inner_error_ = NULL;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (src != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (dest != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_->_ref_count_ = 1;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_->self = g_object_ref (self);
#line 93 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (!g_file_test (src, G_FILE_TEST_EXISTS)) {
#line 1318 "archive-writer.c"
		GError* _tmp0_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp0_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Source file '%s' cannot be injected. File not found.", src);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp0_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1334 "archive-writer.c"
		} else {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1346 "archive-writer.c"
		}
	}
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_file_test (src, G_FILE_TEST_IS_SYMLINK)) {
#line 1351 "archive-writer.c"
		GError* _tmp1_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Inserting symlinks is currently not supported.");
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp1_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1367 "archive-writer.c"
		} else {
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1379 "archive-writer.c"
		}
	}
#line 99 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = boxes_archive_writer_get_entry_for_file (self, src, dest);
#line 99 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_->entry = _tmp2_;
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = _data16_->entry;
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	len = archive_entry_size (_tmp3_);
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp4_ = len;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp5_ = g_new0 (guint8, _tmp4_);
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	buf = _tmp5_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	buf_length1 = _tmp4_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_buf_size_ = buf_length1;
#line 104 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp6_ = g_fopen (src, "r");
#line 104 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	filestream = _tmp6_;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp7_ = filestream;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp8_ = buf;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp8__length1 = buf_length1;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp9_ = len;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	fread ((guint8*) _tmp8_, (gsize) _tmp9_, (_tmp8__length1 * sizeof (guint8)) / sizeof (guint8), _tmp7_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp10_ = self->archive;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp10_, ___lambda40__boxes_libarchive_function, _data16_, (guint) 1, &_inner_error_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1434 "archive-writer.c"
		} else {
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1450 "archive-writer.c"
		}
	}
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp11_ = buf;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp11__length1 = buf_length1;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp12_ = len;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_insert_data (self, (guint8*) _tmp11_, _tmp12_, &_inner_error_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1477 "archive-writer.c"
		} else {
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1493 "archive-writer.c"
		}
	}
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_fclose0 (filestream);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	buf = (g_free (buf), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block16_data_unref (_data16_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_ = NULL;
#line 1504 "archive-writer.c"
}


static int
__lambda35_ (BoxesArchiveWriter* self)
{
	int result = 0;
	struct archive* _tmp0_;
	int _tmp1_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = self->priv->format;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = archive_write_set_format (_tmp0_, _tmp1_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1522 "archive-writer.c"
}


static int
___lambda35__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda35_ ((BoxesArchiveWriter*) self);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1533 "archive-writer.c"
}


static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data17_;
#line 1544 "archive-writer.c"
}


static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 1555 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data17_->self;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block17Data, _data17_);
#line 1563 "archive-writer.c"
	}
}


static int
_____lambda36_ (Block17Data* _data17_)
{
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	int _tmp1_;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data17_->self;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data17_->filter;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = archive_write_add_filter (_tmp0_, _tmp1_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1585 "archive-writer.c"
}


static int
______lambda36__boxes_libarchive_function (gpointer self)
{
	int result;
	result = _____lambda36_ (self);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1596 "archive-writer.c"
}


static void
boxes_archive_writer_prepare_archive (BoxesArchiveWriter* self,
                                      GError** error)
{
	struct archive* _tmp0_;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp0_, ___lambda35__boxes_libarchive_function, self, (guint) 1, &_inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1621 "archive-writer.c"
		} else {
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1629 "archive-writer.c"
		}
	}
#line 113 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = self->priv->filters;
#line 113 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (_tmp1_ != NULL) {
#line 1636 "archive-writer.c"
		GList* _tmp2_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp2_ = self->priv->filters;
#line 1640 "archive-writer.c"
		{
			GList* filter_collection = NULL;
			GList* filter_it = NULL;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			filter_collection = _tmp2_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
#line 1648 "archive-writer.c"
				int filter = 0;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				filter = (int) ((gintptr) filter_it->data);
#line 1652 "archive-writer.c"
				{
					Block17Data* _data17_;
					struct archive* _tmp3_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data17_ = g_slice_new0 (Block17Data);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data17_->_ref_count_ = 1;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data17_->self = g_object_ref (self);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data17_->filter = filter;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp3_ = self->archive;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					boxes_execute_libarchive_function (_tmp3_, ______lambda36__boxes_libarchive_function, _data17_, (guint) 1, &_inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						if (_inner_error_->domain == G_IO_ERROR) {
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							g_propagate_error (error, _inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							block17_data_unref (_data17_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							_data17_ = NULL;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							return;
#line 1680 "archive-writer.c"
						} else {
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							block17_data_unref (_data17_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							_data17_ = NULL;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							g_clear_error (&_inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							return;
#line 1692 "archive-writer.c"
						}
					}
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					block17_data_unref (_data17_);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data17_ = NULL;
#line 1699 "archive-writer.c"
				}
			}
		}
	}
}


static void
boxes_archive_writer_copy_filters_from_read_archive (BoxesArchiveWriter* self,
                                                     struct archive* read_archive)
{
#line 119 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (read_archive != NULL);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_list_free0 (self->priv->filters);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->filters = NULL;
#line 1719 "archive-writer.c"
	{
		gint i = 0;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		i = archive_filter_count (read_archive) - 1;
#line 1724 "archive-writer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp0_ = TRUE;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			while (TRUE) {
#line 1731 "archive-writer.c"
				gint _tmp2_;
				gint _tmp3_;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!_tmp0_) {
#line 1736 "archive-writer.c"
					gint _tmp1_;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp1_ = i;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					i = _tmp1_ - 1;
#line 1742 "archive-writer.c"
				}
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp0_ = FALSE;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp2_ = i;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!(_tmp2_ > 0)) {
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					break;
#line 1752 "archive-writer.c"
				}
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp3_ = i;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				self->priv->filters = g_list_append (self->priv->filters, (gpointer) ((gintptr) archive_filter_code (read_archive, _tmp3_ - 1)));
#line 1758 "archive-writer.c"
			}
		}
	}
}


static void
boxes_archive_writer_insert_data (BoxesArchiveWriter* self,
                                  void* data,
                                  gint64 len,
                                  GError** error)
{
	struct archive* _tmp0_;
	GError * _inner_error_ = NULL;
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (((gint64) archive_write_data (_tmp0_, data, (gsize) len)) != len) {
#line 1779 "archive-writer.c"
		struct archive* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp1_ = self->archive;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp2_ = archive_error_string (_tmp1_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp3_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed writing data to archive. Message: '%s'.", _tmp2_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp3_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1797 "archive-writer.c"
		} else {
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1805 "archive-writer.c"
		}
	}
}


static struct archive_entry*
boxes_archive_writer_get_entry_for_file (BoxesArchiveWriter* self,
                                         const gchar* filename,
                                         const gchar* dest_name)
{
	struct archive_entry* result = NULL;
	struct stat st = {0};
	struct archive_entry* _result_ = NULL;
	struct archive_entry* _tmp0_;
	struct stat _tmp1_ = {0};
	struct stat _tmp2_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (dest_name != NULL, NULL);
#line 133 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = archive_entry_new ();
#line 133 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_result_ = _tmp0_;
#line 135 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	stat (filename, &_tmp1_);
#line 135 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	st = _tmp1_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = st;
#line 137 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	archive_entry_copy_stat (_result_, &_tmp2_);
#line 138 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	archive_entry_set_pathname (_result_, dest_name);
#line 140 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _result_;
#line 140 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1846 "archive-writer.c"
}


static void
boxes_archive_writer_class_init (BoxesArchiveWriterClass * klass)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_parent_class = g_type_class_peek_parent (klass);
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_type_class_add_private (klass, sizeof (BoxesArchiveWriterPrivate));
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_archive_writer_finalize;
#line 1859 "archive-writer.c"
}


static void
boxes_archive_writer_instance_init (BoxesArchiveWriter * self)
{
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv = BOXES_ARCHIVE_WRITER_GET_PRIVATE (self);
#line 1868 "archive-writer.c"
}


static void
boxes_archive_writer_finalize (GObject * obj)
{
	BoxesArchiveWriter * self;
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriter);
#line 5 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_archive_write_finish0 (self->archive);
#line 7 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_list_free0 (self->priv->filters);
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	G_OBJECT_CLASS (boxes_archive_writer_parent_class)->finalize (obj);
#line 1884 "archive-writer.c"
}


GType
boxes_archive_writer_get_type (void)
{
	static volatile gsize boxes_archive_writer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_archive_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesArchiveWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_archive_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesArchiveWriter), 0, (GInstanceInitFunc) boxes_archive_writer_instance_init, NULL };
		GType boxes_archive_writer_type_id;
		boxes_archive_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesArchiveWriter", &g_define_type_info, 0);
		g_once_init_leave (&boxes_archive_writer_type_id__volatile, boxes_archive_writer_type_id);
	}
	return boxes_archive_writer_type_id__volatile;
}



