/* archive-writer.c generated by valac 0.38.4, the Vala compiler
 * generated from archive-writer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* A non-threadsafe wrapper for libarchives write archive*/

#include <glib.h>
#include <glib-object.h>
#include <archive.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libcommon.h>
#include <archive_entry.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <sys/stat.h>


#define BOXES_TYPE_ARCHIVE_WRITER (boxes_archive_writer_get_type ())
#define BOXES_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriter))
#define BOXES_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterClass))
#define BOXES_IS_ARCHIVE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_WRITER))
#define BOXES_IS_ARCHIVE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_WRITER))
#define BOXES_ARCHIVE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterClass))

typedef struct _BoxesArchiveWriter BoxesArchiveWriter;
typedef struct _BoxesArchiveWriterClass BoxesArchiveWriterClass;
typedef struct _BoxesArchiveWriterPrivate BoxesArchiveWriterPrivate;
enum  {
	BOXES_ARCHIVE_WRITER_0_PROPERTY,
	BOXES_ARCHIVE_WRITER_NUM_PROPERTIES
};
static GParamSpec* boxes_archive_writer_properties[BOXES_ARCHIVE_WRITER_NUM_PROPERTIES];
#define _archive_write_finish0(var) ((var == NULL) ? NULL : (var = (archive_write_finish (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block14Data Block14Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _Block15Data Block15Data;
typedef struct _BoxesArchiveReaderPrivate BoxesArchiveReaderPrivate;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block18Data Block18Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesArchiveWriter {
	GObject parent_instance;
	BoxesArchiveWriterPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveWriterClass {
	GObjectClass parent_class;
};

struct _BoxesArchiveWriterPrivate {
	GList* filters;
	int format;
};

struct _Block14Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gchar* filename;
};

struct _Block15Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	gchar* filename;
};

struct _BoxesArchiveReader {
	GObject parent_instance;
	BoxesArchiveReaderPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveReaderClass {
	GObjectClass parent_class;
};

struct _Block16Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	struct archive_entry* iterator;
};

struct _Block17Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	struct archive_entry* entry;
};

struct _Block18Data {
	int _ref_count_;
	BoxesArchiveWriter* self;
	int filter;
};


static gpointer boxes_archive_writer_parent_class = NULL;

GType boxes_archive_writer_get_type (void) G_GNUC_CONST;
#define BOXES_ARCHIVE_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriterPrivate))
BoxesArchiveWriter* boxes_archive_writer_new (const gchar* filename, int format, GList* filters, GError** error);
BoxesArchiveWriter* boxes_archive_writer_construct (GType object_type, const gchar* filename, int format, GList* filters, GError** error);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void boxes_archive_writer_prepare_archive (BoxesArchiveWriter* self, GError** error);
static int __lambda36_ (Block14Data* _data14_);
static int ___lambda36__boxes_libarchive_function (gpointer self);
GType boxes_archive_reader_get_type (void) G_GNUC_CONST;
BoxesArchiveWriter* boxes_archive_writer_new_from_archive_reader (BoxesArchiveReader* archive_reader, const gchar* filename, gboolean import_contents, GError** error);
BoxesArchiveWriter* boxes_archive_writer_construct_from_archive_reader (GType object_type, BoxesArchiveReader* archive_reader, const gchar* filename, gboolean import_contents, GError** error);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void boxes_archive_writer_copy_filters_from_read_archive (BoxesArchiveWriter* self, struct archive* read_archive);
static int __lambda37_ (Block15Data* _data15_);
static int ___lambda37__boxes_libarchive_function (gpointer self);
void boxes_archive_reader_reset (BoxesArchiveReader* self, GError** error);
void boxes_archive_writer_import_read_archive (BoxesArchiveWriter* self, BoxesArchiveReader* archive_reader, gchar** omit_files, int omit_files_length1, gboolean omit_hardlinked_files, GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static int ___lambda38_ (Block16Data* _data16_);
static int ____lambda38__boxes_libarchive_function (gpointer self);
static void boxes_archive_writer_insert_data (BoxesArchiveWriter* self, void* data, gint64 len, GError** error);
void boxes_archive_writer_insert_files (BoxesArchiveWriter* self, gchar** src_list, int src_list_length1, gchar** dest_list, int dest_list_length1, GError** error);
void boxes_archive_writer_insert_file (BoxesArchiveWriter* self, const gchar* src, const gchar* dest, GError** error);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static struct archive_entry* boxes_archive_writer_get_entry_for_file (BoxesArchiveWriter* self, const gchar* filename, const gchar* dest_name);
static int __lambda39_ (Block17Data* _data17_);
static int ___lambda39__boxes_libarchive_function (gpointer self);
static int __lambda34_ (BoxesArchiveWriter* self);
static int ___lambda34__boxes_libarchive_function (gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static int _____lambda35_ (Block18Data* _data18_);
static int ______lambda35__boxes_libarchive_function (gpointer self);
static void boxes_archive_writer_finalize (GObject * obj);


static Block14Data* block14_data_ref (Block14Data* _data14_) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data14_;
#line 166 "archive-writer.c"
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 175 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data14_->self;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_free0 (_data14_->filename);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block14Data, _data14_);
#line 185 "archive-writer.c"
	}
}


static int __lambda36_ (Block14Data* _data14_) {
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	const gchar* _tmp1_;
	int _tmp2_;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data14_->self;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data14_->filename;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_open_filename (_tmp0_, _tmp1_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _tmp2_;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 208 "archive-writer.c"
}


static int ___lambda36__boxes_libarchive_function (gpointer self) {
	int result;
	result = __lambda36_ (self);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 217 "archive-writer.c"
}


BoxesArchiveWriter* boxes_archive_writer_construct (GType object_type, const gchar* filename, int format, GList* filters, GError** error) {
	BoxesArchiveWriter * self = NULL;
	Block14Data* _data14_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	struct archive* _tmp2_;
	int _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	struct archive* _tmp6_;
	GError * _inner_error_ = NULL;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_ = g_slice_new0 (Block14Data);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_->_ref_count_ = 1;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = filename;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_free0 (_data14_->filename);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_->filename = _tmp1_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_->self = g_object_ref (self);
#line 14 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_new ();
#line 14 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_archive_write_finish0 (self->archive);
#line 14 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->archive = _tmp2_;
#line 15 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = format;
#line 15 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->format = _tmp3_;
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp4_ = filters;
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp5_ = g_list_copy (_tmp4_);
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_list_free0 (self->priv->filters);
#line 16 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->filters = _tmp5_;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_prepare_archive (self, &_inner_error_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 284 "archive-writer.c"
		} else {
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 296 "archive-writer.c"
		}
	}
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp6_ = self->archive;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp6_, ___lambda36__boxes_libarchive_function, _data14_, (guint) 1, &_inner_error_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 317 "archive-writer.c"
		} else {
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block14_data_unref (_data14_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data14_ = NULL;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 329 "archive-writer.c"
		}
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block14_data_unref (_data14_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data14_ = NULL;
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return self;
#line 338 "archive-writer.c"
}


BoxesArchiveWriter* boxes_archive_writer_new (const gchar* filename, int format, GList* filters, GError** error) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return boxes_archive_writer_construct (BOXES_TYPE_ARCHIVE_WRITER, filename, format, filters, error);
#line 345 "archive-writer.c"
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data15_;
#line 354 "archive-writer.c"
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 363 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data15_->self;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_free0 (_data15_->filename);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block15Data, _data15_);
#line 373 "archive-writer.c"
	}
}


static int __lambda37_ (Block15Data* _data15_) {
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	const gchar* _tmp1_;
	int _tmp2_;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data15_->self;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data15_->filename;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_open_filename (_tmp0_, _tmp1_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _tmp2_;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 396 "archive-writer.c"
}


static int ___lambda37__boxes_libarchive_function (gpointer self) {
	int result;
	result = __lambda37_ (self);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 405 "archive-writer.c"
}


BoxesArchiveWriter* boxes_archive_writer_construct_from_archive_reader (GType object_type, BoxesArchiveReader* archive_reader, const gchar* filename, gboolean import_contents, GError** error) {
	BoxesArchiveWriter * self = NULL;
	Block15Data* _data15_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	struct archive_entry* iterator = NULL;
	struct archive* _tmp2_;
	gboolean _tmp3_ = FALSE;
	BoxesArchiveReader* _tmp4_;
	struct archive* _tmp5_;
	struct archive_entry* _tmp6_ = NULL;
	gboolean _tmp7_;
	BoxesArchiveReader* _tmp12_;
	struct archive* _tmp13_;
	int _tmp14_;
	BoxesArchiveReader* _tmp15_;
	struct archive* _tmp16_;
	struct archive* _tmp17_;
	BoxesArchiveReader* _tmp18_;
	gboolean _tmp19_;
	GError * _inner_error_ = NULL;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (archive_reader != NULL, NULL);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_->_ref_count_ = 1;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = filename;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_free0 (_data15_->filename);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_->filename = _tmp1_;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = (BoxesArchiveWriter*) g_object_new (object_type, NULL);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_->self = g_object_ref (self);
#line 27 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_new ();
#line 27 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_archive_write_finish0 (self->archive);
#line 27 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->archive = _tmp2_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp4_ = archive_reader;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp5_ = _tmp4_->archive;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp7_ = boxes_get_next_header (_tmp5_, &_tmp6_, (guint) 1, &_inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	iterator = _tmp6_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = _tmp7_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 480 "archive-writer.c"
		} else {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 492 "archive-writer.c"
		}
	}
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (!_tmp3_) {
#line 497 "archive-writer.c"
		gchar* msg = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp8_ = g_strdup ("Error creating write archive for archive '%s'. It is probably empty.");
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		msg = _tmp8_;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp9_ = msg;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp10_ = _data15_->filename;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp11_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp9_, _tmp10_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp11_;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_free0 (msg);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 529 "archive-writer.c"
		} else {
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_free0 (msg);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 30 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 543 "archive-writer.c"
		}
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_free0 (msg);
#line 547 "archive-writer.c"
	}
#line 33 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp12_ = archive_reader;
#line 33 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp13_ = _tmp12_->archive;
#line 33 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp14_ = archive_format (_tmp13_);
#line 33 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->format = _tmp14_;
#line 34 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp15_ = archive_reader;
#line 34 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp16_ = _tmp15_->archive;
#line 34 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_copy_filters_from_read_archive (self, _tmp16_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_prepare_archive (self, &_inner_error_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 579 "archive-writer.c"
		} else {
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 591 "archive-writer.c"
		}
	}
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp17_ = self->archive;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp17_, ___lambda37__boxes_libarchive_function, _data15_, (guint) 1, &_inner_error_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 612 "archive-writer.c"
		} else {
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 36 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 624 "archive-writer.c"
		}
	}
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp18_ = archive_reader;
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_reader_reset (_tmp18_, &_inner_error_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_g_object_unref0 (self);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 645 "archive-writer.c"
		} else {
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block15_data_unref (_data15_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data15_ = NULL;
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 38 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return NULL;
#line 657 "archive-writer.c"
		}
	}
#line 40 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp19_ = import_contents;
#line 40 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (_tmp19_) {
#line 664 "archive-writer.c"
		BoxesArchiveReader* _tmp20_;
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp20_ = archive_reader;
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		boxes_archive_writer_import_read_archive (self, _tmp20_, NULL, 0, FALSE, &_inner_error_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_propagate_error (error, _inner_error_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block15_data_unref (_data15_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data15_ = NULL;
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_g_object_unref0 (self);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return NULL;
#line 684 "archive-writer.c"
			} else {
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block15_data_unref (_data15_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data15_ = NULL;
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_clear_error (&_inner_error_);
#line 41 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return NULL;
#line 696 "archive-writer.c"
			}
		}
	}
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block15_data_unref (_data15_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data15_ = NULL;
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return self;
#line 706 "archive-writer.c"
}


BoxesArchiveWriter* boxes_archive_writer_new_from_archive_reader (BoxesArchiveReader* archive_reader, const gchar* filename, gboolean import_contents, GError** error) {
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return boxes_archive_writer_construct_from_archive_reader (BOXES_TYPE_ARCHIVE_WRITER, archive_reader, filename, import_contents, error);
#line 713 "archive-writer.c"
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data16_;
#line 722 "archive-writer.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 731 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data16_->self;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block16Data, _data16_);
#line 739 "archive-writer.c"
	}
}


static int ___lambda38_ (Block16Data* _data16_) {
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	struct archive_entry* _tmp1_;
	int _tmp2_;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data16_->self;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data16_->iterator;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_header (_tmp0_, _tmp1_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _tmp2_;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 762 "archive-writer.c"
}


static int ____lambda38__boxes_libarchive_function (gpointer self) {
	int result;
	result = ___lambda38_ (self);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 771 "archive-writer.c"
}


void boxes_archive_writer_import_read_archive (BoxesArchiveWriter* self, BoxesArchiveReader* archive_reader, gchar** omit_files, int omit_files_length1, gboolean omit_hardlinked_files, GError** error) {
	Block16Data* _data16_;
	BoxesArchiveReader* _tmp32_;
	GError * _inner_error_ = NULL;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (archive_reader != NULL);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_->_ref_count_ = 1;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_->self = g_object_ref (self);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	while (TRUE) {
#line 791 "archive-writer.c"
		gboolean _tmp0_ = FALSE;
		BoxesArchiveReader* _tmp1_;
		struct archive* _tmp2_;
		struct archive_entry* _tmp3_ = NULL;
		gboolean _tmp4_;
		gboolean omit = FALSE;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gboolean _tmp10_;
		gint64 len = 0LL;
		struct archive_entry* _tmp20_;
		gint64 _tmp21_;
		struct archive* _tmp22_;
		gint64 _tmp23_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp1_ = archive_reader;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp2_ = _tmp1_->archive;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp4_ = boxes_get_next_header (_tmp2_, &_tmp3_, (guint) 1, &_inner_error_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_data16_->iterator = _tmp3_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp0_ = _tmp4_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_propagate_error (error, _inner_error_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block16_data_unref (_data16_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data16_ = NULL;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 828 "archive-writer.c"
			} else {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block16_data_unref (_data16_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data16_ = NULL;
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_clear_error (&_inner_error_);
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 840 "archive-writer.c"
			}
		}
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (!_tmp0_) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			break;
#line 847 "archive-writer.c"
		}
#line 53 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		omit = FALSE;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp5_ = omit_files;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp5__length1 = omit_files_length1;
#line 855 "archive-writer.c"
		{
			gchar** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			file_collection = _tmp5_;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			file_collection_length1 = _tmp5__length1;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			for (file_it = 0; file_it < _tmp5__length1; file_it = file_it + 1) {
#line 867 "archive-writer.c"
				gchar* _tmp6_;
				gchar* file = NULL;
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp6_ = g_strdup (file_collection[file_it]);
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				file = _tmp6_;
#line 874 "archive-writer.c"
				{
					const gchar* _tmp7_;
					struct archive_entry* _tmp8_;
					const gchar* _tmp9_;
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp7_ = file;
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp8_ = _data16_->iterator;
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp9_ = archive_entry_pathname (_tmp8_);
#line 55 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					if (g_strcmp0 (_tmp7_, _tmp9_) == 0) {
#line 56 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						omit = TRUE;
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						_g_free0 (file);
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						break;
#line 893 "archive-writer.c"
					}
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_g_free0 (file);
#line 897 "archive-writer.c"
				}
			}
		}
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp10_ = omit;
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_tmp10_) {
#line 905 "archive-writer.c"
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp13_ = omit_hardlinked_files;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_tmp13_) {
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp12_ = TRUE;
#line 915 "archive-writer.c"
			} else {
				struct archive_entry* _tmp14_;
				guint _tmp15_;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp14_ = _data16_->iterator;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp15_ = archive_entry_nlink (_tmp14_);
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp12_ = _tmp15_ == ((guint) 1);
#line 925 "archive-writer.c"
			}
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_tmp12_) {
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp11_ = TRUE;
#line 931 "archive-writer.c"
			} else {
				struct archive_entry* _tmp16_;
				const gchar* _tmp17_;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp16_ = _data16_->iterator;
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp17_ = archive_entry_hardlink (_tmp16_);
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp11_ = _tmp17_ != NULL;
#line 941 "archive-writer.c"
			}
#line 63 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_tmp11_) {
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				continue;
#line 947 "archive-writer.c"
			} else {
				struct archive_entry* _tmp18_;
				const gchar* _tmp19_;
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp18_ = _data16_->iterator;
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp19_ = archive_entry_pathname (_tmp18_);
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_warning ("archive-writer.vala:68: File '%s' cannot be omitted since a hardlink p" \
"oints to it.", _tmp19_);
#line 957 "archive-writer.c"
			}
		}
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp20_ = _data16_->iterator;
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp21_ = archive_entry_size (_tmp20_);
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		len = _tmp21_;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp22_ = self->archive;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		boxes_execute_libarchive_function (_tmp22_, ____lambda38__boxes_libarchive_function, _data16_, (guint) 1, &_inner_error_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_propagate_error (error, _inner_error_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block16_data_unref (_data16_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data16_ = NULL;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 982 "archive-writer.c"
			} else {
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				block16_data_unref (_data16_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_data16_ = NULL;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				g_clear_error (&_inner_error_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				return;
#line 994 "archive-writer.c"
			}
		}
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp23_ = len;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_tmp23_ > ((gint64) 0)) {
#line 1001 "archive-writer.c"
			guint8* buf = NULL;
			gint64 _tmp24_;
			guint8* _tmp25_;
			gint buf_length1;
			gint _buf_size_;
			guint8* _tmp26_;
			gint _tmp26__length1;
			BoxesArchiveReader* _tmp27_;
			struct archive* _tmp28_;
			guint8* _tmp29_;
			gint _tmp29__length1;
			gint64 _tmp30_;
			gssize _tmp31_;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp24_ = len;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp25_ = g_new0 (guint8, _tmp24_);
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = _tmp25_;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf_length1 = _tmp24_;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_buf_size_ = buf_length1;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp26_ = buf;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp26__length1 = buf_length1;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp27_ = archive_reader;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp28_ = _tmp27_->archive;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp29_ = buf;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp29__length1 = buf_length1;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp30_ = len;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp31_ = archive_read_data (_tmp28_, _tmp29_, (gsize) _tmp30_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			boxes_archive_writer_insert_data (self, _tmp26_, (gint64) _tmp31_, &_inner_error_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					g_propagate_error (error, _inner_error_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					buf = (g_free (buf), NULL);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					block16_data_unref (_data16_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data16_ = NULL;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					return;
#line 1057 "archive-writer.c"
				} else {
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					buf = (g_free (buf), NULL);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					block16_data_unref (_data16_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data16_ = NULL;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					g_clear_error (&_inner_error_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					return;
#line 1071 "archive-writer.c"
				}
			}
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 1076 "archive-writer.c"
		}
	}
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp32_ = archive_reader;
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_reader_reset (_tmp32_, &_inner_error_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1095 "archive-writer.c"
		} else {
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block16_data_unref (_data16_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data16_ = NULL;
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 79 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1107 "archive-writer.c"
		}
	}
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block16_data_unref (_data16_);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data16_ = NULL;
#line 1114 "archive-writer.c"
}


void boxes_archive_writer_insert_files (BoxesArchiveWriter* self, gchar** src_list, int src_list_length1, gchar** dest_list, int dest_list_length1, GError** error) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GError * _inner_error_ = NULL;
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = src_list;
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0__length1 = src_list_length1;
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = dest_list;
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1__length1 = dest_list_length1;
#line 83 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_vala_return_if_fail (_tmp0__length1 == _tmp1__length1, "src_list.length == dest_list.length");
#line 1136 "archive-writer.c"
	{
		guint i = 0U;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		i = (guint) 0;
#line 1141 "archive-writer.c"
		{
			gboolean _tmp2_ = FALSE;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp2_ = TRUE;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			while (TRUE) {
#line 1148 "archive-writer.c"
				guint _tmp4_;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gchar** _tmp6_;
				gint _tmp6__length1;
				guint _tmp7_;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				guint _tmp10_;
				const gchar* _tmp11_;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!_tmp2_) {
#line 1162 "archive-writer.c"
					guint _tmp3_;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp3_ = i;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					i = _tmp3_ + 1;
#line 1168 "archive-writer.c"
				}
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp2_ = FALSE;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp4_ = i;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp5_ = src_list;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp5__length1 = src_list_length1;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!(_tmp4_ < ((guint) _tmp5__length1))) {
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					break;
#line 1182 "archive-writer.c"
				}
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp6_ = src_list;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp6__length1 = src_list_length1;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp7_ = i;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp9_ = dest_list;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp9__length1 = dest_list_length1;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp10_ = i;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp11_ = _tmp9_[_tmp10_];
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				boxes_archive_writer_insert_file (self, _tmp8_, _tmp11_, &_inner_error_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					if (_inner_error_->domain == G_IO_ERROR) {
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						g_propagate_error (error, _inner_error_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						return;
#line 1210 "archive-writer.c"
					} else {
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						g_clear_error (&_inner_error_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						return;
#line 1218 "archive-writer.c"
					}
				}
			}
		}
	}
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data17_;
#line 1232 "archive-writer.c"
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 1241 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data17_->self;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_archive_entry_free0 (_data17_->entry);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block17Data, _data17_);
#line 1251 "archive-writer.c"
	}
}


static int __lambda39_ (Block17Data* _data17_) {
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	struct archive_entry* _tmp1_;
	int _tmp2_;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data17_->self;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data17_->entry;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_header (_tmp0_, _tmp1_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _tmp2_;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1274 "archive-writer.c"
}


static int ___lambda39__boxes_libarchive_function (gpointer self) {
	int result;
	result = __lambda39_ (self);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1283 "archive-writer.c"
}


void boxes_archive_writer_insert_file (BoxesArchiveWriter* self, const gchar* src, const gchar* dest, GError** error) {
	Block17Data* _data17_;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	struct archive_entry* _tmp9_;
	gint64 len = 0LL;
	struct archive_entry* _tmp10_;
	gint64 _tmp11_;
	guint8* buf = NULL;
	gint64 _tmp12_;
	guint8* _tmp13_;
	gint buf_length1;
	gint _buf_size_;
	FILE* filestream = NULL;
	const gchar* _tmp14_;
	FILE* _tmp15_;
	FILE* _tmp16_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	gint64 _tmp18_;
	struct archive* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	gint64 _tmp21_;
	GError * _inner_error_ = NULL;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (src != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (dest != NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data17_->_ref_count_ = 1;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data17_->self = g_object_ref (self);
#line 93 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = src;
#line 93 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
#line 93 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (!_tmp1_) {
#line 1334 "archive-writer.c"
		const gchar* _tmp2_;
		GError* _tmp3_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp2_ = src;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp3_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Source file '%s' cannot be injected. File not found.", _tmp2_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp3_;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1353 "archive-writer.c"
		} else {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1365 "archive-writer.c"
		}
	}
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp4_ = src;
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp5_ = g_file_test (_tmp4_, G_FILE_TEST_IS_SYMLINK);
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (_tmp5_) {
#line 1374 "archive-writer.c"
		GError* _tmp6_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp6_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Inserting symlinks is currently not supported.");
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp6_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1390 "archive-writer.c"
		} else {
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1402 "archive-writer.c"
		}
	}
#line 99 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp7_ = src;
#line 99 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp8_ = dest;
#line 99 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp9_ = boxes_archive_writer_get_entry_for_file (self, _tmp7_, _tmp8_);
#line 99 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data17_->entry = _tmp9_;
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp10_ = _data17_->entry;
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp11_ = archive_entry_size (_tmp10_);
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	len = _tmp11_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp12_ = len;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp13_ = g_new0 (guint8, _tmp12_);
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	buf = _tmp13_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	buf_length1 = _tmp12_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_buf_size_ = buf_length1;
#line 104 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp14_ = src;
#line 104 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp15_ = g_fopen (_tmp14_, "r");
#line 104 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	filestream = _tmp15_;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp16_ = filestream;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp17_ = buf;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp17__length1 = buf_length1;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp18_ = len;
#line 105 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	fread ((guint8*) _tmp17_, (gsize) _tmp18_, (_tmp17__length1 * sizeof (guint8)) / sizeof (guint8), _tmp16_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp19_ = self->archive;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp19_, ___lambda39__boxes_libarchive_function, _data17_, (guint) 1, &_inner_error_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1465 "archive-writer.c"
		} else {
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1481 "archive-writer.c"
		}
	}
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp20_ = buf;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp20__length1 = buf_length1;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp21_ = len;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_insert_data (self, (guint8*) _tmp20_, _tmp21_, &_inner_error_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1508 "archive-writer.c"
		} else {
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_fclose0 (filestream);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			buf = (g_free (buf), NULL);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			block17_data_unref (_data17_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_data17_ = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1524 "archive-writer.c"
		}
	}
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_fclose0 (filestream);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	buf = (g_free (buf), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	block17_data_unref (_data17_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_data17_ = NULL;
#line 1535 "archive-writer.c"
}


static int __lambda34_ (BoxesArchiveWriter* self) {
	int result = 0;
	struct archive* _tmp0_;
	int _tmp1_;
	int _tmp2_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = self->priv->format;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_set_format (_tmp0_, _tmp1_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _tmp2_;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1554 "archive-writer.c"
}


static int ___lambda34__boxes_libarchive_function (gpointer self) {
	int result;
	result = __lambda34_ ((BoxesArchiveWriter*) self);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1563 "archive-writer.c"
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return _data18_;
#line 1572 "archive-writer.c"
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 1581 "archive-writer.c"
		BoxesArchiveWriter* self;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		self = _data18_->self;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_g_object_unref0 (self);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		g_slice_free (Block18Data, _data18_);
#line 1589 "archive-writer.c"
	}
}


static int _____lambda35_ (Block18Data* _data18_) {
	BoxesArchiveWriter* self;
	int result = 0;
	struct archive* _tmp0_;
	int _tmp1_;
	int _tmp2_;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = _data18_->self;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = _data18_->filter;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = archive_write_add_filter (_tmp0_, _tmp1_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _tmp2_;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1612 "archive-writer.c"
}


static int ______lambda35__boxes_libarchive_function (gpointer self) {
	int result;
	result = _____lambda35_ (self);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1621 "archive-writer.c"
}


static void boxes_archive_writer_prepare_archive (BoxesArchiveWriter* self, GError** error) {
	struct archive* _tmp0_;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_execute_libarchive_function (_tmp0_, ___lambda34__boxes_libarchive_function, self, (guint) 1, &_inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1643 "archive-writer.c"
		} else {
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 111 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1651 "archive-writer.c"
		}
	}
#line 113 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = self->priv->filters;
#line 113 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (_tmp1_ != NULL) {
#line 1658 "archive-writer.c"
		GList* _tmp2_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp2_ = self->priv->filters;
#line 1662 "archive-writer.c"
		{
			GList* filter_collection = NULL;
			GList* filter_it = NULL;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			filter_collection = _tmp2_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
#line 1670 "archive-writer.c"
				int filter = 0;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				filter = (int) ((gintptr) filter_it->data);
#line 1674 "archive-writer.c"
				{
					Block18Data* _data18_;
					struct archive* _tmp3_;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data18_ = g_slice_new0 (Block18Data);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data18_->_ref_count_ = 1;
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data18_->self = g_object_ref (self);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data18_->filter = filter;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp3_ = self->archive;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					boxes_execute_libarchive_function (_tmp3_, ______lambda35__boxes_libarchive_function, _data18_, (guint) 1, &_inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
						if (_inner_error_->domain == G_IO_ERROR) {
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							g_propagate_error (error, _inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							block18_data_unref (_data18_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							_data18_ = NULL;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							return;
#line 1702 "archive-writer.c"
						} else {
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							block18_data_unref (_data18_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							_data18_ = NULL;
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							g_clear_error (&_inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
							return;
#line 1714 "archive-writer.c"
						}
					}
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					block18_data_unref (_data18_);
#line 114 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_data18_ = NULL;
#line 1721 "archive-writer.c"
				}
			}
		}
	}
}


static void boxes_archive_writer_copy_filters_from_read_archive (BoxesArchiveWriter* self, struct archive* read_archive) {
#line 119 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (read_archive != NULL);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_list_free0 (self->priv->filters);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv->filters = NULL;
#line 1738 "archive-writer.c"
	{
		gint i = 0;
		struct archive* _tmp0_;
		gint _tmp1_;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp0_ = read_archive;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp1_ = archive_filter_count (_tmp0_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		i = _tmp1_ - 1;
#line 1749 "archive-writer.c"
		{
			gboolean _tmp2_ = FALSE;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			_tmp2_ = TRUE;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			while (TRUE) {
#line 1756 "archive-writer.c"
				gint _tmp4_;
				struct archive* _tmp5_;
				gint _tmp6_;
				int _tmp7_;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!_tmp2_) {
#line 1763 "archive-writer.c"
					gint _tmp3_;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					_tmp3_ = i;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					i = _tmp3_ - 1;
#line 1769 "archive-writer.c"
				}
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp2_ = FALSE;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp4_ = i;
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				if (!(_tmp4_ > 0)) {
#line 121 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
					break;
#line 1779 "archive-writer.c"
				}
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp5_ = read_archive;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp6_ = i;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				_tmp7_ = archive_filter_code (_tmp5_, _tmp6_ - 1);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
				self->priv->filters = g_list_append (self->priv->filters, (gpointer) ((gintptr) _tmp7_));
#line 1789 "archive-writer.c"
			}
		}
	}
}


static void boxes_archive_writer_insert_data (BoxesArchiveWriter* self, void* data, gint64 len, GError** error) {
	struct archive* _tmp0_;
	void* _tmp1_;
	gint64 _tmp2_;
	gssize _tmp3_;
	gint64 _tmp4_;
	GError * _inner_error_ = NULL;
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = self->archive;
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = data;
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp2_ = len;
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = archive_write_data (_tmp0_, _tmp1_, (gsize) _tmp2_);
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp4_ = len;
#line 126 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	if (((gint64) _tmp3_) != _tmp4_) {
#line 1817 "archive-writer.c"
		struct archive* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp5_ = self->archive;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp6_ = archive_error_string (_tmp5_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_tmp7_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed writing data to archive. Message: '%s'.", _tmp6_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		_inner_error_ = _tmp7_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1835 "archive-writer.c"
		} else {
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
			return;
#line 1843 "archive-writer.c"
		}
	}
}


static struct archive_entry* boxes_archive_writer_get_entry_for_file (BoxesArchiveWriter* self, const gchar* filename, const gchar* dest_name) {
	struct archive_entry* result = NULL;
	struct stat st = {0};
	struct archive_entry* _result_ = NULL;
	struct archive_entry* _tmp0_;
	const gchar* _tmp1_;
	struct stat _tmp2_ = {0};
	struct stat _tmp3_;
	const gchar* _tmp4_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_return_val_if_fail (dest_name != NULL, NULL);
#line 133 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp0_ = archive_entry_new ();
#line 133 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_result_ = _tmp0_;
#line 135 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp1_ = filename;
#line 135 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	stat (_tmp1_, &_tmp2_);
#line 135 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	st = _tmp2_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp3_ = st;
#line 137 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	archive_entry_copy_stat (_result_, &_tmp3_);
#line 138 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_tmp4_ = dest_name;
#line 138 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	archive_entry_set_pathname (_result_, _tmp4_);
#line 140 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	result = _result_;
#line 140 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	return result;
#line 1886 "archive-writer.c"
}


static void boxes_archive_writer_class_init (BoxesArchiveWriterClass * klass) {
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	boxes_archive_writer_parent_class = g_type_class_peek_parent (klass);
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	g_type_class_add_private (klass, sizeof (BoxesArchiveWriterPrivate));
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_archive_writer_finalize;
#line 1897 "archive-writer.c"
}


static void boxes_archive_writer_instance_init (BoxesArchiveWriter * self) {
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self->priv = BOXES_ARCHIVE_WRITER_GET_PRIVATE (self);
#line 1904 "archive-writer.c"
}


static void boxes_archive_writer_finalize (GObject * obj) {
	BoxesArchiveWriter * self;
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ARCHIVE_WRITER, BoxesArchiveWriter);
#line 5 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_archive_write_finish0 (self->archive);
#line 7 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	_g_list_free0 (self->priv->filters);
#line 4 "/home/fborges/checkout/gnome-boxes/src/archive-writer.vala"
	G_OBJECT_CLASS (boxes_archive_writer_parent_class)->finalize (obj);
#line 1918 "archive-writer.c"
}


GType boxes_archive_writer_get_type (void) {
	static volatile gsize boxes_archive_writer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_archive_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesArchiveWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_archive_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesArchiveWriter), 0, (GInstanceInitFunc) boxes_archive_writer_instance_init, NULL };
		GType boxes_archive_writer_type_id;
		boxes_archive_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesArchiveWriter", &g_define_type_info, 0);
		g_once_init_leave (&boxes_archive_writer_type_id__volatile, boxes_archive_writer_type_id);
	}
	return boxes_archive_writer_type_id__volatile;
}



