/* vm-configurator.c generated by valac 0.39.5, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <libcommon.h>
#include <gtk/gtk.h>
#include <osinfo/osinfo.h>
#include <libvirt-gobject/libvirt-gobject.h>
#include <unistd.h>
#include <libxml/xmlreader.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _BoxesVmConfiguratorUpdateExistingDomainData BoxesVmConfiguratorUpdateExistingDomainData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))

#define BOXES_TYPE_INSTALLED_MEDIA (boxes_installed_media_get_type ())
#define BOXES_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMedia))
#define BOXES_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))
#define BOXES_IS_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_IS_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_INSTALLED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))

typedef struct _BoxesInstalledMedia BoxesInstalledMedia;
typedef struct _BoxesInstalledMediaClass BoxesInstalledMediaClass;

#define BOXES_TYPE_LIBVIRT_MEDIA (boxes_libvirt_media_get_type ())
#define BOXES_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia))
#define BOXES_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))
#define BOXES_IS_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_IS_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_LIBVIRT_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))

typedef struct _BoxesLibvirtMedia BoxesLibvirtMedia;
typedef struct _BoxesLibvirtMediaClass BoxesLibvirtMediaClass;

#define BOXES_TYPE_LIBVIRT_CLONED_MEDIA (boxes_libvirt_cloned_media_get_type ())
#define BOXES_LIBVIRT_CLONED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMedia))
#define BOXES_LIBVIRT_CLONED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMediaClass))
#define BOXES_IS_LIBVIRT_CLONED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA))
#define BOXES_IS_LIBVIRT_CLONED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_CLONED_MEDIA))
#define BOXES_LIBVIRT_CLONED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMediaClass))

typedef struct _BoxesLibvirtClonedMedia BoxesLibvirtClonedMedia;
typedef struct _BoxesLibvirtClonedMediaClass BoxesLibvirtClonedMediaClass;
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

typedef enum  {
	BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS
} BoxesVMConfiguratorError;
#define BOXES_VM_CONFIGURATOR_ERROR boxes_vm_configurator_error_quark ()
struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_box) (BoxesInstallerMedia* self, GtkBox* setup_box);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	BoxesVMCreator* (*get_vm_creator) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_ready_to_create) (BoxesInstallerMedia* self);
	gboolean (*get_live) (BoxesInstallerMedia* self);
	gchar* (*get_architecture) (BoxesInstallerMedia* self);
};

struct _BoxesVmConfiguratorUpdateExistingDomainData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GVirConfigDomain* domain;
	GVirConnection* connection;
	GVirConfigDomainCpu* cpu;
	GVirConfigDomainCpu* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GVirConfigDomainCpu* _tmp3_;
	gboolean _tmp4_;
	GVirConfigDomainCpu* _tmp5_;
	GVirConfigDomainCpu* _tmp6_;
	GVirConfigCapabilities* capabilities;
	GVirConfigCapabilities* _tmp7_;
	GVirConfigCapabilities* _tmp8_;
	GError* e;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GList* devices;
	GVirConfigDomainInterface* iface;
	GVirConfigDomainGraphicsSpice* graphics;
	GList* _tmp13_;
	GList* device_collection;
	GList* device_it;
	GVirConfigDomainDevice* _tmp14_;
	GVirConfigDomainDevice* device;
	GVirConfigDomainDevice* _tmp15_;
	GVirConfigDomainDevice* _tmp16_;
	GVirConfigDomainInterface* _tmp17_;
	GVirConfigDomainDevice* _tmp18_;
	GVirConfigDomainDevice* _tmp19_;
	GVirConfigDomainGraphicsSpice* _tmp20_;
	GVirConfigDomainDevice* _tmp21_;
	GVirConfigDomainDevice* _tmp22_;
	GVirConfigDomainInterface* _tmp23_;
	gboolean bridge;
	gboolean virtio;
	GVirConfigDomainInterface* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	GVirConfigDomainInterface* _tmp28_;
	GVirConfigDomainGraphicsSpice* _tmp29_;
	GVirConfigDomainGraphicsSpice* _tmp30_;
	GList* _tmp31_;
	GError * _inner_error_;
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

GQuark boxes_vm_configurator_error_quark (void);
gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value,
                                      gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value,
                                       gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI PACKAGE_URL
#define BOXES_VM_CONFIGURATOR_BOXES_OLD_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_BOXES_XML "<gnome-boxes>%s</gnome-boxes>"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_IMPORT_STATE "importing"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE "libvirt-system-importing"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_STATE "libvirt-cloning"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_IMPORT_XML "<os-state>" BOXES_VM_CONFIGURATOR_IMPORT_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_OS_ID_XML "<os-id>%s</os-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_ID_XML "<media-id>%s</media-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_XML "<media>%s</media>"
#define BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML "<num-reboots>%u</num-reboots>"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media,
                                                              const gchar* target_path,
                                                              GVirConfigCapabilities* caps,
                                                              GError** error);
void boxes_vm_configurator_setup_custom_xml (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps,
                                                                        BoxesInstallerMedia* install_media,
                                                                        GError** error);
gpointer boxes_vm_creator_ref (gpointer instance);
void boxes_vm_creator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_creator (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void boxes_value_set_vm_creator (GValue* value,
                                 gpointer v_object);
void boxes_value_take_vm_creator (GValue* value,
                                  gpointer v_object);
gpointer boxes_value_get_vm_creator (const GValue* value);
GType boxes_vm_creator_get_type (void) G_GNUC_CONST;
static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain,
                                           GVirConfigCapabilities* caps);
static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps);
static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain,
                                          BoxesInstallerMedia* install_media,
                                          GVirConfigCapabilitiesGuest* guest_caps);
static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps,
                                                       const gchar* feature_name);
static void _vala_array_add12 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain,
                                                    const gchar* target_path,
                                                    BoxesInstallerMedia* install_media,
                                                    guint8 dev_index);
void boxes_installer_media_setup_domain_config (BoxesInstallerMedia* self,
                                                GVirConfigDomain* domain);
GVirConfigDomainGraphicsSpice* boxes_vm_configurator_create_graphics_device (void);
void boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain);
void boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain);
static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain,
                                              BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_mouse_config (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_keyboard_config (GVirConfigDomain* domain,
                                                BoxesInstallerMedia* install_media);
GVirConfigDomainInterface* boxes_vm_configurator_create_network_interface (GVirConfigDomain* domain,
                                                                           gboolean bridge,
                                                                           gboolean virtio);
gboolean boxes_is_libvirt_bridge_net_available (void);
gboolean boxes_installer_media_get_supports_virtio_net (BoxesInstallerMedia* self);
void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain,
                                               BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain);
void boxes_installer_media_setup_post_install_domain_config (BoxesInstallerMedia* self,
                                                             GVirConfigDomain* domain);
static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain,
                                              BoxesInstallerMedia* install_media);
gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_import_config (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_libvirt_cloning_config (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_boxes_installed (GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name,
                                                                  gint64 storage,
                                                                  GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain,
                                                  const gchar* node_name);
gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain);
gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain);
guint boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain);
void boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain,
                                            BoxesInstallerMedia* install_media,
                                            guint num_reboots);
static void boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain,
                                              BoxesInstallerMedia* install_media,
                                              guint num_reboots,
                                              gboolean installed);
static void boxes_vm_configurator_update_existing_domain_data_free (gpointer _data);
static void boxes_vm_configurator_update_existing_domain_async_ready_wrapper (GObject *source_object,
                                                                       GAsyncResult *res,
                                                                       void *user_data);
void boxes_vm_configurator_update_existing_domain (GVirConfigDomain* domain,
                                                   GVirConnection* connection,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
void boxes_vm_configurator_update_existing_domain_finish (GAsyncResult* _res_);
static gboolean boxes_vm_configurator_update_existing_domain_co (BoxesVmConfiguratorUpdateExistingDomainData* _data_);
static gboolean boxes_vm_configurator_boxes_created_domain (GVirConfigDomain* domain);
static void boxes_vm_configurator_update_existing_domain_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
gboolean boxes_installer_media_get_supports_virtio_disk (BoxesInstallerMedia* self);
void boxes_installer_media_set_direct_boot_params (BoxesInstallerMedia* self,
                                                   GVirConfigDomainOs* os);
OsinfoDevice* boxes_find_device_by_prop (OsinfoDeviceList* devices,
                                         const gchar* prop_name,
                                         const gchar* prop_value);
OsinfoDeviceList* boxes_installer_media_get_supported_devices (BoxesInstallerMedia* self);
static void boxes_vm_configurator_set_input_config (GVirConfigDomain* domain,
                                             GVirConfigDomainInputDeviceType device_type);
GType boxes_installed_media_get_type (void) G_GNUC_CONST;
GType boxes_libvirt_media_get_type (void) G_GNUC_CONST;
GType boxes_libvirt_cloned_media_get_type (void) G_GNUC_CONST;
gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static GVirConfigDomainControllerUsb* boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model,
                                                                            GVirConfigDomainControllerUsb* master,
                                                                            guint index,
                                                                            guint start_port);
static gint __lambda24_ (GVirConfigCapabilitiesGuest* caps_a,
                  GVirConfigCapabilitiesGuest* caps_b);
static gint ___lambda24__gcompare_func (gconstpointer a,
                                 gconstpointer b);
gboolean boxes_installer_media_is_architecture_compatible (BoxesInstallerMedia* self,
                                                           const gchar* architecture);
static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps);
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


GQuark
boxes_vm_configurator_error_quark (void)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	return g_quark_from_static_string ("boxes_vm_configurator_error-quark");
#line 397 "vm-configurator.c"
}


static void
_vala_array_add12 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 413 "vm-configurator.c"
	}
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 419 "vm-configurator.c"
}


static void
_vala_array_add13 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 435 "vm-configurator.c"
	}
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 441 "vm-configurator.c"
}


static void
_vala_array_add14 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 457 "vm-configurator.c"
	}
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 463 "vm-configurator.c"
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1417 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1417 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1418 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1418 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1418 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 483 "vm-configurator.c"
}


GVirConfigDomain*
boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media,
                                            const gchar* target_path,
                                            GVirConfigCapabilities* caps,
                                            GError** error)
{
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* domain = NULL;
	GVirConfigDomain* _tmp0_;
	GVirConfigCapabilitiesGuest* best_caps = NULL;
	GVirConfigCapabilitiesGuest* _tmp1_;
	OsinfoResources* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	GVirConfigDomainVirtType _tmp5_ = 0;
	GVirConfigDomainVirtType virt_type = 0;
	GVirConfigDomainVirtType _tmp6_;
	gchar** features = NULL;
	gchar** _tmp7_;
	gint features_length1;
	gint _features_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GVirConfigDomainClock* clock = NULL;
	GVirConfigDomainClock* _tmp15_;
	gboolean _tmp16_ = FALSE;
	OsinfoOs* _tmp17_;
	GVirConfigDomainTimer* timer = NULL;
	GVirConfigDomainTimerRtc* _tmp23_;
	GVirConfigDomainTimer* _tmp24_;
	GVirConfigDomainClock* _tmp25_;
	GVirConfigDomainTimer* _tmp26_;
	GVirConfigDomainTimerPit* _tmp27_;
	GVirConfigDomainTimer* _tmp28_;
	GVirConfigDomainClock* _tmp29_;
	GVirConfigDomainTimer* _tmp30_;
	GVirConfigDomainTimerHpet* _tmp31_;
	GVirConfigDomainTimer* _tmp32_;
	GVirConfigDomainClock* _tmp33_;
	GVirConfigDomainTimer* _tmp34_;
	GVirConfigDomainClock* _tmp35_;
	GVirConfigDomainGraphicsSpice* graphics = NULL;
	GVirConfigDomainGraphicsSpice* _tmp36_;
	GVirConfigDomainGraphicsSpice* _tmp37_;
	GVirConfigDomainChannel* channel = NULL;
	GVirConfigDomainChannel* _tmp38_;
	GVirConfigDomainChannel* _tmp39_;
	GVirConfigDomainChannel* _tmp40_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp41_;
	GVirConfigDomainChannel* _tmp42_;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp43_;
	GVirConfigDomainChannel* _tmp44_;
	GVirConfigDomainPowerManagement* pm = NULL;
	GVirConfigDomainPowerManagement* _tmp45_;
	GVirConfigDomainPowerManagement* _tmp46_;
	GVirConfigDomainPowerManagement* _tmp47_;
	GVirConfigDomainPowerManagement* _tmp48_;
	GVirConfigDomainConsole* console = NULL;
	GVirConfigDomainConsole* _tmp49_;
	GVirConfigDomainConsole* _tmp50_;
	GVirConfigDomainChardevSourcePty* _tmp51_;
	GVirConfigDomainChardevSourcePty* _tmp52_;
	GVirConfigDomainConsole* _tmp53_;
	GVirConfigDomainInterface* iface = NULL;
	gboolean _tmp54_;
	gboolean _tmp55_;
	GVirConfigDomainInterface* _tmp56_;
	GVirConfigDomainInterface* _tmp57_;
	GError * _inner_error_ = NULL;
#line 33 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 33 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (target_path != NULL, NULL);
#line 33 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 35 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_new ();
#line 35 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	domain = _tmp0_;
#line 37 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_setup_custom_xml (domain, install_media);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_best_guest_caps (caps, install_media, &_inner_error_);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	best_caps = _tmp1_;
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			g_propagate_error (error, _inner_error_);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 583 "vm-configurator.c"
		} else {
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			g_clear_error (&_inner_error_);
#line 39 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 593 "vm-configurator.c"
		}
	}
#line 40 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = install_media->resources;
#line 40 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = osinfo_resources_get_ram (_tmp2_);
#line 40 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_memory (domain, (guint64) (_tmp4_ / OSINFO_KIBIBYTES));
#line 41 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_cpu_config (domain, caps);
#line 43 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (boxes_vm_configurator_guest_kvm_enabled (best_caps)) {
#line 43 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = GVIR_CONFIG_DOMAIN_VIRT_KVM;
#line 610 "vm-configurator.c"
	} else {
#line 43 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = GVIR_CONFIG_DOMAIN_VIRT_QEMU;
#line 614 "vm-configurator.c"
	}
#line 43 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	virt_type = _tmp5_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = virt_type;
#line 44 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_virt_type (domain, _tmp6_);
#line 46 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_os_config (domain, install_media, best_caps);
#line 48 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = g_new0 (gchar*, 0 + 1);
#line 48 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	features = _tmp7_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	features_length1 = 0;
#line 48 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_features_size_ = features_length1;
#line 49 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (boxes_vm_configurator_guest_supports_feature (best_caps, "acpi")) {
#line 634 "vm-configurator.c"
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = features;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp8__length1 = features_length1;
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = g_strdup ("acpi");
#line 50 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add12 (&features, &features_length1, &_features_size_, _tmp9_);
#line 646 "vm-configurator.c"
	}
#line 51 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (boxes_vm_configurator_guest_supports_feature (best_caps, "apic")) {
#line 650 "vm-configurator.c"
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = features;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp10__length1 = features_length1;
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = g_strdup ("apic");
#line 52 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add13 (&features, &features_length1, &_features_size_, _tmp11_);
#line 662 "vm-configurator.c"
	}
#line 53 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (boxes_vm_configurator_guest_supports_feature (best_caps, "pae")) {
#line 666 "vm-configurator.c"
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = features;
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp12__length1 = features_length1;
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = g_strdup ("pae");
#line 54 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add14 (&features, &features_length1, &_features_size_, _tmp13_);
#line 678 "vm-configurator.c"
	}
#line 55 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = features;
#line 55 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp14__length1 = features_length1;
#line 55 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_features (domain, _tmp14_);
#line 57 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = gvir_config_domain_clock_new ();
#line 57 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	clock = _tmp15_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = install_media->os;
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp17_ != NULL) {
#line 694 "vm-configurator.c"
		OsinfoOs* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = install_media->os;
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp19_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp18_);
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp20_ = _tmp19_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp16_ = string_contains (_tmp20_, "win");
#line 706 "vm-configurator.c"
	} else {
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp16_ = FALSE;
#line 710 "vm-configurator.c"
	}
#line 58 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp16_) {
#line 714 "vm-configurator.c"
		GVirConfigDomainClock* _tmp21_;
#line 59 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp21_ = clock;
#line 59 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp21_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
#line 720 "vm-configurator.c"
	} else {
		GVirConfigDomainClock* _tmp22_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp22_ = clock;
#line 61 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp22_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
#line 727 "vm-configurator.c"
	}
#line 63 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp23_ = gvir_config_domain_timer_rtc_new ();
#line 63 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp23_;
#line 64 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp24_ = timer;
#line 64 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp24_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_CATCHUP);
#line 65 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp25_ = clock;
#line 65 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp26_ = timer;
#line 65 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp25_, _tmp26_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp27_ = gvir_config_domain_timer_pit_new ();
#line 66 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 66 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp27_;
#line 67 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp28_ = timer;
#line 67 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp28_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_DELAY);
#line 68 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp29_ = clock;
#line 68 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp30_ = timer;
#line 68 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp29_, _tmp30_);
#line 69 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp31_ = gvir_config_domain_timer_hpet_new ();
#line 69 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 69 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp31_;
#line 70 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp32_ = timer;
#line 70 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_present (_tmp32_, FALSE);
#line 71 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp33_ = clock;
#line 71 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp34_ = timer;
#line 71 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp33_, _tmp34_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp35_ = clock;
#line 72 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_clock (domain, _tmp35_);
#line 74 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_target_media_config (domain, target_path, install_media, (guint8) 0);
#line 75 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_setup_domain_config (install_media, domain);
#line 77 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp36_ = boxes_vm_configurator_create_graphics_device ();
#line 77 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	graphics = _tmp36_;
#line 78 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp37_ = graphics;
#line 78 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp37_);
#line 81 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp38_ = gvir_config_domain_channel_new ();
#line 81 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	channel = _tmp38_;
#line 82 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp39_ = channel;
#line 82 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_type (_tmp39_, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
#line 83 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp40_ = channel;
#line 83 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_name (_tmp40_, "com.redhat.spice.0");
#line 84 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp41_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 84 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp41_;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp42_ = channel;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp43_ = vmc;
#line 85 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp42_, (GVirConfigDomainChardevSource*) _tmp43_);
#line 86 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp44_ = channel;
#line 86 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp44_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_add_usb_support (domain);
#line 89 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_add_smartcard_support (domain);
#line 91 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_video_config (domain, install_media);
#line 92 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_sound_config (domain, install_media);
#line 93 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_tablet_config (domain, install_media);
#line 94 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_mouse_config (domain, install_media);
#line 95 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_keyboard_config (domain, install_media);
#line 97 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 98 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 99 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 101 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp45_ = gvir_config_domain_power_management_new ();
#line 101 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	pm = _tmp45_;
#line 103 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp46_ = pm;
#line 103 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_power_management_set_mem_suspend_enabled (_tmp46_, FALSE);
#line 104 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp47_ = pm;
#line 104 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_power_management_set_disk_suspend_enabled (_tmp47_, FALSE);
#line 105 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp48_ = pm;
#line 105 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_power_management (domain, _tmp48_);
#line 106 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp49_ = gvir_config_domain_console_new ();
#line 106 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	console = _tmp49_;
#line 107 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp50_ = console;
#line 107 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp51_ = gvir_config_domain_chardev_source_pty_new ();
#line 107 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp52_ = _tmp51_;
#line 107 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp50_, (GVirConfigDomainChardevSource*) _tmp52_);
#line 107 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp52_);
#line 108 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp53_ = console;
#line 108 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp53_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp54_ = boxes_installer_media_get_supports_virtio_net (install_media);
#line 110 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp55_ = _tmp54_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp56_ = boxes_vm_configurator_create_network_interface (domain, boxes_is_libvirt_bridge_net_available (), _tmp55_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	iface = _tmp56_;
#line 113 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp57_ = iface;
#line 113 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp57_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = domain;
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (iface);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (console);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (pm);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (channel);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (graphics);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (clock);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (best_caps);
#line 115 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 907 "vm-configurator.c"
}


void
boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain,
                                          BoxesInstallerMedia* install_media)
{
#line 118 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 119 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_post_install_os_config (domain);
#line 120 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
#line 122 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (install_media != NULL) {
#line 123 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		boxes_installer_media_setup_post_install_domain_config (install_media, domain);
#line 925 "vm-configurator.c"
	}
#line 125 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_mark_as_installed (domain, install_media);
#line 929 "vm-configurator.c"
}


gboolean
boxes_vm_configurator_is_install_config (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 129 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
#line 129 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 129 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
#line 129 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp1_);
#line 129 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp2_;
#line 129 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 954 "vm-configurator.c"
}


gboolean
boxes_vm_configurator_is_live_config (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 132 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 133 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
#line 133 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp1_);
#line 133 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp2_;
#line 133 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 979 "vm-configurator.c"
}


gboolean
boxes_vm_configurator_is_import_config (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 136 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 137 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
#line 137 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_IMPORT_STATE) == 0;
#line 137 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp1_);
#line 137 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp2_;
#line 137 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1004 "vm-configurator.c"
}


gboolean
boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 140 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 141 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
#line 141 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 141 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE) == 0;
#line 141 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp1_);
#line 141 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp2_;
#line 141 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1029 "vm-configurator.c"
}


gboolean
boxes_vm_configurator_is_libvirt_cloning_config (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 144 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 145 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
#line 145 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 145 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_STATE) == 0;
#line 145 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp1_);
#line 145 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp2_;
#line 145 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1054 "vm-configurator.c"
}


gboolean
boxes_vm_configurator_is_boxes_installed (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 148 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 149 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
#line 149 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 149 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_INSTALLED_STATE) == 0;
#line 149 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp1_);
#line 149 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp2_;
#line 149 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1079 "vm-configurator.c"
}


GVirConfigStorageVol*
boxes_vm_configurator_create_volume_config (const gchar* name,
                                            gint64 storage,
                                            GError** error)
{
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* volume = NULL;
	GVirConfigStorageVol* _tmp0_;
	GVirConfigStorageVolTarget* target = NULL;
	GVirConfigStorageVolTarget* _tmp1_;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp2_;
#line 152 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 153 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_vol_new ();
#line 153 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	volume = _tmp0_;
#line 154 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_name (volume, name);
#line 155 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_capacity (volume, (guint64) storage);
#line 156 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_storage_vol_target_new ();
#line 156 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	target = _tmp1_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_format (target, "qcow2");
#line 158 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = boxes_vm_configurator_get_default_permissions ();
#line 158 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp2_;
#line 159 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_permissions (target, permissions);
#line 160 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_target (volume, target);
#line 162 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = volume;
#line 162 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 162 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 162 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1127 "vm-configurator.c"
}


GVirConfigStoragePool*
boxes_vm_configurator_get_pool_config (GError** error)
{
	GVirConfigStoragePool* result = NULL;
	gchar* pool_path = NULL;
	gchar* _tmp0_;
	GVirConfigStoragePool* pool = NULL;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePoolSource* source = NULL;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolTarget* target = NULL;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp4_;
#line 166 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_get_user_pkgdata ("images");
#line 166 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	pool_path = _tmp0_;
#line 168 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_storage_pool_new ();
#line 168 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	pool = _tmp1_;
#line 169 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
#line 170 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
#line 172 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_storage_pool_source_new ();
#line 172 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	source = _tmp2_;
#line 173 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_source_set_directory (source, pool_path);
#line 174 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_source (pool, source);
#line 176 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_pool_target_new ();
#line 176 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 177 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_path (target, pool_path);
#line 178 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 178 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 179 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_permissions (target, permissions);
#line 180 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_target (pool, target);
#line 182 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = pool;
#line 182 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 182 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 182 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (source);
#line 182 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (pool_path);
#line 182 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1191 "vm-configurator.c"
}


gchar*
boxes_vm_configurator_get_os_id (GVirConfigDomain* domain)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 185 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 186 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "os-id");
#line 186 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp0_;
#line 186 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1208 "vm-configurator.c"
}


gchar*
boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 189 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 190 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "media-id");
#line 190 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp0_;
#line 190 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1225 "vm-configurator.c"
}


gchar*
boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 193 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 194 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "media");
#line 194 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp0_;
#line 194 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1242 "vm-configurator.c"
}


guint
boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain)
{
	guint result = 0U;
	gchar* str = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	const gchar* _tmp2_;
#line 197 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, 0U);
#line 198 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "num-reboots");
#line 198 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	str = _tmp0_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = str;
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp2_ != NULL) {
#line 1264 "vm-configurator.c"
		const gchar* _tmp3_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = str;
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = atoi (_tmp3_);
#line 1270 "vm-configurator.c"
	} else {
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = 0;
#line 1274 "vm-configurator.c"
	}
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = (guint) _tmp1_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (str);
#line 199 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1282 "vm-configurator.c"
}


void
boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain,
                                       BoxesInstallerMedia* install_media,
                                       guint num_reboots)
{
#line 202 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 202 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 203 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (domain, install_media, num_reboots, FALSE);
#line 1297 "vm-configurator.c"
}


void
boxes_vm_configurator_setup_custom_xml (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
#line 206 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 206 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 207 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (domain, install_media, (guint) 0, FALSE);
#line 1311 "vm-configurator.c"
}


static void
boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain,
                                         BoxesInstallerMedia* install_media)
{
#line 210 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 211 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (domain, install_media, (guint) 0, TRUE);
#line 1323 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain,
                                      GVirConfigCapabilities* caps)
{
	GVirConfigCapabilitiesCpu* cpu_caps = NULL;
	GVirConfigCapabilitiesHost* _tmp0_;
	GVirConfigCapabilitiesHost* _tmp1_;
	GVirConfigCapabilitiesCpu* _tmp2_;
	GVirConfigCapabilitiesCpu* _tmp3_;
	GVirConfigCapabilitiesCpuTopology* topology = NULL;
	GVirConfigCapabilitiesCpu* _tmp4_;
	GVirConfigCapabilitiesCpuTopology* _tmp5_;
	GVirConfigCapabilitiesCpuTopology* _tmp6_;
	GVirConfigCapabilitiesCpuTopology* _tmp7_;
	GVirConfigCapabilitiesCpuTopology* _tmp8_;
	GVirConfigCapabilitiesCpuTopology* _tmp9_;
	GVirConfigDomainCpu* cpu = NULL;
	GVirConfigDomainCpu* _tmp10_;
	GVirConfigDomainCpu* _tmp11_;
	GVirConfigDomainCpu* _tmp12_;
	GVirConfigCapabilitiesCpuTopology* _tmp13_;
	GVirConfigCapabilitiesCpuModel* model_caps = NULL;
	GVirConfigCapabilitiesCpu* _tmp14_;
	GVirConfigCapabilitiesCpuModel* _tmp15_;
	GVirConfigDomainCpuModel* model = NULL;
	GVirConfigDomainCpuModel* _tmp16_;
	GVirConfigDomainCpuModel* _tmp17_;
	GVirConfigCapabilitiesCpuModel* _tmp18_;
	const gchar* _tmp19_;
	GVirConfigDomainCpu* _tmp20_;
	GVirConfigDomainCpuModel* _tmp21_;
	GVirConfigDomainCpu* _tmp22_;
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (caps != NULL);
#line 215 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_capabilities_get_host (caps);
#line 215 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 215 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_host_get_cpu (_tmp1_);
#line 215 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 215 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp1_);
#line 215 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	cpu_caps = _tmp3_;
#line 216 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = cpu_caps;
#line 216 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = gvir_config_capabilities_cpu_get_topology (_tmp4_);
#line 216 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	topology = _tmp5_;
#line 218 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = topology;
#line 218 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp6_ == NULL) {
#line 219 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (topology);
#line 219 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (cpu_caps);
#line 219 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return;
#line 1391 "vm-configurator.c"
	}
#line 221 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = topology;
#line 221 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = topology;
#line 221 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = topology;
#line 221 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_object_set (domain, "vcpu", (gvir_config_capabilities_cpu_topology_get_sockets (_tmp7_) * gvir_config_capabilities_cpu_topology_get_cores (_tmp8_)) * gvir_config_capabilities_cpu_topology_get_threads (_tmp9_), NULL);
#line 223 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = gvir_config_domain_cpu_new ();
#line 223 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	cpu = _tmp10_;
#line 226 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = cpu;
#line 226 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_cpu_set_mode (_tmp11_, GVIR_CONFIG_DOMAIN_CPU_MODE_CUSTOM);
#line 227 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = cpu;
#line 227 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = topology;
#line 227 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_capabilities_cpu_set_topology ((GVirConfigCapabilitiesCpu*) _tmp12_, _tmp13_);
#line 229 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = cpu_caps;
#line 229 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = gvir_config_capabilities_cpu_get_model (_tmp14_);
#line 229 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	model_caps = _tmp15_;
#line 230 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = gvir_config_domain_cpu_model_new ();
#line 230 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	model = _tmp16_;
#line 231 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = model;
#line 231 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = model_caps;
#line 231 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = gvir_config_capabilities_cpu_model_get_name (_tmp18_);
#line 231 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_capabilities_cpu_model_set_name ((GVirConfigCapabilitiesCpuModel*) _tmp17_, _tmp19_);
#line 232 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = cpu;
#line 232 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp21_ = model;
#line 232 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_cpu_set_model (_tmp20_, _tmp21_);
#line 234 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp22_ = cpu;
#line 234 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_cpu (domain, _tmp22_);
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (model);
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (model_caps);
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (cpu);
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (topology);
#line 214 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (cpu_caps);
#line 1453 "vm-configurator.c"
}


static void
boxes_vm_configurator_update_existing_domain_data_free (gpointer _data)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
	_data_ = _data;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_data_->domain);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_data_->connection);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_slice_free (BoxesVmConfiguratorUpdateExistingDomainData, _data_);
#line 1468 "vm-configurator.c"
}


static void
boxes_vm_configurator_update_existing_domain_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _task_data_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_task_data_->_callback_ != NULL) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 1484 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_task_data_->_task_complete_ = TRUE;
#line 1488 "vm-configurator.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return self ? g_object_ref (self) : NULL;
#line 1497 "vm-configurator.c"
}


void
boxes_vm_configurator_update_existing_domain (GVirConfigDomain* domain,
                                              GVirConnection* connection,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
	GVirConfigDomain* _tmp0_;
	GVirConnection* _tmp1_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_ = g_slice_new0 (BoxesVmConfiguratorUpdateExistingDomainData);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_callback_ = _callback_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_async_result = g_task_new (NULL, NULL, boxes_vm_configurator_update_existing_domain_async_ready_wrapper, _user_data_);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_callback_ == NULL) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_task_complete_ = TRUE;
#line 1520 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_vm_configurator_update_existing_domain_data_free);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = _g_object_ref0 (domain);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_data_->domain);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->domain = _tmp0_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _g_object_ref0 (connection);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_data_->connection);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->connection = _tmp1_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_existing_domain_co (_data_);
#line 1538 "vm-configurator.c"
}


void
boxes_vm_configurator_update_existing_domain_finish (GAsyncResult* _res_)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1548 "vm-configurator.c"
}


static void
boxes_vm_configurator_update_existing_domain_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_ = _user_data_;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_source_object_ = source_object;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_res_ = _res_;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_task_complete_ = TRUE;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_existing_domain_co (_data_);
#line 1568 "vm-configurator.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1577 "vm-configurator.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1586 "vm-configurator.c"
}


static gboolean
boxes_vm_configurator_update_existing_domain_co (BoxesVmConfiguratorUpdateExistingDomainData* _data_)
{
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	switch (_data_->_state_) {
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		case 0:
#line 1597 "vm-configurator.c"
		goto _state_0;
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		case 1:
#line 1601 "vm-configurator.c"
		goto _state_1;
		default:
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_assert_not_reached ();
#line 1606 "vm-configurator.c"
	}
	_state_0:
#line 239 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (!boxes_vm_configurator_boxes_created_domain (_data_->domain)) {
#line 240 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 240 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_data_->_state_ != 0) {
#line 240 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 240 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1619 "vm-configurator.c"
			}
		}
#line 240 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_object_unref (_data_->_async_result);
#line 240 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return FALSE;
#line 1626 "vm-configurator.c"
	}
	{
#line 243 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp0_ = gvir_config_domain_get_cpu (_data_->domain);
#line 243 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->cpu = _data_->_tmp0_;
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp3_ = _data_->cpu;
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_data_->_tmp3_ != NULL) {
#line 245 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp5_ = _data_->cpu;
#line 245 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			if (gvir_config_domain_cpu_get_mode (_data_->_tmp5_) == GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_PASSTHROUGH) {
#line 245 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_data_->_tmp4_ = TRUE;
#line 1643 "vm-configurator.c"
			} else {
#line 246 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_data_->_tmp6_ = _data_->cpu;
#line 246 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_data_->_tmp4_ = gvir_config_domain_cpu_get_mode (_data_->_tmp6_) == GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_MODEL;
#line 1649 "vm-configurator.c"
			}
#line 245 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp2_ = _data_->_tmp4_;
#line 1653 "vm-configurator.c"
		} else {
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp2_ = FALSE;
#line 1657 "vm-configurator.c"
		}
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_data_->_tmp2_) {
#line 247 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp1_ = boxes_vm_configurator_is_boxes_installed (_data_->domain);
#line 1663 "vm-configurator.c"
		} else {
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp1_ = FALSE;
#line 1667 "vm-configurator.c"
		}
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_data_->_tmp1_) {
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_state_ = 1;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			gvir_connection_get_capabilities_async (_data_->connection, NULL, boxes_vm_configurator_update_existing_domain_ready, _data_);
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return FALSE;
#line 1677 "vm-configurator.c"
			_state_1:
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp7_ = gvir_connection_get_capabilities_finish (_data_->connection, _data_->_res_, &_data_->_inner_error_);
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->capabilities = _data_->_tmp7_;
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 248 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (_data_->cpu);
#line 1687 "vm-configurator.c"
				goto __catch111_g_error;
			}
#line 249 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp8_ = _data_->capabilities;
#line 249 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			boxes_vm_configurator_set_cpu_config (_data_->domain, _data_->_tmp8_);
#line 244 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (_data_->capabilities);
#line 1696 "vm-configurator.c"
		}
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (_data_->cpu);
#line 1700 "vm-configurator.c"
	}
	goto __finally111;
	__catch111_g_error:
	{
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->e = _data_->_inner_error_;
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_inner_error_ = NULL;
#line 252 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp9_ = gvir_config_domain_get_name (_data_->domain);
#line 252 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 252 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp11_ = _data_->e;
#line 252 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp12_ = _data_->_tmp11_->message;
#line 252 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_warning ("vm-configurator.vala:252: Failed to update CPU config for '%s': %s", _data_->_tmp10_, _data_->_tmp12_);
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_error_free0 (_data_->e);
#line 1721 "vm-configurator.c"
	}
	__finally111:
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_object_unref (_data_->_async_result);
#line 242 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return FALSE;
#line 1734 "vm-configurator.c"
	}
#line 256 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->devices = NULL;
#line 257 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->iface = NULL;
#line 258 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->graphics = NULL;
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_tmp13_ = gvir_config_domain_get_devices (_data_->domain);
#line 1744 "vm-configurator.c"
	{
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->device_collection = _data_->_tmp13_;
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (_data_->device_it = _data_->device_collection; _data_->device_it != NULL; _data_->device_it = _data_->device_it->next) {
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->_tmp14_ = _g_object_ref0 ((GVirConfigDomainDevice*) _data_->device_it->data);
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_data_->device = _data_->_tmp14_;
#line 1754 "vm-configurator.c"
			{
#line 260 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_data_->_tmp15_ = _data_->device;
#line 260 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, gvir_config_domain_interface_get_type ())) {
#line 261 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_data_->_tmp16_ = _data_->device;
#line 261 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_data_->_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, gvir_config_domain_interface_get_type ()) ? ((GVirConfigDomainInterface*) _data_->_tmp16_) : NULL);
#line 261 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (_data_->iface);
#line 261 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_data_->iface = _data_->_tmp17_;
#line 1768 "vm-configurator.c"
				} else {
#line 262 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_data_->_tmp18_ = _data_->device;
#line 262 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, gvir_config_domain_graphics_spice_get_type ())) {
#line 263 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_data_->_tmp19_ = _data_->device;
#line 263 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_data_->_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp19_, gvir_config_domain_graphics_spice_get_type ()) ? ((GVirConfigDomainGraphicsSpice*) _data_->_tmp19_) : NULL);
#line 263 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_g_object_unref0 (_data_->graphics);
#line 263 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_data_->graphics = _data_->_tmp20_;
#line 1782 "vm-configurator.c"
					} else {
#line 265 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_data_->_tmp21_ = _data_->device;
#line 265 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_data_->_tmp22_ = _g_object_ref0 (_data_->_tmp21_);
#line 265 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_data_->devices = g_list_prepend (_data_->devices, _data_->_tmp22_);
#line 1790 "vm-configurator.c"
					}
				}
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (_data_->device);
#line 1795 "vm-configurator.c"
			}
		}
#line 259 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (_data_->device_collection);
#line 1800 "vm-configurator.c"
	}
#line 269 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_tmp23_ = _data_->iface;
#line 269 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_data_->_tmp23_ != NULL) {
#line 270 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->bridge = boxes_is_libvirt_bridge_net_available ();
#line 271 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp24_ = _data_->iface;
#line 271 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp25_ = gvir_config_domain_interface_get_model (_data_->_tmp24_);
#line 271 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->virtio = g_strcmp0 (_data_->_tmp25_, "virtio") == 0;
#line 273 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp26_ = _data_->bridge;
#line 273 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp27_ = _data_->virtio;
#line 273 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp28_ = boxes_vm_configurator_create_network_interface (_data_->domain, _data_->_tmp26_, _data_->_tmp27_);
#line 273 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->devices = g_list_prepend (_data_->devices, (GVirConfigDomainDevice*) _data_->_tmp28_);
#line 1822 "vm-configurator.c"
	}
#line 276 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_tmp29_ = _data_->graphics;
#line 276 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_data_->_tmp29_ != NULL) {
#line 277 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->_tmp30_ = boxes_vm_configurator_create_graphics_device ();
#line 277 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_data_->devices = g_list_prepend (_data_->devices, (GVirConfigDomainDevice*) _data_->_tmp30_);
#line 1832 "vm-configurator.c"
	}
#line 279 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->devices = g_list_reverse (_data_->devices);
#line 280 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_data_->_tmp31_ = _data_->devices;
#line 280 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_devices (_data_->domain, _data_->_tmp31_);
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_data_->graphics);
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_data_->iface);
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (_data_->devices);
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_data_->_state_ != 0) {
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1854 "vm-configurator.c"
		}
	}
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_object_unref (_data_->_async_result);
#line 237 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return FALSE;
#line 1861 "vm-configurator.c"
}


void
boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain,
                                               const gchar* target_path,
                                               BoxesInstallerMedia* install_media,
                                               guint8 dev_index)
{
	GVirConfigDomainDisk* disk = NULL;
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDisk* _tmp4_;
	GVirConfigDomainDisk* _tmp5_;
	GVirConfigDomainDisk* _tmp6_;
	gchar* dev_letter_str = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GVirConfigDomainDisk* _tmp20_;
#line 283 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 283 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (target_path != NULL);
#line 283 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 287 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_disk_new ();
#line 287 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	disk = _tmp0_;
#line 288 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = disk;
#line 288 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_FILE);
#line 289 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = disk;
#line 289 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_guest_device_type (_tmp2_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
#line 290 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = disk;
#line 290 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_name (_tmp3_, "qemu");
#line 291 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = disk;
#line 291 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_format (_tmp4_, GVIR_CONFIG_DOMAIN_DISK_FORMAT_QCOW2);
#line 292 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = disk;
#line 292 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_source (_tmp5_, target_path);
#line 293 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = disk;
#line 293 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_cache (_tmp6_, GVIR_CONFIG_DOMAIN_DISK_CACHE_WRITEBACK);
#line 295 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = g_strdup_printf ("%c", (gchar) (dev_index + 97));
#line 295 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	dev_letter_str = _tmp7_;
#line 296 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = boxes_installer_media_get_supports_virtio_disk (install_media);
#line 296 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = _tmp8_;
#line 296 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp9_) {
#line 1928 "vm-configurator.c"
		GVirConfigDomainDisk* _tmp10_;
		GVirConfigDomainDisk* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 297 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:297: Using virtio controller for the main disk");
#line 298 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = disk;
#line 298 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp10_, GVIR_CONFIG_DOMAIN_DISK_BUS_VIRTIO);
#line 299 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = disk;
#line 299 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = dev_letter_str;
#line 299 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = g_strconcat ("vd", _tmp12_, NULL);
#line 299 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp14_ = _tmp13_;
#line 299 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp11_, _tmp14_);
#line 299 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp14_);
#line 1952 "vm-configurator.c"
	} else {
		GVirConfigDomainDisk* _tmp15_;
		GVirConfigDomainDisk* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
#line 301 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:301: Using IDE controller for the main disk");
#line 302 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp15_ = disk;
#line 302 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp15_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
#line 303 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp16_ = disk;
#line 303 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp17_ = dev_letter_str;
#line 303 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = g_strconcat ("hd", _tmp17_, NULL);
#line 303 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp19_ = _tmp18_;
#line 303 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp16_, _tmp19_);
#line 303 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp19_);
#line 1977 "vm-configurator.c"
	}
#line 306 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = disk;
#line 306 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp20_);
#line 283 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (dev_letter_str);
#line 283 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (disk);
#line 1987 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain)
{
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* old_os = NULL;
	GVirConfigDomainOs* _tmp1_;
	GList* boot_devices = NULL;
	GList* _tmp2_;
	const gchar* _tmp3_;
#line 309 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 310 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 310 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 311 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 313 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_os (domain);
#line 313 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	old_os = _tmp1_;
#line 314 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_domain_os_get_boot_devices (old_os);
#line 314 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boot_devices = _tmp2_;
#line 315 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_remove (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 316 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 318 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_domain_os_get_arch (old_os);
#line 318 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp3_);
#line 320 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (domain, os);
#line 309 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 309 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (old_os);
#line 309 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 2033 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_os_config (GVirConfigDomain* domain,
                                     BoxesInstallerMedia* install_media,
                                     GVirConfigCapabilitiesGuest* guest_caps)
{
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	GVirConfigCapabilitiesGuestArch* _tmp2_;
	const gchar* _tmp3_;
	GList* boot_devices = NULL;
#line 323 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 323 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 323 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (guest_caps != NULL);
#line 324 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 324 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 325 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 326 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (guest_caps);
#line 326 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 326 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_name (_tmp2_);
#line 326 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp3_);
#line 326 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp2_);
#line 328 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boot_devices = NULL;
#line 329 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_set_direct_boot_params (install_media, os);
#line 330 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 331 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
#line 332 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 334 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (domain, os);
#line 323 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 323 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 2086 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_video_config (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
	GVirConfigDomainVideo* video = NULL;
	GVirConfigDomainVideo* _tmp0_;
#line 337 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 337 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 338 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_video_new ();
#line 338 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	video = _tmp0_;
#line 339 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_video_set_model (video, GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL);
#line 341 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) video);
#line 337 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (video);
#line 2110 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
	GVirConfigDomainSound* sound = NULL;
	GVirConfigDomainSound* _tmp0_;
	OsinfoDevice* device = NULL;
	OsinfoDeviceList* _tmp1_;
	OsinfoDeviceList* _tmp2_;
	OsinfoDeviceList* _tmp3_;
	OsinfoDevice* _tmp4_;
	OsinfoDevice* _tmp5_;
	gint _tmp6_ = 0;
	OsinfoDevice* _tmp7_;
	gint model = 0;
	GVirConfigDomainSound* _tmp10_;
	GVirConfigDomainSound* _tmp11_;
#line 344 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 344 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 345 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_sound_new ();
#line 345 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	sound = _tmp0_;
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_installer_media_get_supported_devices (install_media);
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_find_device_by_prop (_tmp3_, OSINFO_DEVICE_PROP_CLASS, "audio");
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = _tmp4_;
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp3_);
#line 346 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	device = _tmp5_;
#line 347 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = device;
#line 347 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp7_ != NULL) {
#line 2157 "vm-configurator.c"
		OsinfoDevice* _tmp8_;
		const gchar* _tmp9_;
#line 347 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = device;
#line 347 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = osinfo_device_get_name (_tmp8_);
#line 347 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = boxes_get_enum_value (_tmp9_, gvir_config_domain_sound_model_get_type ());
#line 2166 "vm-configurator.c"
	} else {
#line 348 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = (gint) GVIR_CONFIG_DOMAIN_SOUND_MODEL_AC97;
#line 2170 "vm-configurator.c"
	}
#line 347 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	model = _tmp6_;
#line 349 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != -1);
#line 350 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = sound;
#line 350 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_sound_set_model (_tmp10_, (GVirConfigDomainSoundModel) model);
#line 352 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = sound;
#line 352 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp11_);
#line 344 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 344 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (sound);
#line 2188 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain,
                                         BoxesInstallerMedia* install_media)
{
#line 355 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 355 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 356 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_input_config (domain, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
#line 2202 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_mouse_config (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
#line 359 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 359 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 360 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_input_config (domain, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_MOUSE);
#line 2216 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_keyboard_config (GVirConfigDomain* domain,
                                           BoxesInstallerMedia* install_media)
{
#line 363 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 363 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 364 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_input_config (domain, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_KEYBOARD);
#line 2230 "vm-configurator.c"
}


static void
boxes_vm_configurator_set_input_config (GVirConfigDomain* domain,
                                        GVirConfigDomainInputDeviceType device_type)
{
	GVirConfigDomainInput* input = NULL;
	GVirConfigDomainInput* _tmp0_;
#line 367 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 368 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_input_new ();
#line 368 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	input = _tmp0_;
#line 369 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_input_set_device_type (input, device_type);
#line 370 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_input_set_bus (input, GVIR_CONFIG_DOMAIN_INPUT_BUS_USB);
#line 372 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) input);
#line 367 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (input);
#line 2254 "vm-configurator.c"
}


static GVirConfigStoragePermissions*
boxes_vm_configurator_get_default_permissions (void)
{
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp0_;
#line 376 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_permissions_new ();
#line 376 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp0_;
#line 378 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_owner (permissions, (guint) getuid ());
#line 379 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_group (permissions, (guint) getgid ());
#line 380 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
#line 382 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = permissions;
#line 382 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2278 "vm-configurator.c"
}


static gchar*
boxes_vm_configurator_get_os_state (GVirConfigDomain* domain)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 385 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 386 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "os-state");
#line 386 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp0_;
#line 386 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2295 "vm-configurator.c"
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1442 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1443 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1443 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1443 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1444 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1444 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1444 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1444 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 2342 "vm-configurator.c"
	}
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1445 "/home/fborges/jhbuild/install/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 2348 "vm-configurator.c"
}


static gchar*
boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain,
                                           const gchar* node_name)
{
	gchar* result = NULL;
	gchar* ns_uri = NULL;
	gchar* _tmp0_;
	gchar* xml = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp33_;
#line 389 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 389 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (node_name != NULL, NULL);
#line 390 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = g_strdup (BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
#line 390 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	ns_uri = _tmp0_;
#line 391 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = ns_uri;
#line 391 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_domain_get_custom_xml (domain, _tmp1_);
#line 391 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	xml = _tmp2_;
#line 392 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = xml;
#line 392 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp3_ == NULL) {
#line 2383 "vm-configurator.c"
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 393 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = g_strdup (BOXES_VM_CONFIGURATOR_BOXES_OLD_NS_URI);
#line 393 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (ns_uri);
#line 393 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		ns_uri = _tmp4_;
#line 394 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = ns_uri;
#line 394 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = gvir_config_domain_get_custom_xml (domain, _tmp5_);
#line 394 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (xml);
#line 394 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		xml = _tmp6_;
#line 2401 "vm-configurator.c"
	}
#line 397 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = xml;
#line 397 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp7_ != NULL) {
#line 2407 "vm-configurator.c"
		xmlTextReader* reader = NULL;
		const gchar* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		guint8* _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		const gchar* _tmp14_;
		xmlTextReader* _tmp15_;
		xmlTextReader* _tmp16_;
		xmlNode* node = NULL;
		xmlTextReader* _tmp17_;
		xmlNode* _tmp18_;
		xmlNode* _tmp19_;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = xml;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = string_get_data (_tmp8_, &_tmp9__length1);
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = _tmp9_;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp10__length1 = _tmp9__length1;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = xml;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = strlen (_tmp11_);
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = _tmp12_;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp14_ = ns_uri;
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp15_ = xmlReaderForMemory ((gchar*) _tmp10_, _tmp13_, _tmp14_, NULL, (gint) XML_PARSE_COMPACT);
#line 398 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		reader = _tmp15_;
#line 403 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp16_ = reader;
#line 403 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		xmlTextReaderNext (_tmp16_);
#line 405 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp17_ = reader;
#line 405 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = xmlTextReaderExpand (_tmp17_);
#line 405 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		node = _tmp18_;
#line 406 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp19_ = node;
#line 406 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_tmp19_ != NULL) {
#line 2458 "vm-configurator.c"
			xmlNode* _tmp20_;
			const gchar* _tmp21_;
#line 408 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp20_ = node;
#line 408 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp21_ = _tmp20_->name;
#line 408 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			if (g_strcmp0 (_tmp21_, "gnome-boxes") == 0) {
#line 2467 "vm-configurator.c"
				xmlNode* _tmp22_;
				xmlNode* _tmp23_;
#line 409 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp22_ = node;
#line 409 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp23_ = _tmp22_->children;
#line 409 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				node = _tmp23_;
#line 2476 "vm-configurator.c"
			}
#line 411 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 2480 "vm-configurator.c"
				xmlNode* _tmp24_;
				xmlNode* _tmp25_;
				const gchar* _tmp26_;
				xmlNode* _tmp31_;
				xmlNode* _tmp32_;
#line 411 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp24_ = node;
#line 411 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (!(_tmp24_ != NULL)) {
#line 411 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					break;
#line 2492 "vm-configurator.c"
				}
#line 412 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp25_ = node;
#line 412 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp26_ = _tmp25_->name;
#line 412 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (_tmp26_, node_name) == 0) {
#line 2500 "vm-configurator.c"
					xmlNode* _tmp27_;
					xmlNode* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp27_ = node;
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp28_ = _tmp27_->children;
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp29_ = _tmp28_->content;
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp30_ = g_strdup (_tmp29_);
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					result = _tmp30_;
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_xmlFreeTextReader0 (reader);
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (xml);
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (ns_uri);
#line 413 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2523 "vm-configurator.c"
				}
#line 415 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp31_ = node;
#line 415 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp32_ = _tmp31_->next;
#line 415 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				node = _tmp32_;
#line 2531 "vm-configurator.c"
			}
		}
#line 397 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_xmlFreeTextReader0 (reader);
#line 2536 "vm-configurator.c"
	}
#line 420 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp33_ = gvir_config_domain_get_name (domain);
#line 420 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_debug ("vm-configurator.vala:420: No XML node %s' for domain '%s'.", node_name, _tmp33_);
#line 422 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = NULL;
#line 422 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (xml);
#line 422 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (ns_uri);
#line 422 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2550 "vm-configurator.c"
}


static gboolean
boxes_vm_configurator_boxes_created_domain (GVirConfigDomain* domain)
{
	gboolean result = FALSE;
	gchar* xml = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
#line 425 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 426 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_get_custom_xml (domain, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
#line 426 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	xml = _tmp0_;
#line 427 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = xml;
#line 427 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_tmp1_ == NULL) {
#line 2572 "vm-configurator.c"
		gchar* _tmp2_;
#line 428 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = gvir_config_domain_get_custom_xml (domain, BOXES_VM_CONFIGURATOR_BOXES_OLD_NS_URI);
#line 428 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (xml);
#line 428 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		xml = _tmp2_;
#line 2580 "vm-configurator.c"
	}
#line 430 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = xml;
#line 430 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_ != NULL;
#line 430 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (xml);
#line 430 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2590 "vm-configurator.c"
}


static void
boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain,
                                         BoxesInstallerMedia* install_media,
                                         guint num_reboots,
                                         gboolean installed)
{
	gboolean _tmp0_ = FALSE;
	gchar* custom_xml = NULL;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GError * _inner_error_ = NULL;
#line 433 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 437 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (install_media != NULL) {
#line 437 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp0_ = TRUE;
#line 2611 "vm-configurator.c"
	} else {
#line 437 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp0_ = installed;
#line 2615 "vm-configurator.c"
	}
#line 437 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (_tmp0_);
#line 440 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (installed) {
#line 2621 "vm-configurator.c"
		gchar* _tmp1_;
#line 441 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = g_strdup (BOXES_VM_CONFIGURATOR_INSTALLED_XML);
#line 441 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 441 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp1_;
#line 2629 "vm-configurator.c"
	} else {
#line 442 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (install_media, BOXES_TYPE_LIBVIRT_CLONED_MEDIA)) {
#line 2633 "vm-configurator.c"
			gchar* _tmp2_;
#line 443 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = g_strdup (BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_XML);
#line 443 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 443 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp2_;
#line 2641 "vm-configurator.c"
		} else {
#line 444 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (install_media, BOXES_TYPE_LIBVIRT_MEDIA)) {
#line 2645 "vm-configurator.c"
				gchar* _tmp3_;
#line 445 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = g_strdup (BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_XML);
#line 445 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (custom_xml);
#line 445 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				custom_xml = _tmp3_;
#line 2653 "vm-configurator.c"
			} else {
#line 446 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (install_media, BOXES_TYPE_INSTALLED_MEDIA)) {
#line 2657 "vm-configurator.c"
					gchar* _tmp4_;
#line 447 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp4_ = g_strdup (BOXES_VM_CONFIGURATOR_IMPORT_XML);
#line 447 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (custom_xml);
#line 447 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					custom_xml = _tmp4_;
#line 2665 "vm-configurator.c"
				} else {
					const gchar* _tmp5_ = NULL;
					gboolean _tmp6_;
					gboolean _tmp7_;
					gchar* _tmp8_;
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp6_ = boxes_installer_media_get_live (install_media);
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp7_ = _tmp6_;
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					if (_tmp7_) {
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_tmp5_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
#line 2679 "vm-configurator.c"
					} else {
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
						_tmp5_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
#line 2683 "vm-configurator.c"
					}
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp8_ = g_strdup (_tmp5_);
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (custom_xml);
#line 449 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					custom_xml = _tmp8_;
#line 2691 "vm-configurator.c"
				}
			}
		}
	}
#line 451 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (install_media != NULL) {
#line 2698 "vm-configurator.c"
		OsinfoOs* _tmp9_;
		OsinfoMedia* _tmp18_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
#line 452 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = install_media->os;
#line 452 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_tmp9_ != NULL) {
#line 2710 "vm-configurator.c"
			const gchar* _tmp10_;
			OsinfoOs* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp10_ = custom_xml;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp11_ = install_media->os;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			g_object_get ((OsinfoEntity*) _tmp11_, "id", &_tmp12_, NULL);
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp13_ = _tmp12_;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp14_ = _tmp13_;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp15_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_OS_ID_XML, _tmp14_);
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp16_ = _tmp15_;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp17_ = g_strconcat (_tmp10_, _tmp16_, NULL);
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp17_;
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp16_);
#line 453 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp14_);
#line 2743 "vm-configurator.c"
		}
#line 454 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = install_media->os_media;
#line 454 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (_tmp18_ != NULL) {
#line 2749 "vm-configurator.c"
			const gchar* _tmp19_;
			OsinfoMedia* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp19_ = custom_xml;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp20_ = install_media->os_media;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			g_object_get ((OsinfoEntity*) _tmp20_, "id", &_tmp21_, NULL);
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp22_ = _tmp21_;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp23_ = _tmp22_;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp24_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_ID_XML, _tmp23_);
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp25_ = _tmp24_;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp26_ = g_strconcat (_tmp19_, _tmp25_, NULL);
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp26_;
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp25_);
#line 455 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp23_);
#line 2782 "vm-configurator.c"
		}
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp27_ = custom_xml;
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp28_ = install_media->device_file;
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp29_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_XML, _tmp28_);
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp30_ = _tmp29_;
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp31_;
#line 456 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp30_);
#line 2800 "vm-configurator.c"
	}
#line 459 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (num_reboots != ((guint) 0)) {
#line 2804 "vm-configurator.c"
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp32_ = custom_xml;
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp33_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML, num_reboots);
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp34_ = _tmp33_;
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp35_;
#line 460 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp34_);
#line 2823 "vm-configurator.c"
	}
#line 462 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp36_ = custom_xml;
#line 462 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp37_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_BOXES_XML, _tmp36_);
#line 462 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (custom_xml);
#line 462 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	custom_xml = _tmp37_;
#line 2833 "vm-configurator.c"
	{
		const gchar* _tmp38_;
#line 464 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp38_ = custom_xml;
#line 464 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_set_custom_xml (domain, _tmp38_, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
#line 464 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2842 "vm-configurator.c"
			goto __catch112_g_error;
		}
	}
	goto __finally112;
	__catch112_g_error:
	{
		GError* _error_ = NULL;
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_error_ = _inner_error_;
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_inner_error_ = NULL;
#line 465 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_assert_not_reached ();
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_error_free0 (_error_);
#line 2858 "vm-configurator.c"
	}
	__finally112:
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 463 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return;
#line 2871 "vm-configurator.c"
	}
#line 433 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (custom_xml);
#line 2875 "vm-configurator.c"
}


void
boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain)
{
	GVirConfigDomainSmartcardPassthrough* smartcard = NULL;
	GVirConfigDomainSmartcardPassthrough* _tmp0_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp1_;
#line 468 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 469 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_smartcard_passthrough_new ();
#line 469 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	smartcard = _tmp0_;
#line 470 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 470 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp1_;
#line 471 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_smartcard_passthrough_set_source (smartcard, (GVirConfigDomainChardevSource*) vmc);
#line 472 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) smartcard);
#line 468 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 468 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (smartcard);
#line 2904 "vm-configurator.c"
}


void
boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain)
{
	GVirConfigDomainControllerUsb* master_controller = NULL;
	GVirConfigDomainControllerUsb* _tmp9_;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp10_;
	GVirConfigDomainControllerUsb* _tmp11_;
	GVirConfigDomainControllerUsb* _tmp12_;
	GVirConfigDomainControllerUsb* _tmp13_;
	GVirConfigDomainControllerUsb* _tmp14_;
	GVirConfigDomainControllerUsb* _tmp15_;
#line 475 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 2922 "vm-configurator.c"
	{
		gint i = 0;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		i = 0;
#line 2927 "vm-configurator.c"
		{
			gboolean _tmp0_ = FALSE;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp0_ = TRUE;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 2934 "vm-configurator.c"
				gint _tmp2_;
				GVirConfigDomainRedirdev* usb_redir = NULL;
				GVirConfigDomainRedirdev* _tmp3_;
				GVirConfigDomainRedirdev* _tmp4_;
				GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp5_;
				GVirConfigDomainRedirdev* _tmp6_;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp7_;
				GVirConfigDomainRedirdev* _tmp8_;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (!_tmp0_) {
#line 2946 "vm-configurator.c"
					gint _tmp1_;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp1_ = i;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					i = _tmp1_ + 1;
#line 2952 "vm-configurator.c"
				}
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp0_ = FALSE;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp2_ = i;
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (!(_tmp2_ < 4)) {
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					break;
#line 2962 "vm-configurator.c"
				}
#line 478 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = gvir_config_domain_redirdev_new ();
#line 478 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				usb_redir = _tmp3_;
#line 479 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = usb_redir;
#line 479 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_redirdev_set_bus (_tmp4_, GVIR_CONFIG_DOMAIN_REDIRDEV_BUS_USB);
#line 480 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 480 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				vmc = _tmp5_;
#line 481 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = usb_redir;
#line 481 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = vmc;
#line 481 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp6_, (GVirConfigDomainChardevSource*) _tmp7_);
#line 482 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = usb_redir;
#line 482 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp8_);
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (vmc);
#line 477 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (usb_redir);
#line 2990 "vm-configurator.c"
			}
		}
	}
#line 486 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_EHCI1, NULL, (guint) 0, (guint) 0);
#line 486 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	master_controller = _tmp9_;
#line 487 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) master_controller);
#line 488 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI1, master_controller, (guint) 0, (guint) 0);
#line 488 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp10_;
#line 489 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = controller;
#line 489 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp11_);
#line 490 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI2, master_controller, (guint) 0, (guint) 2);
#line 490 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 490 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp12_;
#line 491 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = controller;
#line 491 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp13_);
#line 492 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI3, master_controller, (guint) 0, (guint) 4);
#line 492 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 492 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp14_;
#line 493 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = controller;
#line 493 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp15_);
#line 475 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 475 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (master_controller);
#line 3032 "vm-configurator.c"
}


GVirConfigDomainInterface*
boxes_vm_configurator_create_network_interface (GVirConfigDomain* domain,
                                                gboolean bridge,
                                                gboolean virtio)
{
	GVirConfigDomainInterface* result = NULL;
	GVirConfigDomainInterface* iface = NULL;
#line 496 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 499 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (bridge) {
#line 3047 "vm-configurator.c"
		const gchar* _tmp0_;
		GVirConfigDomainInterfaceBridge* bridge_iface = NULL;
		GVirConfigDomainInterfaceBridge* _tmp1_;
		GVirConfigDomainInterfaceBridge* _tmp2_;
		GVirConfigDomainInterfaceBridge* _tmp3_;
		GVirConfigDomainInterface* _tmp4_;
#line 500 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp0_ = gvir_config_domain_get_name (domain);
#line 500 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:500: Creating bridge network device for %s", _tmp0_);
#line 501 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp1_ = gvir_config_domain_interface_bridge_new ();
#line 501 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		bridge_iface = _tmp1_;
#line 502 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = bridge_iface;
#line 502 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_interface_bridge_set_source (_tmp2_, "virbr0");
#line 503 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = bridge_iface;
#line 503 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = _g_object_ref0 ((GVirConfigDomainInterface*) _tmp3_);
#line 503 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (iface);
#line 503 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		iface = _tmp4_;
#line 499 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (bridge_iface);
#line 3076 "vm-configurator.c"
	} else {
		const gchar* _tmp5_;
		GVirConfigDomainInterfaceUser* _tmp6_;
#line 505 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = gvir_config_domain_get_name (domain);
#line 505 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:505: Creating user network device for %s", _tmp5_);
#line 506 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = gvir_config_domain_interface_user_new ();
#line 506 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (iface);
#line 506 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		iface = (GVirConfigDomainInterface*) _tmp6_;
#line 3090 "vm-configurator.c"
	}
#line 509 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (virtio) {
#line 3094 "vm-configurator.c"
		GVirConfigDomainInterface* _tmp7_;
#line 510 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = iface;
#line 510 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_interface_set_model (_tmp7_, "virtio");
#line 3100 "vm-configurator.c"
	}
#line 512 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = iface;
#line 512 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3106 "vm-configurator.c"
}


GVirConfigDomainGraphicsSpice*
boxes_vm_configurator_create_graphics_device (void)
{
	GVirConfigDomainGraphicsSpice* result = NULL;
	GVirConfigDomainGraphicsSpice* graphics = NULL;
	GVirConfigDomainGraphicsSpice* _tmp0_;
#line 516 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_graphics_spice_new ();
#line 516 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	graphics = _tmp0_;
#line 517 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_autoport (graphics, FALSE);
#line 518 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_image_compression (graphics, GVIR_CONFIG_DOMAIN_GRAPHICS_SPICE_IMAGE_COMPRESSION_OFF);
#line 520 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = graphics;
#line 520 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3128 "vm-configurator.c"
}


static GVirConfigDomainControllerUsb*
boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model,
                                             GVirConfigDomainControllerUsb* master,
                                             guint index,
                                             guint start_port)
{
	GVirConfigDomainControllerUsb* result = NULL;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp0_;
	GVirConfigDomainControllerUsb* _tmp1_;
	GVirConfigDomainControllerUsb* _tmp2_;
#line 527 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_controller_usb_new ();
#line 527 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp0_;
#line 528 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = controller;
#line 528 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_controller_usb_set_model (_tmp1_, model);
#line 529 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = controller;
#line 529 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_controller_set_index ((GVirConfigDomainController*) _tmp2_, index);
#line 530 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (master != NULL) {
#line 3157 "vm-configurator.c"
		GVirConfigDomainControllerUsb* _tmp3_;
#line 531 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = controller;
#line 531 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_controller_usb_set_master (_tmp3_, master, start_port);
#line 3163 "vm-configurator.c"
	}
#line 533 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = controller;
#line 533 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3169 "vm-configurator.c"
}


static gint
__lambda24_ (GVirConfigCapabilitiesGuest* caps_a,
             GVirConfigCapabilitiesGuest* caps_b)
{
	gint result = 0;
	gchar* arch_a = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* arch_b = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp5_;
	GVirConfigCapabilitiesGuestArch* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
#line 540 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps_a != NULL, 0);
#line 540 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps_b != NULL, 0);
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_capabilities_guest_get_arch (caps_a);
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = _tmp0_;
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_guest_arch_get_name (_tmp1_);
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp1_);
#line 541 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	arch_a = _tmp4_;
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = gvir_config_capabilities_guest_get_arch (caps_b);
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = gvir_config_capabilities_guest_arch_get_name (_tmp6_);
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = _tmp8_;
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp6_);
#line 542 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	arch_b = _tmp9_;
#line 544 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = arch_a;
#line 544 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (g_strcmp0 (_tmp10_, "i686") == 0) {
#line 3227 "vm-configurator.c"
		const gchar* _tmp11_;
#line 545 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = arch_b;
#line 545 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (g_strcmp0 (_tmp11_, "x86_64") == 0) {
#line 546 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			result = 1;
#line 546 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (arch_b);
#line 546 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (arch_a);
#line 546 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return result;
#line 3241 "vm-configurator.c"
		} else {
#line 548 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			result = -1;
#line 548 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (arch_b);
#line 548 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (arch_a);
#line 548 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return result;
#line 3251 "vm-configurator.c"
		}
	} else {
		const gchar* _tmp12_;
#line 549 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = arch_a;
#line 549 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (g_strcmp0 (_tmp12_, "x86_64") == 0) {
#line 550 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			result = -1;
#line 550 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (arch_b);
#line 550 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (arch_a);
#line 550 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return result;
#line 3267 "vm-configurator.c"
		} else {
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
#line 551 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp14_ = arch_b;
#line 551 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			if (g_strcmp0 (_tmp14_, "x86_64") == 0) {
#line 551 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp13_ = TRUE;
#line 3277 "vm-configurator.c"
			} else {
				const gchar* _tmp15_;
#line 551 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp15_ = arch_b;
#line 551 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp13_ = g_strcmp0 (_tmp15_, "i686") == 0;
#line 3284 "vm-configurator.c"
			}
#line 551 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			if (_tmp13_) {
#line 552 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				result = 1;
#line 552 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (arch_b);
#line 552 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (arch_a);
#line 552 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				return result;
#line 3296 "vm-configurator.c"
			} else {
#line 554 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				result = 0;
#line 554 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (arch_b);
#line 554 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (arch_a);
#line 554 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				return result;
#line 3306 "vm-configurator.c"
			}
		}
	}
#line 540 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (arch_b);
#line 540 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (arch_a);
#line 3314 "vm-configurator.c"
}


static gint
___lambda24__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda24_ ((GVirConfigCapabilitiesGuest*) a, (GVirConfigCapabilitiesGuest*) b);
#line 540 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3326 "vm-configurator.c"
}


static GVirConfigCapabilitiesGuest*
boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps,
                                           BoxesInstallerMedia* install_media,
                                           GError** error)
{
	GVirConfigCapabilitiesGuest* result = NULL;
	GList* guests_caps = NULL;
	GList* _tmp0_;
	GList* compat_guests_caps = NULL;
	GList* _tmp1_;
	GList* _tmp12_;
	GList* _tmp15_;
	GError* _tmp18_;
	GError * _inner_error_ = NULL;
#line 536 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 536 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 538 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_capabilities_get_guests (caps);
#line 538 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	guests_caps = _tmp0_;
#line 540 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	guests_caps = g_list_sort (guests_caps, ___lambda24__gcompare_func);
#line 558 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	compat_guests_caps = NULL;
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = guests_caps;
#line 3358 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp1_;
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 3366 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp2_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp2_;
#line 3373 "vm-configurator.c"
			{
				gchar* guest_arch = NULL;
				GVirConfigCapabilitiesGuest* _tmp3_;
				GVirConfigCapabilitiesGuestArch* _tmp4_;
				GVirConfigCapabilitiesGuestArch* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = guest_caps;
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = gvir_config_capabilities_guest_get_arch (_tmp3_);
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = _tmp4_;
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_arch_get_name (_tmp5_);
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = _tmp7_;
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (_tmp5_);
#line 560 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				guest_arch = _tmp8_;
#line 562 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = guest_arch;
#line 562 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (boxes_installer_media_is_architecture_compatible (install_media, _tmp9_)) {
#line 3403 "vm-configurator.c"
					GVirConfigCapabilitiesGuest* _tmp10_;
					GVirConfigCapabilitiesGuest* _tmp11_;
#line 563 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp10_ = guest_caps;
#line 563 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 563 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					compat_guests_caps = g_list_append (compat_guests_caps, _tmp11_);
#line 3412 "vm-configurator.c"
				}
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (guest_arch);
#line 559 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 3418 "vm-configurator.c"
			}
		}
	}
#line 567 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = compat_guests_caps;
#line 3424 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 567 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp12_;
#line 567 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 3432 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp13_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 567 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp13_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 567 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp13_;
#line 3439 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp14_;
#line 568 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp14_ = guest_caps;
#line 568 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (boxes_vm_configurator_guest_kvm_enabled (_tmp14_)) {
#line 569 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 569 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 569 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 569 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 3454 "vm-configurator.c"
				}
#line 567 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 3458 "vm-configurator.c"
			}
		}
	}
#line 572 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = compat_guests_caps;
#line 3464 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 572 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp15_;
#line 572 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 3472 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp16_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 572 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp16_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 572 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp16_;
#line 3479 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp17_;
#line 573 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = guest_caps;
#line 573 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (boxes_vm_configurator_guest_is_qemu (_tmp17_)) {
#line 574 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 574 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 574 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 574 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 3494 "vm-configurator.c"
				}
#line 572 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 3498 "vm-configurator.c"
			}
		}
	}
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = g_error_new_literal (BOXES_VM_CONFIGURATOR_ERROR, BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, _ ("Incapable host system"));
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_inner_error_ = _tmp18_;
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_propagate_error (error, _inner_error_);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 3516 "vm-configurator.c"
	} else {
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 578 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 3528 "vm-configurator.c"
	}
#line 536 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 536 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (guests_caps);
#line 3534 "vm-configurator.c"
}


static gboolean
boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps)
{
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	GList* _tmp2_;
#line 581 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 582 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_capabilities_guest_get_arch (guest_caps);
#line 582 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp0_;
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = arch;
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_guest_arch_get_domains (_tmp1_);
#line 3556 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp2_;
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 3564 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp3_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp3_;
#line 3571 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp4_;
#line 584 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = domain;
#line 584 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (gvir_config_capabilities_guest_domain_get_virt_type (_tmp4_) == GVIR_CONFIG_DOMAIN_VIRT_KVM) {
#line 585 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 585 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 585 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 585 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 585 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 3588 "vm-configurator.c"
				}
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 3592 "vm-configurator.c"
			}
		}
#line 583 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 3597 "vm-configurator.c"
	}
#line 587 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 587 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 587 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3605 "vm-configurator.c"
}


static gboolean
boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps)
{
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	GList* _tmp2_;
#line 590 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 591 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_capabilities_guest_get_arch (guest_caps);
#line 591 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp0_;
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = arch;
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_guest_arch_get_domains (_tmp1_);
#line 3627 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp2_;
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 3635 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp3_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp3_;
#line 3642 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp4_;
#line 593 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = domain;
#line 593 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (gvir_config_capabilities_guest_domain_get_virt_type (_tmp4_) == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
#line 594 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 594 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 594 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 594 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 594 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 3659 "vm-configurator.c"
				}
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 3663 "vm-configurator.c"
			}
		}
#line 592 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 3668 "vm-configurator.c"
	}
#line 596 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 596 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 596 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3676 "vm-configurator.c"
}


static gboolean
boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps,
                                              const gchar* feature_name)
{
	gboolean result = FALSE;
	gboolean supports = FALSE;
	GList* _tmp0_;
#line 599 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 599 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (feature_name != NULL, FALSE);
#line 600 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	supports = FALSE;
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_capabilities_guest_get_features (guest_caps);
#line 3695 "vm-configurator.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		feature_collection = _tmp0_;
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 3703 "vm-configurator.c"
			GVirConfigCapabilitiesGuestFeature* _tmp1_;
			GVirConfigCapabilitiesGuestFeature* feature = NULL;
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			_tmp1_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestFeature*) feature_it->data);
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			feature = _tmp1_;
#line 3710 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestFeature* _tmp2_;
				const gchar* _tmp3_;
#line 603 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp2_ = feature;
#line 603 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = gvir_config_capabilities_guest_feature_get_name (_tmp2_);
#line 603 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (feature_name, _tmp3_) == 0) {
#line 604 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					supports = TRUE;
#line 606 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (feature);
#line 606 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
					break;
#line 3726 "vm-configurator.c"
				}
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (feature);
#line 3730 "vm-configurator.c"
			}
		}
#line 602 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (feature_collection);
#line 3735 "vm-configurator.c"
	}
#line 609 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	result = supports;
#line 609 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3741 "vm-configurator.c"
}


BoxesVMConfigurator*
boxes_vm_configurator_construct (GType object_type)
{
	BoxesVMConfigurator* self = NULL;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return self;
#line 3753 "vm-configurator.c"
}


BoxesVMConfigurator*
boxes_vm_configurator_new (void)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
#line 3762 "vm-configurator.c"
}


static void
boxes_value_vm_configurator_init (GValue* value)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	value->data[0].v_pointer = NULL;
#line 3771 "vm-configurator.c"
}


static void
boxes_value_vm_configurator_free_value (GValue* value)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (value->data[0].v_pointer) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (value->data[0].v_pointer);
#line 3782 "vm-configurator.c"
	}
}


static void
boxes_value_vm_configurator_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
#line 3795 "vm-configurator.c"
	} else {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3799 "vm-configurator.c"
	}
}


static gpointer
boxes_value_vm_configurator_peek_pointer (const GValue* value)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 3809 "vm-configurator.c"
}


static gchar*
boxes_value_vm_configurator_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (collect_values[0].v_pointer) {
#line 3821 "vm-configurator.c"
		BoxesVMConfigurator * object;
		object = collect_values[0].v_pointer;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3828 "vm-configurator.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3832 "vm-configurator.c"
		}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
#line 3836 "vm-configurator.c"
	} else {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3840 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 3844 "vm-configurator.c"
}


static gchar*
boxes_value_vm_configurator_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	BoxesVMConfigurator ** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (!object_p) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3860 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*object_p = NULL;
#line 3866 "vm-configurator.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*object_p = value->data[0].v_pointer;
#line 3870 "vm-configurator.c"
	} else {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 3874 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 3878 "vm-configurator.c"
}


GParamSpec*
boxes_param_spec_vm_configurator (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	BoxesParamSpecVMConfigurator* spec;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return G_PARAM_SPEC (spec);
#line 3898 "vm-configurator.c"
}


gpointer
boxes_value_get_vm_configurator (const GValue* value)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 3909 "vm-configurator.c"
}


void
boxes_value_set_vm_configurator (GValue* value,
                                 gpointer v_object)
{
	BoxesVMConfigurator * old;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 3932 "vm-configurator.c"
	} else {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3936 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 3942 "vm-configurator.c"
	}
}


void
boxes_value_take_vm_configurator (GValue* value,
                                  gpointer v_object)
{
	BoxesVMConfigurator * old;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 3964 "vm-configurator.c"
	} else {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3968 "vm-configurator.c"
	}
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 3974 "vm-configurator.c"
	}
}


static void
boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	((BoxesVMConfiguratorClass *) klass)->finalize = boxes_vm_configurator_finalize;
#line 3986 "vm-configurator.c"
}


static void
boxes_vm_configurator_instance_init (BoxesVMConfigurator * self)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	self->ref_count = 1;
#line 3995 "vm-configurator.c"
}


static void
boxes_vm_configurator_finalize (BoxesVMConfigurator * obj)
{
	BoxesVMConfigurator * self;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_signal_handlers_destroy (self);
#line 4007 "vm-configurator.c"
}


GType
boxes_vm_configurator_get_type (void)
{
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer
boxes_vm_configurator_ref (gpointer instance)
{
	BoxesVMConfigurator * self;
	self = instance;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	return instance;
#line 4036 "vm-configurator.c"
}


void
boxes_vm_configurator_unref (gpointer instance)
{
	BoxesVMConfigurator * self;
	self = instance;
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
#line 10 "/home/fborges/checkout/gnome-boxes/src/vm-configurator.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4051 "vm-configurator.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 4063 "vm-configurator.c"
		int i;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 4071 "vm-configurator.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 4087 "vm-configurator.c"
}



