/*
 *  GMF: The GNOME Media Framework
 *
 *  Copyright (C) 1999 Elliot Lee
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Elliot Lee <sopwith@redhat.com>
 *
 */

#ifndef GMF_PIPE_H
#define GMF_PIPE_H 1

/* GtkObject GMFPipe */
#define GMF_TYPE_PIPE	(gmf_pipe_get_type())
#define GMF_PIPE(obj)	(GTK_CHECK_CAST((obj), GMF_TYPE_PIPE, GMFPipe))
#define GMF_PIPE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GMF_TYPE_PIPE, GMFPipeClass))
#define GMF_IS_PIPE(obj) (GTK_CHECK_TYPE((obj), GMF_TYPE_PIPE))
#define GMF_IS_PIPE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GMF_TYPE_PIPE))

struct _GMFPipe {
  GtkObject object;

  GtkObject *filter_object;

  CORBA_Object corba_object;
  gpointer servant;
  GMF_TimeVal curtime;
};

typedef struct {
  GtkObjectClass klass;

  void (*receive_sample)(GMFPipe *pipe, GMF_Sample *sample,
			     gboolean must_copy);
  void (*can_process_type)(GMFPipe *pipe, GMF_MediaTypeInfo *type_info,
			       gboolean *retval);
  void (*get_processable_types)(GMFPipe *pipe,
				GMF_MediaTypeInfoList **out_typelist);
  void (*new_segment)(GMFPipe *pipe, GMF_TimeVal *tStart, GMF_TimeVal *tStop,
		      gdouble playRate);
  void (*begin_flush)(GMFPipe *pipe);
  void (*end_flush)(GMFPipe *pipe);
  void (*end_of_stream)(GMFPipe *pipe);
} GMFPipeClass;

GtkType gmf_pipe_get_type (void);
GtkObject *gmf_pipe_new (GMFFilter *filter, GMF_Direction pipedir,
			 GMF_Transport_Type acceptable_transports);
void gmf_pipe_send_sample(GMFPipe *apipe, GMF_Sample *sample);

/* Returns 0 if connection succeeded */
gint gmf_pipe_connect (GMFPipe *apipe, GMF_Pipe remote_end);

#endif /* GMF_PIPE_H */
