/*  Glimmer - gnomeruncmd.c
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnomeruncmd.h"

/* function declarations */
static void gnome_run_cmd_class_init(GnomeRunCmdClass *klass);
static void gnome_run_cmd_init(GnomeRunCmd *grc);
GtkWidget *gnome_run_cmd_new(gchar *title, gchar *prompt);
static void gnome_run_cmd_destroy(GtkObject *object);
static gboolean check_glist_for_multiple_entries(GList *list, gchar *new_entry);
static void kill_combo_history(GList *list);
static void click_button(GtkWidget *entry, GtkWidget *button);
static void check_enable_button(GtkWidget *entry, GtkWidget *button);
/* end function declarations */

static GtkWindowClass *parent_class = NULL;

GtkType gnome_run_cmd_get_type(void)
{
   static GtkType run_cmd_type=0;
   if(!run_cmd_type)
   {
      static const GtkTypeInfo run_cmd_info = 
      {	
         "GnomeRunCmdDialog",
         sizeof(GnomeRunCmd),
         sizeof(GnomeRunCmdClass),
         (GtkClassInitFunc) gnome_run_cmd_class_init,
         (GtkObjectInitFunc) gnome_run_cmd_init,
         NULL,
         NULL,
         (GtkClassInitFunc)NULL,
      };
      run_cmd_type = gtk_type_unique(GTK_TYPE_WINDOW, &run_cmd_info);
   }
   return(run_cmd_type);
}

static void gnome_run_cmd_class_init(GnomeRunCmdClass *klass)
{
   GtkObjectClass *object_class;
   object_class = (GtkObjectClass*)klass;
   parent_class = gtk_type_class(GTK_TYPE_WINDOW);
   object_class->destroy = gnome_run_cmd_destroy;
}

static void gnome_run_cmd_init(GnomeRunCmd *grc)
{
   grc->history = NULL;
}

GtkWidget* gnome_run_cmd_new(gchar *title, gchar *prompt)
{
   GnomeRunCmd *grc;
   GtkWidget *main_box;
   GtkWidget *util_box;
   GtkWidget *label;
   GtkWidget *hsep;

   grc = gtk_type_new(GNOME_TYPE_RUN_CMD);
   gtk_container_set_border_width(GTK_CONTAINER(grc), 5);
   gtk_window_set_title(GTK_WINDOW(grc), title);
   
   main_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(grc), main_box);
   gtk_widget_show(main_box);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(main_box), util_box, TRUE, TRUE, 0);
   gtk_widget_show(util_box);

   label = gtk_label_new(prompt);
   gtk_box_pack_start(GTK_BOX(util_box), label, FALSE, FALSE, 0);   
   gtk_widget_show(label);

   grc->combo = gtk_combo_new();
   gtk_combo_disable_activate(GTK_COMBO(grc->combo));
   gtk_box_pack_start(GTK_BOX(util_box), grc->combo, TRUE, TRUE, 0);
   gtk_widget_show(grc->combo);

   grc->entry = GTK_COMBO(grc->combo)->entry;

   hsep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(main_box), hsep, TRUE, TRUE, 10);
   gtk_widget_show(hsep);

   util_box = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(main_box), util_box, TRUE, TRUE, 0);
   gtk_button_box_set_layout(GTK_BUTTON_BOX(util_box), gnome_preferences_get_button_layout());
   gtk_button_box_set_spacing(GTK_BUTTON_BOX(util_box), GNOME_PAD);
   gtk_widget_show(util_box);

   grc->run_button = gnome_pixmap_button(gnome_stock_pixmap_widget_at_size(GTK_WIDGET(grc), GNOME_STOCK_PIXMAP_EXEC, 20, 20), "Run");
   gtk_box_pack_end(GTK_BOX(util_box), grc->run_button, FALSE, FALSE, 5);
   gtk_widget_show(grc->run_button);
   gtk_widget_set_sensitive(grc->run_button, FALSE);
   GTK_WIDGET_SET_FLAGS(grc->run_button, GTK_CAN_DEFAULT);
   gtk_window_set_default(GTK_WINDOW(grc), grc->run_button);

   grc->cancel_button = gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
   gtk_box_pack_end(GTK_BOX(util_box), grc->cancel_button, FALSE, FALSE, 5);
   GTK_WIDGET_SET_FLAGS(grc->cancel_button, GTK_CAN_DEFAULT);
   gtk_widget_show(grc->cancel_button);   

   gtk_signal_connect(GTK_OBJECT(grc->entry), "changed", GTK_SIGNAL_FUNC(check_enable_button), (gpointer)grc->run_button);
   gtk_signal_connect(GTK_OBJECT(grc->entry), "activate", GTK_SIGNAL_FUNC(click_button), (gpointer)grc->run_button);
   return GTK_WIDGET(grc);
}

static void gnome_run_cmd_destroy(GtkObject *object)
{
   GtkWidget *grc;
   g_return_if_fail(object != NULL);
   g_return_if_fail(GNOME_IS_RUN_CMD(object));
   grc = GTK_WIDGET(object);
   if(GNOME_RUN_CMD(grc)->history)
      kill_combo_history(GNOME_RUN_CMD(grc)->history);
   gtk_widget_destroy(grc);
}

gchar *gnome_run_cmd_get_command(GnomeRunCmd *grc)
{
   gchar *text;

   g_return_val_if_fail(grc != NULL, NULL);
   g_return_val_if_fail(GNOME_IS_RUN_CMD(grc), NULL);
   text = gtk_entry_get_text(GTK_ENTRY(grc->entry));
   return(text);
}

void gnome_run_cmd_set_history(GnomeRunCmd *grc, GList *history)
{
   g_return_if_fail(grc != NULL);
   g_return_if_fail(GNOME_IS_RUN_CMD(grc));
   if(history == NULL) return;
   grc->history = history;
   gtk_combo_set_popdown_strings(GTK_COMBO(grc->combo), grc->history);
   gtk_entry_set_text(GTK_ENTRY(grc->entry), "");
}

gboolean gnome_run_cmd_add_string(GnomeRunCmd *grc, gchar *string)
{
   gpointer temp;
   g_return_val_if_fail(grc != NULL, FALSE);
   g_return_val_if_fail(GNOME_IS_RUN_CMD(grc), FALSE);
   if(check_glist_for_multiple_entries(grc->history, string)) return(FALSE);
   temp = g_new(char, strlen(string)+1);
   strcpy((gchar *)temp, string);
   grc->history = g_list_prepend(grc->history, temp);
   gtk_combo_set_popdown_strings(GTK_COMBO(grc->combo), grc->history);
   return(TRUE);
}   

static gboolean check_glist_for_multiple_entries(GList *list, gchar *new_entry)
{
   GList *temp;
   gchar *cmp_text;

   if(list == NULL) return(FALSE);
   temp = list;
   while(temp != NULL)
   {
      cmp_text = temp->data;
      if(!strcmp(cmp_text, new_entry))
      {
         return(TRUE);
      }
      temp = g_list_next(temp);
   }
   return(FALSE);
}

static void kill_combo_history(GList *list)
{
   GList *temp;
   if(list == NULL)
      return;

   temp = list;
   while(temp != NULL)
   {
      g_free(temp->data);
      temp = g_list_next(temp);
   }
   g_list_free(list);
}

static void click_button(GtkWidget *entry, GtkWidget *button)
{
   gtk_signal_emit_by_name(GTK_OBJECT(button), "clicked", NULL);   
}

static void check_enable_button(GtkWidget *entry, GtkWidget *button)
{
   gchar *text;
   gboolean sensitive = FALSE;
   text = gtk_entry_get_text(GTK_ENTRY(entry));
   if(text && strlen(text) > 0) sensitive = TRUE;
   gtk_widget_set_sensitive(button, sensitive);
}
