/*  Glimmer - splash.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _SPLASH_H_
#define _SPLASH_H_

#include <gnome.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _SplashScreen
{
   GtkWidget *window;
   GtkWidget *pixmap;
   GtkWidget *pixmap_box;
   GList *pixmaps;
   gint index;
   GtkWidget *auth_info;
   GtkWidget *init_info;
}SplashScreen;

SplashScreen *splash_screen_build(gchar *auth_info, gchar *pixmap);
void splash_screen_append_icon(SplashScreen *splash, gchar *gnome_icon);
void splash_screen_update_next_icon(SplashScreen *splash);
void splash_screen_update(SplashScreen *splash, gchar *text);
void splash_screen_die(SplashScreen *splash);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
