/* Gnome Run Command dialog entry.
*
*  A gnome widget for running a command
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef GNOME_RUN_CMD_H__
#define GNOME_RUN_CMD_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_RUN_CMD (gnome_run_cmd_get_type())
#define GNOME_RUN_CMD(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_RUN_CMD, GnomeRunCmd))
#define GNOME_RUN_CMD_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_RUN_CMD, GnomeRunCmdClass))
#define GNOME_IS_RUN_CMD(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_RUN_CMD))
#define GNOME_IS_RUN_CMD_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_RUN_CMD))

typedef struct _GnomeRunCmd GnomeRunCmd;
typedef struct _GnomeRunCmdClass GnomeRunCmdClass;

struct _GnomeRunCmd {
   GtkWindow window;
   GtkWidget *combo;
   GtkWidget *entry; /* Lets have both, even tho they are the same widget */
   GtkWidget *run_button;
   GtkWidget *cancel_button;
   GList *history;
};

struct _GnomeRunCmdClass {
   GtkWindowClass parent_class;
};

GtkType gnome_run_cmd_get_type(void);

GtkWidget *gnome_run_cmd_new(gchar *title, gchar *prompt);
gchar *gnome_run_cmd_get_command(GnomeRunCmd *grc);
void gnome_run_cmd_set_history(GnomeRunCmd *grc, GList *history);
gboolean gnome_run_cmd_add_string(GnomeRunCmd *grc, gchar *string);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
