/* GnomeDirEntry
*
*  By: Chicane (Chris Phelps)
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef GNOME_DIRENTRY_H__
#define GNOME_DIRENTRY_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_DIRENTRY (gnome_direntry_get_type())
#define GNOME_DIRENTRY(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_DIRENTRY, GnomeDirEntry))
#define GNOME_DIRENTRY_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_DIRENTRY, GnomeDirEntryClass))
#define GNOME_IS_DIRENTRY(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_DIRENTRY))
#define GNOME_IS_DIRENTRY_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_DIRENTRY))

typedef struct _GnomeDirEntry GnomeDirEntry;
typedef struct _GnomeDirEntryClass GnomeDirEntryClass;

struct _GnomeDirEntry {
   GtkHBox box;
   GtkWidget *entry;
   GtkWidget *chdir_button;
   GtkWidget *dir_list;
};

struct _GnomeDirEntryClass {
   GtkHBoxClass parent_class;
};

GtkType gnome_direntry_get_type(void);

GtkWidget *gnome_direntry_new(void);

gchar *gnome_direntry_get_dir(GnomeDirEntry *dir_entry);

void gnome_direntry_set_dir(GnomeDirEntry *dir_entry, const gchar *dir);


#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif