#include "gnomeasciilist.h"

/* function declarations */
static void gnome_ascii_list_class_init(GnomeAsciiListClass *_class);
static void gnome_ascii_list_init(GnomeAsciiList *ascii);
GtkWidget *gnome_ascii_list_new(void);
static void gnome_ascii_list_destroy(GtkObject *object);
static void ascii_select_event(GtkCList *list, gint row, gint col, GdkEvent *event, GnomeAsciiList *ascii);
static void button_press_cb(GtkWidget *widget, GnomeAsciiList *ascii);
static void ascii_unselect_event(GtkCList *list, gint row, gint col, GdkEvent *event, GnomeAsciiList *ascii);
static void gnome_ascii_list_fill(GnomeAsciiList *ascii);
static gint gnome_ascii_list_key_press(GtkWidget *widget, GdkEventKey *event);
/* end function declarations */

static GtkWindowClass *parent_class = NULL;

GtkType gnome_ascii_list_get_type(void)
{
   static GtkType ascii_type=0;
   if(!ascii_type)
   {
      static const GtkTypeInfo ascii_info = 
      {	
         "GnomeAsciiList",
         sizeof(GnomeAsciiList),
         sizeof(GnomeAsciiListClass),
         (GtkClassInitFunc) gnome_ascii_list_class_init,
         (GtkObjectInitFunc) gnome_ascii_list_init,
         NULL,
         NULL,
         (GtkClassInitFunc)NULL,
      };
      ascii_type = gtk_type_unique(GTK_TYPE_WINDOW, &ascii_info);
   }
   return(ascii_type);
}

static void gnome_ascii_list_class_init(GnomeAsciiListClass *_class)
{
   GtkObjectClass *object_class;
   object_class = (GtkObjectClass*)_class;
   parent_class = gtk_type_class(GTK_TYPE_WINDOW);
   object_class->destroy = gnome_ascii_list_destroy;
}

static void gnome_ascii_list_init(GnomeAsciiList *ascii)
{
   ascii->chars = NULL;
   ascii->entry = NULL; 
   ascii->selected_row = -1;
}

GtkWidget* gnome_ascii_list_new()
{
   GnomeAsciiList *ascii;
   GtkWidget *main_box;
   GtkWidget *util_box;
   GtkWidget *scrolled_window;
   GtkWidget *car;
   GtkWidget *dec;
   GtkWidget *hex;
   GtkWidget *label;
   GtkWidget *hsep;
   GtkWidget *pixmap;

   ascii = gtk_type_new(GNOME_TYPE_ASCII_LIST);

   gtk_container_set_border_width(GTK_CONTAINER(ascii), 5);
   main_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(ascii), main_box);
   gtk_widget_show(main_box);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(main_box), util_box, TRUE, TRUE, 5);
   gtk_widget_show(util_box);
   scrolled_window = gtk_scrolled_window_new(0, 0);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_box_pack_start(GTK_BOX(util_box), scrolled_window, TRUE, TRUE, 0);
   gtk_widget_set_usize(scrolled_window, 65, 180);
   gtk_widget_show(scrolled_window);

   ascii->chars = gtk_clist_new(3);
   gtk_clist_set_selection_mode(GTK_CLIST(ascii->chars), GTK_SELECTION_SINGLE);
   gtk_clist_set_shadow_type(GTK_CLIST(ascii->chars), GTK_SHADOW_ETCHED_IN);
   gtk_clist_set_row_height(GTK_CLIST(ascii->chars), 16);
   gtk_clist_set_column_width(GTK_CLIST(ascii->chars), 0, 20);
   gtk_clist_set_column_width(GTK_CLIST(ascii->chars), 1, 20);
   gtk_clist_set_column_width(GTK_CLIST(ascii->chars), 2, 20);
   gtk_container_add(GTK_CONTAINER(scrolled_window), ascii->chars);
   gtk_signal_connect(GTK_OBJECT(ascii->chars), "key_press_event", GTK_SIGNAL_FUNC(gnome_ascii_list_key_press), 0);
   gtk_signal_connect(GTK_OBJECT(ascii->chars), "select_row", GTK_SIGNAL_FUNC(ascii_select_event), ascii);
   gtk_signal_connect(GTK_OBJECT(ascii->chars), "unselect_row", GTK_SIGNAL_FUNC(ascii_unselect_event), ascii);
   gtk_widget_show(ascii->chars);

   ascii->vbox = gtk_vbutton_box_new();
   gtk_box_pack_start(GTK_BOX(util_box), ascii->vbox, FALSE, FALSE, 5);
   gtk_button_box_set_layout(GTK_BUTTON_BOX(ascii->vbox), gnome_preferences_get_button_layout());
   gtk_button_box_set_spacing(GTK_BUTTON_BOX(ascii->vbox), GNOME_PAD);
   gtk_widget_show(ascii->vbox);

   dec = gtk_button_new_with_label("Decimal");
   gtk_box_pack_start(GTK_BOX(ascii->vbox), dec, TRUE, FALSE, 0);
   gtk_object_set_data(GTK_OBJECT(dec), "column", GINT_TO_POINTER(0));
   gtk_signal_connect(GTK_OBJECT(dec), "clicked", GTK_SIGNAL_FUNC(button_press_cb), ascii);
   gtk_widget_show(dec);

   car = gtk_button_new_with_label("Character");
   gtk_box_pack_start(GTK_BOX(ascii->vbox), car, TRUE, FALSE, 0);
   gtk_object_set_data(GTK_OBJECT(car), "column", GINT_TO_POINTER(1));
   gtk_signal_connect(GTK_OBJECT(car), "clicked", GTK_SIGNAL_FUNC(button_press_cb), ascii);
   gtk_widget_show(car);

   hex = gtk_button_new_with_label("Hexidecimal");
   gtk_box_pack_start(GTK_BOX(ascii->vbox), hex, TRUE, FALSE, 0);
   gtk_object_set_data(GTK_OBJECT(hex), "column", GINT_TO_POINTER(2));
   gtk_signal_connect(GTK_OBJECT(hex), "clicked", GTK_SIGNAL_FUNC(button_press_cb), ascii);
   gtk_widget_show(hex);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(main_box), util_box, TRUE, TRUE, 0);
   gtk_widget_show(util_box);

   label = gtk_label_new("Insertion:");
   gtk_box_pack_start(GTK_BOX(util_box), label, FALSE, FALSE, 5);   
   gtk_widget_show(label);
   ascii->entry = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(util_box), ascii->entry, TRUE, TRUE, 5);
   gtk_widget_show(ascii->entry);
   
   hsep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(main_box), hsep, TRUE, TRUE, 10);
   gtk_widget_show(hsep);

   util_box = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(main_box), util_box, TRUE, TRUE, 0);
   gtk_button_box_set_layout(GTK_BUTTON_BOX(util_box), gnome_preferences_get_button_layout());
   gtk_button_box_set_spacing(GTK_BUTTON_BOX(util_box), GNOME_PAD);
   gtk_widget_show(util_box);

   pixmap = gnome_stock_new_with_icon(GNOME_STOCK_PIXMAP_ADD);
   ascii->insert_button = gnome_pixmap_button(pixmap, "Insert");
   gtk_box_pack_start(GTK_BOX(util_box), ascii->insert_button, FALSE, FALSE, 5);
   GTK_WIDGET_SET_FLAGS(ascii->insert_button, GTK_CAN_DEFAULT);
   gtk_widget_show(ascii->insert_button);

   ascii->close_button = gnome_stock_button(GNOME_STOCK_BUTTON_CLOSE);
   gtk_box_pack_start(GTK_BOX(util_box), ascii->close_button, FALSE, FALSE, 5);
   GTK_WIDGET_SET_FLAGS(ascii->close_button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(ascii->close_button);
   gtk_widget_show(ascii->close_button);

   gtk_widget_set_sensitive(ascii->vbox, FALSE);
   gnome_ascii_list_fill(ascii);
   return GTK_WIDGET(ascii);
}

static void gnome_ascii_list_destroy(GtkObject *object)
{
   GtkWidget *ascii;
   g_return_if_fail(object != NULL);
   g_return_if_fail(GNOME_IS_ASCII_LIST(object));
   ascii = GTK_WIDGET(object);
   gtk_widget_destroy(ascii);
}

static void gnome_ascii_list_fill(GnomeAsciiList *ascii)
{
   gchar *entries[3];
   int char_count;
   gchar char_string[10];
   gchar dec_string[10];
   gchar hex_string[10];
   entries[0] = dec_string;
   entries[1] = char_string;
   entries[2] = hex_string;
   gtk_clist_freeze(GTK_CLIST(ascii->chars));
   for(char_count = 0; char_count <= 255; char_count++)
   {
      g_snprintf(entries[0], sizeof(10), "%d", char_count);
      g_snprintf(entries[1], sizeof(10), "%c", char_count);
      g_snprintf(entries[2], sizeof(10), "%X", char_count);
      gtk_clist_append(GTK_CLIST(ascii->chars), (gchar **)entries);
   }
   gtk_clist_thaw(GTK_CLIST(ascii->chars));
}

static void ascii_select_event(GtkCList *list, gint row, gint col, GdkEvent *event, GnomeAsciiList *ascii)
{
   gchar *text;
   ascii->selected_row = row;
   gtk_widget_set_sensitive(ascii->vbox, TRUE);
   gtk_clist_get_text(list, row, col, &text);
   gtk_entry_set_text(GTK_ENTRY(ascii->entry), text);
   g_print("Text: %s\n", text);
}

static void button_press_cb(GtkWidget *widget, GnomeAsciiList *ascii)
{
   gint column;
   gpointer user_data;
   gchar *text;
   if(ascii->selected_row < 0) return;
   user_data = gtk_object_get_data(GTK_OBJECT(widget), "column");
   column = GPOINTER_TO_INT(user_data);
   gtk_clist_get_text(GTK_CLIST(ascii->chars), ascii->selected_row, column, &text);
   gtk_entry_set_text(GTK_ENTRY(ascii->entry), text);
}

static void ascii_unselect_event(GtkCList *list, gint row, gint col, GdkEvent *event, GnomeAsciiList *ascii)
{
   ascii->selected_row = -1;
   gtk_widget_set_sensitive(ascii->vbox, FALSE);
}

static gint gnome_ascii_list_key_press(GtkWidget *widget, GdkEventKey *event)
{
   GnomeAsciiList *ascii;
   GtkCList *clist;
   gint row = 0;
   gint skip_rows = 0;
   gfloat left = 0.0;

   clist = GTK_CLIST(widget);
   ascii = (GnomeAsciiList *)widget->parent->parent->parent->parent;
   row = ascii->selected_row;
   skip_rows = clist->clist_window_height / (clist->row_height + 1);
   left = (float)clist->clist_window_height / (float)(clist->row_height + 1);
   left -= skip_rows;
   if(left < .5) skip_rows--;

   if(event->keyval == GDK_Up)
     row--;
   else if(event->keyval == GDK_Down)
     row++;
   else if(event->keyval == GDK_Page_Up)
     row -= skip_rows;
   else if(event->keyval == GDK_Page_Down)
     row += skip_rows;
   if(row >= 0 && row < clist->rows)     
      gtk_clist_select_row(clist, row, 1);
   else if(row < 0 && clist->rows)
      gtk_clist_select_row(clist, 0, 1);
   else if(row > clist->rows)
      gtk_clist_select_row(clist, clist->rows-1, 1);
   return(TRUE);
}