/* Gnome Developers Studio
*  GdsEditor
*  Copyright 2000 by Chris Phelps
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#ifndef WITH_REGEX
#define WITH_REGEX
#endif
#include "../gtkextext/gtkextext.h"

#ifndef GDS_EDITOR_H__
#define GDS_EDITOR_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GDS_TYPE_EDITOR (gds_editor_get_type())
#define GDS_EDITOR(obj) (GTK_CHECK_CAST((obj), GDS_TYPE_EDITOR, GdsEditor))
#define GDS_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GDS_TYPE_EDITOR, GdsEditorClass))
#define GDS_IS_EDITOR(obj) (GTK_CHECK_TYPE((obj), GDS_TYPE_EDITOR))
#define GDS_IS_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDS_TYPE_EDITOR))

#define IS_SYNTAX_TABLE_ENTRIES(l) 

typedef enum
{
   SYNTAX_TABLE,
   PATTERN_TABLE,
   EMBEDDED_TABLE
}GdsEditorHighlightTableType;

typedef struct _GdsEditorSyntaxEntry
{
   gchar *start;
   Regex regex_start;
   Regex regex_end;
   gchar key[32];
   GdkFont *font;
   GdkColor *color;
   GdkColor *bg;
   gint type;
   guint16 flags;
   gint ref_count;
}GdsEditorSyntaxEntry;

typedef struct _GdsEditorPatternEntry
{
   Regex regex;
   gchar key[32];
   GdkFont *font;
   GdkColor *color;
   GdkColor *bg;
   gint type;
   guint16 flags;
   gint ref_count;
}GdsEditorPatternEntry;

typedef struct _GdsEditorEmbeddedEntry
{
   Regex start;
   Regex end;
   Regex regex;
   gchar key[32];
   GdkFont *font;
   GdkColor *color;
   GdkColor *bg;
   gint type;
   guint16 flags;
   gint ref_count;
}GdsEditorEmbeddedEntry;

typedef struct _GdsEditorHighlightTable
{
   GdsEditorHighlightTableType type;
   GList *entries; 
   Regex regex_all;
}GdsEditorHighlightTable;

typedef struct _GdsEditor GdsEditor;
typedef struct _GdsEditorClass GdsEditorClass;

struct _GdsEditor
{
   GtkExText text;
   GdsEditorHighlightTable *syntax_table;
   GdsEditorHighlightTable *pattern_table;
   GdsEditorHighlightTable *embedded_table;
   gboolean highlight;
   gint changed;
};

struct _GdsEditorClass {
   GtkExTextClass parent_class;
};

GtkType gds_editor_get_type(void);
GtkWidget *gds_editor_new(void);
void gds_editor_set_changed(GdsEditor *gds_editor, gpointer data);
gboolean gds_editor_changed(GdsEditor *gds_editor);
void gds_editor_set_style(GdsEditor *gds_editor, GtkStyle *style);

gboolean gds_editor_compile_regex (const gchar *pattern, Regex *regex);

void gds_editor_set_highlight(GdsEditor *text, gboolean value);
void gds_editor_highlight(GdsEditor *text);

GdsEditorHighlightTable *gds_editor_syntax_table_new(GList *entries);
GdsEditorHighlightTable *gds_editor_pattern_table_new(GList *entries);
GdsEditorHighlightTable *gds_editor_embedded_table_new(GList *entries);

void gds_editor_table_free(GdsEditorHighlightTable *table);

GList *gds_editor_syntax_entry_new(GList *entries, gchar *name, gchar *start, gchar *end, GdkColor *fg, GdkColor *bg, GdkFont *font, guint16 flags, gint type);
GList *gds_editor_pattern_entry_new(GList *entries, gchar *name, gchar *start, GdkColor *fg, GdkColor *bg, GdkFont *font, guint16 flags, gint type);
GList *gds_editor_embedded_entry_new(GList *entries, gchar *name, gchar *start, gchar *end, gchar *words, GdkColor *fg, GdkColor *bg, GdkFont *font, guint16 flags, gint type);

void gds_editor_install_table(GdsEditor *text, GdsEditorHighlightTable *table);
void gds_editor_highlight_set(GdsEditor *text, gboolean set);

void gds_editor_insert_text(GdsEditor   *editable,
                            const gchar *new_text,
                            gint         new_text_length,
                            gint        *position);

void gds_editor_delete_text(GdsEditor *editable,
                            gint       start_pos,
                            gint       end_pos);

gchar *gds_editor_get_chars(GdsEditor *editable,
                            gint       start_pos,
                            gint       end_pos);

void gds_editor_set_editable(GdsEditor *editor, gboolean editable);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
